/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.features.commands.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.nekiplay.hypixelcry.HypixelCry;
import com.nekiplay.hypixelcry.features.lua.LuaManager;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/nekiplay/hypixelcry/features/commands/impl/LuaCommand;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "dispatcher", "Lnet/minecraft/class_7157;", "registryAccess", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;Lnet/minecraft/class_7157;)V", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "builder", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "suggestScriptFiles", "(Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;", "suggestLoadedScripts", "", "filename", "source", "executeLuaFile", "(Ljava/lang/String;Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;)V", "unloadLuaScript", "listLuaFiles", "(Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;)V", "listLoadedScripts", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "SCRIPT_SUGGESTION_PROVIDER", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "LOADED_SCRIPT_SUGGESTION_PROVIDER", "hypixel-cry"})
@SourceDebugExtension(value={"SMAP\nLuaCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuaCommand.kt\ncom/nekiplay/hypixelcry/features/commands/impl/LuaCommand\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n13472#2,2:214\n6482#2:218\n1869#3,2:216\n1869#3,2:219\n1869#3,2:221\n*S KotlinDebug\n*F\n+ 1 LuaCommand.kt\ncom/nekiplay/hypixelcry/features/commands/impl/LuaCommand\n*L\n85#1:214,2\n184#1:218\n101#1:216,2\n192#1:219,2\n208#1:221,2\n*E\n"})
public final class LuaCommand {
    @NotNull
    public static final LuaCommand INSTANCE = new LuaCommand();
    @NotNull
    private static final SuggestionProvider<FabricClientCommandSource> SCRIPT_SUGGESTION_PROVIDER = LuaCommand::SCRIPT_SUGGESTION_PROVIDER$lambda$0;
    @NotNull
    private static final SuggestionProvider<FabricClientCommandSource> LOADED_SCRIPT_SUGGESTION_PROVIDER = LuaCommand::LOADED_SCRIPT_SUGGESTION_PROVIDER$lambda$1;

    private LuaCommand() {
    }

    public final void register(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher, @NotNull class_7157 registryAccess) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        LiteralArgumentBuilder luaCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lua").then(ClientCommandManager.literal((String)"clear").executes(LuaCommand::register$lambda$2))).then(ClientCommandManager.literal((String)"load").then(ClientCommandManager.argument((String)"filename", (ArgumentType)((ArgumentType)StringArgumentType.string())).suggests(SCRIPT_SUGGESTION_PROVIDER).executes(LuaCommand::register$lambda$3)))).then(ClientCommandManager.literal((String)"unload").then(ClientCommandManager.argument((String)"filename", (ArgumentType)((ArgumentType)StringArgumentType.string())).suggests(LOADED_SCRIPT_SUGGESTION_PROVIDER).executes(LuaCommand::register$lambda$4)))).then(ClientCommandManager.literal((String)"list").executes(LuaCommand::register$lambda$5))).then(ClientCommandManager.literal((String)"loaded").executes(LuaCommand::register$lambda$6));
        dispatcher.register(luaCommand);
    }

    private final CompletableFuture<Suggestions> suggestScriptFiles(SuggestionsBuilder builder) {
        File[] scriptFiles;
        File scriptsDir = new File("config/hypixelcry/scripts");
        if (!scriptsDir.exists()) {
            CompletableFuture completableFuture = builder.buildFuture();
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"buildFuture(...)");
            return completableFuture;
        }
        String input = builder.getRemainingLowerCase();
        File[] fileArray = scriptsDir.listFiles(LuaCommand::suggestScriptFiles$lambda$7);
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        File[] $this$forEach$iv = scriptFiles = fileArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            File element$iv;
            File file = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            Intrinsics.checkNotNull((Object)file);
            String fileNameWithoutExtension = FilesKt.getNameWithoutExtension((File)file);
            String string = fileNameWithoutExtension.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Intrinsics.checkNotNull((Object)input);
            if (!StringsKt.startsWith$default((String)string, (String)input, (boolean)false, (int)2, null)) continue;
            builder.suggest(fileNameWithoutExtension);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"buildFuture(...)");
        return completableFuture;
    }

    private final CompletableFuture<Suggestions> suggestLoadedScripts(SuggestionsBuilder builder) {
        LuaManager luaManager = HypixelCry.LUA_MANAGER;
        List<String> loadedScripts = luaManager.getLoadedScripts();
        String input = builder.getRemainingLowerCase();
        Iterable $this$forEach$iv = loadedScripts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String scriptName = (String)element$iv;
            boolean bl = false;
            String string = scriptName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Intrinsics.checkNotNull((Object)input);
            if (!StringsKt.startsWith$default((String)string, (String)input, (boolean)false, (int)2, null)) continue;
            builder.suggest(scriptName);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"buildFuture(...)");
        return completableFuture;
    }

    private final void executeLuaFile(String filename, FabricClientCommandSource source) {
        File luaFile;
        File scriptFile;
        LuaManager luaManager = HypixelCry.LUA_MANAGER;
        File scriptsDir = new File("config/hypixelcry/scripts");
        if (!scriptsDir.exists()) {
            scriptsDir.mkdirs();
            source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a7cDirectory for scripts: " + scriptsDir.getPath())));
            return;
        }
        File file = StringsKt.endsWith$default((String)filename, (String)".lua", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filename, (String)".luac", (boolean)false, (int)2, null) ? new File(scriptsDir, filename) : (scriptFile = (luaFile = new File(scriptsDir, filename + ".lua")).exists() ? luaFile : new File(scriptsDir, filename + ".luac"));
        if (!scriptFile.exists()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a7cScript " + scriptFile.getName() + " not found")));
            return;
        }
        try {
            File luaFile2;
            File scriptFile2 = StringsKt.endsWith$default((String)filename, (String)".lua", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filename, (String)".luac", (boolean)false, (int)2, null) ? new File(scriptsDir, filename) : ((luaFile2 = new File(scriptsDir, filename + ".lua")).exists() ? luaFile2 : new File(scriptsDir, filename + ".luac"));
            boolean loaded = luaManager.unloadScript(FilesKt.getNameWithoutExtension((File)scriptFile2));
            Object result = luaManager.executeScript(scriptFile2);
            if (!loaded) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a7aScript '" + FilesKt.getNameWithoutExtension((File)scriptFile2) + "' executed successfully, result: '" + result + "'")));
            } else {
                source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a7aScript '" + FilesKt.getNameWithoutExtension((File)scriptFile2) + "' restarted successfully, result: '" + result + "'")));
            }
        }
        catch (Exception e) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a7cScript execution error: " + e.getMessage())));
            e.printStackTrace();
        }
    }

    private final void unloadLuaScript(String filename, FabricClientCommandSource source) {
        String scriptName;
        LuaManager luaManager = HypixelCry.LUA_MANAGER;
        String string = StringsKt.endsWith$default((String)filename, (String)".lua", (boolean)false, (int)2, null) ? StringsKt.removeSuffix((String)filename, (CharSequence)".lua") : (scriptName = StringsKt.endsWith$default((String)filename, (String)".luac", (boolean)false, (int)2, null) ? StringsKt.removeSuffix((String)filename, (CharSequence)".luac") : filename);
        if (luaManager.unloadScript(scriptName)) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a7aScript '" + scriptName + "' unloaded successfully")));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a7cScript '" + scriptName + "' is not loaded or not found")));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void listLuaFiles(FabricClientCommandSource source) {
        List list;
        File scriptsDir;
        block8: {
            block7: {
                scriptsDir = new File("config/hypixelcry/scripts");
                if (!scriptsDir.exists()) break block7;
                File[] fileArray = scriptsDir.listFiles();
                if (fileArray != null ? !(fileArray.length == 0) : false) break block8;
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a77No scripts available. Create files in: " + scriptsDir.getPath())));
            return;
        }
        Object object = scriptsDir.listFiles(LuaCommand::listLuaFiles$lambda$10);
        if (object != null) {
            void $this$sortedBy$iv;
            File[] fileArray = object;
            boolean $i$f$sortedBy = false;
            list = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        } else {
            list = null;
        }
        List scriptFiles = list;
        object = scriptFiles;
        if (object == null || object.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a77No .lua or .luac files in scripts directory")));
            return;
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a76Available scripts:")));
        Iterable $this$forEach$iv = scriptFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileType = StringsKt.endsWith$default((String)string, (String)".luac", (boolean)false, (int)2, null) ? "\u00a79[compiled]\u00a77" : "\u00a7a[source]\u00a77";
            Intrinsics.checkNotNull((Object)file);
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77- \u00a7e" + FilesKt.getNameWithoutExtension((File)file) + " \u00a77(" + file.length() + " bytes) " + fileType)));
        }
    }

    private final void listLoadedScripts(FabricClientCommandSource source) {
        LuaManager luaManager = HypixelCry.LUA_MANAGER;
        List<String> loadedScripts = luaManager.getLoadedScripts();
        if (loadedScripts.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a77No scripts currently loaded")));
            return;
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a76Loaded scripts:")));
        Iterable $this$forEach$iv = loadedScripts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String scriptName = (String)element$iv;
            boolean bl = false;
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77- \u00a7a" + scriptName)));
        }
    }

    private static final CompletableFuture SCRIPT_SUGGESTION_PROVIDER$lambda$0(CommandContext context, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull((Object)builder);
        return INSTANCE.suggestScriptFiles(builder);
    }

    private static final CompletableFuture LOADED_SCRIPT_SUGGESTION_PROVIDER$lambda$1(CommandContext context, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull((Object)builder);
        return INSTANCE.suggestLoadedScripts(builder);
    }

    private static final int register$lambda$2(CommandContext context) {
        HypixelCry.LUA_MANAGER.clearAllCallbacks();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)(HypixelCry.PREFIX + "\u00a7aAll Lua callback's cleared")));
        return 1;
    }

    private static final int register$lambda$3(CommandContext context) {
        String filename = StringArgumentType.getString((CommandContext)context, (String)"filename");
        Intrinsics.checkNotNull((Object)filename);
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        INSTANCE.executeLuaFile(filename, (FabricClientCommandSource)object);
        return 1;
    }

    private static final int register$lambda$4(CommandContext context) {
        String filename = StringArgumentType.getString((CommandContext)context, (String)"filename");
        Intrinsics.checkNotNull((Object)filename);
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        INSTANCE.unloadLuaScript(filename, (FabricClientCommandSource)object);
        return 1;
    }

    private static final int register$lambda$5(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        INSTANCE.listLuaFiles((FabricClientCommandSource)object);
        return 1;
    }

    private static final int register$lambda$6(CommandContext context) {
        Object object = context.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        INSTANCE.listLoadedScripts((FabricClientCommandSource)object);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean suggestScriptFiles$lambda$7(File file) {
        if (!file.isFile()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".lua", (boolean)false, (int)2, null)) return true;
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)".luac", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean listLuaFiles$lambda$10(File file) {
        if (!file.isFile()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)".lua", (boolean)false, (int)2, null)) return true;
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)".luac", (boolean)false, (int)2, null)) return false;
        return true;
    }
}

