/*
 * Decompiled with CFR 0.152.
 */
package com.nekiplay.hypixelcry.utils.itemlist;

import com.mojang.logging.LogUtils;
import com.nekiplay.hypixelcry.utils.NEURepoManager;
import com.nekiplay.hypixelcry.utils.datafixer.LegacyItemStackFixer;
import com.nekiplay.hypixelcry.utils.datafixer.LegacyStringNbtReader;
import com.nekiplay.hypixelcry.utils.datafixer.TextTransformer;
import com.nekiplay.hypixelcry.utils.itemlist.ItemRepository;
import io.github.moulberry.repo.constants.PetNumbers;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.data.Rarity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.slf4j.Logger;

public class ItemStackBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Map<String, Map<Rarity, PetNumbers>> petNums;

    protected static void loadPetNums() {
        try {
            petNums = NEURepoManager.getConstants().getPetNumbers();
        }
        catch (Exception e) {
            ItemRepository.LOGGER.error("Failed to load petnums.json");
        }
    }

    protected static class_1799 fromNEUItem(NEUItem item) {
        try {
            class_2487 nbt = new class_2487();
            class_2487 tag = LegacyStringNbtReader.parse(item.getNbttag());
            nbt.method_10566("tag", (class_2520)tag);
            nbt.method_10582("id", item.getMinecraftItemId());
            nbt.method_10575("Damage", (short)item.getDamage());
            nbt.method_10569("Count", 1);
            class_1799 stack = LegacyItemStackFixer.fixLegacyStack(nbt);
            if (stack.method_7960()) {
                return ItemStackBuilder.createErrorStack(item.getSkyblockItemId());
            }
            ArrayList<class_3545<String, String>> injectors = new ArrayList<class_3545<String, String>>(ItemStackBuilder.petData(item.getSkyblockItemId()));
            String name = ItemStackBuilder.injectData(item.getDisplayName(), injectors);
            stack.method_57379(class_9334.field_49631, (Object)TextTransformer.fromLegacy(name));
            stack.method_57379(class_9334.field_49632, (Object)new class_9290(item.getLore().stream().map(line -> TextTransformer.fromLegacy(ItemStackBuilder.injectData(line, injectors))).map(class_2561.class::cast).toList()));
            return stack;
        }
        catch (Exception exception) {
            return ItemStackBuilder.createErrorStack(item.getSkyblockItemId());
        }
    }

    private static class_1799 createErrorStack(String skyblockItemId) {
        class_1799 errorStack = new class_1799((class_1935)class_1802.field_8077);
        errorStack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)skyblockItemId));
        return errorStack;
    }

    private static List<class_3545<String, String>> petData(String internalName) {
        String right;
        String left;
        ArrayList<class_3545<String, String>> list = new ArrayList<class_3545<String, String>>();
        String petName = internalName.split(";")[0];
        if (!internalName.contains(";") || !petNums.containsKey(petName)) {
            return list;
        }
        Rarity[] rarities = new Rarity[]{Rarity.COMMON, Rarity.UNCOMMON, Rarity.RARE, Rarity.EPIC, Rarity.LEGENDARY, Rarity.MYTHIC};
        Rarity rarity = rarities[Integer.parseInt(internalName.split(";")[1])];
        PetNumbers data = petNums.get(petName).get(rarity);
        int minLevel = data.getLowLevel();
        int maxLevel = data.getHighLevel();
        list.add((class_3545<String, String>)new class_3545((Object)"\\{LVL\\}", (Object)(minLevel + " \u27a1 " + maxLevel)));
        Map statNumsMin = data.getStatsAtLowLevel().getStatNumbers();
        Map statNumsMax = data.getStatsAtHighLevel().getStatNumbers();
        Set entrySet = statNumsMin.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            left = "\\{" + key + "\\}";
            right = String.valueOf(statNumsMin.get(key)) + " \u27a1 " + String.valueOf(statNumsMax.get(key));
            list.add((class_3545<String, String>)new class_3545((Object)left, (Object)right));
        }
        List otherNumsMin = data.getStatsAtLowLevel().getOtherNumbers();
        List otherNumsMax = data.getStatsAtHighLevel().getOtherNumbers();
        for (int i2 = 0; i2 < otherNumsMin.size(); ++i2) {
            left = "\\{" + i2 + "\\}";
            right = String.valueOf(otherNumsMin.get(i2)) + " \u27a1 " + String.valueOf(otherNumsMax.get(i2));
            list.add((class_3545<String, String>)new class_3545((Object)left, (Object)right));
        }
        return list;
    }

    private static String injectData(String string, List<class_3545<String, String>> injectors) {
        for (class_3545<String, String> injector : injectors) {
            string = string.replaceAll((String)injector.method_15442(), (String)injector.method_15441());
        }
        return string;
    }
}

