/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwbyg;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.bridges.Bridges;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.data.McwBlockIdBase;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.door.Doors;
import fr.samlegamer.addonslib.fences.Fences;
import fr.samlegamer.addonslib.furnitures.Furnitures;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.path.Paths;
import fr.samlegamer.addonslib.roofs.Roofs;
import fr.samlegamer.addonslib.stairs.Stairs;
import fr.samlegamer.addonslib.tab.APICreativeTab;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.trapdoor.Trapdoors;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.addonslib.windows.Windows;
import fr.samlegamer.mcwbyg.Mapping;
import fr.samlegamer.mcwbyg.Recipes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="mcwbyg")
public class McwByg
extends McwMod {
    public static final String MODID = "mcwbyg";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> WOOD = List.of("aspen", "baobab", "blue_enchanted", "cherry", "cika", "cypress", "ebony", "ether", "fir", "green_enchanted", "holly", "jacaranda", "lament", "mahogany", "white_mangrove", "maple", "nightshade", "palm", "pine", "rainbow_eucalyptus", "redwood", "skyris", "willow", "witch_hazel", "zelkova", "bulbis", "imparius", "sythian");
    public static final List<String> fences_rockable = List.of("soapstone", "travertine", "dacite", "red_rock", "scoria_stone");
    public static final List<String> bridges_rockable = List.of("cryptic_stone", "dacite_bricks", "polished_travertine", "purpur_stone", "red_rock_bricks", "scoria_stone_bricks", "soapstone_bricks");
    public static final List<String> LEAVES = List.of("aspen", "baobab", "blue_enchanted", "cika", "cypress", "ebony", "ether", "fir", "green_enchanted", "holly", "jacaranda", "lament", "mahogany", "maple", "palm", "pine", "rainbow_eucalyptus", "redwood", "skyris", "white_mangrove", "willow", "witch_hazel", "zelkova", "blue_spruce", "orange_spruce", "red_spruce", "yellow_spruce", "brown_birch", "orange_birch", "red_birch", "yellow_birch", "brown_oak", "orange_oak", "red_oak", "white_cherry", "pink_cherry", "araucaria", "blooming_witch_hazel", "flowering_indigo_jacaranda", "flowering_jacaranda", "flowering_orchard", "flowering_palo_verde", "palo_verde");
    public static CreativeModeTab MCWBYG_TAB;
    private static final DeferredRegister<Block> block;
    private static final DeferredRegister<Item> item;

    public McwByg() {
        LOGGER.info("Macaw's Oh the Biomes You'll Go Loading...");
        Registration.init(block, item);
        Bridges.setRegistrationWood(WOOD, block, item);
        Bridges.setRegistrationRock(bridges_rockable, block, item);
        Roofs.setRegistrationWood(WOOD, block, item);
        Roofs.setRegistrationRock(fences_rockable, block, item);
        Fences.setRegistrationWood(WOOD, block, item);
        Fences.setRegistrationHedges(LEAVES, block, item);
        Fences.setRegistrationRock(fences_rockable, block, item);
        Furnitures.setRegistrationWood(WOOD, block, item);
        Stairs.setRegistrationWood(WOOD, block, item);
        Paths.setRegistrationWood(WOOD, block, item);
        Doors.setRegistrationWood(WOOD, block, item);
        Trapdoors.setRegistrationWood(WOOD, block, item);
        Windows.setRegistrationWood(WOOD, block, item);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dataSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::tabRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::tabSetup);
        MinecraftForge.EVENT_BUS.register(Mapping.class);
        LOGGER.info("Macaw's Oh the Biomes You'll Go Is Charged !");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOOD, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, LEAVES);
        APIRenderTypes.initAllStone((FMLClientSetupEvent)event, (String)MODID, bridges_rockable, (ModType[])new ModType[]{ModType.BRIDGES});
        APIRenderTypes.initAllStone((FMLClientSetupEvent)event, (String)MODID, fences_rockable, (ModType[])new ModType[]{ModType.FENCES, ModType.ROOFS});
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, WOOD);
            McwLootTables.addBlockHedges((String)MODID, LEAVES);
            McwLootTables.addBlock((String)MODID, bridges_rockable, (McwBlockIdBase)McwBlocksIdBase.BRIDGES_STONE_BLOCKS);
            McwLootTables.addBlock((String)MODID, fences_rockable, (McwBlockIdBase)McwBlocksIdBase.ROOFS_STONE_BLOCKS);
            McwLootTables.addBlock((String)MODID, fences_rockable, (McwBlockIdBase)McwBlocksIdBase.FENCES_STONE_BLOCKS);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        CompletableFuture lookupProvider = gatherDataEvent.getLookupProvider();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(output, lookupProvider, MODID, existingFileHelper){

                protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider p_256380_) {
                    this.addAllMcwTags(McwByg.MODID, WOOD, LEAVES);
                    this.mcwBridgesTagsStone(McwByg.MODID, bridges_rockable);
                    this.mcwRoofsTags(McwByg.MODID, new ArrayList(), fences_rockable);
                    this.mcwFencesTags(McwByg.MODID, new ArrayList(), new ArrayList(), fences_rockable);
                }
            };
            generator.addProvider(true, (DataProvider)new Recipes(output));
            generator.addProvider(true, (DataProvider)mcwBlockTags);
            generator.addProvider(true, (DataProvider)new McwItemTags(output, lookupProvider, (TagsProvider)mcwBlockTags, MODID, existingFileHelper){

                protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull HolderLookup.Provider p_256380_) {
                    this.addAllMcwTags(McwByg.MODID, WOOD, LEAVES);
                    this.mcwFencesTags(McwByg.MODID, new ArrayList(), new ArrayList(), fences_rockable);
                }
            });
        }
    }

    public void tabRegistry(CreativeModeTabEvent.Register event) {
        NewIconRandom.NewProperties prop = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)"aspen_roof"), Finder.findBlock((String)MODID, (String)"aspen_picket_fence"), Finder.findBlock((String)MODID, (String)"aspen_wardrobe"), Finder.findBlock((String)MODID, (String)"aspen_log_bridge_middle"), Finder.findBlock((String)MODID, (String)"aspen_plank_window2"), Finder.findBlock((String)MODID, (String)"aspen_paper_door"), Finder.findBlock((String)MODID, (String)"aspen_blossom_trapdoor"), Finder.findBlock((String)MODID, (String)"aspen_planks_path"), Finder.findBlock((String)MODID, (String)"aspen_bulk_stairs"));
        prop.addType(NewIconRandom.BlockType.ROOFS).addType(NewIconRandom.BlockType.FENCES).addType(NewIconRandom.BlockType.BRIDGES).addType(NewIconRandom.BlockType.FURNITURES).addType(NewIconRandom.BlockType.STAIRS).addType(NewIconRandom.BlockType.DOORS).addType(NewIconRandom.BlockType.TRAPDOORS).addType(NewIconRandom.BlockType.PATHS).addType(NewIconRandom.BlockType.WINDOWS);
        Block icon = prop.buildIcon(new NewIconRandom.BlockType[]{NewIconRandom.BlockType.ROOFS, NewIconRandom.BlockType.FENCES, NewIconRandom.BlockType.FURNITURES, NewIconRandom.BlockType.BRIDGES, NewIconRandom.BlockType.WINDOWS, NewIconRandom.BlockType.DOORS, NewIconRandom.BlockType.TRAPDOORS, NewIconRandom.BlockType.PATHS, NewIconRandom.BlockType.STAIRS});
        MCWBYG_TAB = Registration.tabs((CreativeModeTabEvent.Register)event, (String)MODID, (String)"tab", (ItemLike)icon);
    }

    public void tabSetup(CreativeModeTabEvent.BuildContents event) {
        APICreativeTab.initAllWood((CreativeModeTabEvent.BuildContents)event, (String)MODID, WOOD, (CreativeModeTab)MCWBYG_TAB, (ModType[])Registration.getAllModTypeWood());
        APICreativeTab.initAllLeave((CreativeModeTabEvent.BuildContents)event, (String)MODID, LEAVES, (CreativeModeTab)MCWBYG_TAB);
        APICreativeTab.initAllStone((CreativeModeTabEvent.BuildContents)event, (String)MODID, bridges_rockable, (CreativeModeTab)MCWBYG_TAB, (ModType[])new ModType[]{ModType.BRIDGES});
        APICreativeTab.initAllStone((CreativeModeTabEvent.BuildContents)event, (String)MODID, fences_rockable, (CreativeModeTab)MCWBYG_TAB, (ModType[])new ModType[]{ModType.FENCES, ModType.ROOFS});
    }

    static {
        block = Registration.blocks((String)MODID);
        item = Registration.items((String)MODID);
    }
}

