/*
 * Decompiled with CFR 0.152.
 */
package net.player005.betteraddserver.mixin.screen;

import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.EditServerScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.player005.betteraddserver.AddressToName;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EditServerScreen.class})
public abstract class MixinEditServerScreen
extends Screen {
    @Shadow
    private EditBox nameEdit;
    @Shadow
    private EditBox ipEdit;
    @Shadow
    private Button addButton;
    @Shadow
    @Final
    private static Component NAME_LABEL;
    @Shadow
    @Final
    private static Component IP_LABEL;
    @Unique
    private String lastGeneratedName = "";
    @Unique
    public boolean wasNameCustomised = false;

    protected MixinEditServerScreen(Component title) {
        super(title);
    }

    @Shadow
    protected abstract void onAdd();

    @Shadow
    protected abstract void updateAddButtonStatus();

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.swapInputFields();
        this.ipEdit.setResponder(this::onAddressFieldChange);
        this.nameEdit.setResponder(s -> {
            this.updateAddButtonStatus();
            this.updateSuggestions();
            this.wasNameCustomised = !Objects.equals(s, this.lastGeneratedName);
        });
        if (this.ipEdit.getValue().isEmpty()) {
            this.nameEdit.setValue("");
        }
        this.lastGeneratedName = AddressToName.toName(this.ipEdit.getValue());
        this.wasNameCustomised = !Objects.equals(this.nameEdit.getValue(), this.lastGeneratedName);
        this.updateSuggestions();
    }

    @Unique
    private void onAddressFieldChange(String s) {
        String generatedName;
        this.lastGeneratedName = generatedName = AddressToName.toName(s);
        if (!generatedName.isEmpty() && !this.wasNameCustomised) {
            this.nameEdit.setValue(generatedName);
        }
        this.updateAddButtonStatus();
        this.updateSuggestions();
    }

    @Unique
    private void swapInputFields() {
        int addressFieldOldY = this.ipEdit.getY();
        this.ipEdit.setY(this.nameEdit.getY());
        this.nameEdit.setY(addressFieldOldY);
    }

    @Overwrite
    public void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.ipEdit);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.addButton.active) {
            this.onAdd();
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Unique
    private void updateSuggestions() {
        if (this.nameEdit.getValue().isEmpty()) {
            this.nameEdit.setSuggestion("Hypixel");
        } else {
            this.nameEdit.setSuggestion("");
        }
        if (this.ipEdit.getValue().isEmpty()) {
            this.ipEdit.setSuggestion("hypixel.net");
        } else {
            this.ipEdit.setSuggestion("");
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V"), index=1)
    private Component switchLabels(Component component) {
        if (component == NAME_LABEL) {
            return IP_LABEL;
        }
        if (component == IP_LABEL) {
            return NAME_LABEL;
        }
        return component;
    }
}

