/*
 * Decompiled with CFR 0.152.
 */
package net.player005.betteraddserver;

import java.util.Arrays;
import java.util.List;
import net.player005.betteraddserver.LunarClientServerMappings;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class AddressToName {
    private static final String[] alwaysUppercase = new String[]{"hd", "yt", "pvp", "mc"};
    private static final List<String> keepEndings = Arrays.asList("land", "club", "network", "world");

    @Contract(pure=true)
    @NotNull
    public static String toName(@NotNull String ip) {
        boolean removeEnding;
        boolean ignoreFirstSub;
        if (ip.replace(".", "").length() < 3) {
            return "";
        }
        CharSequence[] splitAddress = ip.split("\\.");
        boolean bl = ignoreFirstSub = splitAddress[0].equalsIgnoreCase("play") || splitAddress[0].equalsIgnoreCase("mc");
        if (ignoreFirstSub) {
            splitAddress = Arrays.copyOfRange(splitAddress, 1, splitAddress.length);
        }
        if (splitAddress.length < 1) {
            return "";
        }
        String lunarName = LunarClientServerMappings.getServerName(String.join((CharSequence)".", splitAddress));
        if (lunarName != null) {
            return lunarName;
        }
        boolean bl2 = removeEnding = !keepEndings.contains(((String)splitAddress[splitAddress.length - 1]).toLowerCase()) && splitAddress.length > 1;
        if (removeEnding) {
            splitAddress = (String[])Arrays.copyOf(splitAddress, splitAddress.length - 1);
        }
        if (splitAddress.length < 1) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (CharSequence element : splitAddress) {
            if (((String)element).length() < 3) {
                result.append(((String)element).toUpperCase()).append(" ");
                continue;
            }
            for (String upper : alwaysUppercase) {
                int index = ((String)element).toLowerCase().indexOf(upper);
                if (index == -1) continue;
                StringBuilder sb = new StringBuilder((String)element);
                sb.replace(index, index + upper.length(), upper.toUpperCase());
                int nextCharIndex = index + upper.length();
                if (((String)element).length() > nextCharIndex) {
                    sb.replace(nextCharIndex, nextCharIndex + 1, ((String)element).substring(nextCharIndex, nextCharIndex + 1).toUpperCase());
                }
                element = sb.toString();
            }
            result.append(AddressToName.capitalise((String)element)).append(" ");
        }
        return result.toString().trim();
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalise(@NotNull String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

