/*
 * Decompiled with CFR 0.152.
 */
package net.player005.betteraddserver;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LunarClientServerMappings {
    private static final String MAPPINGS_URL = "https://servermappings.lunarclientcdn.com/servers.json";
    private static final HttpClient HTTP = HttpClient.newHttpClient();
    private static final Gson GSON = new Gson();
    private static final Map<String, String> ADDRESS_TO_NAME = new ConcurrentHashMap<String, String>();

    @Nullable
    public static String getServerName(@NotNull String address) {
        address = address.trim().toLowerCase(Locale.ROOT);
        return ADDRESS_TO_NAME.get(address);
    }

    static {
        CompletableFuture.runAsync(() -> {
            try {
                HttpRequest request = HttpRequest.newBuilder(URI.create(MAPPINGS_URL)).GET().build();
                HttpResponse<String> response = HTTP.send(request, HttpResponse.BodyHandlers.ofString());
                JsonArray json = (JsonArray)GSON.fromJson(response.body(), JsonArray.class);
                for (JsonElement element : json) {
                    JsonObject obj = element.getAsJsonObject();
                    JsonArray addresses = obj.getAsJsonArray("addresses");
                    String primaryAddress = obj.get("primaryAddress").getAsString();
                    String name = obj.get("name").getAsString();
                    for (JsonElement address : addresses) {
                        ADDRESS_TO_NAME.put(address.getAsString(), name);
                    }
                    ADDRESS_TO_NAME.put(primaryAddress, name);
                }
            }
            catch (Exception e) {
                System.out.println("Failed to fetch Lunar Client server mappings: " + e.getMessage());
            }
        });
    }
}

