/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7157;
import net.minecraft.class_7471;

public class Mentions
implements ParadigmModule {
    private static final String NAME = "Mentions";
    private final Map<UUID, Long> lastIndividualMentionBySender = new HashMap<UUID, Long>();
    private final Map<UUID, Long> lastEveryoneMentionBySender = new HashMap<UUID, Long>();
    private Services services;
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return services != null && services.getMainConfig() != null && (Boolean)services.getMainConfig().mentionsEnable.value != false;
    }

    @Override
    public void onLoad(Object event, Services services, Object modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        if (this.services != null && this.services.getDebugLogger() != null) {
            this.services.getDebugLogger().debugLog("Mentions module loaded.");
        }
    }

    @Override
    public void onServerStarting(Object event, Services services) {
        if (this.services != null && this.services.getDebugLogger() != null) {
            this.services.getDebugLogger().debugLog("Mentions module: Server starting.");
        }
    }

    @Override
    public void onEnable(Services services) {
        if (this.services != null && this.services.getDebugLogger() != null) {
            this.services.getDebugLogger().debugLog("Mentions module enabled.");
        }
    }

    @Override
    public void onDisable(Services services) {
        if (this.services != null && this.services.getDebugLogger() != null) {
            this.services.getDebugLogger().debugLog("Mentions module disabled.");
        }
    }

    @Override
    public void onServerStopping(Object event, Services services) {
        if (this.services != null && this.services.getDebugLogger() != null) {
            this.services.getDebugLogger().debugLog("Mentions module: Server stopping.");
        }
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, Services services) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mention").requires(source -> source.method_9259(0))).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.executeMentionCommand((CommandContext<class_2168>)context, services))));
    }

    @Override
    public void registerEventListeners(Object eventBus, Services services) {
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register(this::shouldAllowChatMessage);
    }

    private boolean shouldAllowChatMessage(class_7471 message, class_3222 sender, class_2556.class_7602 params) {
        if (this.services == null || !this.isEnabled(this.services)) {
            return true;
        }
        MentionConfigHandler.Config mentionConfig = MentionConfigHandler.CONFIG;
        String rawMessage = message.method_46291().getString();
        String everyoneMentionPlaceholder = (String)mentionConfig.MENTION_SYMBOL.value + "everyone";
        Pattern everyonePattern = Pattern.compile(Pattern.quote(everyoneMentionPlaceholder), 2);
        Matcher everyoneMatcher = everyonePattern.matcher(rawMessage);
        if (everyoneMatcher.find()) {
            return this.handleEveryoneMention(sender, rawMessage, mentionConfig, everyoneMatcher.group(0));
        }
        return this.handleIndividualMentions(sender, rawMessage, mentionConfig);
    }

    private boolean handleEveryoneMention(class_3222 sender, String rawMessage, MentionConfigHandler.Config mentionConfig, String matchedEveryoneMention) {
        if (!this.hasPermission(sender, "paradigm.mention.everyone", 2)) {
            this.platform.sendSystemMessage(sender, this.services.getLang().translate("mention.no_permission_everyone"));
            return false;
        }
        if (!this.canMentionEveryoneNow(sender, mentionConfig)) {
            this.platform.sendSystemMessage(sender, this.services.getLang().translate("mention.too_frequent_mention_everyone"));
            return false;
        }
        this.services.getDebugLogger().debugLog("Mention everyone detected in chat by " + this.platform.getPlayerName(sender));
        this.notifyEveryone(this.platform.getOnlinePlayers(), sender, rawMessage, false, mentionConfig, matchedEveryoneMention);
        this.markMentionEveryoneUsed(sender);
        if (sender != null) {
            IPlayer iSender = this.platform.wrapPlayer(sender);
            IComponent feedback = this.services.getMessageParser().parseMessage((String)mentionConfig.SENDER_FEEDBACK_EVERYONE_MESSAGE.value, iSender);
            String appended = this.extractContentAfterToken(rawMessage, matchedEveryoneMention);
            if (!appended.isEmpty()) {
                String prefix = (String)mentionConfig.CHAT_APPEND_PREFIX.value;
                IComponent nl = this.services.getPlatformAdapter().createComponentFromLiteral("\n" + prefix);
                IComponent appendedComp = this.services.getMessageParser().parseMessage(appended, iSender);
                feedback = feedback.append(nl).append(appendedComp);
            }
            this.platform.sendSystemMessage(sender, feedback.getOriginalText());
        }
        return false;
    }

    private boolean handleIndividualMentions(class_3222 sender, String rawMessage, MentionConfigHandler.Config mentionConfig) {
        String mentionSymbol = (String)mentionConfig.MENTION_SYMBOL.value;
        List<class_3222> players = this.platform.getOnlinePlayers();
        Pattern allPlayersPattern = this.buildAllPlayersMentionPattern(players, mentionSymbol);
        Matcher mentionMatcher = allPlayersPattern.matcher(rawMessage);
        if (!mentionMatcher.find()) {
            return true;
        }
        mentionMatcher.reset();
        if (!this.hasPermission(sender, "paradigm.mention.player", 0)) {
            return true;
        }
        if (!this.canMentionIndividualNow(sender, mentionConfig)) {
            this.platform.sendSystemMessage(sender, this.services.getLang().translate("mention.too_frequent_mention_player"));
            return false;
        }
        boolean mentionedSomeone = false;
        LinkedHashSet<String> mentionedNames = new LinkedHashSet<String>();
        while (mentionMatcher.find()) {
            String playerName = mentionMatcher.group(1);
            class_3222 targetPlayer = this.platform.getPlayerByName(playerName);
            if (targetPlayer == null) continue;
            this.services.getDebugLogger().debugLog("Mention player detected in chat: " + this.platform.getPlayerName(targetPlayer) + " by " + this.platform.getPlayerName(sender));
            this.notifyPlayer(targetPlayer, sender, rawMessage, false, mentionConfig, mentionMatcher.group(0));
            mentionedSomeone = true;
            mentionedNames.add(this.platform.getPlayerName(targetPlayer));
        }
        if (mentionedSomeone) {
            this.markMentionIndividualUsed(sender);
            if (sender != null && !mentionedNames.isEmpty()) {
                IPlayer iSender = this.platform.wrapPlayer(sender);
                String list = String.join((CharSequence)", ", new ArrayList(mentionedNames));
                String formatted = String.format((String)mentionConfig.SENDER_FEEDBACK_PLAYER_MESSAGE.value, list);
                IComponent feedback = this.services.getMessageParser().parseMessage(formatted, iSender);
                String appended = this.extractContentAfterFirstMatch(rawMessage, allPlayersPattern);
                if (!appended.isEmpty()) {
                    String prefix = (String)mentionConfig.CHAT_APPEND_PREFIX.value;
                    IComponent nl = this.services.getPlatformAdapter().createComponentFromLiteral("\n" + prefix);
                    IComponent appendedComp = this.services.getMessageParser().parseMessage(appended, iSender);
                    feedback = feedback.append(nl).append(appendedComp);
                }
                this.platform.sendSystemMessage(sender, feedback.getOriginalText());
            }
        }
        return !mentionedSomeone;
    }

    private int executeMentionCommand(CommandContext<class_2168> context, Services services) {
        class_2168 source = (class_2168)context.getSource();
        String message = StringArgumentType.getString(context, (String)"message");
        List<class_3222> players = this.platform.getOnlinePlayers();
        boolean isConsole = source.method_9228() == null;
        class_3222 sender = isConsole ? null : source.method_44023();
        MentionConfigHandler.Config mentionConfig = MentionConfigHandler.CONFIG;
        String everyoneMentionPlaceholder = (String)mentionConfig.MENTION_SYMBOL.value + "everyone";
        Pattern everyonePattern = Pattern.compile(Pattern.quote(everyoneMentionPlaceholder), 2);
        Matcher everyoneMatcher = everyonePattern.matcher(message);
        if (everyoneMatcher.find()) {
            if (sender != null) {
                if (!this.hasPermission(sender, "paradigm.mention.everyone", 2)) {
                    this.platform.sendSystemMessage(sender, services.getLang().translate("mention.no_permission_everyone"));
                    return 0;
                }
                if (!this.canMentionEveryoneNow(sender, mentionConfig)) {
                    this.platform.sendSystemMessage(sender, services.getLang().translate("mention.too_frequent_mention_everyone"));
                    return 0;
                }
            }
            this.notifyEveryone(players, sender, message, isConsole, mentionConfig, everyoneMatcher.group(0));
            if (sender != null) {
                this.markMentionEveryoneUsed(sender);
                IPlayer iSender = this.platform.wrapPlayer(sender);
                IComponent feedback = services.getMessageParser().parseMessage((String)mentionConfig.SENDER_FEEDBACK_EVERYONE_MESSAGE.value, iSender);
                String appended = this.extractContentAfterToken(message, everyoneMatcher.group(0));
                if (!appended.isEmpty()) {
                    String prefix = (String)mentionConfig.CHAT_APPEND_PREFIX.value;
                    IComponent nl = services.getPlatformAdapter().createComponentFromLiteral("\n" + prefix);
                    IComponent appendedComp = services.getMessageParser().parseMessage(appended, iSender);
                    feedback = feedback.append(nl).append(appendedComp);
                }
                this.platform.sendSystemMessage(sender, feedback.getOriginalText());
            }
            this.platform.sendSuccess(source, (class_2561)this.platform.createLiteralComponent("Mentioned everyone successfully."), !isConsole);
            return 1;
        }
        int mentionedCount = 0;
        boolean containsAnyMention = false;
        Pattern allPlayersPattern = this.buildAllPlayersMentionPattern(players, (String)mentionConfig.MENTION_SYMBOL.value);
        Matcher m = allPlayersPattern.matcher(message);
        containsAnyMention = m.find();
        if (containsAnyMention && sender != null) {
            if (!this.hasPermission(sender, "paradigm.mention.player", 0)) {
                this.platform.sendFailure(source, (class_2561)this.platform.createLiteralComponent("No permission to mention players."));
                return 0;
            }
            if (!this.canMentionIndividualNow(sender, mentionConfig)) {
                this.platform.sendFailure(source, (class_2561)this.platform.createLiteralComponent(services.getLang().translate("mention.too_frequent_mention_player").getString()));
                return 0;
            }
        }
        ArrayList<String> mentionedNames = new ArrayList<String>();
        for (class_3222 targetPlayer : players) {
            String playerMentionPlaceholder = (String)mentionConfig.MENTION_SYMBOL.value + this.platform.getPlayerName(targetPlayer);
            Pattern playerMentionPattern = Pattern.compile(Pattern.quote(playerMentionPlaceholder), 2);
            if (!playerMentionPattern.matcher(message).find() || sender != null && !this.hasPermission(sender, "paradigm.mention.player", 0)) continue;
            this.notifyPlayer(targetPlayer, sender, message, isConsole, mentionConfig, playerMentionPlaceholder);
            ++mentionedCount;
            mentionedNames.add(this.platform.getPlayerName(targetPlayer));
        }
        if (mentionedCount > 0) {
            if (sender != null) {
                this.markMentionIndividualUsed(sender);
                IPlayer iSender = this.platform.wrapPlayer(sender);
                String list = String.join((CharSequence)", ", mentionedNames);
                String formatted = String.format((String)mentionConfig.SENDER_FEEDBACK_PLAYER_MESSAGE.value, list);
                IComponent feedback = services.getMessageParser().parseMessage(formatted, iSender);
                Pattern allPlayersPattern2 = this.buildAllPlayersMentionPattern(players, (String)mentionConfig.MENTION_SYMBOL.value);
                String appended = this.extractContentAfterFirstMatch(message, allPlayersPattern2);
                if (!appended.isEmpty()) {
                    String prefix = (String)mentionConfig.CHAT_APPEND_PREFIX.value;
                    IComponent nl = services.getPlatformAdapter().createComponentFromLiteral("\n" + prefix);
                    IComponent appendedComp = services.getMessageParser().parseMessage(appended, iSender);
                    feedback = feedback.append(nl).append(appendedComp);
                }
                this.platform.sendSystemMessage(sender, feedback.getOriginalText());
            }
            this.platform.sendSuccess(source, (class_2561)this.platform.createLiteralComponent("Mentioned " + mentionedCount + " player(s) successfully."), !isConsole);
        } else {
            this.platform.sendFailure(source, (class_2561)this.platform.createLiteralComponent("No valid mentions found in the message."));
        }
        return mentionedCount > 0 ? 1 : 0;
    }

    private void notifyEveryone(List<class_3222> players, class_3222 sender, String originalMessage, boolean isConsole, MentionConfigHandler.Config config, String matchedEveryoneMention) {
        int contentStartIndex;
        String senderName = isConsole || sender == null ? "Console" : this.platform.getPlayerName(sender);
        String chatFormat = (String)config.EVERYONE_MENTION_MESSAGE.value;
        String titleFormat = (String)config.EVERYONE_TITLE_MESSAGE.value;
        int mentionIndex = originalMessage.indexOf(matchedEveryoneMention);
        String content = "";
        if (mentionIndex >= 0 && (contentStartIndex = mentionIndex + matchedEveryoneMention.length()) < originalMessage.length()) {
            content = originalMessage.substring(contentStartIndex).trim();
        }
        this.services.getDebugLogger().debugLog("MENTION DEBUG - Original message: '" + originalMessage + "'");
        this.services.getDebugLogger().debugLog("MENTION DEBUG - Matched mention: '" + matchedEveryoneMention + "'");
        this.services.getDebugLogger().debugLog("MENTION DEBUG - Extracted content: '" + content + "'");
        String chatMessageText = String.format(chatFormat, senderName);
        String titleMessageText = String.format(titleFormat, senderName);
        for (class_3222 targetPlayer : players) {
            this.sendMentionNotification(targetPlayer, chatMessageText, titleMessageText, content, this.services);
        }
    }

    private void notifyPlayer(class_3222 targetPlayer, class_3222 sender, String originalMessage, boolean isConsole, MentionConfigHandler.Config config, String matchedPlayerMention) {
        int contentStartIndex;
        String senderName = isConsole || sender == null ? "Console" : this.platform.getPlayerName(sender);
        String chatFormat = (String)config.INDIVIDUAL_MENTION_MESSAGE.value;
        String titleFormat = (String)config.INDIVIDUAL_TITLE_MESSAGE.value;
        int mentionIndex = originalMessage.indexOf(matchedPlayerMention);
        String content = "";
        if (mentionIndex >= 0 && (contentStartIndex = mentionIndex + matchedPlayerMention.length()) < originalMessage.length()) {
            content = originalMessage.substring(contentStartIndex).trim();
        }
        this.services.getDebugLogger().debugLog("MENTION DEBUG - Original message: '" + originalMessage + "'");
        this.services.getDebugLogger().debugLog("MENTION DEBUG - Matched mention: '" + matchedPlayerMention + "'");
        this.services.getDebugLogger().debugLog("MENTION DEBUG - Extracted content: '" + content + "'");
        String chatMessageText = String.format(chatFormat, senderName);
        String titleMessageText = String.format(titleFormat, senderName);
        this.sendMentionNotification(targetPlayer, chatMessageText, titleMessageText, content, this.services);
    }

    private void sendMentionNotification(class_3222 targetPlayer, String chatMessage, String titleMessage, String contentMessage, Services services) {
        MentionConfigHandler.Config config = MentionConfigHandler.CONFIG;
        IPlayer iTarget = services.getPlatformAdapter().wrapPlayer(targetPlayer);
        long timestamp = System.currentTimeMillis();
        this.services.getDebugLogger().debugLog("NOTIFY DEBUG [" + timestamp + "] - Target: " + this.platform.getPlayerName(targetPlayer));
        this.services.getDebugLogger().debugLog("NOTIFY DEBUG [" + timestamp + "] - Chat message format: '" + chatMessage + "'");
        this.services.getDebugLogger().debugLog("NOTIFY DEBUG [" + timestamp + "] - Content message: '" + contentMessage + "'");
        if (((Boolean)config.enableChatNotification.value).booleanValue()) {
            IComponent finalChatMessage = services.getMessageParser().parseMessage(chatMessage, iTarget);
            if (contentMessage != null && !contentMessage.isEmpty()) {
                String prefix = (String)config.CHAT_APPEND_PREFIX.value;
                IComponent dash = services.getPlatformAdapter().createComponentFromLiteral("\n" + prefix);
                IComponent contentComp = services.getMessageParser().parseMessage(contentMessage, iTarget);
                finalChatMessage = finalChatMessage.append(dash).append(contentComp);
            }
            this.services.getDebugLogger().debugLog("NOTIFY DEBUG [" + timestamp + "] - Sending chat notification to: " + this.platform.getPlayerName(targetPlayer));
            this.platform.sendSystemMessage(targetPlayer, finalChatMessage.getOriginalText());
        }
        if (((Boolean)config.enableTitleNotification.value).booleanValue()) {
            boolean willShowSubtitle;
            IComponent parsedTitleMessage = services.getMessageParser().parseMessage(titleMessage, iTarget);
            IComponent parsedSubtitleMessage = this.platform.createEmptyComponent();
            boolean bl = willShowSubtitle = (Boolean)config.enableSubtitleNotification.value != false && contentMessage != null && !contentMessage.isEmpty();
            if (willShowSubtitle) {
                parsedSubtitleMessage = services.getMessageParser().parseMessage(contentMessage, iTarget);
            }
            this.services.getDebugLogger().debugLog("NOTIFY DEBUG [" + timestamp + "] - Sending title notification" + (willShowSubtitle ? " with subtitle" : " (no subtitle content)") + " to: " + this.platform.getPlayerName(targetPlayer));
            this.platform.sendTitle(targetPlayer, parsedTitleMessage.getOriginalText(), parsedSubtitleMessage.getOriginalText());
        }
        this.platform.playSound(targetPlayer, "minecraft:entity.experience_orb.pickup", class_3419.field_15248, 1.0f, 1.0f);
        this.services.getDebugLogger().debugLog("NOTIFY DEBUG [" + timestamp + "] - Notification complete for: " + this.platform.getPlayerName(targetPlayer));
    }

    private boolean hasPermission(class_3222 player, String permissionNode, int permissionLevel) {
        return this.platform.hasPermission(player, permissionNode, permissionLevel);
    }

    private Pattern buildAllPlayersMentionPattern(List<class_3222> players, String mentionSymbol) {
        if (players.isEmpty()) {
            return Pattern.compile("(?!x)x");
        }
        String allPlayerNames = players.stream().map(p -> Pattern.quote(this.platform.getPlayerName((class_3222)p))).collect(Collectors.joining("|"));
        return Pattern.compile(Pattern.quote(mentionSymbol) + "(" + allPlayerNames + ")", 2);
    }

    private boolean canMentionEveryoneNow(class_3222 sender, MentionConfigHandler.Config config) {
        if (sender == null) {
            return true;
        }
        if (sender.method_5687(2)) {
            return true;
        }
        int rateLimit = config.EVERYONE_MENTION_RATE_LIMIT.get();
        if (rateLimit <= 0) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        Long last = this.lastEveryoneMentionBySender.get(sender.method_5667());
        return last == null || currentTime - last >= (long)rateLimit * 1000L;
    }

    private void markMentionEveryoneUsed(class_3222 sender) {
        if (sender == null) {
            return;
        }
        this.lastEveryoneMentionBySender.put(sender.method_5667(), System.currentTimeMillis());
    }

    private boolean canMentionIndividualNow(class_3222 sender, MentionConfigHandler.Config config) {
        if (sender == null) {
            return true;
        }
        if (sender.method_5687(2)) {
            return true;
        }
        int rateLimit = config.INDIVIDUAL_MENTION_RATE_LIMIT.get();
        if (rateLimit <= 0) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        Long last = this.lastIndividualMentionBySender.get(sender.method_5667());
        return last == null || currentTime - last >= (long)rateLimit * 1000L;
    }

    private void markMentionIndividualUsed(class_3222 sender) {
        if (sender == null) {
            return;
        }
        this.lastIndividualMentionBySender.put(sender.method_5667(), System.currentTimeMillis());
    }

    private String extractContentAfterToken(String originalMessage, String matchedToken) {
        if (originalMessage == null || matchedToken == null) {
            return "";
        }
        int idx = originalMessage.indexOf(matchedToken);
        if (idx < 0) {
            return "";
        }
        int end = idx + matchedToken.length();
        if (end >= originalMessage.length()) {
            return "";
        }
        return originalMessage.substring(end).trim();
    }

    private String extractContentAfterFirstMatch(String message, Pattern pattern) {
        if (message == null || pattern == null) {
            return "";
        }
        Matcher m = pattern.matcher(message);
        if (!m.find()) {
            return "";
        }
        int end = m.end();
        if (end >= message.length()) {
            return "";
        }
        return message.substring(end).trim();
    }
}

