/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftComponent;
import eu.avalanche7.paradigm.utils.Placeholders;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class MessageParser {
    private final Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private final Pattern urlPattern = Pattern.compile("https?://\\S+");
    private final Map<Pattern, BiConsumer<Matcher, TagContext>> tagHandlers;
    private final Map<String, IComponent> messageCache = new ConcurrentHashMap<String, IComponent>();
    private final Placeholders placeholders;
    private final IPlatformAdapter platformAdapter;

    public MessageParser(Placeholders placeholders, IPlatformAdapter platformAdapter) {
        this.placeholders = placeholders;
        this.platformAdapter = platformAdapter;
        this.tagHandlers = new LinkedHashMap<Pattern, BiConsumer<Matcher, TagContext>>();
        this.initializeTagHandlers();
    }

    private void initializeTagHandlers() {
        this.tagHandlers.put(Pattern.compile("\\[link=([^\\]]+)\\]"), (matcher, context) -> {
            if (this.platformAdapter == null) {
                return;
            }
            String url = matcher.group(1);
            IComponent urlComponent = new MinecraftComponent(this.platformAdapter.createLiteralComponent(url));
            urlComponent = urlComponent.onClickOpenUrl(this.formatUrl(url));
            urlComponent = this.platformAdapter.parseFormattingCode("b", urlComponent);
            context.getComponent().append(urlComponent);
        });
        this.tagHandlers.put(Pattern.compile("\\[command=([^\\]]+)\\]"), (matcher, context) -> {
            if (this.platformAdapter == null) {
                return;
            }
            String command = matcher.group(1);
            String displayText = command.startsWith("/") ? command : command;
            Object fullCommand = command.startsWith("/") ? command : "/" + command;
            IComponent cmdComponent = new MinecraftComponent(this.platformAdapter.createLiteralComponent(displayText));
            cmdComponent = cmdComponent.onClickRunCommand((String)fullCommand);
            cmdComponent = this.platformAdapter.parseFormattingCode("b", cmdComponent);
            context.getComponent().append(cmdComponent);
        });
        this.tagHandlers.put(Pattern.compile("\\[hover=(.*?)\\](.*?)\\[/hover\\]", 32), (matcher, context) -> {
            if (this.platformAdapter == null) {
                return;
            }
            String hoverTextContent = matcher.group(1);
            String mainTextContent = matcher.group(2);
            IComponent hoverComponent = this.parseMessageInternal(hoverTextContent, context.getPlayer());
            IComponent textWithHover = this.parseMessageInternal(mainTextContent, context.getPlayer());
            textWithHover = textWithHover.onHoverComponent(hoverComponent);
            context.getComponent().append(textWithHover);
        });
        this.tagHandlers.put(Pattern.compile("\\[divider\\]"), (matcher, context) -> {
            if (this.platformAdapter == null) {
                return;
            }
            String dividerLine = "\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501";
            IComponent dividerComponent = new MinecraftComponent(this.platformAdapter.createLiteralComponent(dividerLine));
            dividerComponent = dividerComponent.withColor("gray");
            context.getComponent().append(dividerComponent);
        });
        this.tagHandlers.put(Pattern.compile("\\[title=(.*?)\\]", 32), (matcher, context) -> {
            if (this.platformAdapter == null || context.getPlayer() == null) {
                return;
            }
            String titleText = matcher.group(1);
            IComponent titleComponent = this.parseMessageInternal(titleText, context.getPlayer());
            if (titleComponent instanceof MinecraftComponent) {
                MinecraftComponent mc = (MinecraftComponent)titleComponent;
                this.platformAdapter.clearTitles(context.getPlayer().getOriginalPlayer());
                this.platformAdapter.sendTitle(context.getPlayer().getOriginalPlayer(), (class_2561)mc.getHandle(), (class_2561)this.platformAdapter.createLiteralComponent(""));
            }
        });
        this.tagHandlers.put(Pattern.compile("\\[subtitle=(.*?)\\]", 32), (matcher, context) -> {
            if (this.platformAdapter == null || context.getPlayer() == null) {
                return;
            }
            String subtitleText = matcher.group(1);
            IComponent subtitleComponent = this.parseMessageInternal(subtitleText, context.getPlayer());
            if (subtitleComponent instanceof MinecraftComponent) {
                MinecraftComponent mc = (MinecraftComponent)subtitleComponent;
                this.platformAdapter.sendSubtitle(context.getPlayer().getOriginalPlayer(), (class_2561)mc.getHandle());
            }
        });
        this.tagHandlers.put(Pattern.compile("\\[center\\](.*?)\\[/center\\]", 32), (matcher, context) -> {
            int totalPadding;
            int leftPadding;
            if (this.platformAdapter == null) {
                return;
            }
            String textToCenter = matcher.group(1);
            IComponent innerComponent = this.parseMessageInternal(textToCenter, context.getPlayer());
            String plainInnerText = innerComponent.getRawText();
            int approximateChatWidthChars = 53;
            int textLength = plainInnerText.length();
            if (textLength < approximateChatWidthChars && (leftPadding = (totalPadding = approximateChatWidthChars - textLength) / 2) > 0) {
                String paddingSpaces = " ".repeat(leftPadding);
                MinecraftComponent padComponent = new MinecraftComponent(this.platformAdapter.createLiteralComponent(paddingSpaces));
                context.getComponent().append(padComponent);
            }
            context.getComponent().append(innerComponent);
        });
    }

    public IComponent parseMessage(String rawMessage, IPlayer player) {
        return this.parseMessageInternal(rawMessage, player);
    }

    private IComponent parseMessageInternal(String rawMessage, IPlayer player) {
        if (rawMessage == null) {
            return this.platformAdapter != null ? this.platformAdapter.createEmptyComponent() : null;
        }
        if (this.platformAdapter == null) {
            return this.platformAdapter.createEmptyComponent();
        }
        String processedMessage = this.placeholders.replacePlaceholders(rawMessage, player != null ? player.getOriginalPlayer() : null);
        Matcher hexMatcher = this.hexPattern.matcher(processedMessage);
        StringBuilder sb = new StringBuilder();
        while (hexMatcher.find()) {
            String hexColor = hexMatcher.group(1);
            hexMatcher.appendReplacement(sb, "\u00a7#" + hexColor);
        }
        hexMatcher.appendTail(sb);
        processedMessage = sb.toString();
        String messageForParsing = processedMessage.replace("&", "\u00a7");
        IComponent rootComponent = this.platformAdapter.createEmptyComponent();
        this.parseTextRecursive(messageForParsing, rootComponent, player);
        return rootComponent;
    }

    private void parseTextRecursive(String textToParse, IComponent parentComponent, IPlayer player) {
        if (this.platformAdapter == null) {
            return;
        }
        int currentIndex = 0;
        int length = textToParse.length();
        StringBuilder plainTextBuffer = new StringBuilder();
        String currentColor = null;
        String currentFormatting = null;
        while (currentIndex < length) {
            int nextFormatCode = textToParse.indexOf(167, currentIndex);
            int nextTagStart = textToParse.indexOf(91, currentIndex);
            Matcher urlMatcher = this.urlPattern.matcher(textToParse);
            boolean nextUrlFound = urlMatcher.find(currentIndex);
            int nextUrlStart = nextUrlFound ? urlMatcher.start() : -1;
            int firstEventIndex = length;
            if (nextFormatCode != -1) {
                firstEventIndex = Math.min(firstEventIndex, nextFormatCode);
            }
            if (nextTagStart != -1) {
                firstEventIndex = Math.min(firstEventIndex, nextTagStart);
            }
            if (nextUrlFound) {
                firstEventIndex = Math.min(firstEventIndex, nextUrlStart);
            }
            if (firstEventIndex > currentIndex) {
                plainTextBuffer.append(textToParse, currentIndex, firstEventIndex);
            }
            if ((currentIndex = firstEventIndex) == length) break;
            if (nextFormatCode == currentIndex) {
                if (currentIndex + 1 < length) {
                    char formatChar = textToParse.charAt(currentIndex + 1);
                    if (formatChar == '#') {
                        if (currentIndex + 8 <= length) {
                            String hex;
                            if (plainTextBuffer.length() > 0) {
                                this.appendStyledText(parentComponent, plainTextBuffer.toString(), currentColor, currentFormatting);
                                plainTextBuffer.setLength(0);
                            }
                            currentColor = hex = textToParse.substring(currentIndex + 2, currentIndex + 8);
                            currentFormatting = null;
                            currentIndex += 8;
                            continue;
                        }
                        plainTextBuffer.append("\u00a7#");
                        currentIndex += 2;
                        continue;
                    }
                    if (formatChar == 'r') {
                        if (plainTextBuffer.length() > 0) {
                            this.appendStyledText(parentComponent, plainTextBuffer.toString(), currentColor, currentFormatting);
                            plainTextBuffer.setLength(0);
                        }
                        currentColor = null;
                        currentFormatting = null;
                        currentIndex += 2;
                        continue;
                    }
                    class_124 format = class_124.method_544((char)formatChar);
                    if (format != null) {
                        if (plainTextBuffer.length() > 0) {
                            this.appendStyledText(parentComponent, plainTextBuffer.toString(), currentColor, currentFormatting);
                            plainTextBuffer.setLength(0);
                        }
                        if (format.method_543()) {
                            currentColor = String.valueOf(formatChar);
                            currentFormatting = null;
                        } else {
                            currentFormatting = String.valueOf(formatChar);
                        }
                    } else {
                        plainTextBuffer.append('\u00a7').append(formatChar);
                    }
                    currentIndex += 2;
                    continue;
                }
                plainTextBuffer.append('\u00a7');
                ++currentIndex;
                continue;
            }
            if (nextTagStart == currentIndex) {
                if (plainTextBuffer.length() > 0) {
                    this.appendStyledText(parentComponent, plainTextBuffer.toString(), currentColor, currentFormatting);
                    plainTextBuffer.setLength(0);
                }
                boolean tagHandled = false;
                for (Map.Entry<Pattern, BiConsumer<Matcher, TagContext>> entry : this.tagHandlers.entrySet()) {
                    Pattern tagPattern = entry.getKey();
                    Matcher tagMatcher = tagPattern.matcher(textToParse);
                    if (!tagMatcher.find(currentIndex) || tagMatcher.start() != currentIndex) continue;
                    TagContext context = new TagContext(parentComponent, player);
                    entry.getValue().accept(tagMatcher, context);
                    currentIndex = tagMatcher.end();
                    tagHandled = true;
                    break;
                }
                if (tagHandled) continue;
                plainTextBuffer.append('[');
                ++currentIndex;
                continue;
            }
            if (nextUrlFound && nextUrlStart == currentIndex) {
                if (plainTextBuffer.length() > 0) {
                    this.appendStyledText(parentComponent, plainTextBuffer.toString(), currentColor, currentFormatting);
                    plainTextBuffer.setLength(0);
                }
                String url = urlMatcher.group(0);
                IComponent urlComp = new MinecraftComponent(this.platformAdapter.createLiteralComponent(url));
                urlComp = urlComp.onClickOpenUrl(this.formatUrl(url));
                urlComp = this.platformAdapter.parseFormattingCode("b", urlComp);
                parentComponent.append(urlComp);
                currentIndex = urlMatcher.end();
                continue;
            }
            if (currentIndex >= length) continue;
            plainTextBuffer.append(textToParse.charAt(currentIndex));
            ++currentIndex;
        }
        if (plainTextBuffer.length() > 0) {
            this.appendStyledText(parentComponent, plainTextBuffer.toString(), currentColor, currentFormatting);
        }
    }

    private void appendStyledText(IComponent parentComponent, String text, String color, String formatting) {
        if (text.isEmpty()) {
            return;
        }
        IComponent textComp = new MinecraftComponent(this.platformAdapter.createLiteralComponent(text));
        if (color != null) {
            if (color.length() == 6) {
                textComp = this.platformAdapter.parseHexColor(color, textComp);
            } else if (color.length() == 1) {
                textComp = this.platformAdapter.parseFormattingCode(color, textComp);
            }
        }
        if (formatting != null && formatting.length() == 1) {
            textComp = this.platformAdapter.parseFormattingCode(formatting, textComp);
        }
        parentComponent.append(textComp);
    }

    private String formatUrl(String url) {
        if (url != null && !url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
            return "https://" + url;
        }
        return url;
    }

    private static class TagContext {
        private final IComponent component;
        private final IPlayer player;

        public TagContext(IComponent component, IPlayer player) {
            this.component = component;
            this.player = player;
        }

        public IComponent getComponent() {
            return this.component;
        }

        public IPlayer getPlayer() {
            return this.player;
        }
    }
}

