/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.configs.CMConfig;
import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.utils.DebugLogger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_3222;
import org.slf4j.Logger;

public class PermissionsHandler {
    private final Logger logger;
    private final CMConfig cmConfig;
    private final DebugLogger debugLogger;
    public static final String MENTION_EVERYONE_PERMISSION = "paradigm.mention.everyone";
    public static final String MENTION_PLAYER_PERMISSION = "paradigm.mention.player";
    public static final String STAFF_CHAT_PERMISSION = "paradigm.staff";
    public static final String RESTART_MANAGE_PERMISSION = "paradigm.restart.manage";
    public static final String BROADCAST_PERMISSION = "paradigm.broadcast";
    public static final String GROUPCHAT_PERMISSION = "paradigm.groupchat";
    public static final String RELOAD_PERMISSION = "paradigm.reload";
    public static final int MENTION_EVERYONE_PERMISSION_LEVEL = 2;
    public static final int MENTION_PLAYER_PERMISSION_LEVEL = 0;
    public static final int BROADCAST_PERMISSION_LEVEL = 2;
    public static final int RESTART_MANAGE_PERMISSION_LEVEL = 2;
    private PermissionChecker checker;

    public PermissionsHandler(Logger logger, CMConfig cmConfig, DebugLogger debugLogger) {
        this.logger = logger;
        this.cmConfig = cmConfig;
        this.debugLogger = debugLogger;
    }

    public void initialize() {
        this.initializeChecker();
    }

    public void registerLuckPermsPermissions() {
        this.registerPermissionsWithLuckPerms();
    }

    private void initializeChecker() {
        if (this.checker == null) {
            if (FabricLoader.getInstance().isModLoaded("luckperms")) {
                this.checker = new LuckPermsCheckerImpl();
                this.logger.info("Paradigm: Using LuckPerms for permission checks.");
            } else {
                this.checker = new VanillaPermissionCheckerImpl();
                this.logger.info("Paradigm: LuckPerms not found. Using vanilla operator permissions for checks.");
            }
        }
    }

    private void registerPermissionsWithLuckPerms() {
        if (!FabricLoader.getInstance().isModLoaded("luckperms")) {
            return;
        }
        this.registerPermissionsWithLuckPermsRetry(0);
    }

    private void registerPermissionsWithLuckPermsRetry(int attemptCount) {
        if (attemptCount >= 5) {
            this.logger.warn("Paradigm: Failed to register permissions with LuckPerms after {} attempts.", (Object)attemptCount);
            return;
        }
        try {
            LuckPerms api = LuckPermsProvider.get();
            Map<String, String> allPermissions = this.knownPermissionNodes();
            UUID dummyUuid = UUID.fromString("00000000-0000-0000-0000-000000000000");
            User dummyUser = (User)api.getUserManager().loadUser(dummyUuid).join();
            if (dummyUser != null) {
                for (String permission : allPermissions.keySet()) {
                    dummyUser.getCachedData().getPermissionData().checkPermission(permission);
                    this.debugLogger.debugLog("Registered permission with LuckPerms: " + permission);
                }
                this.logger.info("Paradigm: Made " + allPermissions.size() + " permissions visible to LuckPerms.");
            }
        }
        catch (IllegalStateException e) {
            if (e.getMessage() != null && e.getMessage().contains("API isn't loaded")) {
                this.debugLogger.debugLog("LuckPerms not ready yet, retrying in " + (attemptCount + 1) + " seconds... (attempt " + (attemptCount + 1) + "/5)");
                this.scheduleRetry(attemptCount);
            } else {
                this.logger.warn("Paradigm: Failed to register permissions with LuckPerms: " + e.getMessage());
            }
        }
        catch (Exception e) {
            this.logger.warn("Paradigm: Failed to register permissions with LuckPerms: " + e.getMessage());
        }
    }

    private void scheduleRetry(int attemptCount) {
        new Thread(() -> {
            try {
                Thread.sleep((long)(attemptCount + 1) * 1000L);
                this.registerPermissionsWithLuckPermsRetry(attemptCount + 1);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public void refreshCustomCommandPermissions() {
        this.registerPermissionsWithLuckPerms();
    }

    public boolean hasPermission(class_3222 player, String permission) {
        if (player == null) {
            return false;
        }
        if (this.checker == null) {
            this.initialize();
        }
        return this.checker.hasPermission(player, permission);
    }

    public Map<String, String> knownPermissionNodes() {
        LinkedHashMap<String, String> nodes = new LinkedHashMap<String, String>();
        nodes.put(STAFF_CHAT_PERMISSION, "Access to /sc (Staff Chat) and receiving staff messages.");
        nodes.put(MENTION_EVERYONE_PERMISSION, "Allows using @everyone to ping all players in Mentions module.");
        nodes.put(MENTION_PLAYER_PERMISSION, "Allows mentioning individual players in Mentions module.");
        nodes.put(RESTART_MANAGE_PERMISSION, "Allows managing restarts: /restart now, /restart cancel.");
        nodes.put(BROADCAST_PERMISSION, "Allows using /paradigm broadcast, actionbar, title, and bossbar commands.");
        nodes.put(GROUPCHAT_PERMISSION, "Allows using /groupchat commands (create, invite, join, etc.).");
        nodes.put(RELOAD_PERMISSION, "Allows using /paradigm reload and /customcommandsreload commands.");
        if (this.cmConfig != null && this.cmConfig.getLoadedCommands() != null) {
            for (CustomCommand cmd : this.cmConfig.getLoadedCommands()) {
                if (!cmd.isRequirePermission() || cmd.getPermission() == null || cmd.getPermission().trim().isEmpty()) continue;
                String desc = cmd.getDescription() != null && !cmd.getDescription().trim().isEmpty() ? cmd.getDescription() : "Custom command: /" + cmd.getName();
                nodes.put(cmd.getPermission(), desc);
            }
        }
        return nodes;
    }

    public static interface PermissionChecker {
        public boolean hasPermission(class_3222 var1, String var2);
    }

    public static class LuckPermsCheckerImpl
    implements PermissionChecker {
        @Override
        public boolean hasPermission(class_3222 player, String permission) {
            try {
                LuckPerms api = LuckPermsProvider.get();
                User user = api.getUserManager().getUser(player.method_5667());
                if (user != null) {
                    Tristate result = user.getCachedData().getPermissionData().checkPermission(permission);
                    return result.asBoolean();
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }
    }

    private static class VanillaPermissionCheckerImpl
    implements PermissionChecker {
        private VanillaPermissionCheckerImpl() {
        }

        @Override
        public boolean hasPermission(class_3222 player, String permission) {
            int requiredLevel = this.getPermissionLevelForVanilla(permission);
            return player.method_5687(requiredLevel);
        }

        private int getPermissionLevelForVanilla(String permission) {
            if (permission == null) {
                return 4;
            }
            return switch (permission) {
                case PermissionsHandler.STAFF_CHAT_PERMISSION, PermissionsHandler.MENTION_EVERYONE_PERMISSION, PermissionsHandler.RESTART_MANAGE_PERMISSION, PermissionsHandler.BROADCAST_PERMISSION, PermissionsHandler.RELOAD_PERMISSION -> 2;
                case PermissionsHandler.MENTION_PLAYER_PERMISSION, PermissionsHandler.GROUPCHAT_PERMISSION -> 0;
                default -> permission.startsWith("paradigm.") ? 0 : 4;
            };
        }
    }
}

