/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.webeditor.socket;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.webeditor.EditorApplier;
import eu.avalanche7.paradigm.webeditor.WebEditorRequest;
import eu.avalanche7.paradigm.webeditor.WebEditorSession;
import eu.avalanche7.paradigm.webeditor.socket.BytesocksClient;
import eu.avalanche7.paradigm.webeditor.socket.SignatureAlgorithm;
import eu.avalanche7.paradigm.webeditor.socket.SocketMessageType;
import eu.avalanche7.paradigm.webeditor.store.RemoteSession;
import eu.avalanche7.paradigm.webeditor.store.WebEditorKeystore;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;

public class WebEditorSocket {
    private static final Gson GSON = new Gson();
    private final Services services;
    private final ICommandSource owner;
    private final KeyPair pluginKeyPair;
    private BytesocksClient.Socket socket;
    private volatile PublicKey remotePublicKey;
    private volatile boolean closed = false;
    private volatile long lastPing = System.currentTimeMillis();
    private final CompletableFuture<Void> connectFuture = new CompletableFuture();
    private ScheduledFuture<?> keepaliveTask;
    private final Map<String, PublicKey> attemptedConnections = new ConcurrentHashMap<String, PublicKey>();

    public WebEditorSocket(Services services, ICommandSource owner) {
        this.services = Objects.requireNonNull(services, "services");
        this.owner = owner;
        this.pluginKeyPair = services.getWebEditorStore().keyPair();
    }

    private boolean debugEnabled() {
        try {
            return MainConfigHandler.CONFIG.debugEnable.get();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void initialize(BytesocksClient client) throws Exception {
        BytesocksListener listener = new BytesocksListener(this);
        try {
            this.socket = new BytesocksClient.Socket("pending", null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = client.createSocket(listener);
    }

    public void appendDetailToRequest(WebEditorRequest request) {
        String channelId = this.getChannelId();
        String publicKey = Base64.getEncoder().encodeToString(this.pluginKeyPair.getPublic().getEncoded());
        JsonObject socket = new JsonObject();
        socket.addProperty("protocolVersion", (Number)SignatureAlgorithm.INSTANCE.protocolVersion());
        socket.addProperty("channelId", channelId);
        socket.addProperty("publicKey", publicKey);
        request.getPayload().add("socket", (JsonElement)socket);
    }

    public void send(JsonObject msg) {
        String encoded = GSON.toJson((JsonElement)msg);
        String signature = SignatureAlgorithm.INSTANCE.sign(this.pluginKeyPair.getPrivate(), encoded);
        if (this.debugEnabled()) {
            try {
                String type = msg.has("type") ? WebEditorSocket.safeGetAsString(msg, "type") : null;
                this.services.getLogger().debug("Paradigm WebEditor: Socket SEND type={}, channel={}, bytes={}", new Object[]{type, this.getChannelId(), encoded.length()});
            }
            catch (Throwable type) {
                // empty catch block
            }
        }
        JsonObject frame = new JsonObject();
        frame.addProperty("msg", encoded);
        frame.addProperty("signature", signature);
        String frameJson = GSON.toJson((JsonElement)frame);
        try {
            this.socket.webSocket().sendText(frameJson, true).whenComplete((ws, ex) -> {
                if (ex != null) {
                    try {
                        this.services.getLogger().warn("Paradigm WebEditor: WebSocket sendText failed for channel {}: {}", (Object)this.getChannelId(), (Object)ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            try {
                this.services.getLogger().warn("Paradigm WebEditor: Failed to send socket message to channel {}: {}", new Object[]{this.getChannelId(), e.getMessage(), e});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void scheduleCleanupIfUnused() {
        this.cancelKeepalive();
        try {
            this.services.getLogger().info("Paradigm WebEditor: Scheduling cleanup check for channel={} in 60s", (Object)this.getChannelId());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.keepaliveTask = this.services.getTaskScheduler().schedule(() -> {
            if (this.closed) {
                return;
            }
            if (this.remotePublicKey == null && System.currentTimeMillis() - this.lastPing > TimeUnit.MINUTES.toMillis(1L)) {
                try {
                    this.services.getLogger().info("Paradigm WebEditor: Cleanup triggered for channel={} (no HELLO/heartbeat)", (Object)this.getChannelId());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.close();
            } else {
                this.startKeepalive();
            }
        }, 60L, TimeUnit.SECONDS);
    }

    private void startKeepalive() {
        this.cancelKeepalive();
        try {
            this.services.getLogger().info("Paradigm WebEditor: Starting keepalive checks for channel={}", (Object)this.getChannelId());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.keepaliveTask = this.services.getTaskScheduler().scheduleAtFixedRate(() -> {
            if (System.currentTimeMillis() - this.lastPing > TimeUnit.MINUTES.toMillis(2L)) {
                try {
                    this.services.getLogger().info("Paradigm WebEditor: Keepalive timeout for channel={} (closing)", (Object)this.getChannelId());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.close();
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    private void cancelKeepalive() {
        ScheduledFuture<?> t = this.keepaliveTask;
        if (t != null) {
            t.cancel(false);
            this.keepaliveTask = null;
            try {
                this.services.getLogger().info("Paradigm WebEditor: Cancelled keepalive for channel={}", (Object)this.getChannelId());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.services.getLogger().info("Paradigm WebEditor: Closing socket for channel={}", (Object)this.getChannelId());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            JsonObject pong = new JsonObject();
            pong.addProperty("type", SocketMessageType.PONG.id);
            pong.addProperty("ok", Boolean.valueOf(false));
            this.send(pong);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.webSocket().sendClose(1000, "Normal");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
        try {
            this.services.getWebEditorStore().sockets().removeSocket(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cancelKeepalive();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getChannelId() {
        return this.socket != null ? this.socket.channelId() : "unsupported";
    }

    public PublicKey getRemotePublicKey() {
        return this.remotePublicKey;
    }

    public void setRemotePublicKey(PublicKey remotePublicKey) {
        this.remotePublicKey = remotePublicKey;
    }

    public CompletableFuture<Void> connectFuture() {
        return this.connectFuture;
    }

    public ICommandSource getOwner() {
        return this.owner;
    }

    public boolean isOwnedBy(ICommandSource src) {
        if (src == null || this.owner == null) {
            return false;
        }
        if (src.isConsole() && this.owner.isConsole()) {
            return true;
        }
        if (!src.isConsole() && !this.owner.isConsole() && src.getPlayer() != null && this.owner.getPlayer() != null) {
            return Objects.equals(src.getPlayer().getUUID(), this.owner.getPlayer().getUUID());
        }
        return false;
    }

    public PublicKey getAttemptedPublicKey(String nonce) {
        if (nonce == null) {
            return null;
        }
        return this.attemptedConnections.get(nonce);
    }

    public boolean clearAttempt(String nonce) {
        if (nonce == null) {
            return false;
        }
        return this.attemptedConnections.remove(nonce) != null;
    }

    public Set<String> getPendingNonces() {
        return this.attemptedConnections.keySet();
    }

    private static String safeGetAsString(JsonObject obj, String key) {
        if (obj == null || key == null) {
            return null;
        }
        if (!obj.has(key)) {
            return null;
        }
        JsonElement el = obj.get(key);
        if (el == null || el.isJsonNull()) {
            return null;
        }
        try {
            return el.getAsString();
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private void handleMessageFrame(String stringMsg) {
        try {
            boolean verified;
            String typeStr;
            JsonObject frame;
            if (stringMsg == null || stringMsg.trim().isEmpty()) {
                if (this.debugEnabled()) {
                    try {
                        this.services.getLogger().warn("Paradigm WebEditor: Received empty message frame on channel {}", (Object)this.getChannelId());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
            if (this.debugEnabled()) {
                try {
                    this.services.getLogger().debug("Paradigm WebEditor: Raw frame received, channel={}, bytes={}, preview={}", new Object[]{this.getChannelId(), stringMsg.length(), stringMsg.length() > 300 ? stringMsg.substring(0, 300) + "..." : stringMsg});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                frame = (JsonObject)GSON.fromJson(stringMsg, JsonObject.class);
            }
            catch (Exception e) {
                if (this.debugEnabled()) {
                    try {
                        this.services.getLogger().warn("Paradigm WebEditor: Failed to parse frame JSON on channel {}: {}", (Object)this.getChannelId(), (Object)e.getMessage());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Invalid JSON frame: " + e.getMessage());
            }
            if (frame == null) {
                if (this.debugEnabled()) {
                    try {
                        this.services.getLogger().warn("Paradigm WebEditor: Frame parsed to null on channel {}", (Object)this.getChannelId());
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Frame is null");
            }
            String innerMsg = WebEditorSocket.safeGetAsString(frame, "msg");
            String signature = WebEditorSocket.safeGetAsString(frame, "signature");
            if (innerMsg == null || innerMsg.isEmpty()) {
                if (this.debugEnabled()) {
                    try {
                        this.services.getLogger().warn("Paradigm WebEditor: Incomplete message frame on channel {}, hasMsg={}, hasSig={}, frameKeys={}", new Object[]{this.getChannelId(), frame.has("msg"), frame.has("signature"), frame.keySet()});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Incomplete message: missing 'msg' field");
            }
            JsonObject msg = (JsonObject)GSON.fromJson(innerMsg, JsonObject.class);
            String string = typeStr = msg != null ? WebEditorSocket.safeGetAsString(msg, "type") : null;
            if (typeStr == null) {
                throw new IllegalStateException("Missing type");
            }
            SocketMessageType type = SocketMessageType.getById(typeStr);
            if (this.debugEnabled()) {
                try {
                    this.services.getLogger().debug("Paradigm WebEditor: Socket RECV type={}, channel={}, signed={}", new Object[]{typeStr, this.getChannelId(), signature != null});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (type == SocketMessageType.HELLO) {
                block76: {
                    this.services.getLogger().info("Paradigm WebEditor: Full HELLO message: {}", (Object)msg);
                    this.lastPing = System.currentTimeMillis();
                    try {
                        boolean trusted;
                        RemoteSession rs;
                        PublicKey remote;
                        String nonce = WebEditorSocket.safeGetAsString(msg, "nonce");
                        String publicKeyB64 = WebEditorSocket.safeGetAsString(msg, "publicKey");
                        String sessionId = WebEditorSocket.safeGetAsString(msg, "sessionId");
                        String browser = WebEditorSocket.safeGetAsString(msg, "browser");
                        if (publicKeyB64 == null || publicKeyB64.isEmpty()) {
                            JsonObject reply = new JsonObject();
                            reply.addProperty("type", SocketMessageType.HELLO_REPLY.id);
                            reply.addProperty("nonce", nonce == null ? "" : nonce);
                            reply.addProperty("state", "invalid");
                            this.send(reply);
                            try {
                                this.services.getLogger().info("Paradigm WebEditor: HELLO -> reply=invalid, channel={}, nonce={}", (Object)this.getChannelId(), (Object)nonce);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return;
                        }
                        try {
                            remote = SignatureAlgorithm.INSTANCE.parsePublicKey(publicKeyB64);
                        }
                        catch (Exception ex) {
                            JsonObject reply = new JsonObject();
                            reply.addProperty("type", SocketMessageType.HELLO_REPLY.id);
                            reply.addProperty("nonce", nonce == null ? "" : nonce);
                            reply.addProperty("state", "invalid");
                            this.send(reply);
                            try {
                                this.services.getLogger().info("Paradigm WebEditor: HELLO -> reply=invalid(publicKey parse failed), channel={}, nonce={}", (Object)this.getChannelId(), (Object)nonce);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return;
                        }
                        if (this.remotePublicKey != null && !this.remotePublicKey.equals(remote)) {
                            String existingKeyHash = WebEditorKeystore.hash(this.remotePublicKey.getEncoded());
                            String newKeyHash = WebEditorKeystore.hash(remote.getEncoded());
                            try {
                                this.services.getLogger().info("Paradigm WebEditor: Rejecting connection with different key. channel={}, existingKey={}, attemptedKey={}", new Object[]{this.getChannelId(), existingKeyHash, newKeyHash});
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            JsonObject reply2 = new JsonObject();
                            reply2.addProperty("type", SocketMessageType.HELLO_REPLY.id);
                            reply2.addProperty("nonce", nonce == null ? "" : nonce);
                            reply2.addProperty("state", "rejected");
                            this.send(reply2);
                            return;
                        }
                        if (sessionId != null && ((rs = this.services.getWebEditorStore().sessions().getSession(sessionId)) == null || rs.isCompleted())) {
                            JsonObject reply = new JsonObject();
                            reply.addProperty("type", SocketMessageType.HELLO_REPLY.id);
                            reply.addProperty("nonce", nonce == null ? "" : nonce);
                            reply.addProperty("state", "invalid");
                            this.send(reply);
                            try {
                                this.services.getLogger().info("Paradigm WebEditor: HELLO -> reply=invalid(session), channel={}, sessionId={}, nonce={}", new Object[]{this.getChannelId(), sessionId, nonce});
                            }
                            catch (Throwable reply2) {
                                // empty catch block
                            }
                            if (this.debugEnabled()) {
                                try {
                                    this.services.getLogger().debug("Paradigm WebEditor: HELLO reply state=invalid, sessionId={}", (Object)sessionId);
                                }
                                catch (Throwable reply2) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                        boolean bl = trusted = this.owner != null && this.services.getWebEditorStore().keystore().isTrusted(this.owner, remote.getEncoded());
                        if (!trusted) {
                            block75: {
                                this.attemptedConnections.put(nonce == null ? "" : nonce, remote);
                                JsonObject reply = new JsonObject();
                                reply.addProperty("type", SocketMessageType.HELLO_REPLY.id);
                                reply.addProperty("nonce", nonce == null ? "" : nonce);
                                reply.addProperty("state", "untrusted");
                                this.send(reply);
                                if (this.debugEnabled()) {
                                    try {
                                        this.services.getLogger().debug("Paradigm WebEditor: HELLO reply state=untrusted, nonce={} channel={}", (Object)nonce, (Object)this.getChannelId());
                                    }
                                    catch (Throwable reply2) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    if (this.owner == null) break block75;
                                    String cmd = "/paradigm editor trust " + (nonce == null ? "nonce" : nonce);
                                    IComponent clickable = this.services.getPlatformAdapter().createComponentFromLiteral("Click to trust this editor (" + (browser == null ? "unknown" : browser) + ")").onClickRunCommand(cmd).onHoverText("Run " + cmd);
                                    try {
                                        Object orig = this.owner.getOriginalSource();
                                        if (orig instanceof class_2168) {
                                            class_2168 scs = (class_2168)orig;
                                            this.services.getPlatformAdapter().sendSuccess(scs, clickable.getOriginalText(), false);
                                            break block75;
                                        }
                                        this.services.getLogger().info("Paradigm WebEditor: owner original source is not a ServerCommandSource for owner={}", (Object)this.owner.getSourceName());
                                    }
                                    catch (Throwable orig) {}
                                }
                                catch (Throwable cmd) {
                                    // empty catch block
                                }
                            }
                            try {
                                String ownerName = this.owner == null ? "unknown" : this.owner.getSourceName();
                                String pkHash = WebEditorKeystore.hash(remote.getEncoded());
                                this.services.getLogger().info("Paradigm WebEditor: Untrusted editor attempted to connect. channel={}, owner={}, browser={}, nonce={}, keyHash={}", new Object[]{this.getChannelId(), ownerName, browser, nonce, pkHash});
                            }
                            catch (Throwable ownerName) {
                                // empty catch block
                            }
                            return;
                        }
                        boolean reconnected = this.remotePublicKey != null;
                        this.remotePublicKey = remote;
                        JsonObject reply = new JsonObject();
                        reply.addProperty("type", SocketMessageType.HELLO_REPLY.id);
                        reply.addProperty("nonce", nonce == null ? "" : nonce);
                        reply.addProperty("state", "accepted");
                        this.send(reply);
                        try {
                            this.services.getLogger().info("Paradigm WebEditor: HELLO -> reply=accepted, channel={}, nonce={}, reconnected={}", new Object[]{this.getChannelId(), nonce, reconnected});
                        }
                        catch (Throwable pkHash) {
                            // empty catch block
                        }
                        if (this.debugEnabled()) {
                            try {
                                this.services.getLogger().debug("Paradigm WebEditor: HELLO reply state=accepted, channel={} reconnected={}", (Object)this.getChannelId(), (Object)reconnected);
                            }
                            catch (Throwable pkHash) {
                                // empty catch block
                            }
                        }
                        try {
                            if (this.owner == null || reconnected) break block76;
                            String msgTxt = "Web Editor socket connected.";
                            IComponent comp = this.services.getPlatformAdapter().createComponentFromLiteral(msgTxt);
                            try {
                                Object orig = this.owner.getOriginalSource();
                                if (orig instanceof class_2168) {
                                    class_2168 scs = (class_2168)orig;
                                    this.services.getPlatformAdapter().sendSuccess(scs, comp.getOriginalText(), false);
                                }
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("HELLO handling failed", e);
                    }
                }
                return;
            }
            boolean bl = verified = this.remotePublicKey != null && signature != null && !signature.isEmpty() && SignatureAlgorithm.INSTANCE.verify(this.remotePublicKey, innerMsg, signature);
            if (!verified) {
                throw new IllegalStateException("Signature not accepted");
            }
            switch (type) {
                case PING: {
                    this.lastPing = System.currentTimeMillis();
                    JsonObject pong = new JsonObject();
                    pong.addProperty("type", SocketMessageType.PONG.id);
                    pong.addProperty("ok", Boolean.valueOf(true));
                    this.send(pong);
                    break;
                }
                case CONNECTED: {
                    break;
                }
                case CHANGE_REQUEST: {
                    String code = WebEditorSocket.safeGetAsString(msg, "code");
                    if (code == null || code.isEmpty()) {
                        throw new IllegalArgumentException("Invalid code");
                    }
                    this.services.getTaskScheduler().schedule(() -> {
                        try {
                            int applied;
                            JsonObject changeAccepted = new JsonObject();
                            changeAccepted.addProperty("type", SocketMessageType.CHANGE_RESPONSE.id);
                            changeAccepted.addProperty("state", "accepted");
                            this.send(changeAccepted);
                            try {
                                applied = EditorApplier.applyFromBytebin(this.services, code);
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex);
                            }
                            JsonObject followup = WebEditorSession.buildPayload(this.services);
                            String newSessionCode = WebEditorSession.uploadPayload(this.services, followup);
                            JsonObject appliedMsg = new JsonObject();
                            appliedMsg.addProperty("type", SocketMessageType.CHANGE_RESPONSE.id);
                            appliedMsg.addProperty("state", "applied");
                            if (newSessionCode != null) {
                                appliedMsg.addProperty("newSessionCode", newSessionCode);
                            }
                            appliedMsg.addProperty("appliedCount", (Number)applied);
                            this.send(appliedMsg);
                            try {
                                this.services.getLogger().info("Paradigm WebEditor: Applied {} change(s) from socket channel {}.", (Object)applied, (Object)this.getChannelId());
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (Exception e) {
                            JsonObject err = new JsonObject();
                            err.addProperty("type", SocketMessageType.CHANGE_RESPONSE.id);
                            err.addProperty("state", "error");
                            err.addProperty("message", e.getMessage() == null ? e.toString() : e.getMessage());
                            this.send(err);
                            try {
                                this.services.getLogger().warn("Paradigm WebEditor: Apply from socket failed for channel {}", (Object)this.getChannelId(), (Object)e);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }, 0L, TimeUnit.SECONDS);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown message type: " + String.valueOf((Object)type));
                }
            }
        }
        catch (Throwable t) {
            try {
                this.services.getLogger().warn("Paradigm WebEditor: Error in message handling", t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static final class BytesocksListener
    implements WebSocket.Listener {
        private final WebEditorSocket parent;

        public BytesocksListener(WebEditorSocket parent) {
            this.parent = parent;
        }

        @Override
        public void onOpen(WebSocket webSocket) {
            webSocket.request(1L);
            this.parent.connectFuture.complete(null);
            this.parent.scheduleCleanupIfUnused();
            try {
                this.parent.services.getLogger().info("Paradigm WebEditor: WebSocket opened, channel={}", (Object)this.parent.getChannelId());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
            try {
                this.parent.services.getLogger().info("Paradigm WebEditor: onText received, channel={}, bytes={}", (Object)this.parent.getChannelId(), (Object)(data == null ? 0 : data.length()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                String s = data == null ? "" : data.toString();
                this.parent.handleMessageFrame(s);
            }
            catch (Exception e) {
                try {
                    this.parent.services.getLogger().warn("Paradigm WebEditor: Error handling socket frame", (Throwable)e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                webSocket.request(1L);
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
            webSocket.request(1L);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void onError(WebSocket webSocket, Throwable error) {
            try {
                this.parent.services.getLogger().warn("Paradigm WebEditor: Socket error", error);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
            this.parent.close();
            return CompletableFuture.completedFuture(null);
        }
    }
}

