/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.configs.CMConfig;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.configs.CooldownConfigHandler;
import eu.avalanche7.paradigm.configs.MOTDConfigHandler;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.modules.Announcements;
import eu.avalanche7.paradigm.modules.CustomCommands;
import eu.avalanche7.paradigm.modules.Mentions;
import eu.avalanche7.paradigm.modules.Restart;
import eu.avalanche7.paradigm.modules.chat.GroupChat;
import eu.avalanche7.paradigm.modules.chat.JoinLeaveMessages;
import eu.avalanche7.paradigm.modules.chat.MOTD;
import eu.avalanche7.paradigm.modules.chat.StaffChat;
import eu.avalanche7.paradigm.modules.commands.editor;
import eu.avalanche7.paradigm.modules.commands.help;
import eu.avalanche7.paradigm.modules.commands.reload;
import eu.avalanche7.paradigm.platform.PlatformAdapterImpl;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.GroupChatManager;
import eu.avalanche7.paradigm.utils.Lang;
import eu.avalanche7.paradigm.utils.MessageParser;
import eu.avalanche7.paradigm.utils.PermissionsHandler;
import eu.avalanche7.paradigm.utils.Placeholders;
import eu.avalanche7.paradigm.utils.TaskScheduler;
import eu.avalanche7.paradigm.utils.TelemetryReporter;
import eu.avalanche7.paradigm.webeditor.store.WebEditorStore;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="paradigm")
public class Paradigm {
    public static final String MOD_ID = "paradigm";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ParadigmModule> modules = new ArrayList<ParadigmModule>();
    private Services services;
    private static Services SERVICES_INSTANCE;
    private TelemetryReporter telemetryReporter;
    private static Paradigm INSTANCE;
    private static Paradigm instance;

    public static Services getServices() {
        return SERVICES_INSTANCE;
    }

    public static List<ParadigmModule> getModules() {
        return Paradigm.INSTANCE.modules;
    }

    public Paradigm() {
        INSTANCE = this;
    }

    public static Paradigm getInstance() {
        return INSTANCE;
    }

    public static List<ParadigmModule> getModulesStatic() {
        return INSTANCE != null ? Paradigm.INSTANCE.modules : Collections.emptyList();
    }

    public Paradigm(FMLJavaModLoadingContext ctx) {
        INSTANCE = this;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            LOGGER.info("Paradigm mod is only supported on the server side. Please remove it from the client.");
            return;
        }
        IEventBus modEventBus = ctx.getModEventBus();
        SERVICES_INSTANCE = this.services = this.initialize();
        this.registerModules();
        this.modules.forEach(module -> module.onLoad(null, this.services, modEventBus));
        this.modules.forEach(module -> module.registerEventListeners(MinecraftForge.EVENT_BUS, this.services));
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private Services initialize() {
        MainConfigHandler.load();
        AnnouncementsConfigHandler.load();
        MOTDConfigHandler.load();
        MentionConfigHandler.load();
        RestartConfigHandler.load();
        ChatConfigHandler.load();
        DebugLogger debugLogger = new DebugLogger(MainConfigHandler.CONFIG);
        debugLogger.debugLog("Paradigm: DebugLogger constructed and all configs loaded.");
        ChatConfigHandler.setJsonValidator(debugLogger);
        AnnouncementsConfigHandler.setJsonValidator(debugLogger);
        MentionConfigHandler.setJsonValidator(debugLogger);
        RestartConfigHandler.setJsonValidator(debugLogger);
        MOTDConfigHandler.setJsonValidator(debugLogger);
        CMConfig cmConfig = new CMConfig(debugLogger);
        cmConfig.loadCommands();
        debugLogger.debugLog("Paradigm: CMConfig loaded.");
        Placeholders placeholders = new Placeholders();
        debugLogger.debugLog("Paradigm: Placeholders created.");
        TaskScheduler taskScheduler = new TaskScheduler(debugLogger);
        debugLogger.debugLog("Paradigm: TaskScheduler created.");
        PermissionsHandler permissionsHandler = new PermissionsHandler(LOGGER, cmConfig, debugLogger);
        debugLogger.debugLog("Paradigm: PermissionsHandler created.");
        PlatformAdapterImpl platformAdapter = new PlatformAdapterImpl(permissionsHandler, placeholders, taskScheduler, debugLogger);
        debugLogger.debugLog("Paradigm: PlatformAdapterImpl created.");
        MessageParser messageParser = new MessageParser(placeholders, platformAdapter);
        platformAdapter.provideMessageParser(messageParser);
        debugLogger.debugLog("Paradigm: MessageParser created and provided to PlatformAdapter.");
        Lang lang = new Lang(LOGGER, MainConfigHandler.CONFIG, messageParser, platformAdapter);
        lang.initializeLanguage();
        debugLogger.debugLog("Paradigm: Lang created and initialized.");
        GroupChatManager groupChatManager = new GroupChatManager(platformAdapter, lang, debugLogger, messageParser);
        debugLogger.debugLog("Paradigm: GroupChatManager created.");
        CooldownConfigHandler cooldownConfigHandler = new CooldownConfigHandler(debugLogger);
        cooldownConfigHandler.loadCooldowns();
        debugLogger.debugLog("Paradigm: CooldownConfigHandler created and cooldowns loaded.");
        WebEditorStore webEditorStore = new WebEditorStore();
        debugLogger.debugLog("Paradigm: Creating Services object.");
        return new Services(LOGGER, MainConfigHandler.CONFIG, AnnouncementsConfigHandler.CONFIG, MOTDConfigHandler.CONFIG, MentionConfigHandler.CONFIG, RestartConfigHandler.CONFIG, ChatConfigHandler.CONFIG, cmConfig, groupChatManager, debugLogger, lang, messageParser, permissionsHandler, placeholders, taskScheduler, platformAdapter, cooldownConfigHandler, webEditorStore);
    }

    private void registerModules() {
        this.modules.add(new Announcements());
        this.modules.add(new MOTD());
        this.modules.add(new Mentions());
        this.modules.add(new Restart());
        this.modules.add(new StaffChat());
        this.modules.add(new GroupChat(this.services.getGroupChatManager()));
        this.modules.add(new CustomCommands());
        this.modules.add(new JoinLeaveMessages());
        this.modules.add(new reload());
        this.modules.add(new help());
        this.modules.add(new editor());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> this.modules.forEach(module -> {
            if (module.isEnabled(this.services)) {
                module.onEnable(this.services);
            }
        }));
        ModList.get().getModContainerById(MOD_ID).ifPresent(modContainer -> {
            String version = modContainer.getModInfo().getVersion().toString();
            String displayName = modContainer.getModInfo().getDisplayName();
            LOGGER.info("==================================================");
            LOGGER.info("{} - Version {}", (Object)displayName, (Object)(version + " - FORGE"));
            LOGGER.info("Author: Avalanche7CZ");
            LOGGER.info("Discord: https://discord.com/invite/qZDcQdEFqQ");
            LOGGER.info("==================================================");
            String mcVersion = UpdateChecker.getMinecraftVersionSafe();
            String loader = "forge";
            UpdateChecker.checkForUpdates(version, mcVersion, loader, LOGGER);
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.services.getPlatformAdapter().setMinecraftServer(event.getServer());
        this.services.getTaskScheduler().initialize(event.getServer());
        this.services.getPermissionsHandler().initialize();
        if (this.telemetryReporter == null) {
            this.telemetryReporter = new TelemetryReporter(this.services);
        }
        this.telemetryReporter.start();
        this.modules.forEach(module -> {
            if (module.isEnabled(this.services)) {
                module.onServerStarting(event, this.services);
            }
        });
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        this.modules.forEach(module -> {
            if (module.isEnabled(this.services)) {
                module.registerCommands(event.getDispatcher(), this.services);
            }
        });
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.modules.forEach(module -> {
            if (module.isEnabled(this.services)) {
                module.onServerStopping(event, this.services);
                module.onDisable(this.services);
            }
        });
        if (this.telemetryReporter != null) {
            this.telemetryReporter.stop();
        }
        this.services.getTaskScheduler().onServerStopping();
        this.services.getCooldownConfigHandler().saveCooldowns();
    }

    public static class UpdateChecker {
        private static final String LATEST_VERSION_URL = "https://raw.githubusercontent.com/Avalanche7CZ/Paradigm/1.20.1/version.txt?v=1";
        private static final String MODRINTH_PROJECT_ID = "s4i32SJd";
        private static final String CURSEFORGE_SLUG = "paradigm";
        private static final String MODRINTH_PROJECT_PAGE = "https://modrinth.com/mod/s4i32SJd";
        private static final String CURSEFORGE_PROJECT_PAGE = "https://www.curseforge.com/minecraft/mc-mods/paradigm";

        public static void checkForUpdates(String currentVersion, String mcVersion, String loader, Logger logger) {
            boolean foundOnModrinth = UpdateChecker.checkModrinth(currentVersion, mcVersion, loader, logger);
            if (!foundOnModrinth) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(URI.create(LATEST_VERSION_URL).toURL().openStream(), StandardCharsets.UTF_8));){
                    String latestVersion = reader.readLine();
                    if (latestVersion != null && !currentVersion.equals(latestVersion.trim())) {
                        logger.info("Paradigm: A new version is available: {} (Current: {})", (Object)latestVersion.trim(), (Object)currentVersion);
                        logger.info("Modrinth: {}", (Object)MODRINTH_PROJECT_PAGE);
                        logger.info("CurseForge: {}", (Object)CURSEFORGE_PROJECT_PAGE);
                    }
                }
                catch (Exception e) {
                    logger.warn("Paradigm: Failed to check for updates (GitHub).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean checkModrinth(String currentVersion, String mcVersion, String loader, Logger logger) {
            block25: {
                HttpURLConnection conn = null;
                try {
                    StringBuilder apiUrl = new StringBuilder("https://api.modrinth.com/v2/project/s4i32SJd/version");
                    ArrayList<CallSite> params = new ArrayList<CallSite>();
                    if (mcVersion != null && !mcVersion.isBlank()) {
                        params.add((CallSite)((Object)("game_versions=" + URLEncoder.encode(mcVersion, StandardCharsets.UTF_8))));
                    }
                    if (loader != null && !loader.isBlank()) {
                        params.add((CallSite)((Object)("loaders=" + URLEncoder.encode(loader, StandardCharsets.UTF_8))));
                    }
                    if (!params.isEmpty()) {
                        apiUrl.append("?").append(String.join((CharSequence)"&", params));
                    }
                    conn = (HttpURLConnection)URI.create(apiUrl.toString()).toURL().openConnection();
                    conn.setRequestProperty("User-Agent", "Paradigm-UpdateChecker/1.0 (+https://modrinth.com/mod/s4i32SJd)");
                    conn.setConnectTimeout(4000);
                    conn.setReadTimeout(6000);
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                    JsonArray arr = JsonParser.parseReader((Reader)br).getAsJsonArray();
                    if (arr.isEmpty()) {
                        boolean bl = false;
                        return bl;
                    }
                    String newestCompatible = null;
                    String publishedAtNewest = null;
                    for (JsonElement el : arr) {
                        String published;
                        JsonObject obj = el.getAsJsonObject();
                        boolean loaderOk = false;
                        JsonArray loaders = obj.getAsJsonArray("loaders");
                        if (loaders != null) {
                            for (JsonElement l : loaders) {
                                if (loader == null || !loader.equalsIgnoreCase(l.getAsString())) continue;
                                loaderOk = true;
                                break;
                            }
                        }
                        if (!loaderOk) continue;
                        boolean versionOk = true;
                        if (mcVersion != null) {
                            versionOk = false;
                            JsonArray gameVersions = obj.getAsJsonArray("game_versions");
                            if (gameVersions != null) {
                                for (JsonElement v : gameVersions) {
                                    if (!mcVersion.equals(v.getAsString())) continue;
                                    versionOk = true;
                                    break;
                                }
                            }
                        }
                        if (!versionOk) continue;
                        String ver = obj.get("version_number").getAsString();
                        String string = published = obj.has("date_published") ? obj.get("date_published").getAsString() : null;
                        if (newestCompatible == null) {
                            newestCompatible = ver;
                            publishedAtNewest = published;
                            continue;
                        }
                        if (!UpdateChecker.isAfter(published, publishedAtNewest)) continue;
                        newestCompatible = ver;
                        publishedAtNewest = published;
                    }
                    if (newestCompatible == null || newestCompatible.equals(currentVersion)) break block25;
                    logger.info("Paradigm: A new version is available on Modrinth: {} (Current: {})", (Object)newestCompatible, (Object)currentVersion);
                    logger.info("Modrinth: {}", (Object)MODRINTH_PROJECT_PAGE);
                    logger.info("CurseForge: {}", (Object)CURSEFORGE_PROJECT_PAGE);
                    boolean bl = true;
                    return bl;
                    finally {
                        br.close();
                    }
                }
                catch (Exception ex) {
                    logger.debug("Paradigm: Modrinth check failed: {}", (Object)ex.toString());
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
            return false;
        }

        private static boolean isAfter(String a, String b) {
            if (a == null) {
                return false;
            }
            if (b == null) {
                return true;
            }
            return a.compareTo(b) > 0;
        }

        public static String getMinecraftVersionSafe() {
            try {
                Class<?> sc;
                block22: {
                    sc = Class.forName("net.minecraft.SharedConstants");
                    try {
                        Object verObj = sc.getMethod("getCurrentVersion", new Class[0]).invoke(null, new Object[0]);
                        if (verObj == null) break block22;
                        try {
                            Object name = verObj.getClass().getMethod("getName", new Class[0]).invoke(verObj, new Object[0]);
                            if (name instanceof String && !((String)name).isEmpty()) {
                                return (String)name;
                            }
                        }
                        catch (NoSuchMethodException e1) {
                            try {
                                Object id = verObj.getClass().getMethod("getId", new Class[0]).invoke(verObj, new Object[0]);
                                if (id instanceof String && !((String)id).isEmpty()) {
                                    return (String)id;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {}
                        }
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Object str = sc.getMethod("getGameVersion", new Class[0]).invoke(null, new Object[0]);
                            if (str instanceof String && !((String)str).isEmpty()) {
                                return (String)str;
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    Object vs = sc.getField("VERSION_STRING").get(null);
                    if (vs instanceof String && !((String)vs).isEmpty()) {
                        return (String)vs;
                    }
                }
                catch (NoSuchFieldException vs) {}
            }
            catch (Throwable sc) {
                // empty catch block
            }
            try {
                Class<?> fv = Class.forName("net.minecraftforge.versions.forge.ForgeVersion");
                Object mcVer = fv.getField("mcVersion").get(null);
                if (mcVer instanceof String && !((String)mcVer).isEmpty()) {
                    return (String)mcVer;
                }
            }
            catch (Throwable fv) {
                // empty catch block
            }
            try {
                Class<?> mcp = Class.forName("net.minecraftforge.versions.mcp.MCPVersion");
                Object ver = mcp.getMethod("getMCVersion", new Class[0]).invoke(null, new Object[0]);
                if (ver instanceof String && !((String)ver).isEmpty()) {
                    return (String)ver;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

