/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.core;

import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.configs.CMConfig;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.configs.CooldownConfigHandler;
import eu.avalanche7.paradigm.configs.MOTDConfigHandler;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.GroupChatManager;
import eu.avalanche7.paradigm.utils.Lang;
import eu.avalanche7.paradigm.utils.MessageParser;
import eu.avalanche7.paradigm.utils.PermissionsHandler;
import eu.avalanche7.paradigm.utils.Placeholders;
import eu.avalanche7.paradigm.utils.TaskScheduler;
import eu.avalanche7.paradigm.webeditor.store.WebEditorStore;
import org.slf4j.Logger;

public class Services {
    private final Logger logger;
    private final MainConfigHandler.Config mainConfig;
    private final AnnouncementsConfigHandler.Config announcementsConfig;
    private final MOTDConfigHandler.Config motdConfig;
    private final MentionConfigHandler.Config mentionConfig;
    private final RestartConfigHandler.Config restartConfig;
    private final ChatConfigHandler.Config chatConfig;
    private final CMConfig cmConfigInstance;
    private final DebugLogger debugLoggerInstance;
    private final Lang langInstance;
    private final MessageParser messageParserInstance;
    private final PermissionsHandler permissionsHandlerInstance;
    private final Placeholders placeholdersInstance;
    private final TaskScheduler taskSchedulerInstance;
    private final GroupChatManager groupChatManagerInstance;
    private final IPlatformAdapter platformAdapter;
    private final CooldownConfigHandler cooldownConfigHandler;
    private final WebEditorStore webEditorStore;

    public Services(Logger logger, MainConfigHandler.Config mainConfig, AnnouncementsConfigHandler.Config announcementsConfig, MOTDConfigHandler.Config motdConfig, MentionConfigHandler.Config mentionConfig, RestartConfigHandler.Config restartConfig, ChatConfigHandler.Config chatConfig, CMConfig cmConfig, GroupChatManager groupChatManager, DebugLogger debugLogger, Lang lang, MessageParser messageParser, PermissionsHandler permissionsHandler, Placeholders placeholders, TaskScheduler taskScheduler, IPlatformAdapter platformAdapter, CooldownConfigHandler cooldownConfigHandler, WebEditorStore webEditorStore) {
        this.logger = logger;
        this.mainConfig = mainConfig;
        this.announcementsConfig = announcementsConfig;
        this.motdConfig = motdConfig;
        this.mentionConfig = mentionConfig;
        this.restartConfig = restartConfig;
        this.chatConfig = chatConfig;
        this.cmConfigInstance = cmConfig;
        this.groupChatManagerInstance = groupChatManager;
        this.debugLoggerInstance = debugLogger;
        this.langInstance = lang;
        this.messageParserInstance = messageParser;
        this.permissionsHandlerInstance = permissionsHandler;
        this.placeholdersInstance = placeholders;
        this.taskSchedulerInstance = taskScheduler;
        this.platformAdapter = platformAdapter;
        this.cooldownConfigHandler = cooldownConfigHandler;
        this.webEditorStore = webEditorStore;
        this.initializeJsonValidators();
    }

    private void initializeJsonValidators() {
        ChatConfigHandler.setJsonValidator(this.debugLoggerInstance);
        AnnouncementsConfigHandler.setJsonValidator(this.debugLoggerInstance);
        MentionConfigHandler.setJsonValidator(this.debugLoggerInstance);
        RestartConfigHandler.setJsonValidator(this.debugLoggerInstance);
        MainConfigHandler.setJsonValidator(this.debugLoggerInstance);
        MOTDConfigHandler.setJsonValidator(this.debugLoggerInstance);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public DebugLogger getDebugLogger() {
        return this.debugLoggerInstance;
    }

    public Lang getLang() {
        return this.langInstance;
    }

    public MessageParser getMessageParser() {
        return this.messageParserInstance;
    }

    public PermissionsHandler getPermissionsHandler() {
        return this.permissionsHandlerInstance;
    }

    public Placeholders getPlaceholders() {
        return this.placeholdersInstance;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskSchedulerInstance;
    }

    public MainConfigHandler.Config getMainConfig() {
        return MainConfigHandler.CONFIG;
    }

    public AnnouncementsConfigHandler.Config getAnnouncementsConfig() {
        return AnnouncementsConfigHandler.CONFIG;
    }

    public MOTDConfigHandler.Config getMotdConfig() {
        return MOTDConfigHandler.CONFIG;
    }

    public MentionConfigHandler.Config getMentionConfig() {
        return MentionConfigHandler.CONFIG;
    }

    public RestartConfigHandler.Config getRestartConfig() {
        return RestartConfigHandler.CONFIG;
    }

    public ChatConfigHandler.Config getChatConfig() {
        return ChatConfigHandler.CONFIG;
    }

    public CMConfig getCmConfig() {
        return this.cmConfigInstance;
    }

    public GroupChatManager getGroupChatManager() {
        return this.groupChatManagerInstance;
    }

    public IPlatformAdapter getPlatformAdapter() {
        return this.platformAdapter;
    }

    public CooldownConfigHandler getCooldownConfigHandler() {
        return this.cooldownConfigHandler;
    }

    public WebEditorStore getWebEditorStore() {
        return this.webEditorStore;
    }
}

