/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class Restart
implements ParadigmModule {
    private static final String NAME = "Restart";
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("00");
    private Services services;
    private IPlatformAdapter platform;
    private final AtomicBoolean restartInProgress = new AtomicBoolean(false);
    private ScheduledFuture<?> mainTaskFuture = null;
    private final List<ScheduledFuture<?>> warningFutures = new ArrayList();
    private ScheduledFuture<?> shutdownFuture = null;
    private final List<ScheduledFuture<?>> preCommandFutures = new ArrayList();
    private final Set<Integer> sentWarningMoments = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return services.getMainConfig().restartEnable.get();
    }

    @Override
    public void onLoad(FMLCommonSetupEvent event, Services services, IEventBus modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("Restart module loaded.");
    }

    @Override
    public void onServerStarting(ServerStartingEvent event, Services services) {
        if (this.platform.getMinecraftServer() != null && this.isEnabled(services)) {
            services.getDebugLogger().debugLog("Restart: Server is starting, scheduling restarts.");
            this.scheduleNextRestart();
        } else {
            services.getDebugLogger().debugLog("Restart: Server is starting, but platform or config not ready. Skipping scheduling.");
        }
    }

    @Override
    public void onEnable(Services services) {
        services.getDebugLogger().debugLog("Restart: Module enabled (deferring restart scheduling to onServerStarting).");
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("Restart: Module disabled, cancelling any scheduled restarts.");
        this.cancelAndCleanup();
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event, Services services) {
        this.cancelAndCleanup();
    }

    @Override
    public void registerCommands(CommandDispatcher<?> dispatcher, Services services) {
        CommandDispatcher<?> dispatcherCS = dispatcher;
        dispatcherCS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"restart").requires(source -> this.platform.hasCommandPermission(this.platform.wrapCommandSource(source), "paradigm.restart.manage", 2))).then(Commands.literal((String)"now").executes(context -> {
            services.getDebugLogger().debugLog("Restart: /restart now command executed by " + ((CommandSourceStack)context.getSource()).getTextName());
            if (this.restartInProgress.get()) {
                services.getDebugLogger().debugLog("Restart: /restart now overriding active restart sequence.");
                this.cancelAndCleanup();
            }
            this.initiateRestartSequence(60.0, services.getRestartConfig());
            this.platform.sendSuccess(this.platform.wrapCommandSource(context.getSource()), this.platform.createLiteralComponent("Initiating immediate 60-second restart sequence."), true);
            return 1;
        }))).then(Commands.literal((String)"cancel").executes(context -> {
            services.getDebugLogger().debugLog("Restart: /restart cancel command executed by " + ((CommandSourceStack)context.getSource()).getTextName());
            if (this.restartInProgress.get()) {
                this.cancelAndCleanup();
                this.scheduleNextRestart();
                this.platform.sendSuccess(this.platform.wrapCommandSource(context.getSource()), this.platform.createLiteralComponent("The active server restart has been cancelled."), true);
            } else {
                this.platform.sendFailure(this.platform.wrapCommandSource(context.getSource()), this.platform.createLiteralComponent("No restart is currently scheduled to be cancelled."));
            }
            return 1;
        })));
    }

    @Override
    public void registerEventListeners(IEventBus forgeEventBus, Services services) {
    }

    private void cancelAndCleanup() {
        this.services.getDebugLogger().debugLog("Restart: Initiating cleanup process.");
        if (this.mainTaskFuture != null && !this.mainTaskFuture.isDone()) {
            this.mainTaskFuture.cancel(false);
            this.services.getDebugLogger().debugLog("Restart: Main restart task future cancelled.");
        }
        this.mainTaskFuture = null;
        for (ScheduledFuture<?> f : this.warningFutures) {
            if (f == null || f.isDone()) continue;
            f.cancel(false);
        }
        this.warningFutures.clear();
        for (ScheduledFuture<?> f : this.preCommandFutures) {
            if (f == null || f.isDone()) continue;
            f.cancel(false);
        }
        this.preCommandFutures.clear();
        if (this.shutdownFuture != null && !this.shutdownFuture.isDone()) {
            this.shutdownFuture.cancel(false);
        }
        this.shutdownFuture = null;
        this.sentWarningMoments.clear();
        this.restartInProgress.set(false);
        if (this.platform != null) {
            this.platform.removeRestartBossBar();
        }
        if (this.services != null) {
            this.services.getDebugLogger().debugLog("Restart: A scheduled restart has been cancelled and cleaned up.");
        }
    }

    public void scheduleNextRestart() {
        this.cancelAndCleanup();
        RestartConfigHandler.Config config = this.services.getRestartConfig();
        String restartType = config.restartType.get();
        long delayMillis = -1L;
        this.services.getDebugLogger().debugLog("Restart: scheduleNextRestart called. restartType=" + restartType);
        if ("fixed".equalsIgnoreCase(restartType)) {
            double intervalHours = config.restartInterval.get();
            this.services.getDebugLogger().debugLog("Restart: fixed intervalHours=" + intervalHours);
            if (intervalHours > 0.0) {
                delayMillis = (long)(intervalHours * 3600.0 * 1000.0);
                this.services.getDebugLogger().debugLog("Restart: Scheduling next fixed restart in " + intervalHours + " hours (" + delayMillis + " ms).");
            }
        } else if ("realtime".equalsIgnoreCase(restartType)) {
            delayMillis = this.getNextRealTimeDelay(config);
            this.services.getDebugLogger().debugLog("Restart: realtime delayMillis=" + delayMillis);
        }
        if (delayMillis > 0L) {
            double totalSeconds = (double)delayMillis / 1000.0;
            this.services.getDebugLogger().debugLog("Restart: Starting restart countdown now for " + totalSeconds + " seconds.");
            this.initiateRestartSequence(totalSeconds, config);
        } else {
            this.services.getDebugLogger().debugLog("Restart: No valid restart delay computed. Skipping schedule.");
        }
    }

    private long getNextRealTimeDelay(RestartConfigHandler.Config config) {
        List<String> realTimeIntervals = config.realTimeInterval.get();
        if (realTimeIntervals == null || realTimeIntervals.isEmpty()) {
            this.services.getDebugLogger().debugLog("Restart: Real-time restart intervals are not configured.");
            return -1L;
        }
        Calendar nowCal = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        long minDelayMillis = Long.MAX_VALUE;
        String nextRestartTime = "N/A";
        for (String restartTimeStr : realTimeIntervals) {
            try {
                long delayMillis;
                Date restartTime = format.parse(restartTimeStr);
                Calendar restartCal = Calendar.getInstance();
                restartCal.setTime(restartTime);
                restartCal.set(1, nowCal.get(1));
                restartCal.set(2, nowCal.get(2));
                restartCal.set(5, nowCal.get(5));
                restartCal.set(13, 0);
                restartCal.set(14, 0);
                if (nowCal.after(restartCal)) {
                    restartCal.add(5, 1);
                }
                if ((delayMillis = restartCal.getTimeInMillis() - nowCal.getTimeInMillis()) <= 0L || delayMillis >= minDelayMillis) continue;
                minDelayMillis = delayMillis;
                nextRestartTime = format.format(restartCal.getTime());
            }
            catch (ParseException e) {
                this.services.getDebugLogger().debugLog("Restart: Error parsing restart time: " + restartTimeStr, e);
            }
        }
        if (minDelayMillis != Long.MAX_VALUE) {
            this.services.getDebugLogger().debugLog("Restart: Next real-time restart is scheduled for " + nextRestartTime + " (in " + minDelayMillis + "ms).");
            return minDelayMillis;
        }
        this.services.getDebugLogger().debugLog("Restart: No upcoming real-time restart found for today.");
        return -1L;
    }

    private boolean isAsEachPlayerDirective(String commandText) {
        if (commandText == null) {
            return false;
        }
        String trimmed = commandText.trim();
        return trimmed.startsWith("asplayer:") || trimmed.startsWith("each:") || trimmed.startsWith("[asPlayer]");
    }

    private String stripAsEachPlayerDirective(String commandText) {
        String trimmed = commandText.trim();
        if (trimmed.startsWith("[asPlayer]")) {
            return trimmed.substring("[asPlayer]".length()).trim();
        }
        if (trimmed.startsWith("asplayer:")) {
            return trimmed.substring("asplayer:".length()).trim();
        }
        if (trimmed.startsWith("each:")) {
            return trimmed.substring("each:".length()).trim();
        }
        return commandText;
    }

    private void initiateRestartSequence(double totalIntervalSeconds, RestartConfigHandler.Config config) {
        if (!this.restartInProgress.compareAndSet(false, true)) {
            this.services.getDebugLogger().debugLog("Restart: Restart sequence already in progress. Ignoring new trigger.");
            return;
        }
        this.sentWarningMoments.clear();
        this.services.getDebugLogger().debugLog("Restart: Initiating restart sequence. Total duration: " + totalIntervalSeconds + " seconds.");
        long totalIntervalMillis = (long)(totalIntervalSeconds * 1000.0);
        ArrayList broadcastTimes = new ArrayList(config.timerBroadcast.get());
        Collections.sort(broadcastTimes, Collections.reverseOrder());
        this.services.getDebugLogger().debugLog("Restart: Scheduling " + broadcastTimes.size() + " warning messages.");
        Iterator iterator = broadcastTimes.iterator();
        while (iterator.hasNext()) {
            ScheduledFuture<?> future;
            int broadcastTimeSec = (Integer)iterator.next();
            long delayUntilWarning = totalIntervalMillis - (long)broadcastTimeSec * 1000L;
            if (delayUntilWarning < 0L || (future = this.services.getTaskScheduler().schedule(() -> {
                if (!this.restartInProgress.get()) {
                    return;
                }
                if (!this.sentWarningMoments.add(broadcastTimeSec)) {
                    this.services.getDebugLogger().debugLog("Restart: Duplicate warning suppressed. Time left: " + broadcastTimeSec + "s.");
                    return;
                }
                this.sendRestartWarning(broadcastTimeSec, config, totalIntervalSeconds);
            }, delayUntilWarning, TimeUnit.MILLISECONDS)) == null) continue;
            this.warningFutures.add(future);
        }
        List<RestartConfigHandler.PreRestartCommand> preCommands = config.preRestartCommands.get();
        if (preCommands != null && !preCommands.isEmpty()) {
            this.services.getDebugLogger().debugLog("Restart: Scheduling " + preCommands.size() + " pre-restart commands.");
            for (RestartConfigHandler.PreRestartCommand pre : preCommands) {
                String commandText;
                int secondsBefore = Math.max(0, pre.secondsBefore);
                long delayUntilRun = totalIntervalMillis - (long)secondsBefore * 1000L;
                if (delayUntilRun < 0L) {
                    this.services.getDebugLogger().debugLog("Restart: Pre-restart command scheduled too early (" + pre.secondsBefore + "s before) and will be skipped: " + pre.command);
                    continue;
                }
                String string = commandText = pre.command == null ? "" : pre.command;
                ScheduledFuture<?> f = this.services.getTaskScheduler().schedule(() -> {
                    if (!this.restartInProgress.get()) {
                        return;
                    }
                    if (this.isAsEachPlayerDirective(commandText)) {
                        String raw = this.stripAsEachPlayerDirective(commandText);
                        List<IPlayer> players = this.platform.getOnlinePlayers();
                        this.services.getDebugLogger().debugLog("Restart: Executing pre-restart player-commands (" + secondsBefore + "s before) for " + players.size() + " players: " + raw);
                        for (IPlayer player : players) {
                            String perPlayer = this.services.getPlaceholders().replacePlaceholders(raw, player);
                            try {
                                if (!(player instanceof MinecraftPlayer)) continue;
                                ServerPlayer sp = ((MinecraftPlayer)player).getHandle();
                                CommandSourceStack src = sp.createCommandSourceStack();
                                this.platform.executeCommandAs(this.platform.wrapCommandSource(src), perPlayer);
                            }
                            catch (Exception ex) {
                                this.services.getDebugLogger().debugLog("Restart: Failed executing as player " + player.getName() + ": " + perPlayer, ex);
                            }
                        }
                    } else {
                        String replaced = this.services.getPlaceholders().replacePlaceholders(commandText, null);
                        this.services.getDebugLogger().debugLog("Restart: Executing pre-restart console command (" + secondsBefore + "s before): " + replaced);
                        this.platform.executeCommandAsConsole(replaced);
                    }
                }, delayUntilRun, TimeUnit.MILLISECONDS);
                if (f == null) continue;
                this.preCommandFutures.add(f);
            }
        }
        this.shutdownFuture = this.services.getTaskScheduler().schedule(() -> {
            if (!this.restartInProgress.get()) {
                return;
            }
            this.performShutdown(config);
        }, totalIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private void sendRestartWarning(long timeLeftSeconds, RestartConfigHandler.Config config, double originalTotalIntervalSeconds) {
        if (this.platform.getMinecraftServer() == null) {
            this.services.getDebugLogger().debugLog("Restart: Server instance is null, cannot send restart warning.");
            return;
        }
        this.services.getDebugLogger().debugLog("Restart: Sending restart warning. Time left: " + timeLeftSeconds + "s.");
        List<IPlayer> players = this.platform.getOnlinePlayers();
        if (!players.isEmpty()) {
            this.sendWarningToPlayerAtIndex(players, 0, timeLeftSeconds, config);
        }
        if (config.bossbarEnabled.get().booleanValue()) {
            int hours = (int)(timeLeftSeconds / 3600L);
            int minutes = (int)(timeLeftSeconds % 3600L / 60L);
            int seconds = (int)(timeLeftSeconds % 60L);
            String formattedTime = String.format("%dh %sm %ss", hours, TIME_FORMATTER.format(minutes), TIME_FORMATTER.format(seconds));
            String bossBarMessage = config.bossBarMessage.get().replace("{hours}", String.valueOf(hours)).replace("{minutes}", TIME_FORMATTER.format(minutes)).replace("{seconds}", String.valueOf(seconds)).replace("{time}", formattedTime);
            IComponent parsedBossBarMessage = this.services.getMessageParser().parseMessage(bossBarMessage, null);
            float progress = Math.max(0.0f, (float)timeLeftSeconds / (float)Math.max(1L, (long)originalTotalIntervalSeconds));
            this.platform.createOrUpdateRestartBossBar(parsedBossBarMessage, IPlatformAdapter.BossBarColor.RED, progress);
        }
    }

    private void sendWarningToPlayerAtIndex(List<IPlayer> players, int index, long timeLeftSeconds, RestartConfigHandler.Config config) {
        if (index >= players.size() || !this.restartInProgress.get()) {
            return;
        }
        IPlayer player = players.get(index);
        int hours = (int)(timeLeftSeconds / 3600L);
        int minutes = (int)(timeLeftSeconds % 3600L / 60L);
        int seconds = (int)(timeLeftSeconds % 60L);
        String formattedTime = String.format("%dh %sm %ss", hours, TIME_FORMATTER.format(minutes), TIME_FORMATTER.format(seconds));
        if (config.timerUseChat.get().booleanValue()) {
            String message = config.BroadcastMessage.get().replace("{hours}", String.valueOf(hours)).replace("{minutes}", TIME_FORMATTER.format(minutes)).replace("{seconds}", String.valueOf(seconds)).replace("{time}", formattedTime);
            IComponent parsedMessage = this.services.getMessageParser().parseMessage(message, player);
            this.platform.sendSystemMessage(player, parsedMessage);
        }
        if (config.titleEnabled.get().booleanValue()) {
            String titleText = config.titleMessage.get().replace("{hours}", String.valueOf(hours)).replace("{minutes}", TIME_FORMATTER.format(minutes)).replace("{seconds}", String.valueOf(seconds)).replace("{time}", formattedTime);
            IComponent parsedTitle = this.services.getMessageParser().parseMessage(titleText, player);
            this.platform.sendTitle(player, parsedTitle, null);
        }
        if (config.playSoundEnabled.get().booleanValue() && (double)timeLeftSeconds <= config.playSoundFirstTime.get()) {
            String soundId = config.playSoundString.get();
            if (soundId == null || soundId.isEmpty()) {
                soundId = "minecraft:block.note_block.pling";
            }
            this.platform.playSound(player, soundId, IPlatformAdapter.SoundCategory.MASTER, 1.0f, 1.0f);
        }
        int nextIndex = index + 1;
        this.services.getTaskScheduler().schedule(() -> this.sendWarningToPlayerAtIndex(players, nextIndex, timeLeftSeconds, config), 50L, TimeUnit.MILLISECONDS);
    }

    private void performShutdown(RestartConfigHandler.Config config) {
        if (!this.restartInProgress.get()) {
            return;
        }
        this.services.getDebugLogger().debugLog("Restart: Initiating final shutdown procedure.");
        IComponent parsedReason = this.services.getMessageParser().parseMessage(config.defaultRestartReason.get(), null);
        this.platform.shutdownServer(parsedReason);
    }

    public void rescheduleNextRestart(Services services) {
        if (services == null) {
            return;
        }
        this.services = services;
        this.cancelAndCleanup();
        this.scheduleNextRestart();
    }
}

