/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules.chat;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IEventSystem;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class StaffChat
implements ParadigmModule,
IEventSystem.ChatEventListener {
    private static final String NAME = "StaffChat";
    private static final Map<UUID, Boolean> staffChatEnabledMap = new HashMap<UUID, Boolean>();
    private Services services;
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return services.getChatConfig().enableStaffChat.get();
    }

    @Override
    public void onLoad(FMLCommonSetupEvent event, Services services, IEventBus modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("StaffChat module loaded.");
    }

    @Override
    public void onServerStarting(ServerStartingEvent event, Services services) {
    }

    @Override
    public void onEnable(Services services) {
    }

    @Override
    public void onDisable(Services services) {
        if (this.platform.getMinecraftServer() != null) {
            staffChatEnabledMap.forEach((uuid, isEnabled) -> {
                IPlayer player;
                if (isEnabled.booleanValue() && (player = this.platform.getPlayerByUuid((UUID)uuid)) != null) {
                    this.platform.removePersistentBossBar(player);
                }
            });
        }
        staffChatEnabledMap.clear();
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event, Services services) {
        this.onDisable(services);
    }

    @Override
    public void registerCommands(CommandDispatcher<?> dispatcher, Services services) {
        CommandDispatcher<?> dispatcherCS = dispatcher;
        dispatcherCS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sc").requires(source -> this.platform.hasCommandPermission(this.platform.wrapCommandSource(source), "paradigm.staff"))).then(Commands.literal((String)"toggle").executes(context -> this.toggleStaffChatCmd(this.platform.wrapCommandSource(context.getSource()))))).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendStaffChatMessageCmd(this.platform.wrapCommandSource(context.getSource()), StringArgumentType.getString((CommandContext)context, (String)"message"))))).executes(context -> this.toggleStaffChatCmd(this.platform.wrapCommandSource(context.getSource()))));
    }

    @Override
    public void registerEventListeners(IEventBus forgeEventBus, Services services) {
        this.platform.getEventSystem().registerChatListener(this);
    }

    private int toggleStaffChatCmd(ICommandSource source) throws CommandSyntaxException {
        try {
            if (!this.services.getChatConfig().enableStaffChat.get().booleanValue()) {
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cStaff chat is disabled.", null));
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IPlayer player = source.getPlayer();
        if (player != null) {
            this.toggleStaffChat(((MinecraftPlayer)player).getHandle());
        }
        return 1;
    }

    private int sendStaffChatMessageCmd(ICommandSource source, String message) throws CommandSyntaxException {
        try {
            if (!this.services.getChatConfig().enableStaffChat.get().booleanValue()) {
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cStaff chat is disabled.", null));
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.platform.getMinecraftServer() == null) {
            this.platform.sendFailure(source, this.platform.createLiteralComponent("Server not available."));
            return 0;
        }
        IPlayer player = source.getPlayer();
        if (player != null) {
            this.sendStaffChatMessage(((MinecraftPlayer)player).getHandle(), message);
        }
        return 1;
    }

    public static boolean isStaffChatEnabled(UUID playerUuid) {
        return staffChatEnabledMap.getOrDefault(playerUuid, false);
    }

    private void toggleStaffChat(ServerPlayer mcPlayer) {
        UUID playerUUID;
        MinecraftPlayer player = new MinecraftPlayer(mcPlayer);
        boolean isCurrentlyEnabled = staffChatEnabledMap.getOrDefault(playerUUID = UUID.fromString(player.getUUID()), false);
        staffChatEnabledMap.put(playerUUID, !isCurrentlyEnabled);
        IComponent message = this.services.getMessageParser().parseMessage("Staff chat " + (!isCurrentlyEnabled ? "\u00a7aenabled" : "\u00a7cdisabled"), null);
        this.platform.sendSystemMessage((IPlayer)player, message);
        if (!isCurrentlyEnabled) {
            if (this.services.getChatConfig().enableStaffBossBar.get().booleanValue()) {
                IComponent title = this.services.getMessageParser().parseMessage("\u00a7cStaff Chat Mode \u00a7aEnabled", player);
                this.platform.showPersistentBossBar(player, title, IPlatformAdapter.BossBarColor.RED, IPlatformAdapter.BossBarOverlay.NOTCHED_10);
            }
        } else {
            this.platform.removePersistentBossBar(player);
        }
        this.services.getDebugLogger().debugLog("Player " + this.platform.getPlayerName(player) + " toggled staff chat to " + !isCurrentlyEnabled);
    }

    private void sendStaffChatMessage(ServerPlayer mcSender, String message) {
        MinecraftPlayer sender = new MinecraftPlayer(mcSender);
        ChatConfigHandler.Config chatConfig = this.services.getChatConfig();
        String format = chatConfig.staffChatFormat.get();
        String rawFormattedMessage = String.format(format, this.platform.getPlayerName(sender), message);
        IComponent chatComponent = this.services.getMessageParser().parseMessage(rawFormattedMessage, sender);
        this.platform.getOnlinePlayers().forEach(onlinePlayer -> {
            if (this.platform.hasPermission((IPlayer)onlinePlayer, "paradigm.staff")) {
                this.platform.sendSystemMessage((IPlayer)onlinePlayer, chatComponent);
            }
        });
        this.services.getLogger().info("[StaffChat] {}: {}", (Object)this.platform.getPlayerName(sender), (Object)message);
    }

    @Override
    public void onPlayerChat(IEventSystem.ChatEvent event) {
        if (this.services == null || !this.isEnabled(this.services)) {
            return;
        }
        IPlayer player = event.getPlayer();
        UUID playerUUID = UUID.fromString(player.getUUID());
        if (staffChatEnabledMap.getOrDefault(playerUUID, false).booleanValue()) {
            if (this.platform.getMinecraftServer() == null) {
                return;
            }
            this.sendStaffChatMessage(((MinecraftPlayer)player).getHandle(), event.getMessage());
            event.setCancelled(true);
        }
    }
}

