/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.platform;

import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MinecraftCommandSource
implements ICommandSource {
    private final CommandSourceStack source;
    private final IPlayer player;

    public MinecraftCommandSource(CommandSourceStack source) {
        IPlayer iPlayer;
        this.source = source;
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            iPlayer = MinecraftPlayer.of(sp);
        } else {
            iPlayer = null;
        }
        this.player = iPlayer;
    }

    @Override
    @Nullable
    public IPlayer getPlayer() {
        return this.player;
    }

    @Override
    public String getSourceName() {
        if (this.player != null) {
            return this.player.getName();
        }
        return "Console";
    }

    @Override
    public boolean hasPermissionLevel(int level) {
        return this.source.hasPermission(level);
    }

    @Override
    public boolean isConsole() {
        return this.player == null;
    }

    @Override
    public Object getOriginalSource() {
        return this.source;
    }

    public CommandSourceStack getHandle() {
        return this.source;
    }

    public static ICommandSource of(CommandSourceStack source) {
        return new MinecraftCommandSource(source);
    }
}

