/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.platform;

import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IEventSystem;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MinecraftEventSystem
implements IEventSystem {
    private final CopyOnWriteArrayList<IEventSystem.ChatEventListener> chatListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<IEventSystem.PlayerJoinEventListener> joinListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<IEventSystem.PlayerLeaveEventListener> leaveListeners = new CopyOnWriteArrayList();

    @Override
    public void registerChatListener(IEventSystem.ChatEventListener listener) {
        this.chatListeners.add(listener);
    }

    @Override
    public void registerJoinListener(IEventSystem.PlayerJoinEventListener listener) {
        this.joinListeners.add(listener);
    }

    @Override
    public void registerLeaveListener(IEventSystem.PlayerLeaveEventListener listener) {
        this.leaveListeners.add(listener);
    }

    @Override
    public void unregisterChatListener(IEventSystem.ChatEventListener listener) {
        this.chatListeners.remove(listener);
    }

    @Override
    public void unregisterJoinListener(IEventSystem.PlayerJoinEventListener listener) {
        this.joinListeners.remove(listener);
    }

    @Override
    public void unregisterLeaveListener(IEventSystem.PlayerLeaveEventListener listener) {
        this.leaveListeners.remove(listener);
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (this.chatListeners.isEmpty()) {
            return;
        }
        MinecraftChatEvent chatEvent = new MinecraftChatEvent(event);
        for (IEventSystem.ChatEventListener listener : this.chatListeners) {
            try {
                listener.onPlayerChat(chatEvent);
            }
            catch (Exception e) {
                System.err.println("Error in chat event listener: " + e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.joinListeners.isEmpty()) {
            return;
        }
        MinecraftPlayerJoinEvent joinEvent = new MinecraftPlayerJoinEvent(event);
        for (IEventSystem.PlayerJoinEventListener listener : this.joinListeners) {
            try {
                listener.onPlayerJoin(joinEvent);
            }
            catch (Exception e) {
                System.err.println("Error in player join event listener: " + e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (this.leaveListeners.isEmpty()) {
            return;
        }
        MinecraftPlayerLeaveEvent leaveEvent = new MinecraftPlayerLeaveEvent(event);
        for (IEventSystem.PlayerLeaveEventListener listener : this.leaveListeners) {
            try {
                listener.onPlayerLeave(leaveEvent);
            }
            catch (Exception e) {
                System.err.println("Error in player leave event listener: " + e.getMessage());
            }
        }
    }

    private static class MinecraftChatEvent
    implements IEventSystem.ChatEvent {
        private final ServerChatEvent forgeEvent;
        private final IPlayer player;

        public MinecraftChatEvent(ServerChatEvent forgeEvent) {
            this.forgeEvent = forgeEvent;
            this.player = MinecraftPlayer.of(forgeEvent.getPlayer());
        }

        @Override
        public IPlayer getPlayer() {
            return this.player;
        }

        @Override
        public String getMessage() {
            return this.forgeEvent.getMessage().getString();
        }

        @Override
        public void setMessage(String message) {
            if (message == null || message.equals(this.getMessage())) {
                return;
            }
            this.forgeEvent.setCanceled(true);
        }

        @Override
        public boolean isCancelled() {
            return this.forgeEvent.isCanceled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.forgeEvent.setCanceled(cancelled);
        }
    }

    private static class MinecraftPlayerJoinEvent
    implements IEventSystem.PlayerJoinEvent {
        private final PlayerEvent.PlayerLoggedInEvent forgeEvent;
        private final IPlayer player;

        public MinecraftPlayerJoinEvent(PlayerEvent.PlayerLoggedInEvent forgeEvent) {
            this.forgeEvent = forgeEvent;
            this.player = MinecraftPlayer.of((ServerPlayer)forgeEvent.getEntity());
        }

        @Override
        public IPlayer getPlayer() {
            return this.player;
        }

        @Override
        public IComponent getJoinMessage() {
            return null;
        }

        @Override
        public void setJoinMessage(IComponent message) {
        }
    }

    private static class MinecraftPlayerLeaveEvent
    implements IEventSystem.PlayerLeaveEvent {
        private final PlayerEvent.PlayerLoggedOutEvent forgeEvent;
        private final IPlayer player;

        public MinecraftPlayerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent forgeEvent) {
            this.forgeEvent = forgeEvent;
            this.player = MinecraftPlayer.of((ServerPlayer)forgeEvent.getEntity());
        }

        @Override
        public IPlayer getPlayer() {
            return this.player;
        }

        @Override
        public IComponent getLeaveMessage() {
            return null;
        }

        @Override
        public void setLeaveMessage(IComponent message) {
        }
    }
}

