/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.utils.DebugLogger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.MinecraftServer;

public class TaskScheduler {
    private ScheduledExecutorService executorService;
    private final AtomicReference<MinecraftServer> serverRef = new AtomicReference<Object>(null);
    private final DebugLogger debugLogger;

    public TaskScheduler(DebugLogger debugLogger) {
        this.debugLogger = debugLogger;
    }

    public void initialize(MinecraftServer serverInstance) {
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = Executors.newScheduledThreadPool(1);
            this.debugLogger.debugLog("TaskScheduler: Executor service created.");
        }
        this.serverRef.set(serverInstance);
        if (serverInstance != null) {
            this.debugLogger.debugLog("TaskScheduler: Initialized with server instance.");
        } else {
            this.debugLogger.debugLog("TaskScheduler: Initialized with null server instance (server might not be ready).");
        }
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.debugLogger.debugLog("TaskScheduler: Cannot schedule task, executor service is not running.");
            return null;
        }
        return this.executorService.scheduleAtFixedRate(() -> this.syncExecute(task), initialDelay, period, unit);
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.debugLogger.debugLog("TaskScheduler: Cannot schedule task, executor service is not running.");
            return null;
        }
        return this.executorService.schedule(() -> this.syncExecute(task), delay, unit);
    }

    private void syncExecute(Runnable task) {
        MinecraftServer currentServer = this.serverRef.get();
        if (currentServer != null && !currentServer.isStopped()) {
            currentServer.execute(task);
        } else if (currentServer != null) {
            this.debugLogger.debugLog("TaskScheduler: Server instance is stopped, unable to execute task synchronously.");
        }
    }

    public void onServerStopping() {
        if (this.executorService == null) {
            this.debugLogger.debugLog("TaskScheduler: Executor service was null, nothing to shut down.");
            return;
        }
        if (this.executorService.isShutdown()) {
            this.debugLogger.debugLog("TaskScheduler: Executor service already shut down.");
            return;
        }
        this.debugLogger.debugLog("TaskScheduler: Server is stopping, shutting down scheduler...");
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                this.debugLogger.debugLog("TaskScheduler: Executor service forcefully shut down.");
            } else {
                this.debugLogger.debugLog("TaskScheduler: Executor service shut down gracefully.");
            }
        }
        catch (InterruptedException ex) {
            this.executorService.shutdownNow();
            this.debugLogger.debugLog("TaskScheduler: Executor service shutdown interrupted.");
            Thread.currentThread().interrupt();
        }
    }

    public boolean isServerAvailable() {
        MinecraftServer currentServer = this.serverRef.get();
        return currentServer != null && !currentServer.isStopped();
    }
}

