/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.webeditor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.avalanche7.paradigm.Paradigm;
import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.configs.MOTDConfigHandler;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.modules.Announcements;
import eu.avalanche7.paradigm.modules.Mentions;
import eu.avalanche7.paradigm.modules.Restart;
import eu.avalanche7.paradigm.modules.chat.GroupChat;
import eu.avalanche7.paradigm.modules.chat.JoinLeaveMessages;
import eu.avalanche7.paradigm.modules.chat.MOTD;
import eu.avalanche7.paradigm.modules.chat.StaffChat;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class EditorApplier {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static final String USER_AGENT = "paradigm/editor";

    private EditorApplier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObject downloadFromBytebinOrThrow(String code) throws Exception {
        String url = "https://bytebin.avalanche7.eu/" + code;
        HttpURLConnection conn = (HttpURLConnection)URI.create(url).toURL().openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", USER_AGENT);
        conn.setRequestProperty("Accept", "application/json, text/plain;q=0.5, */*;q=0.1");
        conn.setConnectTimeout(8000);
        conn.setReadTimeout(10000);
        int status = conn.getResponseCode();
        if (status < 200 || status >= 300) {
            String msg;
            try {
                msg = conn.getResponseMessage();
            }
            catch (Exception e) {
                msg = null;
            }
            InputStream es = null;
            String errBody = null;
            try {
                es = conn.getErrorStream();
                if (es != null) {
                    errBody = new String(es.readAllBytes(), StandardCharsets.UTF_8);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (es != null) {
                    try {
                        es.close();
                    }
                    catch (Exception exception) {}
                }
            }
            String respCt = null;
            String respCe = null;
            try {
                respCt = conn.getHeaderField("Content-Type");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                respCe = conn.getHeaderField("Content-Encoding");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            conn.disconnect();
            throw new Exception("Bytebin GET failed: url=" + url + ", HTTP " + status + (String)(msg != null ? " (" + msg + ")" : "") + (String)(respCt != null ? ", contentType=" + respCt : "") + (String)(respCe != null ? ", contentEncoding=" + respCe : "") + (String)(errBody != null && !errBody.isEmpty() ? ", body=" + errBody : ""));
        }
        try {
            JsonObject jsonObject;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                String body = sb.toString();
                JsonObject obj = (JsonObject)GSON.fromJson(body, JsonObject.class);
                if (obj == null) {
                    throw new Exception("Bytebin response was empty or invalid JSON. url=" + url);
                }
                jsonObject = obj;
            }
            return jsonObject;
        }
        finally {
            conn.disconnect();
        }
    }

    public static ApplyResult applyFromBytebinWithReport(Services services, String code) throws Exception {
        JsonObject payload = EditorApplier.downloadFromBytebinOrThrow(code);
        return EditorApplier.applyPayloadWithReport(services, payload);
    }

    private static JsonElement unwrapValues(JsonElement element) {
        if (element == null) {
            return null;
        }
        if (element.isJsonArray()) {
            for (int i = 0; i < element.getAsJsonArray().size(); ++i) {
                JsonElement child = element.getAsJsonArray().get(i);
                element.getAsJsonArray().set(i, EditorApplier.unwrapValues(child));
            }
            return element;
        }
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            if (!obj.entrySet().isEmpty() && obj.has("value")) {
                return EditorApplier.unwrapValues(obj.get("value"));
            }
            JsonObject out = new JsonObject();
            for (Map.Entry e : obj.entrySet()) {
                out.add((String)e.getKey(), EditorApplier.unwrapValues((JsonElement)e.getValue()));
            }
            return out;
        }
        return element;
    }

    public static ApplyResult applyPayloadWithReport(Services services, JsonObject payload) throws Exception {
        if (payload == null) {
            throw new Exception("Payload was null");
        }
        if (!payload.has("files") || !payload.get("files").isJsonObject()) {
            throw new Exception("Payload missing 'files' object");
        }
        JsonObject files = payload.getAsJsonObject("files");
        int applied = 0;
        int unchanged = 0;
        ArrayList<String> appliedFiles = new ArrayList<String>();
        ArrayList<String> unchangedFiles = new ArrayList<String>();
        ArrayList<String> skipped = new ArrayList<String>();
        ApplyOneResult result = EditorApplier.applyOne(files, () -> {
            JsonElement el = EditorApplier.find(files, "main", "main.json");
            if (el == null) {
                return ApplyStatus.MISSING;
            }
            MainConfigHandler.Config newConfig = (MainConfigHandler.Config)GSON.fromJson(el, MainConfigHandler.Config.class);
            if (EditorApplier.configsEqual(MainConfigHandler.CONFIG, newConfig)) {
                return ApplyStatus.UNCHANGED;
            }
            MainConfigHandler.CONFIG = newConfig;
            MainConfigHandler.save();
            return ApplyStatus.APPLIED;
        }, "main");
        EditorApplier.updateCounters(result, "main", appliedFiles, unchangedFiles, skipped);
        if (result.status == ApplyStatus.APPLIED) {
            ++applied;
        }
        if (result.status == ApplyStatus.UNCHANGED) {
            ++unchanged;
        }
        result = EditorApplier.applyOne(files, () -> {
            JsonElement el = EditorApplier.find(files, "announcements", "announcements.json");
            if (el == null) {
                return ApplyStatus.MISSING;
            }
            AnnouncementsConfigHandler.Config newConfig = (AnnouncementsConfigHandler.Config)GSON.fromJson(el, AnnouncementsConfigHandler.Config.class);
            if (EditorApplier.configsEqual(AnnouncementsConfigHandler.CONFIG, newConfig)) {
                return ApplyStatus.UNCHANGED;
            }
            AnnouncementsConfigHandler.CONFIG = newConfig;
            AnnouncementsConfigHandler.save();
            return ApplyStatus.APPLIED;
        }, "announcements");
        EditorApplier.updateCounters(result, "announcements", appliedFiles, unchangedFiles, skipped);
        if (result.status == ApplyStatus.APPLIED) {
            ++applied;
        }
        if (result.status == ApplyStatus.UNCHANGED) {
            ++unchanged;
        }
        result = EditorApplier.applyOne(files, () -> {
            JsonElement el = EditorApplier.find(files, "chat", "chat.json");
            if (el == null) {
                return ApplyStatus.MISSING;
            }
            ChatConfigHandler.Config newConfig = (ChatConfigHandler.Config)GSON.fromJson(el, ChatConfigHandler.Config.class);
            if (EditorApplier.configsEqual(ChatConfigHandler.CONFIG, newConfig)) {
                return ApplyStatus.UNCHANGED;
            }
            ChatConfigHandler.CONFIG = newConfig;
            ChatConfigHandler.save();
            return ApplyStatus.APPLIED;
        }, "chat");
        EditorApplier.updateCounters(result, "chat", appliedFiles, unchangedFiles, skipped);
        if (result.status == ApplyStatus.APPLIED) {
            ++applied;
        }
        if (result.status == ApplyStatus.UNCHANGED) {
            ++unchanged;
        }
        result = EditorApplier.applyOne(files, () -> {
            JsonElement el = EditorApplier.find(files, "motd", "motd.json");
            if (el == null) {
                return ApplyStatus.MISSING;
            }
            MOTDConfigHandler.Config newConfig = (MOTDConfigHandler.Config)GSON.fromJson(el, MOTDConfigHandler.Config.class);
            if (EditorApplier.configsEqual(MOTDConfigHandler.CONFIG, newConfig)) {
                return ApplyStatus.UNCHANGED;
            }
            MOTDConfigHandler.CONFIG = newConfig;
            MOTDConfigHandler.save();
            return ApplyStatus.APPLIED;
        }, "motd");
        EditorApplier.updateCounters(result, "motd", appliedFiles, unchangedFiles, skipped);
        if (result.status == ApplyStatus.APPLIED) {
            ++applied;
        }
        if (result.status == ApplyStatus.UNCHANGED) {
            ++unchanged;
        }
        result = EditorApplier.applyOne(files, () -> {
            JsonElement el = EditorApplier.find(files, "mention", "mentions", "mention.json", "mentions.json");
            if (el == null) {
                return ApplyStatus.MISSING;
            }
            MentionConfigHandler.Config newConfig = (MentionConfigHandler.Config)GSON.fromJson(el, MentionConfigHandler.Config.class);
            if (EditorApplier.configsEqual(MentionConfigHandler.CONFIG, newConfig)) {
                return ApplyStatus.UNCHANGED;
            }
            MentionConfigHandler.CONFIG = newConfig;
            MentionConfigHandler.save();
            return ApplyStatus.APPLIED;
        }, "mention");
        EditorApplier.updateCounters(result, "mention", appliedFiles, unchangedFiles, skipped);
        if (result.status == ApplyStatus.APPLIED) {
            ++applied;
        }
        if (result.status == ApplyStatus.UNCHANGED) {
            ++unchanged;
        }
        result = EditorApplier.applyOne(files, () -> {
            JsonElement el = EditorApplier.find(files, "restart", "restart.json");
            if (el == null) {
                return ApplyStatus.MISSING;
            }
            RestartConfigHandler.Config newConfig = (RestartConfigHandler.Config)GSON.fromJson(el, RestartConfigHandler.Config.class);
            if (EditorApplier.configsEqual(RestartConfigHandler.CONFIG, newConfig)) {
                return ApplyStatus.UNCHANGED;
            }
            RestartConfigHandler.CONFIG = newConfig;
            RestartConfigHandler.save();
            return ApplyStatus.APPLIED;
        }, "restart");
        EditorApplier.updateCounters(result, "restart", appliedFiles, unchangedFiles, skipped);
        if (result.status == ApplyStatus.APPLIED) {
            ++applied;
        }
        if (result.status == ApplyStatus.UNCHANGED) {
            ++unchanged;
        }
        if (applied > 0) {
            Paradigm.getModules().stream().filter(m -> m instanceof Restart).findFirst().ifPresent(m -> ((Restart)m).scheduleNextRestart());
            Paradigm.getModules().stream().filter(m -> m instanceof Announcements).findFirst().ifPresent(m -> ((Announcements)m).rescheduleAnnouncements());
            EditorApplier.reloadAffectedModules(services, appliedFiles);
        }
        StringBuilder msg = new StringBuilder();
        if (applied > 0) {
            msg.append("Applied changes to ").append(appliedFiles.size()).append(" file");
            if (appliedFiles.size() != 1) {
                msg.append("s");
            }
            msg.append(": ").append(String.join((CharSequence)", ", appliedFiles)).append(". Modules reloaded.");
        } else {
            msg.append("No changes were applied.");
        }
        if (unchanged > 0) {
            msg.append(" ").append(unchangedFiles.size()).append(" file");
            if (unchangedFiles.size() != 1) {
                msg.append("s");
            }
            msg.append(" had no changes.");
        }
        if (!skipped.isEmpty()) {
            msg.append(" Skipped: ").append(String.join((CharSequence)", ", skipped)).append(".");
        }
        String finalMsg = msg.toString().trim();
        try {
            services.getLogger().info("Paradigm WebEditor: {}", (Object)finalMsg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ApplyResult(applied, unchanged, finalMsg);
    }

    private static boolean jsonEquals(String a, String b) {
        try {
            JsonElement ja = JsonParser.parseString((String)a);
            JsonElement jb = JsonParser.parseString((String)b);
            return ja.equals(jb);
        }
        catch (Throwable ignored) {
            return a != null && a.trim().equals(b != null ? b.trim() : null);
        }
    }

    private static void updateCounters(ApplyOneResult result, String name, List<String> appliedFiles, List<String> unchangedFiles, List<String> skipped) {
        switch (result.status.ordinal()) {
            case 0: {
                appliedFiles.add(name);
                break;
            }
            case 1: {
                unchangedFiles.add(name);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                skipped.add(name + " (" + result.errorMsg + ")");
            }
        }
    }

    private static void reloadAffectedModules(Services services, List<String> appliedFiles) {
        try {
            Iterator<String> iterator = appliedFiles.iterator();
            while (iterator.hasNext()) {
                String fileName;
                switch (fileName = iterator.next()) {
                    case "chat": {
                        Paradigm.getModules().stream().filter(m -> m instanceof GroupChat || m instanceof StaffChat || m instanceof JoinLeaveMessages).forEach(m -> {
                            try {
                                m.onDisable(services);
                                if (m.isEnabled(services)) {
                                    m.onEnable(services);
                                }
                            }
                            catch (Exception e) {
                                services.getLogger().warn("Failed to reload module {}", (Object)m.getName(), (Object)e);
                            }
                        });
                        break;
                    }
                    case "motd": {
                        Paradigm.getModules().stream().filter(m -> m instanceof MOTD).forEach(m -> {
                            try {
                                m.onDisable(services);
                                if (m.isEnabled(services)) {
                                    m.onEnable(services);
                                }
                            }
                            catch (Exception e) {
                                services.getLogger().warn("Failed to reload module {}", (Object)m.getName(), (Object)e);
                            }
                        });
                        break;
                    }
                    case "mention": {
                        Paradigm.getModules().stream().filter(m -> m instanceof Mentions).forEach(m -> {
                            try {
                                m.onDisable(services);
                                if (m.isEnabled(services)) {
                                    m.onEnable(services);
                                }
                            }
                            catch (Exception e) {
                                services.getLogger().warn("Failed to reload module {}", (Object)m.getName(), (Object)e);
                            }
                        });
                        break;
                    }
                    case "announcements": {
                        Paradigm.getModules().stream().filter(m -> m instanceof Announcements).forEach(m -> {
                            try {
                                m.onDisable(services);
                                if (m.isEnabled(services)) {
                                    m.onEnable(services);
                                }
                                try {
                                    ((Announcements)m).rescheduleAnnouncements();
                                }
                                catch (Throwable throwable) {}
                            }
                            catch (Exception e) {
                                services.getLogger().warn("Failed to reload module {}", (Object)m.getName(), (Object)e);
                            }
                        });
                        break;
                    }
                    case "restart": {
                        Paradigm.getModules().stream().filter(m -> m instanceof Restart).forEach(m -> {
                            try {
                                m.onDisable(services);
                                if (m.isEnabled(services)) {
                                    m.onEnable(services);
                                }
                                try {
                                    ((Restart)m).scheduleNextRestart();
                                }
                                catch (Throwable throwable) {}
                            }
                            catch (Exception e) {
                                services.getLogger().warn("Failed to reload module {}", (Object)m.getName(), (Object)e);
                            }
                        });
                        break;
                    }
                    case "main": {
                        Paradigm.getModules().forEach(m -> {
                            try {
                                m.onDisable(services);
                                if (m.isEnabled(services)) {
                                    m.onEnable(services);
                                }
                            }
                            catch (Exception e) {
                                try {
                                    services.getLogger().warn("Failed to reload module {}", (Object)m.getName(), (Object)e);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                        Paradigm.getModules().stream().filter(m -> m instanceof Announcements).forEach(m -> {
                            try {
                                ((Announcements)m).rescheduleAnnouncements();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                        Paradigm.getModules().stream().filter(m -> m instanceof Restart).forEach(m -> {
                            try {
                                ((Restart)m).scheduleNextRestart();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        });
                    }
                }
            }
            services.getLogger().info("Paradigm WebEditor: Reloaded affected modules");
        }
        catch (Exception e) {
            services.getLogger().warn("Paradigm WebEditor: Error while reloading modules", (Throwable)e);
        }
    }

    private static boolean configsEqual(Object current, Object newConfig) {
        if (current == null && newConfig == null) {
            return true;
        }
        if (current == null || newConfig == null) {
            return false;
        }
        String currentJson = GSON.toJson(current);
        String newJson = GSON.toJson(newConfig);
        return currentJson.equals(newJson);
    }

    private static JsonElement find(JsonObject files, String ... keys) {
        for (String k : keys) {
            if (!files.has(k)) continue;
            return files.get(k);
        }
        return null;
    }

    private static ApplyOneResult applyOne(JsonObject files, Applier applier, String nameForMsg) {
        try {
            ApplyStatus status = applier.apply();
            return new ApplyOneResult(status, null);
        }
        catch (Exception e) {
            Object errMsg = e.getClass().getSimpleName();
            if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                errMsg = (String)errMsg + ": " + e.getMessage();
            }
            return new ApplyOneResult(ApplyStatus.ERROR, (String)errMsg);
        }
    }

    public static int applyFromBytebin(Services services, String code) throws Exception {
        ApplyResult r = EditorApplier.applyFromBytebinWithReport(services, code);
        return r.applied;
    }

    public static final class ApplyResult {
        public final int applied;
        public final int unchanged;
        public final String message;

        public ApplyResult(int applied, int unchanged, String message) {
            this.applied = applied;
            this.unchanged = unchanged;
            this.message = message;
        }
    }

    @FunctionalInterface
    private static interface Applier {
        public ApplyStatus apply() throws Exception;
    }

    private static class ApplyOneResult {
        final ApplyStatus status;
        final String errorMsg;

        ApplyOneResult(ApplyStatus status, String errorMsg) {
            this.status = status;
            this.errorMsg = errorMsg;
        }
    }

    private static enum ApplyStatus {
        APPLIED,
        UNCHANGED,
        MISSING,
        ERROR;

    }
}

