/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.webeditor.store;

import eu.avalanche7.paradigm.webeditor.socket.SignatureAlgorithm;
import eu.avalanche7.paradigm.webeditor.store.WebEditorKeystore;
import eu.avalanche7.paradigm.webeditor.store.WebEditorSessionMap;
import eu.avalanche7.paradigm.webeditor.store.WebEditorSocketMap;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.concurrent.atomic.AtomicReference;

public class WebEditorStore {
    private final WebEditorSessionMap sessions = new WebEditorSessionMap();
    private final WebEditorSocketMap sockets = new WebEditorSocketMap();
    private final WebEditorKeystore keystore = new WebEditorKeystore(Path.of("editor-keystore.json", new String[0]));
    private final AtomicReference<KeyPair> keyPairRef = new AtomicReference();

    public WebEditorSessionMap sessions() {
        return this.sessions;
    }

    public WebEditorSocketMap sockets() {
        return this.sockets;
    }

    public WebEditorKeystore keystore() {
        return this.keystore;
    }

    public KeyPair keyPair() {
        KeyPair kp = this.keyPairRef.get();
        if (kp == null) {
            kp = SignatureAlgorithm.INSTANCE.generateKeyPair();
            this.keyPairRef.compareAndSet(null, kp);
        }
        return kp;
    }
}

