/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.configs.CMConfig;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.configs.CooldownConfigHandler;
import eu.avalanche7.paradigm.configs.MOTDConfigHandler;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.modules.Announcements;
import eu.avalanche7.paradigm.modules.CommandManager;
import eu.avalanche7.paradigm.modules.Mentions;
import eu.avalanche7.paradigm.modules.Restart;
import eu.avalanche7.paradigm.modules.chat.GroupChat;
import eu.avalanche7.paradigm.modules.chat.MOTD;
import eu.avalanche7.paradigm.modules.chat.StaffChat;
import eu.avalanche7.paradigm.modules.commands.Help;
import eu.avalanche7.paradigm.modules.commands.Reload;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.PlatformAdapterImpl;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.GroupChatManager;
import eu.avalanche7.paradigm.utils.Lang;
import eu.avalanche7.paradigm.utils.MessageParser;
import eu.avalanche7.paradigm.utils.PermissionsHandler;
import eu.avalanche7.paradigm.utils.Placeholders;
import eu.avalanche7.paradigm.utils.TaskScheduler;
import eu.avalanche7.paradigm.utils.TelemetryReporter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paradigm
implements DedicatedServerModInitializer {
    public static final String MOD_ID = "paradigm";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"paradigm");
    private final List<ParadigmModule> modules = new ArrayList<ParadigmModule>();
    private static List<ParadigmModule> modulesStatic;
    private Services services;
    private static Services servicesInstance;
    private DebugLogger debugLoggerInstance;
    private Lang langInstance;
    private static String modVersion;
    private MessageParser messageParserInstance;
    private PermissionsHandler permissionsHandlerInstance;
    private Placeholders placeholdersInstance;
    private TaskScheduler taskSchedulerInstance;
    private GroupChatManager groupChatManagerInstance;
    private CMConfig cmConfigInstance;
    private IPlatformAdapter platformAdapterInstance;
    private CooldownConfigHandler cooldownConfigHandlerInstance;
    private TelemetryReporter telemetryReporter;

    public void onInitializeServer() {
        LOGGER.info("Initializing Paradigm Mod for Fabric 1.21.1...");
        this.loadConfigurations();
        this.initializeServices();
        this.registerModules();
        servicesInstance = this.services;
        modulesStatic = this.modules;
        this.modules.forEach(module -> module.registerEventListeners(null, this.services));
        this.modules.forEach(module -> module.onLoad(null, this.services, null));
        this.registerFabricEvents();
        FabricLoader.getInstance().getModContainer(MOD_ID).ifPresent(modContainer -> {
            modVersion = modContainer.getMetadata().getVersion().getFriendlyString();
            String displayName = modContainer.getMetadata().getName();
            LOGGER.info("Paradigm Fabric mod (1.21.1) has been set up.");
            LOGGER.info("==================================================");
            LOGGER.info("{} - Version {}", (Object)displayName, (Object)Paradigm.getModVersion());
            LOGGER.info("Author: Avalanche7CZ");
            LOGGER.info("Discord: https://discord.com/invite/qZDcQdEFqQ");
            LOGGER.info("==================================================");
            UpdateChecker.checkForUpdates(Paradigm.getModVersion(), LOGGER);
        });
    }

    private void loadConfigurations() {
        try {
            LOGGER.info("[Paradigm] Loading configurations...");
            DebugLogger bootstrapDebugLogger = new DebugLogger(null);
            MainConfigHandler.setJsonValidator(bootstrapDebugLogger);
            AnnouncementsConfigHandler.setJsonValidator(bootstrapDebugLogger);
            ChatConfigHandler.setJsonValidator(bootstrapDebugLogger);
            MentionConfigHandler.setJsonValidator(bootstrapDebugLogger);
            RestartConfigHandler.setJsonValidator(bootstrapDebugLogger);
            MOTDConfigHandler.setJsonValidator(bootstrapDebugLogger);
            MainConfigHandler.getConfig();
            AnnouncementsConfigHandler.getConfig();
            MentionConfigHandler.getConfig();
            RestartConfigHandler.getConfig();
            ChatConfigHandler.getConfig();
            MOTDConfigHandler.getConfig();
            CooldownConfigHandler.load();
            this.debugLoggerInstance = new DebugLogger(MainConfigHandler.getConfig());
            MainConfigHandler.setJsonValidator(this.debugLoggerInstance);
            AnnouncementsConfigHandler.setJsonValidator(this.debugLoggerInstance);
            ChatConfigHandler.setJsonValidator(this.debugLoggerInstance);
            MentionConfigHandler.setJsonValidator(this.debugLoggerInstance);
            RestartConfigHandler.setJsonValidator(this.debugLoggerInstance);
            MOTDConfigHandler.setJsonValidator(this.debugLoggerInstance);
            if (this.cmConfigInstance == null) {
                this.cmConfigInstance = new CMConfig(this.debugLoggerInstance);
            }
            this.cmConfigInstance.loadCommands();
            this.createUtilityInstances();
            if (this.langInstance == null) {
                this.langInstance = new Lang(LOGGER, MainConfigHandler.getConfig(), this.messageParserInstance);
            }
            this.langInstance.initializeLanguage();
            LOGGER.info("[Paradigm] All configurations loaded successfully.");
        }
        catch (Exception e) {
            LOGGER.error("Failed to load configuration for {}", (Object)MOD_ID, (Object)e);
            throw new RuntimeException("Configuration loading failed for paradigm", e);
        }
    }

    private void createUtilityInstances() {
        this.placeholdersInstance = new Placeholders();
        this.debugLoggerInstance = new DebugLogger(MainConfigHandler.getConfig());
        this.taskSchedulerInstance = new TaskScheduler(this.debugLoggerInstance);
        this.permissionsHandlerInstance = new PermissionsHandler(LOGGER, this.cmConfigInstance, this.debugLoggerInstance);
        this.groupChatManagerInstance = new GroupChatManager();
        this.cooldownConfigHandlerInstance = new CooldownConfigHandler();
        this.platformAdapterInstance = new PlatformAdapterImpl(this.permissionsHandlerInstance, this.placeholdersInstance, this.taskSchedulerInstance, this.debugLoggerInstance);
        this.messageParserInstance = new MessageParser(this.placeholdersInstance, this.platformAdapterInstance);
        this.platformAdapterInstance.provideMessageParser(this.messageParserInstance);
    }

    private void initializeServices() {
        LOGGER.info("[Paradigm] Initializing Services with configs:");
        LOGGER.info("[Paradigm] MainConfig: " + (MainConfigHandler.getConfig() != null ? "NOT NULL" : "NULL"));
        LOGGER.info("[Paradigm] AnnouncementsConfig: " + (AnnouncementsConfigHandler.getConfig() != null ? "NOT NULL" : "NULL"));
        LOGGER.info("[Paradigm] MentionConfig: " + (MentionConfigHandler.getConfig() != null ? "NOT NULL" : "NULL"));
        this.services = new Services(LOGGER, MainConfigHandler.getConfig(), AnnouncementsConfigHandler.getConfig(), MOTDConfigHandler.getConfig(), MentionConfigHandler.getConfig(), RestartConfigHandler.getConfig(), ChatConfigHandler.getConfig(), this.cmConfigInstance, this.groupChatManagerInstance, this.debugLoggerInstance, this.langInstance, this.messageParserInstance, this.permissionsHandlerInstance, this.placeholdersInstance, this.taskSchedulerInstance, this.platformAdapterInstance, this.cooldownConfigHandlerInstance);
        this.groupChatManagerInstance.setServices(this.services);
        LOGGER.info("[Paradigm] Services initialized successfully");
    }

    private void registerModules() {
        this.modules.add(new Help());
        this.modules.add(new Announcements());
        this.modules.add(new MOTD());
        this.modules.add(new Mentions());
        this.modules.add(new Restart());
        this.modules.add(new StaffChat());
        this.modules.add(new GroupChat(this.groupChatManagerInstance));
        this.modules.add(new CommandManager());
        this.modules.add(new Reload());
        LOGGER.info("Paradigm: Registered {} modules.", (Object)this.modules.size());
    }

    private void registerFabricEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        CommandRegistrationCallback.EVENT.register(this::onRegisterCommands);
    }

    private void onServerStarting(MinecraftServer server) {
        this.services.setServer(server);
        if (this.telemetryReporter == null) {
            this.telemetryReporter = new TelemetryReporter(this.services);
        }
        this.telemetryReporter.start();
        if (this.permissionsHandlerInstance != null) {
            this.permissionsHandlerInstance.registerLuckPermsPermissions();
        }
        this.modules.forEach(module -> {
            if (module.isEnabled(this.services)) {
                module.onEnable(this.services);
                module.onServerStarting(null, this.services);
            }
        });
    }

    private void onRegisterCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        this.modules.forEach(module -> {
            if (module.isEnabled(this.services)) {
                module.registerCommands(dispatcher, registryAccess, this.services);
            }
        });
        CommandNode root = dispatcher.getRoot().getChild(MOD_ID);
        if (root != null) {
            LOGGER.info("[Paradigm] Root /paradigm command node present. Has executes? {}", (Object)(root.getCommand() != null ? 1 : 0));
        } else {
            LOGGER.warn("[Paradigm] Root /paradigm command node NOT found after registration!");
        }
    }

    public static Services getServices() {
        return servicesInstance;
    }

    public static List<ParadigmModule> getModules() {
        return modulesStatic != null ? modulesStatic : List.of();
    }

    public static String getModVersion() {
        if (!"unknown".equals(modVersion)) {
            return modVersion;
        }
        try {
            return FabricLoader.getInstance().getModContainer(MOD_ID).map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    private void onServerStopping(MinecraftServer server) {
        this.modules.forEach(module -> {
            if (module.isEnabled(this.services)) {
                module.onServerStopping(null, this.services);
                module.onDisable(this.services);
            }
        });
        if (this.telemetryReporter != null) {
            this.telemetryReporter.stop();
        }
        if (this.taskSchedulerInstance != null) {
            this.taskSchedulerInstance.onServerStopping();
        }
        LOGGER.info("Paradigm modules (1.21.1) have been processed for server stop.");
    }

    static {
        modVersion = "unknown";
    }

    public static class UpdateChecker {
        private static final String LATEST_VERSION_URL = "https://raw.githubusercontent.com/Avalanche7CZ/Paradigm/Fabric/1.21.1/version.txt?v=1";
        private static final String MODRINTH_PROJECT_ID = "s4i32SJd";
        private static final String CURSEFORGE_SLUG = "paradigm";
        private static final String MODRINTH_PROJECT_PAGE = "https://modrinth.com/mod/s4i32SJd";
        private static final String CURSEFORGE_PROJECT_PAGE = "https://www.curseforge.com/minecraft/mc-mods/paradigm";

        public static void checkForUpdates(String currentVersion, Logger logger) {
            boolean foundOnModrinth = UpdateChecker.checkModrinth(currentVersion, logger);
            if (!foundOnModrinth) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(URI.create(LATEST_VERSION_URL).toURL().openStream(), StandardCharsets.UTF_8));){
                    String latestVersion = reader.readLine();
                    if (latestVersion != null && !currentVersion.equals(latestVersion.trim())) {
                        logger.info("Paradigm: A new version is available: {} (Current: {})", (Object)latestVersion.trim(), (Object)currentVersion);
                        logger.info("Modrinth: {}", (Object)MODRINTH_PROJECT_PAGE);
                        logger.info("CurseForge: {}", (Object)CURSEFORGE_PROJECT_PAGE);
                    }
                }
                catch (Exception e) {
                    logger.warn("Paradigm: Failed to check for updates (GitHub).");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean checkModrinth(String currentVersion, Logger logger) {
            block22: {
                HttpURLConnection conn = null;
                try {
                    String apiUrl = "https://api.modrinth.com/v2/project/s4i32SJd/version";
                    conn = (HttpURLConnection)URI.create(apiUrl).toURL().openConnection();
                    conn.setRequestProperty("User-Agent", "Paradigm-UpdateChecker/1.0 (+https://modrinth.com/mod/s4i32SJd)");
                    conn.setConnectTimeout(4000);
                    conn.setReadTimeout(6000);
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                    JsonArray arr = JsonParser.parseReader((Reader)br).getAsJsonArray();
                    if (arr.isEmpty()) {
                        boolean bl = false;
                        return bl;
                    }
                    String mcVersion = UpdateChecker.getMinecraftVersionSafe();
                    String loader = "fabric";
                    String newestCompatible = null;
                    String publishedAtNewest = null;
                    for (JsonElement el : arr) {
                        String published;
                        JsonObject obj = el.getAsJsonObject();
                        boolean loaderOk = false;
                        JsonArray loaders = obj.getAsJsonArray("loaders");
                        if (loaders != null) {
                            for (JsonElement l : loaders) {
                                if (!loader.equalsIgnoreCase(l.getAsString())) continue;
                                loaderOk = true;
                                break;
                            }
                        }
                        if (!loaderOk) continue;
                        boolean versionOk = true;
                        if (mcVersion != null) {
                            versionOk = false;
                            JsonArray gameVersions = obj.getAsJsonArray("game_versions");
                            if (gameVersions != null) {
                                for (JsonElement v : gameVersions) {
                                    if (!mcVersion.equals(v.getAsString())) continue;
                                    versionOk = true;
                                    break;
                                }
                            }
                        }
                        if (!versionOk) continue;
                        String ver = obj.get("version_number").getAsString();
                        String string = published = obj.has("date_published") ? obj.get("date_published").getAsString() : null;
                        if (newestCompatible == null) {
                            newestCompatible = ver;
                            publishedAtNewest = published;
                            continue;
                        }
                        if (!UpdateChecker.isAfter(published, publishedAtNewest)) continue;
                        newestCompatible = ver;
                        publishedAtNewest = published;
                    }
                    if (newestCompatible == null || newestCompatible.equals(currentVersion)) break block22;
                    logger.info("Paradigm: A new version is available on Modrinth: {} (Current: {})", (Object)newestCompatible, (Object)currentVersion);
                    logger.info("Modrinth: {}", (Object)MODRINTH_PROJECT_PAGE);
                    logger.info("CurseForge: {}", (Object)CURSEFORGE_PROJECT_PAGE);
                    boolean bl = true;
                    return bl;
                    finally {
                        br.close();
                    }
                }
                catch (Exception ex) {
                    logger.debug("Paradigm: Modrinth check failed: {}", (Object)ex.toString());
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
            return false;
        }

        private static boolean isAfter(String a, String b) {
            if (a == null) {
                return false;
            }
            if (b == null) {
                return true;
            }
            return a.compareTo(b) > 0;
        }

        private static String getMinecraftVersionSafe() {
            try {
                return class_155.method_16673().comp_4025();
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

