/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules.chat;

import com.mojang.brigadier.CommandDispatcher;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class MOTD
implements ParadigmModule {
    private static final String NAME = "MOTD";
    private Services services;
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getMainConfig().motdEnable.value;
    }

    @Override
    public void onLoad(Object event, Services services, Object modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        if (services != null && services.getDebugLogger() != null) {
            services.getDebugLogger().debugLog("MOTD module loaded.");
        }
    }

    @Override
    public void onServerStarting(Object event, Services services) {
        if (services != null && services.getDebugLogger() != null) {
            services.getDebugLogger().debugLog("MOTD module: Server starting.");
        }
    }

    @Override
    public void onEnable(Services services) {
        if (services != null && services.getDebugLogger() != null) {
            services.getDebugLogger().debugLog("MOTD module enabled.");
        }
    }

    @Override
    public void onDisable(Services services) {
        if (services != null && services.getDebugLogger() != null) {
            services.getDebugLogger().debugLog("MOTD module disabled.");
        }
    }

    @Override
    public void onServerStopping(Object event, Services services) {
        if (services != null && services.getDebugLogger() != null) {
            services.getDebugLogger().debugLog("MOTD module: Server stopping.");
        }
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, Services services) {
    }

    @Override
    public void registerEventListeners(Object eventBus, Services services) {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.onPlayerJoin(handler.field_14140, services));
    }

    public void onPlayerJoin(class_3222 player, Services services) {
        if (this.services == null || !this.isEnabled(this.services) || this.services.getMotdConfig() == null) {
            if (this.services != null && this.services.getDebugLogger() != null) {
                this.services.getDebugLogger().debugLog("MOTDModule: Services, MOTD module not enabled, or MOTDConfig is null. Skipping MOTD for " + this.platform.getPlayerName(player));
            }
            return;
        }
        class_2561 motdMessage = this.createMOTDMessage(player, this.services);
        this.platform.sendSystemMessage(player, motdMessage);
        this.services.getDebugLogger().debugLog("Sent MOTD to " + this.platform.getPlayerName(player));
    }

    private class_2561 createMOTDMessage(class_3222 player, Services services) {
        if (services == null || services.getMotdConfig() == null) {
            if (services != null && services.getDebugLogger() != null) {
                services.getDebugLogger().debugLog("MOTDModule: Services or MOTDConfig is null in createMOTDMessage.");
            }
            return class_2561.method_43473();
        }
        List<String> lines = services.getMotdConfig().motdLines;
        if (lines == null || lines.isEmpty()) {
            return class_2561.method_43473();
        }
        class_5250 motdMessage = this.platform.createLiteralComponent("");
        IPlayer iPlayer = services.getPlatformAdapter().wrapPlayer(player);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (services.getMessageParser() != null) {
                motdMessage.method_10852(services.getMessageParser().parseMessage(line, iPlayer).getOriginalText());
            } else {
                if (services.getDebugLogger() != null) {
                    services.getDebugLogger().debugLog("MOTDModule: MessageParser is null in createMOTDMessage loop.");
                }
                motdMessage.method_10852((class_2561)this.platform.createLiteralComponent(line));
            }
            if (i >= lines.size() - 1) continue;
            motdMessage.method_10852((class_2561)this.platform.createLiteralComponent("\n"));
        }
        return motdMessage;
    }
}

