/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules.chat;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_7471;

public class StaffChat
implements ParadigmModule {
    private static final String NAME = "StaffChat";
    private final ConcurrentHashMap<UUID, Boolean> staffChatEnabledMap = new ConcurrentHashMap();
    private Services services;
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getChatConfig().enableStaffChat.value;
    }

    @Override
    public void onLoad(Object event, Services services, Object modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
    }

    @Override
    public void onServerStarting(Object event, Services services) {
    }

    @Override
    public void onEnable(Services services) {
    }

    @Override
    public void onDisable(Services services) {
        ((ConcurrentHashMap.KeySetView)this.staffChatEnabledMap.keySet()).forEach(uuid -> {
            class_3222 player = this.platform.getPlayerByUuid((UUID)uuid);
            if (player != null) {
                this.platform.removePersistentBossBar(player);
            }
        });
        this.staffChatEnabledMap.clear();
    }

    @Override
    public void onServerStopping(Object event, Services services) {
        this.onDisable(services);
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, Services services) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sc").requires(source -> source.method_43737() && this.services.getPermissionsHandler().hasPermission(source.method_44023(), "paradigm.staff"))).then(class_2170.method_9247((String)"toggle").executes(context -> this.toggleStaffChatCmd((class_2168)context.getSource())))).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendStaffChatMessageCmd((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"message"))))).executes(context -> this.toggleStaffChatCmd((class_2168)context.getSource())));
    }

    @Override
    public void registerEventListeners(Object eventBus, Services services) {
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register(this::onAllowChatMessage);
    }

    private void toggleStaffChat(class_3222 player) {
        boolean isCurrentlyEnabled = this.staffChatEnabledMap.getOrDefault(player.method_5667(), false);
        boolean newState = !isCurrentlyEnabled;
        this.staffChatEnabledMap.put(player.method_5667(), newState);
        class_5250 feedbackMessage = this.platform.createLiteralComponent("Staff chat ").method_10852((class_2561)(newState ? this.platform.createLiteralComponent("enabled").method_27694(s -> s.method_36139(0x55FF55)) : this.platform.createLiteralComponent("disabled").method_27694(s -> s.method_36139(0xFF5555))));
        this.platform.sendSystemMessage(player, (class_2561)feedbackMessage);
        if (newState) {
            this.showBossBar(player);
        } else {
            this.platform.removePersistentBossBar(player);
        }
    }

    private void sendStaffChatMessage(class_3222 sender, String message) {
        ChatConfigHandler.Config chatConfig = this.services.getChatConfig();
        String formattedMessage = String.format((String)chatConfig.staffChatFormat.value, this.platform.getPlayerName(sender), message);
        IPlayer iSender = this.services.getPlatformAdapter().wrapPlayer(sender);
        class_2561 chatComponent = this.services.getMessageParser().parseMessage(formattedMessage, iSender).getOriginalText();
        this.platform.getOnlinePlayers().stream().filter(onlinePlayer -> this.platform.hasPermission((class_3222)onlinePlayer, "paradigm.staff")).forEach(staffMember -> this.platform.sendSystemMessage((class_3222)staffMember, chatComponent));
        this.services.getLogger().info("(StaffChat) {}: {}", (Object)this.platform.getPlayerName(sender), (Object)message);
    }

    private boolean onAllowChatMessage(class_7471 message, class_3222 player, class_2556.class_7602 params) {
        if (player == null) {
            return true;
        }
        if (!this.isEnabled(this.services)) {
            return true;
        }
        if (this.staffChatEnabledMap.getOrDefault(player.method_5667(), false).booleanValue()) {
            this.sendStaffChatMessage(player, message.method_46291().getString());
            return false;
        }
        return true;
    }

    private void showBossBar(class_3222 player) {
        if (((Boolean)this.services.getChatConfig().enableStaffBossBar.value).booleanValue()) {
            IPlayer iPlayer = this.services.getPlatformAdapter().wrapPlayer(player);
            class_2561 title = this.services.getMessageParser().parseMessage("\u00a7cStaff Chat Mode \u00a7aEnabled", iPlayer).getOriginalText();
            this.platform.showPersistentBossBar(player, title, IPlatformAdapter.BossBarColor.RED, IPlatformAdapter.BossBarOverlay.PROGRESS);
        }
    }

    private int toggleStaffChatCmd(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        this.toggleStaffChat(player);
        return 1;
    }

    private int sendStaffChatMessageCmd(class_2168 source, String message) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        this.sendStaffChatMessage(player, message);
        return 1;
    }
}

