/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.avalanche7.paradigm.Paradigm;
import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.configs.MOTDConfigHandler;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.modules.Announcements;
import eu.avalanche7.paradigm.modules.Restart;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class Reload
implements ParadigmModule {
    @Override
    public String getName() {
        return "Reload";
    }

    @Override
    public boolean isEnabled(Services services) {
        return true;
    }

    @Override
    public void onLoad(Object e, Services s, Object b) {
    }

    @Override
    public void onServerStarting(Object e, Services s) {
    }

    @Override
    public void onEnable(Services s) {
    }

    @Override
    public void onDisable(Services s) {
    }

    @Override
    public void onServerStopping(Object e, Services s) {
    }

    @Override
    public void registerEventListeners(Object bus, Services s) {
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, Services services) {
        SuggestionProvider configSuggestions = (ctx, builder) -> {
            List<String> options = List.of("main", "announcements", "chat", "motd", "mention", "restart", "customcommands", "all");
            options.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        };
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"paradigm").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"config", (ArgumentType)StringArgumentType.word()).suggests(configSuggestions).executes(ctx -> {
            String cfg = StringArgumentType.getString((CommandContext)ctx, (String)"config").toLowerCase(Locale.ROOT);
            boolean ok = true;
            Object msg = switch (cfg) {
                case "main" -> {
                    MainConfigHandler.load();
                    yield "Main config reloaded.";
                }
                case "announcements" -> {
                    AnnouncementsConfigHandler.load();
                    this.rescheduleAnnouncements();
                    yield "Announcements config reloaded and rescheduled.";
                }
                case "chat" -> {
                    ChatConfigHandler.load();
                    yield "Chat config reloaded.";
                }
                case "motd" -> {
                    MOTDConfigHandler.loadConfig();
                    yield "MOTD config reloaded.";
                }
                case "mention" -> {
                    MentionConfigHandler.load();
                    yield "Mention config reloaded.";
                }
                case "restart" -> {
                    RestartConfigHandler.load();
                    this.rescheduleRestart(services);
                    yield "Restart config reloaded and rescheduled.";
                }
                case "customcommands" -> {
                    services.getCmConfig().reloadCommands();
                    services.getPermissionsHandler().refreshCustomCommandPermissions();
                    yield "Custom commands config reloaded. \u00a7e\u00a7lNote: Command changes require a server restart to take effect!";
                }
                case "all" -> {
                    MainConfigHandler.load();
                    AnnouncementsConfigHandler.load();
                    ChatConfigHandler.load();
                    MOTDConfigHandler.loadConfig();
                    MentionConfigHandler.load();
                    RestartConfigHandler.load();
                    services.getCmConfig().reloadCommands();
                    services.getPermissionsHandler().refreshCustomCommandPermissions();
                    this.rescheduleAnnouncements();
                    this.rescheduleRestart(services);
                    yield "All configs reloaded; schedules refreshed. \u00a7e\u00a7lNote: Custom command changes require server restart!";
                }
                default -> {
                    ok = false;
                    yield "Unknown config: " + cfg;
                }
            };
            if (ok) {
                ((class_2168)ctx.getSource()).method_9226(() -> Reload.lambda$registerCommands$2((String)msg), false);
            } else {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)msg));
            }
            return ok ? 1 : 0;
        }))));
    }

    private void rescheduleAnnouncements() {
        for (ParadigmModule m : Paradigm.getModules()) {
            if (!(m instanceof Announcements)) continue;
            ((Announcements)m).rescheduleAnnouncements();
        }
    }

    private void rescheduleRestart(Services services) {
        for (ParadigmModule m : Paradigm.getModules()) {
            if (!(m instanceof Restart)) continue;
            ((Restart)m).rescheduleNextRestart(services);
        }
    }

    private static /* synthetic */ class_2561 lambda$registerCommands$2(String msg) {
        return class_2561.method_43470((String)("\u00a7a" + msg));
    }
}

