/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.platform;

import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IEventSystem;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;

public class MinecraftEventSystem
implements IEventSystem {
    private final CopyOnWriteArrayList<IEventSystem.PlayerJoinEventListener> joinListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<IEventSystem.PlayerLeaveEventListener> leaveListeners = new CopyOnWriteArrayList();
    private static final CopyOnWriteArrayList<IEventSystem.ChatEventListener> chatListeners = new CopyOnWriteArrayList();

    public MinecraftEventSystem() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (this.joinListeners.isEmpty()) {
                return;
            }
            MinecraftPlayerJoinEvent joinEvent = new MinecraftPlayerJoinEvent(player);
            for (IEventSystem.PlayerJoinEventListener listener : this.joinListeners) {
                try {
                    listener.onPlayerJoin(joinEvent);
                }
                catch (Exception e) {
                    System.err.println("Error in player join event listener: " + e.getMessage());
                }
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            if (this.leaveListeners.isEmpty()) {
                return;
            }
            MinecraftPlayerLeaveEvent leaveEvent = new MinecraftPlayerLeaveEvent(player);
            for (IEventSystem.PlayerLeaveEventListener listener : this.leaveListeners) {
                try {
                    listener.onPlayerLeave(leaveEvent);
                }
                catch (Exception e) {
                    System.err.println("Error in player leave event listener: " + e.getMessage());
                }
            }
        });
    }

    public void registerJoinListener(IEventSystem.PlayerJoinEventListener listener) {
        this.joinListeners.add(listener);
    }

    public void registerLeaveListener(IEventSystem.PlayerLeaveEventListener listener) {
        this.leaveListeners.add(listener);
    }

    public void unregisterJoinListener(IEventSystem.PlayerJoinEventListener listener) {
        this.joinListeners.remove(listener);
    }

    public void unregisterLeaveListener(IEventSystem.PlayerLeaveEventListener listener) {
        this.leaveListeners.remove(listener);
    }

    public static CopyOnWriteArrayList<IEventSystem.ChatEventListener> getChatListeners() {
        return chatListeners;
    }

    public void registerChatListener(IEventSystem.ChatEventListener listener) {
        chatListeners.add(listener);
    }

    public void unregisterChatListener(IEventSystem.ChatEventListener listener) {
        chatListeners.remove(listener);
    }

    private static class MinecraftPlayerLeaveEvent
    implements IEventSystem.PlayerLeaveEvent {
        private final IPlayer player;
        private IComponent leaveMessage;

        public MinecraftPlayerLeaveEvent(class_3222 player) {
            this.player = MinecraftPlayer.of(player);
        }

        @Override
        public IPlayer getPlayer() {
            return this.player;
        }

        @Override
        public IComponent getLeaveMessage() {
            return this.leaveMessage;
        }

        @Override
        public void setLeaveMessage(IComponent message) {
            this.leaveMessage = message;
        }
    }

    private static class MinecraftPlayerJoinEvent
    implements IEventSystem.PlayerJoinEvent {
        private final IPlayer player;
        private IComponent joinMessage;

        public MinecraftPlayerJoinEvent(class_3222 player) {
            this.player = MinecraftPlayer.of(player);
        }

        @Override
        public IPlayer getPlayer() {
            return this.player;
        }

        @Override
        public IComponent getJoinMessage() {
            return this.joinMessage;
        }

        @Override
        public void setJoinMessage(IComponent message) {
            this.joinMessage = message;
        }
    }

    public static class ChatEventImpl
    implements IEventSystem.ChatEvent {
        private final IPlayer player;
        private String message;
        private boolean cancelled = false;

        public ChatEventImpl(class_3222 player, String message) {
            this.player = MinecraftPlayer.of(player);
            this.message = message;
        }

        @Override
        public IPlayer getPlayer() {
            return this.player;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }
    }
}

