/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.platform;

import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftComponent;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.MessageParser;
import eu.avalanche7.paradigm.utils.PermissionsHandler;
import eu.avalanche7.paradigm.utils.Placeholders;
import eu.avalanche7.paradigm.utils.TaskScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5888;
import net.minecraft.class_5894;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PlatformAdapterImpl
implements IPlatformAdapter {
    private MinecraftServer server;
    private MessageParser messageParser;
    private final PermissionsHandler permissionsHandler;
    private final Placeholders placeholders;
    private final TaskScheduler taskScheduler;
    private final DebugLogger debugLogger;
    private final Map<UUID, class_3213> persistentBossBars = new HashMap<UUID, class_3213>();
    private class_3213 restartBossBar;

    public PlatformAdapterImpl(PermissionsHandler permissionsHandler, Placeholders placeholders, TaskScheduler taskScheduler, DebugLogger debugLogger) {
        this.permissionsHandler = permissionsHandler;
        this.placeholders = placeholders;
        this.taskScheduler = taskScheduler;
        this.debugLogger = debugLogger;
    }

    @Override
    public void provideMessageParser(MessageParser messageParser) {
        this.messageParser = messageParser;
    }

    @Override
    public MinecraftServer getMinecraftServer() {
        return this.server;
    }

    @Override
    public void setMinecraftServer(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public List<class_3222> getOnlinePlayers() {
        if (this.server == null) {
            return new ArrayList<class_3222>();
        }
        return this.server.method_3760().method_14571();
    }

    @Override
    @Nullable
    public class_3222 getPlayerByName(String name) {
        if (this.server == null) {
            return null;
        }
        return this.server.method_3760().method_14566(name);
    }

    @Override
    @Nullable
    public class_3222 getPlayerByUuid(UUID uuid) {
        if (this.server == null) {
            return null;
        }
        return this.server.method_3760().method_14602(uuid);
    }

    @Override
    public String getPlayerName(class_3222 player) {
        return player.method_5477().getString();
    }

    @Override
    public class_2561 getPlayerDisplayName(class_3222 player) {
        return player.method_5476();
    }

    @Override
    public class_5250 createLiteralComponent(String text) {
        return class_2561.method_43470((String)text);
    }

    @Override
    public class_5250 createTranslatableComponent(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args);
    }

    @Override
    public class_1799 createItemStack(String itemId) {
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemId));
        return item != class_1802.field_8162 ? new class_1799((class_1935)item) : new class_1799((class_1935)class_1802.field_20391);
    }

    @Override
    public boolean hasPermission(class_3222 player, String permissionNode) {
        return this.permissionsHandler.hasPermission(player, permissionNode);
    }

    @Override
    public boolean hasPermission(class_3222 player, String permissionNode, int vanillaLevel) {
        return this.hasPermission(player, permissionNode) || player.method_64475(vanillaLevel);
    }

    @Override
    public void sendSystemMessage(class_3222 player, class_2561 message) {
        player.method_64398(message);
    }

    @Override
    public void broadcastSystemMessage(class_2561 message) {
        if (this.server != null && this.server.method_3760() != null) {
            this.server.method_3760().method_43514(message, false);
        }
    }

    @Override
    public void broadcastChatMessage(class_2561 message) {
        if (this.server != null && this.server.method_3760() != null) {
            this.server.method_3760().method_43514(message, false);
        }
    }

    @Override
    public void broadcastSystemMessage(class_2561 message, String header, String footer, @Nullable class_3222 playerContext) {
        if (this.messageParser == null || this.server == null) {
            return;
        }
        if (playerContext != null) {
            IPlayer iPlayerContext = this.wrapPlayer(playerContext);
            IComponent headerComp = this.messageParser.parseMessage(header, iPlayerContext);
            IComponent footerComp = this.messageParser.parseMessage(footer, iPlayerContext);
            this.getOnlinePlayers().forEach(p -> {
                this.sendSystemMessage((class_3222)p, headerComp.getOriginalText());
                this.sendSystemMessage((class_3222)p, message);
                this.sendSystemMessage((class_3222)p, footerComp.getOriginalText());
            });
        } else {
            this.getOnlinePlayers().forEach(p -> {
                IPlayer iPlayer = this.wrapPlayer((class_3222)p);
                IComponent headerComp = this.messageParser.parseMessage(header, iPlayer);
                IComponent footerComp = this.messageParser.parseMessage(footer, iPlayer);
                this.sendSystemMessage((class_3222)p, headerComp.getOriginalText());
                this.sendSystemMessage((class_3222)p, message);
                this.sendSystemMessage((class_3222)p, footerComp.getOriginalText());
            });
        }
    }

    @Override
    public void sendTitle(class_3222 player, class_2561 title, class_2561 subtitle) {
        player.field_13987.method_14364((class_2596)new class_5904(title));
        if (subtitle != null && !subtitle.getString().isEmpty()) {
            player.field_13987.method_14364((class_2596)new class_5903(subtitle));
        }
    }

    @Override
    public void sendSubtitle(class_3222 player, class_2561 subtitle) {
        if (subtitle != null && !subtitle.getString().isEmpty()) {
            player.field_13987.method_14364((class_2596)new class_5903(subtitle));
        }
    }

    @Override
    public void sendActionBar(class_3222 player, class_2561 message) {
        player.field_13987.method_14364((class_2596)new class_5894(message));
    }

    private class_1259.class_1260 toMinecraftColor(IPlatformAdapter.BossBarColor color) {
        return class_1259.class_1260.valueOf((String)color.name());
    }

    private class_1259.class_1261 toMinecraftOverlay(IPlatformAdapter.BossBarOverlay overlay) {
        return class_1259.class_1261.valueOf((String)overlay.name());
    }

    @Override
    public void sendBossBar(List<class_3222> players, class_2561 message, int durationSeconds, IPlatformAdapter.BossBarColor color, float progress) {
        class_3213 bossEvent = new class_3213(message, this.toMinecraftColor(color), class_1259.class_1261.field_5795);
        bossEvent.method_5408(progress);
        players.forEach(arg_0 -> ((class_3213)bossEvent).method_14088(arg_0));
        this.taskScheduler.schedule(() -> {
            bossEvent.method_14094();
            bossEvent.method_14091(false);
        }, durationSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void showPersistentBossBar(class_3222 player, class_2561 message, IPlatformAdapter.BossBarColor color, IPlatformAdapter.BossBarOverlay overlay) {
        this.removePersistentBossBar(player);
        class_3213 bossEvent = new class_3213(message, this.toMinecraftColor(color), this.toMinecraftOverlay(overlay));
        bossEvent.method_14088(player);
        this.persistentBossBars.put(player.method_5667(), bossEvent);
    }

    @Override
    public void removePersistentBossBar(class_3222 player) {
        class_3213 bossBar = this.persistentBossBars.remove(player.method_5667());
        if (bossBar != null) {
            bossBar.method_14094();
        }
    }

    @Override
    public void createOrUpdateRestartBossBar(class_2561 message, IPlatformAdapter.BossBarColor color, float progress) {
        if (this.restartBossBar == null) {
            this.restartBossBar = new class_3213(message, this.toMinecraftColor(color), class_1259.class_1261.field_5795);
            this.restartBossBar.method_14091(true);
            this.getOnlinePlayers().forEach(arg_0 -> ((class_3213)this.restartBossBar).method_14088(arg_0));
        }
        this.restartBossBar.method_5413(message);
        this.restartBossBar.method_5408(progress);
    }

    @Override
    public void removeRestartBossBar() {
        if (this.restartBossBar != null) {
            this.restartBossBar.method_14091(false);
            this.restartBossBar.method_14094();
            this.restartBossBar = null;
        }
    }

    @Override
    public void clearTitles(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_5888(true));
    }

    @Override
    public void playSound(class_3222 player, String soundId, class_3419 category, float volume, float pitch) {
        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_63535(class_2960.method_60654((String)soundId));
        if (soundEvent != null) {
            player.field_13987.method_14364((class_2596)new class_2767(class_7923.field_41172.method_47983((Object)soundEvent), category, player.method_23317(), player.method_23318(), player.method_23321(), volume, pitch, player.method_51469().method_8409().method_43055()));
        }
    }

    @Override
    public void executeCommandAs(class_2168 source, String command) {
        this.getMinecraftServer().method_3734().method_44252(source, command);
    }

    @Override
    public void executeCommandAsConsole(String command) {
        if (this.server == null) {
            return;
        }
        class_2168 consoleSource = this.server.method_3739().method_9206(4);
        this.server.method_3734().method_44252(consoleSource, command);
    }

    @Override
    public String replacePlaceholders(String text, @Nullable class_3222 player) {
        return this.placeholders.replacePlaceholders(text, player);
    }

    @Override
    public boolean hasPermissionForCustomCommand(class_2168 source, CustomCommand command) {
        if (!command.isRequirePermission()) {
            return true;
        }
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            return true;
        }
        class_3222 player = (class_3222)class_12972;
        boolean hasPerm = this.permissionsHandler.hasPermission(player, command.getPermission());
        return hasPerm;
    }

    @Override
    public void shutdownServer(class_2561 kickMessage) {
        if (this.server != null) {
            try {
                this.debugLogger.debugLog("PlatformAdapter: Initiating server shutdown sequence.");
                this.server.method_3760().method_43514(kickMessage, false);
                this.server.method_39218(true, true, true);
                this.server.method_3747(false);
                this.taskScheduler.scheduleRaw(() -> {
                    this.debugLogger.debugLog("PlatformAdapter: Forcing JVM exit with status 1 to trigger auto-restart.");
                    System.exit(1);
                }, 500L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                this.debugLogger.debugLog("PlatformAdapter: Failed to shutdown server: " + e.getMessage(), e);
            }
        } else {
            this.debugLogger.debugLog("PlatformAdapter: Shutdown called but server instance is null.");
        }
    }

    @Override
    public void sendSuccess(class_2168 source, class_2561 message, boolean toOps) {
        source.method_9226(() -> message, toOps);
    }

    @Override
    public void sendFailure(class_2168 source, class_2561 message) {
        source.method_9213(message);
    }

    @Override
    public void teleportPlayer(class_3222 player, double x, double y, double z) {
        player.method_5859(x, y, z);
    }

    @Override
    public boolean playerHasItem(class_3222 player, String itemId, int amount) {
        if (player == null || itemId == null) {
            return false;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemId));
        if (item == class_1802.field_8162) {
            this.debugLogger.debugLog("PlatformAdapter: Could not find item with ID: " + itemId);
            return false;
        }
        return player.method_31548().method_18861(item) >= amount;
    }

    @Override
    public boolean isPlayerInArea(class_3222 player, String worldId, List<Integer> corner1, List<Integer> corner2) {
        if (player == null || worldId == null || corner1 == null || corner2 == null || corner1.size() != 3 || corner2.size() != 3) {
            return false;
        }
        class_2960 worldIdentifier = class_2960.method_60654((String)worldId);
        class_5321 targetWorldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldIdentifier);
        if (!player.method_51469().method_27983().equals(targetWorldKey)) {
            return false;
        }
        class_243 pos = player.method_19538();
        double pX = pos.method_10216();
        double pY = pos.method_10214();
        double pZ = pos.method_10215();
        double x1 = Math.min(corner1.get(0), corner2.get(0));
        double y1 = Math.min(corner1.get(1), corner2.get(1));
        double z1 = Math.min(corner1.get(2), corner2.get(2));
        double x2 = Math.max(corner1.get(0), corner2.get(0));
        double y2 = Math.max(corner1.get(1), corner2.get(1));
        double z2 = Math.max(corner1.get(2), corner2.get(2));
        return pX >= x1 && pX <= x2 && pY >= y1 && pY <= y2 && pZ >= z1 && pZ <= z2;
    }

    @Override
    public List<String> getOnlinePlayerNames() {
        return this.getOnlinePlayers().stream().map(this::getPlayerName).toList();
    }

    @Override
    public List<String> getWorldNames() {
        if (this.server == null) {
            return List.of();
        }
        ArrayList<String> worldNames = new ArrayList<String>();
        for (class_3218 world : this.server.method_3738()) {
            worldNames.add(world.method_27983().method_29177().toString());
        }
        return worldNames;
    }

    @Override
    public IPlayer wrapPlayer(class_3222 player) {
        return MinecraftPlayer.of(player);
    }

    @Override
    public IComponent createEmptyComponent() {
        return new MinecraftComponent(class_2561.method_43470((String)""));
    }

    @Override
    public IComponent parseFormattingCode(String code, IComponent currentComponent) {
        if (code == null || code.isEmpty()) {
            return currentComponent;
        }
        class_124 format = class_124.method_544((char)code.charAt(0));
        if (format != null) {
            if (format == class_124.field_1070) {
                return currentComponent.resetStyle();
            }
            return currentComponent.withFormatting(format);
        }
        return currentComponent;
    }

    @Override
    public IComponent parseHexColor(String hex, IComponent currentComponent) {
        if (hex == null || hex.length() != 6) {
            return currentComponent;
        }
        try {
            return currentComponent.withColor(hex);
        }
        catch (Exception e) {
            this.debugLogger.debugLog("Failed to parse hex color: " + hex, e);
            return currentComponent;
        }
    }

    @Override
    public IComponent wrap(class_2561 text) {
        if (text == null) {
            return this.createEmptyComponent();
        }
        if (text instanceof class_5250) {
            class_5250 mt = (class_5250)text;
            return new MinecraftComponent(mt);
        }
        return new MinecraftComponent(text);
    }

    @Override
    public IComponent createComponentFromLiteral(String text) {
        return new MinecraftComponent(class_2561.method_43470((String)(text != null ? text : "")));
    }

    @Override
    public String getMinecraftVersion() {
        return class_155.method_16673().comp_4025();
    }
}

