/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.data.Group;
import eu.avalanche7.paradigm.data.PlayerGroupData;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class GroupChatManager {
    private final Map<String, Group> groups = new HashMap<String, Group>();
    private final Map<UUID, PlayerGroupData> playerData = new HashMap<UUID, PlayerGroupData>();
    private final Map<String, Set<UUID>> pendingJoinRequests = new HashMap<String, Set<UUID>>();
    private final Map<UUID, Long> inviteCooldowns = new HashMap<UUID, Long>();
    private static final long INVITE_COOLDOWN_MS = 10000L;
    private Services services;

    private IPlatformAdapter platform() {
        return this.services.getPlatformAdapter();
    }

    public void setServices(Services services) {
        this.services = services;
    }

    private class_2561 translate(String key) {
        if (this.services != null && this.services.getLang() != null) {
            return this.services.getLang().translate(key);
        }
        if (this.services != null && this.services.getDebugLogger() != null) {
            this.services.getDebugLogger().debugLog("GroupChatManager: Services or Lang is null for key '{}'. Returning literal text.", key);
        }
        return class_2561.method_43470((String)key);
    }

    private class_2561 parseMessage(String message, class_3222 player) {
        if (this.services != null && this.services.getMessageParser() != null) {
            IPlayer iPlayer = player != null ? this.services.getPlatformAdapter().wrapPlayer(player) : null;
            return this.services.getMessageParser().parseMessage(message, iPlayer).getOriginalText();
        }
        if (this.services != null && this.services.getDebugLogger() != null) {
            this.services.getDebugLogger().debugLog("GroupChatManager: Services or MessageParser is null for message '{}'. Returning literal text.", message);
        }
        return class_2561.method_43470((String)message);
    }

    private MinecraftServer getServer() {
        return this.services != null ? this.services.getMinecraftServer() : null;
    }

    private void debugLog(String message) {
        if (this.services != null) {
            this.services.getDebugLogger().debugLog(message);
        }
    }

    public void broadcastToGroup(Group group, class_2561 message, UUID playerToExclude) {
        MinecraftServer server = this.getServer();
        if (server == null) {
            return;
        }
        group.getMembers().forEach(memberUUID -> {
            if (playerToExclude != null && playerToExclude.equals(memberUUID)) {
                return;
            }
            class_3222 member = server.method_3760().method_14602(memberUUID);
            if (member != null) {
                this.platform().sendSystemMessage(member, message);
            }
        });
    }

    public boolean createGroup(class_3222 player, String groupName) {
        if (groupName == null || groupName.trim().isEmpty() || groupName.length() > 16) {
            this.platform().sendSystemMessage(player, this.translate("group.invalid_name"));
            return false;
        }
        if (this.groups.containsKey(groupName)) {
            this.platform().sendSystemMessage(player, this.translate("group.already_exists"));
            return false;
        }
        Group group = new Group(groupName, player.method_5667());
        this.groups.put(groupName, group);
        this.getPlayerData(player).setCurrentGroup(groupName);
        this.platform().sendSystemMessage(player, this.translate("group.created_successfully"));
        this.debugLog("Player " + player.method_5477().getString() + " created group: " + groupName);
        return true;
    }

    public boolean deleteGroup(class_3222 player) {
        PlayerGroupData data = this.getPlayerData(player);
        String groupName = data.getCurrentGroup();
        if (groupName == null) {
            this.platform().sendSystemMessage(player, this.translate("group.no_group_to_delete"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(player.method_5667())) {
            this.platform().sendSystemMessage(player, this.translate("group.not_owner"));
            return false;
        }
        MinecraftServer server = this.getServer();
        String deletedMessageRaw = this.translate("group.group_deleted_by_owner").getString().replace("{group_name}", groupName);
        class_2561 deletedMessage = this.parseMessage(deletedMessageRaw, null);
        group.getMembers().forEach(memberUUID -> {
            class_3222 memberPlayer;
            PlayerGroupData memberData = this.playerData.get(memberUUID);
            if (memberData != null) {
                memberData.setCurrentGroup(null);
            }
            if (server != null && (memberPlayer = server.method_3760().method_14602(memberUUID)) != null && !memberPlayer.equals((Object)player)) {
                this.platform().sendSystemMessage(memberPlayer, deletedMessage);
            }
        });
        this.groups.remove(groupName);
        this.platform().sendSystemMessage(player, this.translate("group.deleted_successfully"));
        this.debugLog("Player " + player.method_5477().getString() + " deleted group: " + groupName);
        return true;
    }

    public void listGroups(class_3222 player) {
        if (this.groups.isEmpty()) {
            this.platform().sendSystemMessage(player, this.translate("group.no_groups_available"));
            return;
        }
        this.platform().sendSystemMessage(player, this.translate("group.available_groups"));
        MinecraftServer server = this.getServer();
        for (Map.Entry<String, Group> entry : this.groups.entrySet()) {
            class_3222 owner;
            String groupName = entry.getKey();
            Group group = entry.getValue();
            String ownerName = "Unknown";
            if (server != null && (owner = server.method_3760().method_14602(group.getOwner())) != null) {
                ownerName = owner.method_5477().getString();
            }
            int memberCount = group.getMembers().size();
            IComponent joinBtn = this.platform().createComponentFromLiteral("[Join]").onClickSuggestCommand("/groupchat join " + groupName).onHoverText("Click to request join");
            class_5250 line = class_2561.method_43470((String)("\u00a7e" + groupName + " \u00a77(" + memberCount + " members, owner: " + ownerName + ") ")).method_10852(joinBtn.getOriginalText());
            this.platform().sendSystemMessage(player, (class_2561)line);
        }
    }

    public void groupInfo(class_3222 player, String groupName) {
        class_3222 owner;
        Group group = this.groups.get(groupName);
        if (group == null) {
            this.platform().sendSystemMessage(player, this.translate("group.group_not_found"));
            return;
        }
        this.platform().sendSystemMessage(player, this.parseMessage("&6Group Information: &e" + groupName, player));
        String ownerName = "Offline";
        MinecraftServer server = this.getServer();
        if (server != null && (owner = server.method_3760().method_14602(group.getOwner())) != null) {
            ownerName = owner.method_5477().getString();
        }
        this.platform().sendSystemMessage(player, this.parseMessage("&7Owner: &f" + ownerName, player));
        this.platform().sendSystemMessage(player, this.parseMessage("&7Members (" + group.getMembers().size() + "):", player));
        group.getMembers().forEach(memberUUID -> {
            class_3222 member;
            String memberName = "Offline";
            if (server != null && (member = server.method_3760().method_14602(memberUUID)) != null) {
                memberName = member.method_5477().getString();
            }
            this.platform().sendSystemMessage(player, (class_2561)class_2561.method_43470((String)("- " + memberName)));
        });
    }

    public boolean invitePlayer(class_3222 inviter, class_3222 target) {
        long now = System.currentTimeMillis();
        Long last = this.inviteCooldowns.get(inviter.method_5667());
        if (last != null && now - last < 10000L) {
            long wait = (10000L - (now - last) + 999L) / 1000L;
            this.platform().sendSystemMessage(inviter, (class_2561)class_2561.method_43470((String)("\u00a7cPlease wait " + wait + "s before sending another invite.")));
            return false;
        }
        this.inviteCooldowns.put(inviter.method_5667(), now);
        String groupName = this.getPlayerData(inviter).getCurrentGroup();
        if (groupName == null) {
            this.platform().sendSystemMessage(inviter, this.translate("group.no_group_to_invite_from"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(inviter.method_5667())) {
            this.platform().sendSystemMessage(inviter, this.translate("group.not_owner_invite"));
            return false;
        }
        if (group.getMembers().contains(target.method_5667())) {
            String alreadyRaw = this.translate("group.player_already_in_group").getString().replace("{player_name}", target.method_5477().getString());
            this.platform().sendSystemMessage(inviter, this.parseMessage(alreadyRaw, inviter));
            return false;
        }
        this.getPlayerData(target).addInvitation(groupName);
        String inviteSentRaw = this.translate("group.invite_sent").getString().replace("{player_name}", target.method_5477().getString());
        this.platform().sendSystemMessage(inviter, this.parseMessage(inviteSentRaw, inviter));
        class_5250 base = class_2561.method_43470((String)("\u00a7eYou have been invited to join group \u00a7b" + groupName + "\u00a7e by \u00a7a" + inviter.method_5477().getString() + " \u00a78["));
        IComponent accept = this.platform().createComponentFromLiteral("\u00a7aACCEPT").onClickRunCommand("/groupchat accept " + groupName).onHoverText("Click to accept");
        IComponent deny = this.platform().createComponentFromLiteral("\u00a7cDENY").onClickRunCommand("/groupchat deny " + groupName).onHoverText("Click to deny");
        this.platform().sendSystemMessage(target, (class_2561)base.method_10852(accept.getOriginalText()).method_10852((class_2561)class_2561.method_43470((String)"\u00a78 | ")).method_10852(deny.getOriginalText()).method_10852((class_2561)class_2561.method_43470((String)"\u00a78]")));
        this.debugLog("Player " + inviter.method_5477().getString() + " invited " + target.method_5477().getString() + " to group: " + groupName);
        return true;
    }

    public boolean joinGroup(class_3222 player, String groupName) {
        PlayerGroupData playerData = this.getPlayerData(player);
        if (!playerData.getInvitations().contains(groupName)) {
            this.platform().sendSystemMessage(player, this.translate("group.no_invite_or_not_exists"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (group == null) {
            this.platform().sendSystemMessage(player, this.translate("group.group_not_found"));
            playerData.removeInvitation(groupName);
            return false;
        }
        this.leaveGroup(player, true);
        group.addMember(player.method_5667());
        playerData.setCurrentGroup(groupName);
        playerData.removeInvitation(groupName);
        String joinedRaw = this.translate("group.joined").getString().replace("{group_name}", groupName);
        this.platform().sendSystemMessage(player, this.parseMessage(joinedRaw, player));
        String joinedNotificationRaw = this.translate("group.player_joined_notification").getString().replace("{player_name}", player.method_5477().getString());
        this.broadcastToGroup(group, this.parseMessage(joinedNotificationRaw, null), player.method_5667());
        this.debugLog("Player " + player.method_5477().getString() + " joined group: " + groupName);
        return true;
    }

    public boolean leaveGroup(class_3222 player) {
        return this.leaveGroup(player, false);
    }

    public boolean leaveGroup(class_3222 player, boolean isJoiningAnother) {
        PlayerGroupData data = this.getPlayerData(player);
        String groupName = data.getCurrentGroup();
        if (groupName == null) {
            if (!isJoiningAnother) {
                this.platform().sendSystemMessage(player, this.translate("group.no_group_to_leave"));
            }
            return false;
        }
        Group group = this.groups.get(groupName);
        if (group == null) {
            data.setCurrentGroup(null);
            return false;
        }
        group.removeMember(player.method_5667());
        data.setCurrentGroup(null);
        if (!isJoiningAnother) {
            String leftRaw = this.translate("group.left").getString().replace("{group_name}", groupName);
            this.platform().sendSystemMessage(player, this.parseMessage(leftRaw, player));
        }
        String leftNotificationRaw = this.translate("group.player_left_notification").getString().replace("{player_name}", player.method_5477().getString());
        this.broadcastToGroup(group, this.parseMessage(leftNotificationRaw, null), null);
        if (group.getMembers().isEmpty()) {
            this.groups.remove(groupName);
            this.debugLog("Group " + groupName + " disbanded as last member left.");
        } else if (group.getOwner().equals(player.method_5667())) {
            class_3222 newOwnerPlayer;
            UUID newOwnerUUID = group.getMembers().stream().findFirst().orElse(null);
            group.setOwner(newOwnerUUID);
            class_3222 class_32222 = newOwnerPlayer = newOwnerUUID != null && this.getServer() != null ? this.getServer().method_3760().method_14602(newOwnerUUID) : null;
            if (newOwnerPlayer != null) {
                this.platform().sendSystemMessage(newOwnerPlayer, this.translate("group.new_owner_notification"));
                this.debugLog("Ownership of group " + groupName + " transferred to " + newOwnerPlayer.method_5477().getString());
            }
        }
        this.debugLog("Player " + player.method_5477().getString() + " left group: " + groupName);
        return true;
    }

    private boolean internalJoinGroup(class_3222 player, String groupName) {
        PlayerGroupData playerData = this.getPlayerData(player);
        Group group = this.groups.get(groupName);
        if (group == null) {
            this.platform().sendSystemMessage(player, this.translate("group.group_not_found"));
            return false;
        }
        if (playerData.getCurrentGroup() != null && !playerData.getCurrentGroup().equals(groupName)) {
            this.leaveGroup(player, true);
        }
        group.addMember(player.method_5667());
        playerData.setCurrentGroup(groupName);
        playerData.removeInvitation(groupName);
        String joinedRaw = this.translate("group.joined").getString().replace("{group_name}", groupName);
        this.platform().sendSystemMessage(player, this.parseMessage(joinedRaw, player));
        String joinedNotificationRaw = this.translate("group.player_joined_notification").getString().replace("{player_name}", player.method_5477().getString());
        this.broadcastToGroup(group, this.parseMessage(joinedNotificationRaw, null), player.method_5667());
        this.debugLog("Player " + player.method_5477().getString() + " joined group: " + groupName);
        return true;
    }

    public boolean kickMember(class_3222 owner, String targetName) {
        PlayerGroupData data = this.getPlayerData(owner);
        String groupName = data.getCurrentGroup();
        if (groupName == null) {
            this.platform().sendSystemMessage(owner, this.translate("group.no_group_to_manage_requests"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(owner.method_5667())) {
            this.platform().sendSystemMessage(owner, this.translate("group.not_owner"));
            return false;
        }
        MinecraftServer server = this.getServer();
        if (server == null) {
            this.platform().sendSystemMessage(owner, (class_2561)class_2561.method_43470((String)"Server not available."));
            return false;
        }
        class_3222 target = server.method_3760().method_14566(targetName);
        if (target == null) {
            this.platform().sendSystemMessage(owner, this.translate("group.kick_not_found"));
            return false;
        }
        if (!group.getMembers().contains(target.method_5667())) {
            this.platform().sendSystemMessage(owner, this.translate("group.kick_not_member"));
            return false;
        }
        if (target.method_5667().equals(owner.method_5667())) {
            this.platform().sendSystemMessage(owner, this.translate("group.kick_cannot_self"));
            return false;
        }
        group.removeMember(target.method_5667());
        this.getPlayerData(target).setCurrentGroup(null);
        String tMsg = this.translate("group.kick_success_target").getString().replace("{group_name}", groupName);
        this.platform().sendSystemMessage(target, (class_2561)class_2561.method_43470((String)tMsg));
        String oMsg = this.translate("group.kick_success_owner").getString().replace("{player_name}", target.method_5477().getString());
        this.platform().sendSystemMessage(owner, (class_2561)class_2561.method_43470((String)oMsg));
        String nMsg = this.translate("group.kick_success_notify").getString().replace("{player_name}", target.method_5477().getString());
        this.broadcastToGroup(group, (class_2561)class_2561.method_43470((String)nMsg), owner.method_5667());
        if (group.getMembers().isEmpty()) {
            this.groups.remove(groupName);
            this.debugLog("Group " + groupName + " disbanded as last member was kicked.");
        }
        this.debugLog("Player " + target.method_5477().getString() + " was kicked from group: " + groupName + " by owner " + owner.method_5477().getString());
        return true;
    }

    public PlayerGroupData getPlayerData(class_3222 player) {
        return this.playerData.computeIfAbsent(player.method_5667(), k -> new PlayerGroupData());
    }

    public void clearAllGroupsAndPlayerData() {
        this.groups.clear();
        this.playerData.clear();
        this.pendingJoinRequests.clear();
        this.inviteCooldowns.clear();
        this.debugLog("All group chat data cleared.");
    }

    public boolean acceptInvite(class_3222 player, String groupName) {
        PlayerGroupData data = this.getPlayerData(player);
        if (!data.getInvitations().contains(groupName)) {
            this.platform().sendSystemMessage(player, this.translate("group.not_invited"));
            return false;
        }
        data.removeInvitation(groupName);
        return this.internalJoinGroup(player, groupName);
    }

    public boolean denyInvite(class_3222 player, String groupName) {
        PlayerGroupData data = this.getPlayerData(player);
        if (!data.getInvitations().contains(groupName)) {
            this.platform().sendSystemMessage(player, this.translate("group.not_invited"));
            return false;
        }
        data.removeInvitation(groupName);
        this.platform().sendSystemMessage(player, this.translate("group.invite_denied"));
        return true;
    }

    public void requestJoinGroup(class_3222 player, String groupName) {
        class_3222 owner;
        if (!this.groups.containsKey(groupName)) {
            this.platform().sendSystemMessage(player, this.translate("group.group_not_found"));
            return;
        }
        Group group = this.groups.get(groupName);
        UUID playerUUID = player.method_5667();
        if (group.getMembers().contains(playerUUID)) {
            this.platform().sendSystemMessage(player, this.parseMessage("&7You are already in group &f" + groupName, player));
            return;
        }
        if (this.getPlayerData(player).getInvitations().contains(groupName)) {
            this.platform().sendSystemMessage(player, this.parseMessage("&7You already have an invite to &e" + groupName + "&7. Use &a/groupchat accept " + groupName, player));
            return;
        }
        this.pendingJoinRequests.computeIfAbsent(groupName, k -> new HashSet()).add(playerUUID);
        this.platform().sendSystemMessage(player, this.translate("group.join_request_sent"));
        class_5250 reqMsg = class_2561.method_43470((String)("\u00a7eYou have a pending join request to \u00a7b" + groupName + " \u00a78["));
        IComponent cancel = this.platform().createComponentFromLiteral("\u00a76CANCEL").onClickRunCommand("/groupchat cancelreq " + groupName).onHoverText("Click to cancel request");
        this.platform().sendSystemMessage(player, (class_2561)reqMsg.method_10852(cancel.getOriginalText()).method_10852((class_2561)class_2561.method_43470((String)"\u00a78]")));
        MinecraftServer server = this.getServer();
        if (server != null && (owner = server.method_3760().method_14602(group.getOwner())) != null) {
            class_5250 ownerMsg = class_2561.method_43470((String)("\u00a7e" + player.method_5477().getString() + " wants to join \u00a7b" + groupName + " \u00a78["));
            IComponent acc = this.platform().createComponentFromLiteral("\u00a7aACCEPT").onClickRunCommand("/groupchat acceptreq " + player.method_5477().getString()).onHoverText("Click to accept");
            IComponent dny = this.platform().createComponentFromLiteral("\u00a7cDENY").onClickRunCommand("/groupchat denyreq " + player.method_5477().getString()).onHoverText("Click to deny");
            this.platform().sendSystemMessage(owner, (class_2561)ownerMsg.method_10852(acc.getOriginalText()).method_10852((class_2561)class_2561.method_43470((String)"\u00a78 | ")).method_10852(dny.getOriginalText()).method_10852((class_2561)class_2561.method_43470((String)"\u00a78]")));
        }
    }

    public boolean acceptJoinRequest(class_3222 owner, String playerName) {
        String groupName = this.getPlayerData(owner).getCurrentGroup();
        if (groupName == null) {
            this.platform().sendSystemMessage(owner, this.translate("group.no_group_to_manage_requests"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(owner.method_5667())) {
            this.platform().sendSystemMessage(owner, this.translate("group.not_owner"));
            return false;
        }
        MinecraftServer server = this.getServer();
        if (server == null) {
            this.platform().sendSystemMessage(owner, this.translate("group.request_player_offline"));
            return false;
        }
        class_3222 target = server.method_3760().method_14566(playerName);
        if (target == null) {
            this.platform().sendSystemMessage(owner, this.translate("group.request_player_offline"));
            return false;
        }
        Set reqs = this.pendingJoinRequests.getOrDefault(groupName, Collections.emptySet());
        if (!reqs.contains(target.method_5667())) {
            this.platform().sendSystemMessage(owner, this.translate("group.no_pending_request"));
            return false;
        }
        reqs.remove(target.method_5667());
        boolean ok = this.internalJoinGroup(target, groupName);
        if (ok) {
            this.platform().sendSystemMessage(owner, this.translate("group.request_accepted_owner"));
            this.platform().sendSystemMessage(target, this.translate("group.request_accepted_player"));
        }
        return ok;
    }

    public boolean denyJoinRequest(class_3222 owner, String playerName) {
        String groupName = this.getPlayerData(owner).getCurrentGroup();
        if (groupName == null) {
            this.platform().sendSystemMessage(owner, this.translate("group.no_group_to_manage_requests"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(owner.method_5667())) {
            this.platform().sendSystemMessage(owner, this.translate("group.not_owner"));
            return false;
        }
        MinecraftServer server = this.getServer();
        if (server == null) {
            this.platform().sendSystemMessage(owner, this.translate("group.request_player_offline"));
            return false;
        }
        class_3222 target = server.method_3760().method_14566(playerName);
        if (target == null) {
            this.platform().sendSystemMessage(owner, this.translate("group.request_player_offline"));
            return false;
        }
        Set reqs = this.pendingJoinRequests.getOrDefault(groupName, Collections.emptySet());
        if (!reqs.remove(target.method_5667())) {
            this.platform().sendSystemMessage(owner, this.translate("group.no_pending_request"));
            return false;
        }
        this.platform().sendSystemMessage(owner, this.translate("group.request_denied_owner"));
        this.platform().sendSystemMessage(target, this.translate("group.request_denied_player"));
        return true;
    }

    public void listJoinRequests(class_3222 owner) {
        String groupName = this.getPlayerData(owner).getCurrentGroup();
        if (groupName == null) {
            this.platform().sendSystemMessage(owner, this.translate("group.no_group_to_manage_requests"));
            return;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(owner.method_5667())) {
            this.platform().sendSystemMessage(owner, this.translate("group.not_owner"));
            return;
        }
        Set reqs = this.pendingJoinRequests.getOrDefault(groupName, Collections.emptySet());
        if (reqs.isEmpty()) {
            this.platform().sendSystemMessage(owner, this.translate("group.no_pending_request"));
            return;
        }
        this.platform().sendSystemMessage(owner, this.parseMessage("&6Pending join requests:", owner));
        MinecraftServer server = this.getServer();
        for (UUID uuid : reqs) {
            class_3222 p;
            String name = uuid.toString();
            if (server != null && (p = server.method_3760().method_14602(uuid)) != null) {
                name = p.method_5477().getString();
            }
            String pName = name;
            class_5250 line = class_2561.method_43470((String)("\u00a77- \u00a7f" + pName + " \u00a78["));
            IComponent acc = this.platform().createComponentFromLiteral("\u00a7aACCEPT").onClickRunCommand("/groupchat acceptreq " + pName).onHoverText("Click to accept");
            IComponent dny = this.platform().createComponentFromLiteral("\u00a7cDENY").onClickRunCommand("/groupchat denyreq " + pName).onHoverText("Click to deny");
            this.platform().sendSystemMessage(owner, (class_2561)line.method_10852(acc.getOriginalText()).method_10852((class_2561)class_2561.method_43470((String)"\u00a78 | ")).method_10852(dny.getOriginalText()).method_10852((class_2561)class_2561.method_43470((String)"\u00a78]")));
        }
    }

    public void toggleGroupChat(class_3222 player) {
        PlayerGroupData data = this.getPlayerData(player);
        if (!data.isGroupChatToggled() && data.getCurrentGroup() == null) {
            this.platform().sendSystemMessage(player, this.translate("group.must_be_in_group_to_toggle"));
            return;
        }
        data.setGroupChatToggled(!data.isGroupChatToggled());
        this.platform().sendSystemMessage(player, data.isGroupChatToggled() ? this.translate("group.chat_enabled") : this.translate("group.chat_disabled"));
    }

    public boolean isGroupChatToggled(class_3222 player) {
        return this.getPlayerData(player).isGroupChatToggled();
    }

    public void setGroupChatToggled(class_3222 player, boolean toggled) {
        this.getPlayerData(player).setGroupChatToggled(toggled);
    }

    public boolean sendMessageToGroup(class_3222 sender, String groupName, String messageContent) {
        Group group = this.groups.get(groupName);
        if (group == null || !group.getMembers().contains(sender.method_5667())) {
            this.platform().sendSystemMessage(sender, this.translate("group.not_in_group_or_not_exists"));
            return false;
        }
        String preFormatted = String.format("&9[Group: %s] &r%s &7> &f%s", groupName, sender.method_5477().getString(), messageContent);
        class_2561 finalMessage = this.parseMessage(preFormatted, sender);
        this.broadcastToGroup(group, finalMessage, null);
        return true;
    }

    public void sendMessageFromCommand(class_3222 sender, String messageContent) {
        String groupName = this.getPlayerData(sender).getCurrentGroup();
        if (groupName == null) {
            this.platform().sendSystemMessage(sender, this.translate("group.no_group_to_send_message"));
            return;
        }
        this.sendMessageToGroup(sender, groupName, messageContent);
    }
}

