/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.utils.Placeholders;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5251;

public class MessageParser {
    private final Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private final Pattern urlPattern = Pattern.compile("https?://\\S+");
    private final Map<Pattern, BiConsumer<Matcher, TagContext>> tagHandlers;
    private final Placeholders placeholders;
    private final IPlatformAdapter platformAdapter;

    public MessageParser(Placeholders placeholders, IPlatformAdapter platformAdapter) {
        this.placeholders = placeholders;
        this.platformAdapter = platformAdapter;
        this.tagHandlers = new LinkedHashMap<Pattern, BiConsumer<Matcher, TagContext>>();
        this.initializeTagHandlers();
    }

    private void initializeTagHandlers() {
        this.tagHandlers.put(Pattern.compile("\\[link=(.*?)]"), (matcher, context) -> {
            String url = matcher.group(1);
            String formattedUrl = this.formatUrl(url);
            IComponent clickable = this.platformAdapter.createComponentFromLiteral(url).withStyle(context.getCurrentStyle()).onClickOpenUrl(formattedUrl);
            context.getText().append(clickable);
            context.getText().append(this.platformAdapter.createComponentFromLiteral(" ").withStyle(context.getCurrentStyle()));
        });
        this.tagHandlers.put(Pattern.compile("\\[command=(.*?)]"), (matcher, context) -> {
            String command = matcher.group(1);
            Object fullCommand = command.startsWith("/") ? command : "/" + command;
            IComponent clickable = this.platformAdapter.createComponentFromLiteral((String)fullCommand).withStyle(context.getCurrentStyle()).onClickRunCommand((String)fullCommand);
            context.getText().append(clickable);
            context.getText().append(this.platformAdapter.createComponentFromLiteral(" ").withStyle(context.getCurrentStyle()));
        });
        this.tagHandlers.put(Pattern.compile("\\[hover=(.*?)](.*?)\\[/hover]", 32), (matcher, context) -> {
            String hoverTextContent = matcher.group(1);
            String mainTextContent = matcher.group(2);
            IComponent hoverComponent = this.parseMessageInternal(this.mainTextContentOf(hoverTextContent), context.getPlayer(), class_2583.field_24360);
            IComponent textWithHover = this.platformAdapter.createEmptyComponent();
            this.parseTextRecursive(mainTextContent, textWithHover, context.getCurrentStyle(), context.getPlayer());
            IComponent hovered = textWithHover.onHoverComponent(hoverComponent);
            context.getText().append(hovered);
        });
        this.tagHandlers.put(Pattern.compile("\\[divider]"), (matcher, context) -> {
            IComponent divider = this.platformAdapter.createComponentFromLiteral("--------------------").withStyle(context.getCurrentStyle()).withFormatting(class_124.field_1080);
            context.getText().append(divider);
        });
        this.tagHandlers.put(Pattern.compile("\\[title=(.*?)]", 32), (matcher, context) -> {
            class_3222 sp = context.getOriginalPlayer();
            if (sp != null) {
                String titleText = matcher.group(1);
                IComponent titleComponent = this.parseMessageInternal(titleText, context.getPlayer(), context.getCurrentStyle());
                this.platformAdapter.clearTitles(sp);
                this.platformAdapter.sendTitle(sp, titleComponent.getOriginalText(), this.platformAdapter.createComponentFromLiteral("").getOriginalText());
            }
        });
        this.tagHandlers.put(Pattern.compile("\\[subtitle=(.*?)]", 32), (matcher, context) -> {
            class_3222 sp = context.getOriginalPlayer();
            if (sp != null) {
                String subtitleText = matcher.group(1);
                IComponent subtitleComponent = this.parseMessageInternal(subtitleText, context.getPlayer(), context.getCurrentStyle());
                this.platformAdapter.sendSubtitle(sp, subtitleComponent.getOriginalText());
            }
        });
        this.tagHandlers.put(Pattern.compile("\\[center](.*?)\\[/center]", 32), (matcher, context) -> {
            int totalPadding;
            int leftPadding;
            String textToCenter = matcher.group(1);
            IComponent innerComponent = this.parseMessageInternal(textToCenter, context.getPlayer(), context.getCurrentStyle());
            String plainInnerText = innerComponent.getRawText();
            int approximateChatWidthChars = 53;
            String paddingSpaces = "";
            int textLength = plainInnerText.length();
            if (textLength < approximateChatWidthChars && (leftPadding = (totalPadding = approximateChatWidthChars - textLength) / 2) > 0) {
                paddingSpaces = " ".repeat(leftPadding);
            }
            if (!paddingSpaces.isEmpty()) {
                context.getText().append(this.platformAdapter.createComponentFromLiteral(paddingSpaces).withStyle(context.getCurrentStyle()));
            }
            context.getText().append(innerComponent);
        });
    }

    public IComponent parseMessage(String rawMessage, IPlayer player) {
        return this.parseMessageInternal(rawMessage, player, class_2583.field_24360);
    }

    private IComponent parseMessageInternal(String rawMessage, IPlayer player, class_2583 initialStyle) {
        if (rawMessage == null) {
            return this.platformAdapter.createComponentFromLiteral("").withStyle(initialStyle);
        }
        String processedMessage = this.placeholders.replacePlaceholders(rawMessage, player != null ? player.getOriginalPlayer() : null);
        Matcher hexMatcher = this.hexPattern.matcher(processedMessage);
        StringBuilder sb = new StringBuilder();
        while (hexMatcher.find()) {
            String hexColor = hexMatcher.group(1);
            hexMatcher.appendReplacement(sb, "\u00a7#" + hexColor);
        }
        hexMatcher.appendTail(sb);
        processedMessage = sb.toString();
        String messageForParsing = processedMessage.replace("&", "\u00a7");
        IComponent rootComponent = this.platformAdapter.createEmptyComponent();
        this.parseTextRecursive(messageForParsing, rootComponent, initialStyle, player);
        return rootComponent;
    }

    private void parseTextRecursive(String textToParse, IComponent parentComponent, class_2583 currentStyle, IPlayer player) {
        int currentIndex = 0;
        int length = textToParse.length();
        Matcher urlMatcher = this.urlPattern.matcher(textToParse);
        while (currentIndex < length) {
            int nextLegacyFormat = textToParse.indexOf(167, currentIndex);
            int nextTagStart = textToParse.indexOf(91, currentIndex);
            boolean nextUrlFound = urlMatcher.find(currentIndex);
            int nextUrlStart = nextUrlFound ? urlMatcher.start() : -1;
            int firstEventIndex = length;
            if (nextLegacyFormat != -1) {
                firstEventIndex = Math.min(firstEventIndex, nextLegacyFormat);
            }
            if (nextTagStart != -1) {
                firstEventIndex = Math.min(firstEventIndex, nextTagStart);
            }
            if (nextUrlFound) {
                firstEventIndex = Math.min(firstEventIndex, nextUrlStart);
            }
            if (firstEventIndex > currentIndex) {
                String plain = textToParse.substring(currentIndex, firstEventIndex);
                parentComponent.append(this.platformAdapter.createComponentFromLiteral(plain).withStyle(currentStyle));
            }
            if ((currentIndex = firstEventIndex) == length) break;
            if (nextLegacyFormat == currentIndex) {
                if (currentIndex + 1 < length) {
                    char formatChar = textToParse.charAt(currentIndex + 1);
                    if (formatChar == '#') {
                        if (currentIndex + 7 < length) {
                            String hex = textToParse.substring(currentIndex + 2, currentIndex + 8);
                            try {
                                currentStyle = currentStyle.method_27703((class_5251)class_5251.method_27719((String)("#" + hex)).getOrThrow());
                                currentIndex += 8;
                            }
                            catch (Exception e) {
                                parentComponent.append(this.platformAdapter.createComponentFromLiteral(textToParse.substring(currentIndex, currentIndex + 2)).withStyle(currentStyle));
                                currentIndex += 2;
                            }
                            continue;
                        }
                        parentComponent.append(this.platformAdapter.createComponentFromLiteral(textToParse.substring(currentIndex, currentIndex + 1)).withStyle(currentStyle));
                        ++currentIndex;
                        continue;
                    }
                    class_124 format = class_124.method_544((char)formatChar);
                    if (format != null) {
                        currentStyle = currentStyle.method_27706(format);
                        if (format == class_124.field_1070) {
                            currentStyle = class_2583.field_24360;
                        }
                    } else {
                        parentComponent.append(this.platformAdapter.createComponentFromLiteral("\u00a7").withStyle(currentStyle));
                    }
                    currentIndex += 2;
                    continue;
                }
                parentComponent.append(this.platformAdapter.createComponentFromLiteral("\u00a7").withStyle(currentStyle));
                ++currentIndex;
                continue;
            }
            if (nextTagStart == currentIndex) {
                boolean tagHandled = false;
                for (Map.Entry<Pattern, BiConsumer<Matcher, TagContext>> entry : this.tagHandlers.entrySet()) {
                    Pattern tagPattern = entry.getKey();
                    Matcher tagMatcher = tagPattern.matcher(textToParse);
                    if (!tagMatcher.find(currentIndex) || tagMatcher.start() != currentIndex) continue;
                    TagContext context = new TagContext(parentComponent, currentStyle, player);
                    entry.getValue().accept(tagMatcher, context);
                    currentIndex = tagMatcher.end();
                    tagHandled = true;
                    break;
                }
                if (tagHandled) continue;
                parentComponent.append(this.platformAdapter.createComponentFromLiteral("[").withStyle(currentStyle));
                ++currentIndex;
                continue;
            }
            if (nextUrlFound && nextUrlStart == currentIndex) {
                String url = urlMatcher.group(0);
                String formattedUrl = this.formatUrl(url);
                IComponent urlComp = this.platformAdapter.createComponentFromLiteral(url).withStyle(currentStyle).onClickOpenUrl(formattedUrl);
                parentComponent.append(urlComp);
                currentIndex = urlMatcher.end();
                continue;
            }
            if (currentIndex >= length) continue;
            parentComponent.append(this.platformAdapter.createComponentFromLiteral(textToParse.substring(currentIndex, currentIndex + 1)).withStyle(currentStyle));
            ++currentIndex;
        }
    }

    private String formatUrl(String url) {
        if (url != null && !url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
            return "https://" + url;
        }
        return url;
    }

    private String mainTextContentOf(String s) {
        return s == null ? "" : s;
    }

    private static class TagContext {
        private final IComponent text;
        private final class_2583 currentStyle;
        private final IPlayer player;

        TagContext(IComponent text, class_2583 style, IPlayer player) {
            this.text = text;
            this.currentStyle = style;
            this.player = player;
        }

        public IComponent getText() {
            return this.text;
        }

        public class_2583 getCurrentStyle() {
            return this.currentStyle;
        }

        public IPlayer getPlayer() {
            return this.player;
        }

        public class_3222 getOriginalPlayer() {
            return this.player != null ? this.player.getOriginalPlayer() : null;
        }
    }
}

