/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.JsonValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class CMConfig {
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Path configFolderPath = Path.of("config", "paradigm", "commands");
    private List<CustomCommand> loadedCommands = new ArrayList<CustomCommand>();
    private final DebugLogger debugLogger;
    private final JsonValidator jsonValidator;

    public CMConfig(DebugLogger debugLogger) {
        this.debugLogger = debugLogger;
        this.jsonValidator = new JsonValidator(debugLogger);
    }

    public void loadCommands() {
        block18: {
            this.loadedCommands.clear();
            try {
                Stream<Path> stream;
                Files.createDirectories(this.configFolderPath, new FileAttribute[0]);
                boolean isEmpty = true;
                if (Files.exists(this.configFolderPath, new LinkOption[0]) && Files.isDirectory(this.configFolderPath, new LinkOption[0])) {
                    stream = Files.list(this.configFolderPath);
                    try {
                        isEmpty = stream.noneMatch(p -> p.toString().endsWith(".json"));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                if (isEmpty) {
                    this.debugLogger.debugLog("CMConfig: No command files found in " + this.configFolderPath + ". Generating example commands.");
                    this.generateDefaultConfig();
                    break block18;
                }
                stream = Files.list(this.configFolderPath);
                try {
                    stream.filter(path -> path.toString().endsWith(".json")).forEach(file -> {
                        block16: {
                            try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                                int c;
                                StringBuilder content = new StringBuilder();
                                while ((c = ((Reader)reader).read()) != -1) {
                                    content.append((char)c);
                                }
                                JsonValidator.ValidationResult result = this.jsonValidator.validateAndFix(content.toString());
                                if (result.isValid()) {
                                    if (result.hasIssues()) {
                                        this.debugLogger.debugLog("CMConfig: Fixed JSON syntax issues in " + file.getFileName() + ": " + result.getIssuesSummary());
                                        this.debugLogger.debugLog("CMConfig: Using fixed version in memory, original file unchanged");
                                    }
                                    try {
                                        CustomCommand[] commands = (CustomCommand[])this.gson.fromJson(result.getFixedJson(), CustomCommand[].class);
                                        if (commands != null) {
                                            for (CustomCommand command : commands) {
                                                if (command != null && command.getName() != null && !command.getName().trim().isEmpty()) {
                                                    this.loadedCommands.add(command);
                                                    continue;
                                                }
                                                this.debugLogger.debugLog("CMConfig: Skipped a null or invalid command entry in file: " + file.getFileName());
                                            }
                                            this.debugLogger.debugLog("CMConfig: Loaded commands from file: " + file.getFileName());
                                            break block16;
                                        }
                                        this.debugLogger.debugLog("CMConfig: No commands found in file: " + file.getFileName());
                                    }
                                    catch (Exception parseError) {
                                        this.debugLogger.debugLog("CMConfig: Failed to parse fixed JSON from " + file.getFileName() + ": " + parseError.getMessage());
                                    }
                                    break block16;
                                }
                                this.debugLogger.debugLog("CMConfig: Unable to fix JSON syntax errors in " + file.getFileName() + ": " + result.getMessage());
                                this.debugLogger.debugLog("CMConfig: Skipping file - please fix syntax manually");
                            }
                            catch (IOException e) {
                                this.debugLogger.debugLog("CMConfig: Failed to read file: " + file.getFileName(), e);
                            }
                        }
                    });
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
                if (this.loadedCommands.isEmpty() && !isEmpty) {
                    this.debugLogger.debugLog("CMConfig: No valid commands loaded from existing files. Consider checking their format or generating defaults.");
                }
            }
            catch (IOException e) {
                this.debugLogger.debugLog("CMConfig: Failed to read commands configuration folder.", e);
            }
        }
    }

    public void saveCommands() {
        try {
            Files.createDirectories(this.configFolderPath, new FileAttribute[0]);
            Path exampleFile = this.configFolderPath.resolve("example.json");
            try (BufferedWriter writer = Files.newBufferedWriter(exampleFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                this.gson.toJson(this.loadedCommands, (Appendable)writer);
                this.debugLogger.debugLog("CMConfig: Commands configuration saved successfully to example.json.");
            }
        }
        catch (IOException e) {
            this.debugLogger.debugLog("CMConfig: Failed to save commands configuration.", e);
        }
    }

    private void generateDefaultConfig() {
        ArrayList<CustomCommand> defaultCommands = new ArrayList<CustomCommand>();
        ArrayList<CustomCommand.Action> actions1 = new ArrayList<CustomCommand.Action>();
        List<String> welcomeText = List.of("&aHello &6{player}! &bWelcome to the server!", "&aEnjoy your stay and check out our rules.");
        actions1.add(new CustomCommand.Action("message", welcomeText, null, null, null, null, null, null, null));
        defaultCommands.add(new CustomCommand("example", "Sends a greeting to the player.", "example.custom.permissions", false, null, actions1));
        ArrayList<CustomCommand.Action> actions2 = new ArrayList<CustomCommand.Action>();
        actions2.add(new CustomCommand.Action("teleport", null, 100, 64, 100, null, null, null, null));
        List<String> spawnText = List.of("&aYou have been teleported to spawn!");
        actions2.add(new CustomCommand.Action("message", spawnText, null, null, null, null, null, null, null));
        defaultCommands.add(new CustomCommand("example2", "Teleports the player to spawn.", "example2.custom.permissions", false, null, actions2));
        ArrayList<CustomCommand.Action> actions3 = new ArrayList<CustomCommand.Action>();
        List<String> cmds = List.of("say Hello world!", "give @p minecraft:diamond 1");
        actions3.add(new CustomCommand.Action("runcmd", null, null, null, null, cmds, null, null, null));
        defaultCommands.add(new CustomCommand("example3", "Runs multiple commands for admins.", "example3.custom.permissions", true, null, actions3));
        ArrayList<CustomCommand.Action> successActions = new ArrayList<CustomCommand.Action>();
        successActions.add(new CustomCommand.Action("message", List.of("&aSuccess! You had the required item."), null, null, null, null, null, null, null));
        successActions.add(new CustomCommand.Action("run_console", null, null, null, null, List.of("say {player} has at least 5 diamonds!"), null, null, null));
        ArrayList<CustomCommand.Action> failureActions = new ArrayList<CustomCommand.Action>();
        failureActions.add(new CustomCommand.Action("message", List.of("&cFailure! You need at least 5 diamonds to use this command."), null, null, null, null, null, null, null));
        ArrayList<CustomCommand.Condition> conditions = new ArrayList<CustomCommand.Condition>();
        conditions.add(new CustomCommand.Condition("has_item", "minecraft:diamond", 5, false));
        ArrayList<CustomCommand.Action> conditionalActionList = new ArrayList<CustomCommand.Action>();
        conditionalActionList.add(new CustomCommand.Action("conditional", null, null, null, null, null, conditions, successActions, failureActions));
        defaultCommands.add(new CustomCommand("checkdiamond", "Checks if you have 5 diamonds.", "paradigm.checkdiamond", false, null, conditionalActionList));
        ArrayList<CustomCommand.Action> cooldownActions = new ArrayList<CustomCommand.Action>();
        cooldownActions.add(new CustomCommand.Action("message", List.of("&aYou successfully used the cooldown command!"), null, null, null, null, null, null, null));
        defaultCommands.add(new CustomCommand("cooldown_test", "A command with a 30-second cooldown.", "paradigm.cooldown.test", false, null, cooldownActions, 30, "&cThis command is on cooldown! Please wait &e{remaining_time} &cseconds."));
        ArrayList<CustomCommand.Action> areaActions = new ArrayList<CustomCommand.Action>();
        areaActions.add(new CustomCommand.Action("message", List.of("&aYou have found the secret altar!"), null, null, null, null, null, null, null));
        CustomCommand.AreaRestriction restriction = new CustomCommand.AreaRestriction("minecraft:overworld", Arrays.asList(0, 60, 0), Arrays.asList(10, 70, 10), "&cYou must be at the secret altar to use this command.");
        defaultCommands.add(new CustomCommand("altar_ritual", "A command that only works in a specific area.", "paradigm.altar.use", false, null, areaActions, 60, "&cThe altar's magic needs time to recharge.", restriction));
        ArrayList<CustomCommand.Action> teleportActions = new ArrayList<CustomCommand.Action>();
        teleportActions.add(new CustomCommand.Action("message", List.of("&aTeleporting to coordinates $1, $2, $3..."), null, null, null, null, null, null, null));
        teleportActions.add(new CustomCommand.Action("run_console", null, null, null, null, List.of("tp {player} $1 $2 $3"), null, null, null));
        ArrayList<CustomCommand.ArgumentDefinition> teleportArgs = new ArrayList<CustomCommand.ArgumentDefinition>();
        teleportArgs.add(new CustomCommand.ArgumentDefinition("x", "integer", true, "&cX coordinate must be a valid integer!", null, -30000000, 30000000));
        teleportArgs.add(new CustomCommand.ArgumentDefinition("y", "integer", true, "&cY coordinate must be a valid integer between 0 and 320!", null, 0, 320));
        teleportArgs.add(new CustomCommand.ArgumentDefinition("z", "integer", true, "&cZ coordinate must be a valid integer!", null, -30000000, 30000000));
        defaultCommands.add(new CustomCommand("tpto", "Teleports to specific coordinates with validation.", "paradigm.tpto", false, null, teleportActions, null, null, null, teleportArgs));
        ArrayList<CustomCommand.Action> healActions = new ArrayList<CustomCommand.Action>();
        healActions.add(new CustomCommand.Action("message", List.of("&aHealing player $1..."), null, null, null, null, null, null, null));
        healActions.add(new CustomCommand.Action("run_console", null, null, null, null, List.of("effect give $1 minecraft:instant_health 1 10"), null, null, null));
        ArrayList<CustomCommand.ArgumentDefinition> healArgs = new ArrayList<CustomCommand.ArgumentDefinition>();
        healArgs.add(new CustomCommand.ArgumentDefinition("target", "player", true, "&cYou must specify a valid online player!", null, null, null));
        defaultCommands.add(new CustomCommand("healplayer", "Heals a specific player with tab completion.", "paradigm.heal", false, null, healActions, null, null, null, healArgs));
        ArrayList<CustomCommand.Action> weatherActions = new ArrayList<CustomCommand.Action>();
        weatherActions.add(new CustomCommand.Action("conditional", null, null, null, null, null, List.of(new CustomCommand.Condition("has_permission", "paradigm.weather.admin", null, false)), List.of(new CustomCommand.Action("run_console", null, null, null, null, List.of("weather clear"), null, null, null)), List.of(new CustomCommand.Action("message", List.of("&cNo permission."), null, null, null, null, null, null, null))));
        defaultCommands.add(new CustomCommand("weather", "Changes the weather if you have permission.", "paradigm.weather", false, null, weatherActions));
        this.loadedCommands = defaultCommands;
        this.saveCommands();
    }

    public List<CustomCommand> getLoadedCommands() {
        return new ArrayList<CustomCommand>(this.loadedCommands);
    }

    public void reloadCommands() {
        this.debugLogger.debugLog("CMConfig: Reloading custom commands...");
        this.loadCommands();
        this.debugLogger.debugLog("CMConfig: Custom commands reloaded. Found " + this.loadedCommands.size() + " commands.");
    }
}

