/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.data;

import java.util.ArrayList;
import java.util.List;

public class CustomCommand {
    private String name;
    private String description;
    private String permission;
    private boolean requirePermission;
    private String permissionErrorMessage;
    private List<Action> actions;
    private Integer cooldown_seconds;
    private String cooldown_message;
    private AreaRestriction area_restriction;
    private List<ArgumentDefinition> arguments;

    private CustomCommand() {
    }

    public CustomCommand(String name, String description, String permission, boolean requirePermission, String permissionErrorMessage, List<Action> actions) {
        this(name, description, permission, requirePermission, permissionErrorMessage, actions, null, null, null);
    }

    public CustomCommand(String name, String description, String permission, boolean requirePermission, String permissionErrorMessage, List<Action> actions, Integer cooldown_seconds, String cooldown_message) {
        this(name, description, permission, requirePermission, permissionErrorMessage, actions, cooldown_seconds, cooldown_message, null);
    }

    public CustomCommand(String name, String description, String permission, boolean requirePermission, String permissionErrorMessage, List<Action> actions, Integer cooldown_seconds, String cooldown_message, AreaRestriction area_restriction) {
        this(name, description, permission, requirePermission, permissionErrorMessage, actions, cooldown_seconds, cooldown_message, area_restriction, null);
    }

    public CustomCommand(String name, String description, String permission, boolean requirePermission, String permissionErrorMessage, List<Action> actions, Integer cooldown_seconds, String cooldown_message, AreaRestriction area_restriction, List<ArgumentDefinition> arguments) {
        this.name = name;
        this.description = description;
        this.permission = permission;
        this.requirePermission = requirePermission;
        this.permissionErrorMessage = permissionErrorMessage;
        this.actions = actions;
        this.cooldown_seconds = cooldown_seconds;
        this.cooldown_message = cooldown_message;
        this.area_restriction = area_restriction;
        this.arguments = arguments;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isRequirePermission() {
        return this.requirePermission;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public String getPermissionErrorMessage() {
        return this.permissionErrorMessage != null ? this.permissionErrorMessage : "&cYou do not have permission to execute this command.";
    }

    public Integer getCooldownSeconds() {
        return this.cooldown_seconds;
    }

    public String getCooldownMessage() {
        return this.cooldown_message;
    }

    public AreaRestriction getAreaRestriction() {
        return this.area_restriction;
    }

    public List<ArgumentDefinition> getArguments() {
        return this.arguments != null ? this.arguments : new ArrayList<ArgumentDefinition>();
    }

    public static class AreaRestriction {
        private String world;
        private List<Integer> corner1;
        private List<Integer> corner2;
        private String restriction_message;

        private AreaRestriction() {
        }

        public AreaRestriction(String world, List<Integer> corner1, List<Integer> corner2, String restriction_message) {
            this.world = world;
            this.corner1 = corner1;
            this.corner2 = corner2;
            this.restriction_message = restriction_message;
        }

        public String getWorld() {
            return this.world;
        }

        public List<Integer> getCorner1() {
            return this.corner1;
        }

        public List<Integer> getCorner2() {
            return this.corner2;
        }

        public String getRestrictionMessage() {
            return this.restriction_message != null ? this.restriction_message : "&cYou are not in the correct area to use this command.";
        }
    }

    public static class ArgumentDefinition {
        private String name;
        private String type;
        private boolean required;
        private String errorMessage;
        private List<String> customCompletions;
        private Integer minValue;
        private Integer maxValue;

        private ArgumentDefinition() {
        }

        public ArgumentDefinition(String name, String type, boolean required, String errorMessage, List<String> customCompletions, Integer minValue, Integer maxValue) {
            this.name = name;
            this.type = type != null ? type.toLowerCase() : "string";
            this.required = required;
            this.errorMessage = errorMessage;
            this.customCompletions = customCompletions;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type != null ? this.type.toLowerCase() : "string";
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getErrorMessage() {
            return this.errorMessage != null ? this.errorMessage : "&cInvalid argument: " + this.name;
        }

        public List<String> getCustomCompletions() {
            return this.customCompletions != null ? this.customCompletions : new ArrayList<String>();
        }

        public Integer getMinValue() {
            return this.minValue;
        }

        public Integer getMaxValue() {
            return this.maxValue;
        }
    }

    public static class Action {
        private String type;
        private List<String> text;
        private Integer x;
        private Integer y;
        private Integer z;
        private List<String> commands;
        private List<Condition> conditions;
        private List<Action> on_success;
        private List<Action> on_failure;

        private Action() {
        }

        public Action(String type, List<String> text, Integer x, Integer y, Integer z, List<String> commands, List<Condition> conditions, List<Action> on_success, List<Action> on_failure) {
            this.type = type;
            this.text = text;
            this.x = x;
            this.y = y;
            this.z = z;
            this.commands = commands;
            this.conditions = conditions;
            this.on_success = on_success;
            this.on_failure = on_failure;
        }

        public String getType() {
            return this.type != null ? this.type.toLowerCase() : "";
        }

        public List<String> getText() {
            return this.text;
        }

        public Integer getX() {
            return this.x;
        }

        public Integer getY() {
            return this.y;
        }

        public Integer getZ() {
            return this.z;
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public List<Condition> getConditions() {
            return this.conditions != null ? this.conditions : new ArrayList<Condition>();
        }

        public List<Action> getOnSuccess() {
            return this.on_success != null ? this.on_success : new ArrayList<Action>();
        }

        public List<Action> getOnFailure() {
            return this.on_failure != null ? this.on_failure : new ArrayList<Action>();
        }
    }

    public static class Condition {
        private String type;
        private String value;
        private Integer item_amount;
        private boolean negate;

        private Condition() {
        }

        public Condition(String type, String value, Integer item_amount, boolean negate) {
            this.type = type;
            this.value = value;
            this.item_amount = item_amount;
            this.negate = negate;
        }

        public String getType() {
            return this.type != null ? this.type.toLowerCase() : "";
        }

        public String getValue() {
            return this.value;
        }

        public int getItemAmount() {
            return this.item_amount != null ? this.item_amount : 1;
        }

        public boolean isNegate() {
            return this.negate;
        }
    }
}

