/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class Announcements
implements ParadigmModule {
    private static final String NAME = "Announcements";
    private final Random random = new Random();
    private int globalMessageIndex = 0;
    private int actionbarMessageIndex = 0;
    private int titleMessageIndex = 0;
    private int bossbarMessageIndex = 0;
    private int lastGlobalRandomIndex = -1;
    private int lastActionbarRandomIndex = -1;
    private int lastTitleRandomIndex = -1;
    private int lastBossbarRandomIndex = -1;
    private boolean announcementsScheduled = false;
    private IPlatformAdapter platform;
    private Services services;
    private ScheduledFuture<?> globalTask;
    private ScheduledFuture<?> actionbarTask;
    private ScheduledFuture<?> titleTask;
    private ScheduledFuture<?> bossbarTask;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return services.getMainConfig().announcementsEnable.get();
    }

    @Override
    public void onLoad(FMLCommonSetupEvent event, Services services, IEventBus modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("{} module loaded.", NAME);
    }

    @Override
    public void onServerStarting(ServerStartingEvent event, Services services) {
        if (this.isEnabled(services) && !this.announcementsScheduled) {
            services.getDebugLogger().debugLog("{}: Server is starting, scheduling announcements.", NAME);
            this.scheduleConfiguredAnnouncements();
        }
    }

    @Override
    public void onEnable(Services services) {
        if (this.platform.getMinecraftServer() != null && this.isEnabled(services) && !this.announcementsScheduled) {
            services.getDebugLogger().debugLog("{}: Module enabled, scheduling announcements.", NAME);
            this.scheduleConfiguredAnnouncements();
        }
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("{}: Module disabled. Scheduled announcement tasks will be terminated.", NAME);
        this.announcementsScheduled = false;
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event, Services services) {
    }

    @Override
    public void registerCommands(CommandDispatcher<?> dispatcher, Services services) {
        services.getDebugLogger().debugLog("{}: Registering commands.", NAME);
        CommandDispatcher<?> dispatcherCS = dispatcher;
        dispatcherCS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"paradigm").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"broadcast").then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this::broadcastMessageCmd)))).then(Commands.m_82127_((String)"actionbar").then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this::broadcastMessageCmd)))).then(Commands.m_82127_((String)"title").then(Commands.m_82129_((String)"titleAndSubtitle", (ArgumentType)StringArgumentType.greedyString()).executes(this::broadcastTitleCmd)))).then(Commands.m_82127_((String)"bossbar").then(Commands.m_82129_((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (IPlatformAdapter.BossBarColor color : IPlatformAdapter.BossBarColor.values()) {
                builder.suggest(color.name());
            }
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this::broadcastMessageCmd))))));
    }

    @Override
    public void registerEventListeners(IEventBus forgeEventBus, Services services) {
    }

    public void rescheduleAnnouncements() {
        this.services.getDebugLogger().debugLog("{}: rescheduleAnnouncements() called.", NAME);
        if (this.globalTask != null) {
            this.globalTask.cancel(false);
            this.globalTask = null;
        }
        if (this.actionbarTask != null) {
            this.actionbarTask.cancel(false);
            this.actionbarTask = null;
        }
        if (this.titleTask != null) {
            this.titleTask.cancel(false);
            this.titleTask = null;
        }
        if (this.bossbarTask != null) {
            this.bossbarTask.cancel(false);
            this.bossbarTask = null;
        }
        this.announcementsScheduled = false;
        this.scheduleConfiguredAnnouncements();
    }

    private void scheduleConfiguredAnnouncements() {
        long interval;
        this.services.getDebugLogger().debugLog("{}: scheduleConfiguredAnnouncements() called. Config: globalInterval={}, actionbarInterval={}, titleInterval={}, bossbarInterval={}", NAME, this.services.getAnnouncementsConfig().globalInterval.get(), this.services.getAnnouncementsConfig().actionbarInterval.get(), this.services.getAnnouncementsConfig().titleInterval.get(), this.services.getAnnouncementsConfig().bossbarInterval.get());
        if (this.announcementsScheduled) {
            this.services.getDebugLogger().debugLog("{}: Announcements already scheduled, skipping duplicate scheduling.", NAME);
            return;
        }
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        if (this.platform.getMinecraftServer() == null) {
            this.services.getDebugLogger().debugLog("{}: Server not available, skipping announcement scheduling.", NAME);
            return;
        }
        this.services.getDebugLogger().debugLog("{}: Scheduling announcements based on config.", NAME);
        if (config.globalEnable.get().booleanValue()) {
            interval = config.globalInterval.get().intValue();
            this.services.getDebugLogger().debugLog("{}: Scheduling global announcements every {} seconds.", NAME, interval);
            this.globalTask = this.services.getTaskScheduler().scheduleAtFixedRate(this::broadcastGlobalMessages, interval, interval, TimeUnit.SECONDS);
        }
        if (config.actionbarEnable.get().booleanValue()) {
            interval = config.actionbarInterval.get().intValue();
            this.services.getDebugLogger().debugLog("{}: Scheduling actionbar announcements every {} seconds.", NAME, interval);
            this.actionbarTask = this.services.getTaskScheduler().scheduleAtFixedRate(this::broadcastActionbarMessages, interval, interval, TimeUnit.SECONDS);
        }
        if (config.titleEnable.get().booleanValue()) {
            interval = config.titleInterval.get().intValue();
            this.services.getDebugLogger().debugLog("{}: Scheduling title announcements every {} seconds.", NAME, interval);
            this.titleTask = this.services.getTaskScheduler().scheduleAtFixedRate(this::broadcastTitleMessages, interval, interval, TimeUnit.SECONDS);
        }
        if (config.bossbarEnable.get().booleanValue()) {
            interval = config.bossbarInterval.get().intValue();
            this.services.getDebugLogger().debugLog("{}: Scheduling bossbar announcements every {} seconds.", NAME, interval);
            this.bossbarTask = this.services.getTaskScheduler().scheduleAtFixedRate(this::broadcastBossbarMessages, interval, interval, TimeUnit.SECONDS);
        }
        this.announcementsScheduled = true;
        this.services.getDebugLogger().debugLog("{}: All announcements successfully scheduled.", NAME);
    }

    private void broadcastGlobalMessages() {
        this.services.getDebugLogger().debugLog("{}: Firing global announcement task.", NAME);
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        if (config.globalMessages.get().isEmpty()) {
            this.services.getDebugLogger().debugLog("{}: No global messages configured, skipping.", NAME);
            return;
        }
        String messageText = this.getNextMessage(config.globalMessages.get(), config.orderMode.get(), "global");
        this.platform.getOnlinePlayers().forEach(player -> {
            if (config.headerAndFooter.get().booleanValue()) {
                IComponent header = this.services.getMessageParser().parseMessage(config.header.get(), (IPlayer)player);
                IComponent message = this.services.getMessageParser().parseMessage(messageText, (IPlayer)player);
                IComponent footer = this.services.getMessageParser().parseMessage(config.footer.get(), (IPlayer)player);
                this.platform.sendSystemMessage((IPlayer)player, header);
                this.platform.sendSystemMessage((IPlayer)player, message);
                this.platform.sendSystemMessage((IPlayer)player, footer);
            } else {
                this.platform.sendSystemMessage((IPlayer)player, messageText);
            }
        });
    }

    private void broadcastActionbarMessages() {
        this.services.getDebugLogger().debugLog("{}: Firing actionbar announcement task.", NAME);
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        if (config.actionbarMessages.get().isEmpty()) {
            this.services.getDebugLogger().debugLog("{}: No actionbar messages configured, skipping.", NAME);
            return;
        }
        String messageText = this.getNextMessage(config.actionbarMessages.get(), config.orderMode.get(), "actionbar");
        this.platform.getOnlinePlayers().forEach(player -> this.platform.sendActionBar((IPlayer)player, messageText));
    }

    private void broadcastTitleMessages() {
        this.services.getDebugLogger().debugLog("{}: Firing title announcement task.", NAME);
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        if (config.titleMessages.get().isEmpty()) {
            this.services.getDebugLogger().debugLog("{}: No title messages configured, skipping.", NAME);
            return;
        }
        String messageText = this.getNextMessage(config.titleMessages.get(), config.orderMode.get(), "title");
        this.platform.getOnlinePlayers().forEach(player -> {
            String[] parts = messageText.split(" \\|\\| ", 2);
            IComponent title = this.services.getMessageParser().parseMessage(parts[0], (IPlayer)player);
            IComponent subtitle = parts.length > 1 ? this.services.getMessageParser().parseMessage(parts[1], (IPlayer)player) : this.platform.createLiteralComponent("");
            this.platform.clearTitles((IPlayer)player);
            this.platform.sendTitle((IPlayer)player, title, subtitle);
        });
    }

    private void broadcastBossbarMessages() {
        this.services.getDebugLogger().debugLog("{}: Firing bossbar announcement task.", NAME);
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        if (config.bossbarMessages.get().isEmpty()) {
            this.services.getDebugLogger().debugLog("{}: No bossbar messages configured, skipping.", NAME);
            return;
        }
        String messageText = this.getNextMessage(config.bossbarMessages.get(), config.orderMode.get(), "bossbar");
        int duration = config.bossbarTime.get();
        IPlatformAdapter.BossBarColor color = IPlatformAdapter.BossBarColor.valueOf(config.bossbarColor.get().toUpperCase());
        this.platform.getOnlinePlayers().forEach(player -> this.platform.sendBossBar(Collections.singletonList(player), messageText, duration, color, 1.0f));
    }

    private String getNextMessage(List<? extends String> messages, String orderMode, String type) {
        String messageText;
        String prefix = this.services.getAnnouncementsConfig().prefix.get() + "\u00a7r";
        if ("SEQUENTIAL".equalsIgnoreCase(orderMode)) {
            int index;
            switch (type) {
                case "global": {
                    index = this.globalMessageIndex++;
                    if (this.globalMessageIndex < messages.size()) break;
                    this.globalMessageIndex = 0;
                    break;
                }
                case "actionbar": {
                    index = this.actionbarMessageIndex++;
                    if (this.actionbarMessageIndex < messages.size()) break;
                    this.actionbarMessageIndex = 0;
                    break;
                }
                case "title": {
                    index = this.titleMessageIndex++;
                    if (this.titleMessageIndex < messages.size()) break;
                    this.titleMessageIndex = 0;
                    break;
                }
                case "bossbar": {
                    index = this.bossbarMessageIndex++;
                    if (this.bossbarMessageIndex < messages.size()) break;
                    this.bossbarMessageIndex = 0;
                    break;
                }
                default: {
                    index = this.random.nextInt(messages.size());
                }
            }
            messageText = messages.get(index);
            this.services.getDebugLogger().debugLog("{}: Picked sequential message for type '{}' at index {}: \"{}\"", NAME, type, index, messageText);
        } else {
            int index;
            int lastIndex = switch (type) {
                case "global" -> this.lastGlobalRandomIndex;
                case "actionbar" -> this.lastActionbarRandomIndex;
                case "title" -> this.lastTitleRandomIndex;
                case "bossbar" -> this.lastBossbarRandomIndex;
                default -> -1;
            };
            if (messages.size() > 1) {
                while ((index = this.random.nextInt(messages.size())) == lastIndex) {
                }
            } else {
                index = 0;
            }
            switch (type) {
                case "global": {
                    this.lastGlobalRandomIndex = index;
                    break;
                }
                case "actionbar": {
                    this.lastActionbarRandomIndex = index;
                    break;
                }
                case "title": {
                    this.lastTitleRandomIndex = index;
                    break;
                }
                case "bossbar": {
                    this.lastBossbarRandomIndex = index;
                }
            }
            messageText = messages.get(index);
            this.services.getDebugLogger().debugLog("{}: Picked random message for type '{}' at index {}: \"{}\"", NAME, type, index, messageText);
        }
        return messageText.replace("{Prefix}", prefix);
    }

    private int broadcastTitleCmd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String titleAndSubtitle = StringArgumentType.getString(context, (String)"titleAndSubtitle");
        ICommandSource source = this.platform.wrapCommandSource(context.getSource());
        this.services.getDebugLogger().debugLog("{}: /paradigm title command executed by {} with message: \"{}\"", NAME, source.getSourceName(), titleAndSubtitle);
        String[] parts = titleAndSubtitle.split(" \\|\\| ", 2);
        this.platform.getOnlinePlayers().forEach(target -> {
            IComponent title = this.services.getMessageParser().parseMessage(parts[0], (IPlayer)target);
            IComponent subtitle = parts.length > 1 ? this.services.getMessageParser().parseMessage(parts[1], (IPlayer)target) : this.platform.createLiteralComponent("");
            this.platform.clearTitles((IPlayer)target);
            this.platform.sendTitle((IPlayer)target, title, subtitle);
        });
        this.platform.sendSuccess(source, this.platform.createLiteralComponent("Title broadcasted."), !source.isConsole());
        return 1;
    }

    private int broadcastMessageCmd(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String messageStr = StringArgumentType.getString(context, (String)"message");
        String commandName = ((ParsedCommandNode)context.getNodes().get(1)).getNode().getName();
        ICommandSource source = this.platform.wrapCommandSource(context.getSource());
        this.services.getDebugLogger().debugLog("{}: /paradigm {} command executed by {} with message: \"{}\"", NAME, commandName, source.getSourceName(), messageStr);
        switch (commandName) {
            case "broadcast": {
                this.platform.getOnlinePlayers().forEach(player -> {
                    IComponent message = this.services.getMessageParser().parseMessage(messageStr, (IPlayer)player);
                    this.platform.sendSystemMessage((IPlayer)player, message);
                });
                break;
            }
            case "actionbar": {
                this.platform.getOnlinePlayers().forEach(player -> {
                    IComponent message = this.services.getMessageParser().parseMessage(messageStr, (IPlayer)player);
                    this.platform.sendActionBar((IPlayer)player, message);
                });
                break;
            }
            case "bossbar": {
                String colorStr = StringArgumentType.getString(context, (String)"color");
                int interval = IntegerArgumentType.getInteger(context, (String)"interval");
                IPlatformAdapter.BossBarColor color = IPlatformAdapter.BossBarColor.valueOf(colorStr.toUpperCase());
                this.services.getDebugLogger().debugLog("{}: Bossbar broadcast details: color={}, interval={}", NAME, colorStr, interval);
                this.platform.getOnlinePlayers().forEach(player -> {
                    IComponent message = this.services.getMessageParser().parseMessage(messageStr, (IPlayer)player);
                    this.platform.sendBossBar(Collections.singletonList(player), message, interval, color, 1.0f);
                });
            }
        }
        this.platform.sendSuccess(source, this.platform.createLiteralComponent(commandName + " broadcasted."), !source.isConsole());
        return 1;
    }
}

