/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules.chat;

import com.mojang.brigadier.CommandDispatcher;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class JoinLeaveMessages
implements ParadigmModule {
    private static final String NAME = "JoinLeaveMessages";
    private Services services;
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        ChatConfigHandler.Config config = services.getChatConfig();
        return config.enableJoinLeaveMessages.get() != false || config.enableFirstJoinMessage.get() != false;
    }

    @Override
    public void onLoad(FMLCommonSetupEvent event, Services services, IEventBus modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("JoinLeaveMessages module loaded.");
    }

    @Override
    public void onServerStarting(ServerStartingEvent event, Services services) {
    }

    @Override
    public void onEnable(Services services) {
    }

    @Override
    public void onDisable(Services services) {
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event, Services services) {
    }

    @Override
    public void registerCommands(CommandDispatcher<?> dispatcher, Services services) {
    }

    @Override
    public void registerEventListeners(IEventBus forgeEventBus, Services services) {
        forgeEventBus.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.services == null || !this.isEnabled(this.services) || !(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ChatConfigHandler.Config chatConfig = this.services.getChatConfig();
        boolean isFirstJoin = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12989_)) == 0;
        String messageFormat = null;
        String logMessage = null;
        if (isFirstJoin && chatConfig.enableFirstJoinMessage.get().booleanValue()) {
            messageFormat = chatConfig.firstJoinMessageFormat.get();
            logMessage = "Sent FIRST join message for ";
        } else if (chatConfig.enableJoinLeaveMessages.get().booleanValue()) {
            messageFormat = chatConfig.joinMessageFormat.get();
            logMessage = "Sent regular join message for ";
        }
        if (messageFormat != null) {
            IPlayer iPlayer = MinecraftPlayer.of(player);
            IComponent formattedMessage = this.services.getMessageParser().parseMessage(messageFormat, iPlayer);
            this.platform.broadcastSystemMessage(formattedMessage);
            this.services.getDebugLogger().debugLog(logMessage + this.platform.getPlayerName(iPlayer));
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (this.services == null || !this.isEnabled(this.services) || !(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ChatConfigHandler.Config chatConfig = this.services.getChatConfig();
        if (chatConfig.enableJoinLeaveMessages.get().booleanValue()) {
            String leaveMessageFormat = chatConfig.leaveMessageFormat.get();
            IPlayer iPlayer = MinecraftPlayer.of(player);
            IComponent formattedMessage = this.services.getMessageParser().parseMessage(leaveMessageFormat, iPlayer);
            this.platform.broadcastSystemMessage(formattedMessage);
            this.services.getDebugLogger().debugLog("Sent leave message for " + this.platform.getPlayerName(iPlayer));
        }
    }
}

