/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules.chat;

import com.mojang.brigadier.CommandDispatcher;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class MOTD
implements ParadigmModule {
    private static final String NAME = "MOTD";
    private Services services;
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return services.getMainConfig().motdEnable.get();
    }

    @Override
    public void onLoad(FMLCommonSetupEvent event, Services services, IEventBus modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("MOTD module loaded.");
    }

    @Override
    public void onServerStarting(ServerStartingEvent event, Services services) {
    }

    @Override
    public void onEnable(Services services) {
    }

    @Override
    public void onDisable(Services services) {
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event, Services services) {
    }

    @Override
    public void registerCommands(CommandDispatcher<?> dispatcher, Services services) {
    }

    @Override
    public void registerEventListeners(IEventBus forgeEventBus, Services services) {
        forgeEventBus.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.services == null || !this.isEnabled(this.services) || !(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer mcPlayer = (ServerPlayer)event.getEntity();
        MinecraftPlayer player = new MinecraftPlayer(mcPlayer);
        IComponent motdMessage = this.createMOTDMessage(player);
        this.platform.sendSystemMessage((IPlayer)player, motdMessage);
        this.services.getDebugLogger().debugLog("Sent MOTD to " + this.platform.getPlayerName(player));
    }

    private IComponent createMOTDMessage(IPlayer player) {
        List<String> lines = this.services.getMotdConfig().motdLines;
        if (lines == null || lines.isEmpty()) {
            return this.platform.createLiteralComponent("");
        }
        IComponent motdMessage = this.platform.createLiteralComponent("");
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            IComponent lineComponent = this.services.getMessageParser().parseMessage(line, player);
            motdMessage.append(lineComponent);
            if (i >= lines.size() - 1) continue;
            motdMessage.append(this.platform.createLiteralComponent("\n"));
        }
        return motdMessage;
    }
}

