/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.avalanche7.paradigm.Paradigm;
import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.configs.MOTDConfigHandler;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.modules.Announcements;
import eu.avalanche7.paradigm.modules.Restart;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import java.util.List;
import java.util.Locale;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class reload
implements ParadigmModule {
    private static final String NAME = "Reload";
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return true;
    }

    @Override
    public void registerCommands(CommandDispatcher<?> dispatcher, Services services) {
        this.platform = services.getPlatformAdapter();
        CommandDispatcher<?> dispatcherCS = dispatcher;
        SuggestionProvider configSuggestions = (ctx, builder) -> {
            List<String> options = List.of("main", "announcements", "chat", "motd", "mention", "restart", "customcommands", "all");
            return SharedSuggestionProvider.m_82970_(options, (SuggestionsBuilder)builder);
        };
        dispatcherCS.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"paradigm").requires(source -> this.platform.hasCommandPermission(source, "paradigm.command.reload", 2))).then(Commands.m_82127_((String)"reload").then(Commands.m_82129_((String)"config", (ArgumentType)StringArgumentType.word()).suggests(configSuggestions).executes(ctx -> {
            ICommandSource wrappedSource = this.platform.wrapCommandSource(ctx.getSource());
            return this.reloadConfig(wrappedSource, services, this.platform, StringArgumentType.getString((CommandContext)ctx, (String)"config"));
        }))));
    }

    private int reloadConfig(ICommandSource source, Services services, IPlatformAdapter platform, String configRaw) {
        String config = configRaw.toLowerCase(Locale.ROOT);
        boolean found = true;
        StringBuilder result = new StringBuilder();
        String color = "&a";
        switch (config) {
            case "main": {
                MainConfigHandler.load();
                result.append("\u2714 &aMain config reloaded!");
                break;
            }
            case "announcements": {
                AnnouncementsConfigHandler.load();
                Paradigm.getModules().stream().filter(m -> m instanceof Announcements).findFirst().ifPresent(m -> ((Announcements)m).rescheduleAnnouncements());
                result.append("\u2714 &aAnnouncements config reloaded!");
                break;
            }
            case "chat": {
                ChatConfigHandler.load();
                result.append("\u2714 &aChat config reloaded!");
                break;
            }
            case "motd": {
                MOTDConfigHandler.load();
                result.append("\u2714 &aMOTD config reloaded!");
                break;
            }
            case "mention": {
                MentionConfigHandler.load();
                result.append("\u2714 &aMention config reloaded!");
                break;
            }
            case "restart": {
                RestartConfigHandler.load();
                Paradigm.getModules().stream().filter(m -> m instanceof Restart).findFirst().ifPresent(m -> ((Restart)m).scheduleNextRestart());
                result.append("\u2714 &aRestart config reloaded!");
                break;
            }
            case "customcommands": {
                services.getCmConfig().reloadCommands();
                services.getPermissionsHandler().refreshCustomCommandPermissions();
                result.append("\u2714 &aCustom commands reloaded!");
                break;
            }
            case "all": {
                MainConfigHandler.load();
                AnnouncementsConfigHandler.load();
                ChatConfigHandler.load();
                MOTDConfigHandler.load();
                MentionConfigHandler.load();
                RestartConfigHandler.load();
                Paradigm.getModules().stream().filter(m -> m instanceof Restart).findFirst().ifPresent(m -> ((Restart)m).scheduleNextRestart());
                services.getCmConfig().reloadCommands();
                services.getPermissionsHandler().refreshCustomCommandPermissions();
                Paradigm.getModules().stream().filter(m -> m instanceof Announcements).findFirst().ifPresent(m -> ((Announcements)m).rescheduleAnnouncements());
                result.append("\u2714 &aAll configs reloaded!");
                break;
            }
            default: {
                found = false;
                color = "&c";
                result.append("\u2716 &cUnknown config: ").append(config).append("! Valid: main, announcements, chat, motd, mention, restart, customcommands, all");
            }
        }
        IComponent message = services.getMessageParser().parseMessage(color + result, null);
        if (found) {
            platform.sendSuccess(source, message, false);
        } else {
            platform.sendFailure(source, message);
        }
        return found ? 1 : 0;
    }

    @Override
    public void onLoad(FMLCommonSetupEvent event, Services services, IEventBus modEventBus) {
    }

    @Override
    public void onServerStarting(ServerStartingEvent event, Services services) {
    }

    @Override
    public void onEnable(Services services) {
    }

    @Override
    public void onDisable(Services services) {
    }

    @Override
    public void onServerStopping(ServerStoppingEvent event, Services services) {
    }

    @Override
    public void registerEventListeners(IEventBus forgeEventBus, Services services) {
    }
}

