/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.platform;

import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class MinecraftComponent
implements IComponent {
    private final MutableComponent component;

    public MinecraftComponent(MutableComponent component) {
        this.component = component;
    }

    public MinecraftComponent(Component component) {
        this.component = component.m_6881_();
    }

    public MutableComponent getHandle() {
        return this.component;
    }

    @Override
    public String getRawText() {
        return this.component.getString();
    }

    @Override
    public IComponent setStyle(Style style) {
        this.component.m_6270_(style);
        return this;
    }

    @Override
    public Style getStyle() {
        return this.component.m_7383_();
    }

    @Override
    public IComponent append(IComponent sibling) {
        if (sibling instanceof MinecraftComponent) {
            MinecraftComponent mc = (MinecraftComponent)sibling;
            this.component.m_7220_((Component)mc.getHandle());
        } else if (sibling != null) {
            System.err.println("[Paradigm] Warning: Tried to append non-MinecraftComponent: " + sibling.getClass().getName());
        }
        return this;
    }

    @Override
    public List<?> getSiblings() {
        return this.component.m_7360_();
    }

    @Override
    public IComponent copy() {
        return new MinecraftComponent(this.component.m_6881_());
    }

    @Override
    public IComponent withStyle(ChatFormatting formatting) {
        return new MinecraftComponent(this.component.m_6881_().m_130940_(formatting));
    }

    @Override
    public IComponent withStyle(Style style) {
        return new MinecraftComponent(this.component.m_6881_().m_130948_(style));
    }

    @Override
    public IComponent withStyle(UnaryOperator<Style> styleUpdater) {
        return new MinecraftComponent(this.component.m_6881_().m_130938_(styleUpdater));
    }

    @Override
    public IComponent withColor(int rgb) {
        return new MinecraftComponent(this.component.m_6881_().m_130938_(s -> s.m_131148_(TextColor.m_131266_((int)rgb))));
    }

    @Override
    public IComponent withColorHex(String hex) {
        if (hex == null || hex.isEmpty()) {
            return this.copy();
        }
        String cleaned = hex.startsWith("#") ? hex.substring(1) : hex;
        try {
            int rgb = Integer.parseInt(cleaned, 16);
            return this.withColor(rgb);
        }
        catch (NumberFormatException e) {
            return this.copy();
        }
    }

    @Override
    public IComponent onClickRunCommand(String command) {
        return new MinecraftComponent(this.component.m_6881_().m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command))));
    }

    @Override
    public IComponent onClickSuggestCommand(String command) {
        return new MinecraftComponent(this.component.m_6881_().m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command))));
    }

    @Override
    public IComponent onClickOpenUrl(String url) {
        String u = url == null ? "" : (url.startsWith("http://") || url.startsWith("https://") ? url : "https://" + url);
        return new MinecraftComponent(this.component.m_6881_().m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, u))));
    }

    @Override
    public IComponent onHoverText(String text) {
        MutableComponent hover = Component.m_237113_((String)(text != null ? text : ""));
        return new MinecraftComponent(this.component.m_6881_().m_130938_(arg_0 -> MinecraftComponent.lambda$onHoverText$4((Component)hover, arg_0)));
    }

    @Override
    public IComponent onHoverComponent(IComponent comp) {
        MutableComponent hover;
        if (comp instanceof MinecraftComponent) {
            MinecraftComponent mc = (MinecraftComponent)comp;
            hover = mc.getHandle();
        } else {
            hover = Component.m_237113_((String)(comp != null ? comp.getRawText() : ""));
        }
        return new MinecraftComponent(this.component.m_6881_().m_130938_(arg_0 -> MinecraftComponent.lambda$onHoverComponent$5((Component)hover, arg_0)));
    }

    private static /* synthetic */ Style lambda$onHoverComponent$5(Component hover, Style s) {
        return s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hover));
    }

    private static /* synthetic */ Style lambda$onHoverText$4(Component hover, Style s) {
        return s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hover));
    }
}

