/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.platform;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IEventSystem;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.platform.MinecraftCommandSource;
import eu.avalanche7.paradigm.platform.MinecraftComponent;
import eu.avalanche7.paradigm.platform.MinecraftEventSystem;
import eu.avalanche7.paradigm.platform.MinecraftPlayer;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.MessageParser;
import eu.avalanche7.paradigm.utils.PermissionsHandler;
import eu.avalanche7.paradigm.utils.Placeholders;
import eu.avalanche7.paradigm.utils.TaskScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class PlatformAdapterImpl
implements IPlatformAdapter {
    private MinecraftServer server;
    private MessageParser messageParser;
    private final PermissionsHandler permissionsHandler;
    private final Placeholders placeholders;
    private final TaskScheduler taskScheduler;
    private final DebugLogger debugLogger;
    private final Map<UUID, ServerBossEvent> persistentBossBars = new HashMap<UUID, ServerBossEvent>();
    private ServerBossEvent restartBossBar;
    private final MinecraftEventSystem eventSystem;

    public PlatformAdapterImpl(PermissionsHandler permissionsHandler, Placeholders placeholders, TaskScheduler taskScheduler, DebugLogger debugLogger) {
        this.permissionsHandler = permissionsHandler;
        this.placeholders = placeholders;
        this.taskScheduler = taskScheduler;
        this.debugLogger = debugLogger;
        this.eventSystem = new MinecraftEventSystem();
        MinecraftForge.EVENT_BUS.register((Object)this.eventSystem);
    }

    @Override
    public void provideMessageParser(MessageParser messageParser) {
        this.messageParser = messageParser;
    }

    @Override
    public Object getMinecraftServer() {
        return this.server;
    }

    @Override
    public void setMinecraftServer(Object server) {
        this.server = (MinecraftServer)server;
    }

    @Override
    public List<IPlayer> getOnlinePlayers() {
        ArrayList<IPlayer> players = new ArrayList<IPlayer>();
        for (ServerPlayer player : ((MinecraftServer)this.getMinecraftServer()).m_6846_().m_11314_()) {
            players.add(new MinecraftPlayer(player));
        }
        return players;
    }

    @Override
    @Nullable
    public IPlayer getPlayerByName(String name) {
        ServerPlayer player = ((MinecraftServer)this.getMinecraftServer()).m_6846_().m_11255_(name);
        return player != null ? new MinecraftPlayer(player) : null;
    }

    @Override
    @Nullable
    public IPlayer getPlayerByUuid(UUID uuid) {
        ServerPlayer player = ((MinecraftServer)this.getMinecraftServer()).m_6846_().m_11259_(uuid);
        return player != null ? new MinecraftPlayer(player) : null;
    }

    @Override
    public String getPlayerName(IPlayer player) {
        return player.getName();
    }

    @Override
    public IComponent getPlayerDisplayName(IPlayer player) {
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        return new MinecraftComponent(mcPlayer.m_5446_().m_6881_());
    }

    @Override
    public IComponent createLiteralComponent(String text) {
        return new MinecraftComponent(Component.m_237113_((String)text));
    }

    @Override
    public IComponent createTranslatableComponent(String key, Object ... args) {
        return new MinecraftComponent(Component.m_237110_((String)key, (Object[])args));
    }

    @Override
    public Object createItemStack(String itemId) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
        return item != null ? new ItemStack((ItemLike)item) : new ItemStack((ItemLike)Items.f_41905_);
    }

    @Override
    public boolean hasPermission(IPlayer player, String permissionNode) {
        return this.permissionsHandler.hasPermission(((MinecraftPlayer)player).getHandle(), permissionNode);
    }

    @Override
    public boolean hasPermission(IPlayer player, String permissionNode, int vanillaLevel) {
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        return this.permissionsHandler.hasPermission(mcPlayer, permissionNode) || mcPlayer.m_20310_(vanillaLevel);
    }

    @Override
    public boolean hasPermissionNode(IPlayer player, String permission) {
        return this.hasPermission(player, permission);
    }

    @Override
    public void sendSystemMessage(IPlayer player, IComponent message) {
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        mcPlayer.m_213846_((Component)((MinecraftComponent)message).getHandle());
    }

    @Override
    public void broadcastSystemMessage(IComponent message) {
        if (this.getMinecraftServer() != null) {
            ((MinecraftServer)this.getMinecraftServer()).m_6846_().m_240416_((Component)((MinecraftComponent)message).getHandle(), false);
        }
    }

    @Override
    public void broadcastChatMessage(IComponent message) {
        if (this.getMinecraftServer() != null) {
            ((MinecraftServer)this.getMinecraftServer()).m_6846_().m_240416_((Component)((MinecraftComponent)message).getHandle(), false);
        }
    }

    @Override
    public void broadcastSystemMessage(IComponent message, String header, String footer, @Nullable IPlayer playerContext) {
        if (this.messageParser == null) {
            return;
        }
        IComponent headerComp = this.messageParser.parseMessage(header, playerContext);
        IComponent footerComp = this.messageParser.parseMessage(footer, playerContext);
        this.getOnlinePlayers().forEach(p -> {
            this.sendSystemMessage((IPlayer)p, headerComp);
            this.sendSystemMessage((IPlayer)p, message);
            this.sendSystemMessage((IPlayer)p, footerComp);
        });
    }

    @Override
    public void sendTitle(IPlayer player, IComponent title, IComponent subtitle) {
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        mcPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)((MinecraftComponent)title).getHandle()));
        if (subtitle != null && !subtitle.getRawText().isEmpty()) {
            mcPlayer.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)((MinecraftComponent)subtitle).getHandle()));
        }
    }

    @Override
    public void sendSubtitle(IPlayer player, IComponent subtitle) {
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        if (subtitle != null && !subtitle.getRawText().isEmpty()) {
            mcPlayer.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)((MinecraftComponent)subtitle).getHandle()));
        }
    }

    @Override
    public void sendActionBar(IPlayer player, IComponent message) {
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        mcPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)((MinecraftComponent)message).getHandle()));
    }

    @Override
    public void clearTitles(IPlayer player) {
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        mcPlayer.f_8906_.m_9829_((Packet)new ClientboundClearTitlesPacket(true));
    }

    @Override
    public void sendSystemMessage(IPlayer player, String message) {
        if (this.messageParser != null) {
            IComponent parsed = this.messageParser.parseMessage(message, player);
            this.sendSystemMessage(player, parsed);
        }
    }

    @Override
    public void sendActionBar(IPlayer player, String message) {
        if (this.messageParser != null) {
            ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
            IComponent parsed = this.messageParser.parseMessage(message, player);
            this.sendActionBar(player, parsed);
        }
    }

    @Override
    public void sendBossBar(List<IPlayer> players, String message, int durationSeconds, IPlatformAdapter.BossBarColor color, float progress) {
        if (this.messageParser != null) {
            IComponent parsed = this.messageParser.parseMessage(message, !players.isEmpty() ? players.get(0) : null);
            this.sendBossBar(players, parsed, durationSeconds, color, progress);
        }
    }

    private BossEvent.BossBarColor toMinecraftColor(IPlatformAdapter.BossBarColor color) {
        return BossEvent.BossBarColor.valueOf((String)color.name());
    }

    private BossEvent.BossBarOverlay toMinecraftOverlay(IPlatformAdapter.BossBarOverlay overlay) {
        return BossEvent.BossBarOverlay.valueOf((String)overlay.name());
    }

    @Override
    public void sendBossBar(List<IPlayer> players, IComponent message, int durationSeconds, IPlatformAdapter.BossBarColor color, float progress) {
        MutableComponent mcMessage = ((MinecraftComponent)message).getHandle();
        ServerBossEvent bossEvent = new ServerBossEvent((Component)mcMessage, this.toMinecraftColor(color), BossEvent.BossBarOverlay.PROGRESS);
        bossEvent.m_142711_(progress);
        players.forEach(p -> bossEvent.m_6543_(((MinecraftPlayer)p).getHandle()));
        this.taskScheduler.schedule(() -> {
            bossEvent.m_7706_();
            bossEvent.m_8321_(false);
        }, durationSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void showPersistentBossBar(IPlayer player, IComponent message, IPlatformAdapter.BossBarColor color, IPlatformAdapter.BossBarOverlay overlay) {
        this.removePersistentBossBar(player);
        MutableComponent mcMessage = ((MinecraftComponent)message).getHandle();
        ServerBossEvent bossEvent = new ServerBossEvent((Component)mcMessage, this.toMinecraftColor(color), this.toMinecraftOverlay(overlay));
        bossEvent.m_6543_(((MinecraftPlayer)player).getHandle());
        this.persistentBossBars.put(UUID.fromString(player.getUUID()), bossEvent);
    }

    @Override
    public void removePersistentBossBar(IPlayer player) {
        ServerBossEvent bossBar = this.persistentBossBars.remove(UUID.fromString(player.getUUID()));
        if (bossBar != null) {
            bossBar.m_6539_(((MinecraftPlayer)player).getHandle());
        }
    }

    @Override
    public void createOrUpdateRestartBossBar(IComponent message, IPlatformAdapter.BossBarColor color, float progress) {
        MutableComponent mcMessage = ((MinecraftComponent)message).getHandle();
        if (this.restartBossBar == null) {
            this.restartBossBar = new ServerBossEvent((Component)mcMessage, this.toMinecraftColor(color), BossEvent.BossBarOverlay.PROGRESS);
            this.restartBossBar.m_8321_(true);
            this.getOnlinePlayers().forEach(p -> this.restartBossBar.m_6543_(((MinecraftPlayer)p).getHandle()));
        }
        this.restartBossBar.m_6456_((Component)mcMessage);
        this.restartBossBar.m_142711_(progress);
    }

    @Override
    public void createOrUpdateRestartBossBar(String message, IPlatformAdapter.BossBarColor color, float progress) {
        if (this.messageParser != null) {
            IComponent parsed = this.messageParser.parseMessage(message, null);
            this.createOrUpdateRestartBossBar(parsed, color, progress);
        }
    }

    @Override
    public void removeRestartBossBar() {
        if (this.restartBossBar != null) {
            this.restartBossBar.m_8321_(false);
            this.restartBossBar.m_7706_();
            this.restartBossBar = null;
        }
    }

    @Override
    public void sendTitle(IPlayer player, String title, String subtitle) {
        if (this.messageParser != null) {
            IComponent titleComp = this.messageParser.parseMessage(title, player);
            IComponent subtitleComp = subtitle != null ? this.messageParser.parseMessage(subtitle, player) : this.createLiteralComponent("");
            this.sendTitle(player, titleComp, subtitleComp);
        }
    }

    @Override
    public void shutdownServer(IComponent kickMessage) {
        MinecraftServer server = (MinecraftServer)this.getMinecraftServer();
        if (server != null && kickMessage instanceof MinecraftComponent) {
            MinecraftComponent mc = (MinecraftComponent)kickMessage;
            try {
                server.m_6846_().m_240416_((Component)mc.getHandle(), false);
                server.m_195514_(true, true, true);
                server.m_7570_(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("[Paradigm-Debug] PlatformAdapterImpl: Exception during shutdown: " + e.getMessage());
            }
        }
    }

    @Override
    public void shutdownServer(String kickMessage) {
        MinecraftServer server = (MinecraftServer)this.getMinecraftServer();
        if (server != null) {
            try {
                System.out.println("[Paradigm-Debug] PlatformAdapterImpl: shutdownServer called with message: " + kickMessage);
                server.m_6846_().m_240416_((Component)Component.m_237113_((String)kickMessage), false);
                server.m_195514_(true, true, true);
                System.out.println("[Paradigm-Debug] PlatformAdapterImpl: Calling server.halt(false)");
                server.m_7570_(false);
                System.out.println("[Paradigm-Debug] PlatformAdapterImpl: server.halt(false) called");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("[Paradigm-Debug] PlatformAdapterImpl: Exception during shutdown: " + e.getMessage());
            }
        } else {
            System.out.println("[Paradigm-Debug] PlatformAdapterImpl: shutdownServer called but server is null!");
        }
    }

    @Override
    public void sendSuccess(Object source, IComponent message, boolean toOps) {
        if (source instanceof CommandSourceStack) {
            CommandSourceStack stack = (CommandSourceStack)source;
            if (message instanceof MinecraftComponent) {
                MinecraftComponent mc = (MinecraftComponent)message;
                stack.m_81354_((Component)mc.getHandle(), toOps);
            }
        }
    }

    @Override
    public void sendFailure(Object source, IComponent message) {
        if (source instanceof CommandSourceStack) {
            CommandSourceStack stack = (CommandSourceStack)source;
            if (message instanceof MinecraftComponent) {
                MinecraftComponent mc = (MinecraftComponent)message;
                stack.m_81352_((Component)mc.getHandle());
            }
        }
    }

    @Override
    public boolean hasCommandPermission(Object source, String permission) {
        if (!(source instanceof CommandSourceStack)) {
            return true;
        }
        CommandSourceStack stack = (CommandSourceStack)source;
        Entity entity = stack.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer player = (ServerPlayer)entity;
        return this.permissionsHandler.hasPermission(player, permission);
    }

    @Override
    public boolean hasCommandPermission(Object source, String permission, int vanillaLevel) {
        if (!(source instanceof CommandSourceStack)) {
            return true;
        }
        CommandSourceStack stack = (CommandSourceStack)source;
        Entity entity = stack.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer player = (ServerPlayer)entity;
        return this.permissionsHandler.hasPermission(player, permission) || player.m_20310_(vanillaLevel);
    }

    @Override
    public void executeCommandAs(Object source, String command) {
        if (this.server == null || command == null || source == null) {
            return;
        }
        if (source instanceof CommandSourceStack) {
            CommandSourceStack stack = (CommandSourceStack)source;
            CommandDispatcher dispatcher = this.server.m_129892_().m_82094_();
            ParseResults parseResults = dispatcher.parse(command, (Object)stack);
            try {
                dispatcher.execute(parseResults);
            }
            catch (CommandSyntaxException e) {
                this.debugLogger.debugLog("Command execution failed: " + command, (Exception)((Object)e));
            }
        }
    }

    @Override
    public void executeCommandAsConsole(String command) {
        if (this.server == null || command == null) {
            return;
        }
        CommandSourceStack console = this.server.m_129893_();
        CommandDispatcher dispatcher = this.server.m_129892_().m_82094_();
        ParseResults parseResults = dispatcher.parse(command, (Object)console);
        try {
            dispatcher.execute(parseResults);
        }
        catch (CommandSyntaxException e) {
            this.debugLogger.debugLog("Console command execution failed: " + command, (Exception)((Object)e));
        }
    }

    @Override
    public void teleportPlayer(IPlayer player, double x, double y, double z) {
        if (player instanceof MinecraftPlayer) {
            MinecraftPlayer mcPlayer = (MinecraftPlayer)player;
            mcPlayer.getHandle().m_6021_(x, y, z);
        }
    }

    @Override
    public boolean playerHasItem(IPlayer player, String itemId, int amount) {
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        if (mcPlayer == null || itemId == null) {
            return false;
        }
        try {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
            if (item == null || item == Items.f_41852_) {
                this.debugLogger.debugLog("PlatformAdapter: Could not find item with ID: " + itemId);
                return false;
            }
            return mcPlayer.m_150109_().m_18947_(item) >= amount;
        }
        catch (Exception e) {
            this.debugLogger.debugLog("Error checking player items: " + itemId, e);
            return false;
        }
    }

    @Override
    public boolean isPlayerInArea(IPlayer player, String worldId, List<Integer> corner1, List<Integer> corner2) {
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        if (mcPlayer == null || worldId == null || corner1 == null || corner2 == null || corner1.size() != 3 || corner2.size() != 3) {
            return false;
        }
        try {
            ResourceKey targetWorldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(worldId));
            if (!mcPlayer.m_9236_().m_46472_().equals((Object)targetWorldKey)) {
                return false;
            }
            Vec3 pos = mcPlayer.m_20182_();
            double pX = pos.m_7096_();
            double pY = pos.m_7098_();
            double pZ = pos.m_7094_();
            double x1 = Math.min(corner1.get(0), corner2.get(0));
            double y1 = Math.min(corner1.get(1), corner2.get(1));
            double z1 = Math.min(corner1.get(2), corner2.get(2));
            double x2 = Math.max(corner1.get(0), corner2.get(0));
            double y2 = Math.max(corner1.get(1), corner2.get(1));
            double z2 = Math.max(corner1.get(2), corner2.get(2));
            return pX >= x1 && pX <= x2 && pY >= y1 && pY <= y2 && pZ >= z1 && pZ <= z2;
        }
        catch (Exception e) {
            this.debugLogger.debugLog("Error checking player area: " + worldId, e);
            return false;
        }
    }

    @Override
    public boolean isModLoaded(String modId) {
        try {
            return ModList.get().isLoaded(modId);
        }
        catch (Exception e) {
            this.debugLogger.debugLog("Error checking mod loaded: " + modId, e);
            return false;
        }
    }

    @Override
    public void playSound(IPlayer player, String soundId, IPlatformAdapter.SoundCategory category, float volume, float pitch) {
        if (!(player instanceof MinecraftPlayer)) {
            return;
        }
        ServerPlayer mcPlayer = ((MinecraftPlayer)player).getHandle();
        try {
            SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundId));
            if (soundEvent != null) {
                SoundSource mcCategory = SoundSource.valueOf((String)category.name());
                mcPlayer.m_6330_(soundEvent, mcCategory, volume, pitch);
            }
        }
        catch (Exception e) {
            this.debugLogger.debugLog("Failed to play sound: " + soundId, e);
        }
    }

    @Override
    public ICommandSource wrapCommandSource(Object source) {
        if (source instanceof CommandSourceStack) {
            CommandSourceStack stack = (CommandSourceStack)source;
            return new MinecraftCommandSource(stack);
        }
        throw new IllegalArgumentException("Unsupported command source type: " + source.getClass());
    }

    @Override
    public void sendSuccess(ICommandSource source, IComponent message, boolean toOps) {
        if (source instanceof MinecraftCommandSource) {
            MinecraftCommandSource mcSource = (MinecraftCommandSource)source;
            if (message instanceof MinecraftComponent) {
                MinecraftComponent mc = (MinecraftComponent)message;
                mcSource.getHandle().m_81354_((Component)mc.getHandle(), toOps);
            }
        }
    }

    @Override
    public void sendFailure(ICommandSource source, IComponent message) {
        if (source instanceof MinecraftCommandSource) {
            MinecraftCommandSource mcSource = (MinecraftCommandSource)source;
            if (message instanceof MinecraftComponent) {
                MinecraftComponent mc = (MinecraftComponent)message;
                mcSource.getHandle().m_81352_((Component)mc.getHandle());
            }
        }
    }

    @Override
    public boolean hasCommandPermission(ICommandSource source, String permission) {
        IPlayer player = source.getPlayer();
        if (player != null) {
            return this.hasPermission(player, permission);
        }
        return true;
    }

    @Override
    public boolean hasCommandPermission(ICommandSource source, String permission, int vanillaLevel) {
        IPlayer player = source.getPlayer();
        if (player != null) {
            return this.hasPermission(player, permission, vanillaLevel);
        }
        return true;
    }

    @Override
    public String replacePlaceholders(String text, @Nullable IPlayer player) {
        return this.placeholders.replacePlaceholders(text, player);
    }

    @Override
    public boolean hasPermissionForCustomCommand(Object source, CustomCommand command) {
        if (!(source instanceof CommandSourceStack)) {
            return true;
        }
        CommandSourceStack stack = (CommandSourceStack)source;
        if (!command.isRequirePermission()) {
            return true;
        }
        Entity entity = stack.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer player = (ServerPlayer)entity;
        boolean hasPerm = this.permissionsHandler.hasPermission(player, command.getPermission());
        if (!hasPerm && this.messageParser != null) {
            String errorMessage = command.getPermissionErrorMessage();
            IComponent parsed = this.messageParser.parseMessage(errorMessage, new MinecraftPlayer(player));
            player.m_213846_((Component)((MinecraftComponent)parsed).getHandle());
        }
        return hasPerm;
    }

    @Override
    public void executeCommandAs(ICommandSource source, String command) {
        if (source instanceof MinecraftCommandSource) {
            MinecraftCommandSource mcSource = (MinecraftCommandSource)source;
            this.executeCommandAs(mcSource.getHandle(), command);
        }
    }

    @Override
    public IEventSystem getEventSystem() {
        return this.eventSystem;
    }

    @Override
    public List<String> getWorldNames() {
        ArrayList<String> worldNames = new ArrayList<String>();
        if (this.server != null) {
            for (ServerLevel level : this.server.m_129785_()) {
                worldNames.add(level.m_46472_().m_135782_().toString());
            }
        }
        return worldNames;
    }

    @Override
    public List<String> getOnlinePlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        for (IPlayer player : this.getOnlinePlayers()) {
            playerNames.add(player.getName());
        }
        return playerNames;
    }
}

