/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import eu.avalanche7.paradigm.data.Group;
import eu.avalanche7.paradigm.data.PlayerGroupData;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.Lang;
import eu.avalanche7.paradigm.utils.MessageParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class GroupChatManager {
    private final Map<String, Group> groups = new HashMap<String, Group>();
    private final Map<UUID, PlayerGroupData> playerData = new HashMap<UUID, PlayerGroupData>();
    private final Map<String, Set<UUID>> pendingJoinRequests = new HashMap<String, Set<UUID>>();
    private final IPlatformAdapter platform;
    private final Lang lang;
    private final DebugLogger logger;
    private final MessageParser messageParser;
    private final Map<UUID, Long> inviteCooldowns = new HashMap<UUID, Long>();
    private static final long INVITE_COOLDOWN_MS = 10000L;

    public GroupChatManager(IPlatformAdapter platform, Lang lang, DebugLogger logger, MessageParser messageParser) {
        this.platform = platform;
        this.lang = lang;
        this.logger = logger;
        this.messageParser = messageParser;
    }

    private IComponent translate(String key) {
        return this.lang.translate(key);
    }

    private IComponent parseMessage(String message, IPlayer player) {
        return this.messageParser.parseMessage(message, player);
    }

    private void debugLog(String message) {
        this.logger.debugLog(message);
    }

    public boolean createGroup(IPlayer player, String groupName) {
        if (groupName == null || groupName.trim().isEmpty() || groupName.length() > 32) {
            this.platform.sendSystemMessage(player, this.translate("group.invalid_name"));
            return false;
        }
        if (this.groups.containsKey(groupName)) {
            this.platform.sendSystemMessage(player, this.translate("group.already_exists"));
            return false;
        }
        Group group = new Group(groupName, UUID.fromString(player.getUUID()));
        this.groups.put(groupName, group);
        this.getPlayerData(player).setCurrentGroup(groupName);
        this.platform.sendSystemMessage(player, this.translate("group.created_successfully"));
        this.debugLog("Player " + this.platform.getPlayerName(player) + " created group: " + groupName);
        return true;
    }

    public boolean deleteGroup(IPlayer player) {
        UUID playerUUID = UUID.fromString(player.getUUID());
        String groupName = this.findPlayerGroup(playerUUID);
        if (groupName == null) {
            this.platform.sendSystemMessage(player, this.translate("group.no_group_to_delete"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(playerUUID)) {
            this.platform.sendSystemMessage(player, this.translate("group.not_owner"));
            return false;
        }
        for (UUID memberUUID : group.getMembers()) {
            IPlayer memberPlayer;
            if (memberUUID.equals(playerUUID) || (memberPlayer = this.platform.getPlayerByUuid(memberUUID)) == null) continue;
            IComponent messageToMember = this.parseMessage(this.translate("group.group_deleted_notification").getRawText().replace("{group_name}", groupName), memberPlayer);
            this.platform.sendSystemMessage(memberPlayer, messageToMember);
        }
        this.groups.remove(groupName);
        this.platform.sendSystemMessage(player, this.translate("group.deleted_successfully"));
        this.debugLog("Player " + this.platform.getPlayerName(player) + " deleted group: " + groupName);
        return true;
    }

    public void listGroups(IPlayer player) {
        if (this.groups.isEmpty()) {
            this.platform.sendSystemMessage(player, this.translate("group.no_groups_available"));
            return;
        }
        this.platform.sendSystemMessage(player, this.translate("group.available_groups"));
        for (Map.Entry<String, Group> entry : this.groups.entrySet()) {
            String groupName = entry.getKey();
            Group group = entry.getValue();
            String ownerName = "Unknown";
            IPlayer ownerPlayer = this.platform.getPlayerByUuid(group.getOwner());
            if (ownerPlayer != null) {
                ownerName = this.platform.getPlayerName(ownerPlayer);
            }
            int memberCount = group.getMembers().size();
            IComponent joinButton = this.platform.createLiteralComponent("[Join]").withColorHex("55FF55").onClickSuggestCommand("/groupchat join " + groupName).onHoverText("Click to join " + groupName);
            IComponent groupLine = this.platform.createLiteralComponent("\u00a7e" + groupName + " \u00a77(" + memberCount + " members, owner: " + ownerName + ") ").append(joinButton);
            this.platform.sendSystemMessage(player, groupLine);
        }
    }

    public void groupInfo(IPlayer player, String groupName) {
        Group group = this.groups.get(groupName);
        if (group == null) {
            this.platform.sendSystemMessage(player, this.translate("group.group_not_found"));
            return;
        }
        this.platform.sendSystemMessage(player, this.parseMessage("&6Group Information: &e" + groupName, player));
        IPlayer ownerPlayer = this.platform.getPlayerByUuid(group.getOwner());
        String ownerName = ownerPlayer != null ? this.platform.getPlayerName(ownerPlayer) : "Unknown (Offline)";
        this.platform.sendSystemMessage(player, this.parseMessage("&7Owner: &f" + ownerName, player));
        this.platform.sendSystemMessage(player, this.parseMessage("&7Members (" + group.getMembers().size() + "):", player));
        group.getMembers().forEach(memberUUID -> {
            IPlayer memberPlayer = this.platform.getPlayerByUuid((UUID)memberUUID);
            String memberName = memberPlayer != null ? this.platform.getPlayerName(memberPlayer) : "Unknown (Offline)";
            this.platform.sendSystemMessage(player, this.platform.createLiteralComponent("- " + memberName));
        });
    }

    public boolean invitePlayer(IPlayer inviter, IPlayer target) {
        long lastInvite;
        UUID inviterUUID = UUID.fromString(inviter.getUUID());
        long now = System.currentTimeMillis();
        if (this.inviteCooldowns.containsKey(inviterUUID) && now - (lastInvite = this.inviteCooldowns.get(inviterUUID).longValue()) < 10000L) {
            long waitSec = (10000L - (now - lastInvite)) / 1000L;
            this.platform.sendSystemMessage(inviter, this.platform.createLiteralComponent("\u00a7cPlease wait " + waitSec + "s before sending another invite."));
            return false;
        }
        this.inviteCooldowns.put(inviterUUID, now);
        PlayerGroupData inviterData = this.getPlayerData(inviter);
        String groupName = inviterData.getCurrentGroup();
        if (groupName == null || !this.groups.containsKey(groupName)) {
            this.platform.sendSystemMessage(inviter, this.translate("group.no_group_to_invite_from"));
            return false;
        }
        Group group = this.groups.get(groupName);
        UUID targetUUID = UUID.fromString(target.getUUID());
        if (!group.getOwner().equals(inviterUUID)) {
            this.platform.sendSystemMessage(inviter, this.translate("group.not_owner_invite"));
            return false;
        }
        if (group.getMembers().contains(targetUUID)) {
            IComponent message = this.parseMessage(this.translate("group.player_already_in_group").getRawText().replace("{player_name}", this.platform.getPlayerName(target)), inviter);
            this.platform.sendSystemMessage(inviter, message);
            return false;
        }
        this.getPlayerData(target).addInvitation(groupName);
        this.platform.sendSystemMessage(inviter, this.platform.createLiteralComponent("\u00a7aInvite sent to " + this.platform.getPlayerName(target) + " for group " + groupName + "."));
        IComponent msg = this.platform.createLiteralComponent("\u00a7eYou have been invited to join group \u00a7b" + groupName + "\u00a7e by \u00a7a" + this.platform.getPlayerName(inviter));
        IComponent space = this.platform.createLiteralComponent(" ");
        IComponent accept = this.platform.createLiteralComponent("[Accept]").withColorHex("55FF55").onClickRunCommand("/groupchat accept " + groupName).onHoverText("Click to accept the invite");
        IComponent deny = this.platform.createLiteralComponent("[Deny]").withColorHex("FF5555").onClickRunCommand("/groupchat deny " + groupName).onHoverText("Click to deny the invite");
        IComponent full = msg.append(space).append(accept).append(space.copy()).append(deny);
        this.platform.sendSystemMessage(target, full);
        this.debugLog("Player " + this.platform.getPlayerName(inviter) + " invited " + this.platform.getPlayerName(target) + " to group: " + groupName);
        return true;
    }

    private String langText(String key) {
        return this.lang.translate(key).getRawText();
    }

    public void requestJoinGroup(IPlayer player, String groupName) {
        if (!this.groups.containsKey(groupName)) {
            this.platform.sendSystemMessage(player, this.translate("group.group_not_found"));
            return;
        }
        Group group = this.groups.get(groupName);
        UUID playerUUID = UUID.fromString(player.getUUID());
        if (group.getMembers().contains(playerUUID)) {
            this.platform.sendSystemMessage(player, this.parseMessage("&7You are already in group &f" + groupName, player));
            return;
        }
        if (this.getPlayerData(player).getInvitations().contains(groupName)) {
            this.platform.sendSystemMessage(player, this.parseMessage("&7You already have an invite to &e" + groupName + "&7. Use &a/groupchat accept " + groupName, player));
            return;
        }
        this.pendingJoinRequests.computeIfAbsent(groupName, k -> new HashSet()).add(playerUUID);
        this.platform.sendSystemMessage(player, this.translate("group.join_request_sent"));
        IComponent space = this.platform.createLiteralComponent(" ");
        IComponent cancel = this.platform.createLiteralComponent("[Cancel]").withColorHex("FFAA00").onClickRunCommand("/groupchat cancelreq " + groupName).onHoverText("Click to cancel your join request");
        IComponent msg = this.platform.createLiteralComponent("\u00a7eYou have a pending join request to \u00a7b" + groupName + "\u00a7e.").append(space).append(cancel);
        this.platform.sendSystemMessage(player, msg);
        IPlayer owner = this.platform.getPlayerByUuid(group.getOwner());
        if (owner != null) {
            IComponent notify = this.platform.createLiteralComponent(this.langText("group.join_request_received").replace("{player_name}", this.platform.getPlayerName(player)).replace("{group_name}", groupName));
            IComponent space2 = this.platform.createLiteralComponent(" ");
            IComponent accept = this.platform.createLiteralComponent("[" + this.langText("group.button_accept") + "]").withColorHex("55FF55").onClickRunCommand("/groupchat acceptreq " + this.platform.getPlayerName(player)).onHoverText(this.langText("group.hover_accept_request"));
            IComponent deny = this.platform.createLiteralComponent("[" + this.langText("group.button_deny") + "]").withColorHex("FF5555").onClickRunCommand("/groupchat denyreq " + this.platform.getPlayerName(player)).onHoverText(this.langText("group.hover_deny_request"));
            notify.append(space2).append(accept).append(space2.copy()).append(deny);
            this.platform.sendSystemMessage(owner, notify);
        }
    }

    public boolean acceptInvite(IPlayer player, String groupName) {
        IPlayer owner;
        Group group;
        PlayerGroupData data = this.getPlayerData(player);
        if (!data.getInvitations().contains(groupName)) {
            this.platform.sendSystemMessage(player, this.platform.createLiteralComponent("\u00a7c" + this.translate("group.not_invited").getRawText()));
            return false;
        }
        data.removeInvitation(groupName);
        boolean joined = this.internalJoinGroup(player, groupName);
        if (joined && (group = this.groups.get(groupName)) != null && (owner = this.platform.getPlayerByUuid(group.getOwner())) != null) {
            IComponent msg = this.platform.createLiteralComponent("\u00a7a" + this.platform.getPlayerName(player) + "\u00a7e accepted your invite to \u00a7b" + groupName + "\u00a7e!");
            this.platform.sendSystemMessage(owner, msg);
        }
        return joined;
    }

    public boolean denyInvite(IPlayer player, String groupName) {
        PlayerGroupData data = this.getPlayerData(player);
        if (!data.getInvitations().contains(groupName)) {
            this.platform.sendSystemMessage(player, this.translate("group.not_invited"));
            return false;
        }
        data.removeInvitation(groupName);
        this.platform.sendSystemMessage(player, this.translate("group.invite_denied"));
        return true;
    }

    public boolean acceptJoinRequest(IPlayer owner, String playerName) {
        String groupName = this.getPlayerData(owner).getCurrentGroup();
        if (groupName == null) {
            this.platform.sendSystemMessage(owner, this.platform.createLiteralComponent("\u00a7c" + this.translate("group.no_group_to_manage_requests").getRawText()));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(UUID.fromString(owner.getUUID()))) {
            this.platform.sendSystemMessage(owner, this.platform.createLiteralComponent("\u00a7c" + this.translate("group.not_owner").getRawText()));
            return false;
        }
        IPlayer target = this.platform.getPlayerByName(playerName);
        if (target == null) {
            this.platform.sendSystemMessage(owner, this.platform.createLiteralComponent("\u00a7c" + this.translate("group.request_player_offline").getRawText()));
            return false;
        }
        Set reqs = this.pendingJoinRequests.getOrDefault(groupName, Collections.emptySet());
        if (!reqs.contains(UUID.fromString(target.getUUID()))) {
            this.platform.sendSystemMessage(owner, this.platform.createLiteralComponent("\u00a7c" + this.translate("group.no_pending_request").getRawText()));
            return false;
        }
        reqs.remove(UUID.fromString(target.getUUID()));
        boolean ok = this.internalJoinGroup(target, groupName);
        if (ok) {
            this.platform.sendSystemMessage(owner, this.platform.createLiteralComponent("\u00a7a" + this.translate("group.request_accepted_owner").getRawText()));
            this.platform.sendSystemMessage(target, this.platform.createLiteralComponent("\u00a7a" + this.translate("group.request_accepted_player").getRawText()));
        }
        return ok;
    }

    public boolean denyJoinRequest(IPlayer owner, String playerName) {
        String groupName = this.getPlayerData(owner).getCurrentGroup();
        if (groupName == null) {
            this.platform.sendSystemMessage(owner, this.translate("group.no_group_to_manage_requests"));
            return false;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(UUID.fromString(owner.getUUID()))) {
            this.platform.sendSystemMessage(owner, this.translate("group.not_owner"));
            return false;
        }
        IPlayer target = this.platform.getPlayerByName(playerName);
        if (target == null) {
            this.platform.sendSystemMessage(owner, this.translate("group.request_player_offline"));
            return false;
        }
        Set reqs = this.pendingJoinRequests.getOrDefault(groupName, Collections.emptySet());
        if (!reqs.remove(UUID.fromString(target.getUUID()))) {
            this.platform.sendSystemMessage(owner, this.translate("group.no_pending_request"));
            return false;
        }
        this.platform.sendSystemMessage(owner, this.translate("group.request_denied_owner"));
        this.platform.sendSystemMessage(target, this.translate("group.request_denied_player"));
        return true;
    }

    public void listJoinRequests(IPlayer owner) {
        String groupName = this.getPlayerData(owner).getCurrentGroup();
        if (groupName == null) {
            this.platform.sendSystemMessage(owner, this.translate("group.no_group_to_manage_requests"));
            return;
        }
        Group group = this.groups.get(groupName);
        if (!group.getOwner().equals(UUID.fromString(owner.getUUID()))) {
            this.platform.sendSystemMessage(owner, this.translate("group.not_owner"));
            return;
        }
        Set reqs = this.pendingJoinRequests.getOrDefault(groupName, Collections.emptySet());
        if (reqs.isEmpty()) {
            this.platform.sendSystemMessage(owner, this.translate("group.no_pending_request"));
            return;
        }
        this.platform.sendSystemMessage(owner, this.parseMessage("&6Pending join requests:", owner));
        for (UUID uuid : reqs) {
            IPlayer p = this.platform.getPlayerByUuid(uuid);
            String name = p != null ? this.platform.getPlayerName(p) : uuid.toString();
            System.out.println("[Paradigm Debug] Building clickable join request line for: " + name);
            IComponent base = this.parseMessage("&7- &f" + name + " &8[", owner);
            IComponent accept = this.parseMessage("&a/groupchat accept " + name, owner).onClickRunCommand("/groupchat accept " + name).onHoverText("Click to accept " + name);
            IComponent sep = this.parseMessage("&8 | ", owner);
            IComponent deny = this.parseMessage("&c/groupchat deny " + name, owner).onClickRunCommand("/groupchat deny " + name).onHoverText("Click to deny " + name);
            IComponent end = this.parseMessage("&8]", owner);
            IComponent full = base.append(accept).append(sep).append(deny).append(end);
            System.out.println("[Paradigm Debug] Sending clickable join request line for: " + name);
            this.platform.sendSystemMessage(owner, full);
        }
    }

    private boolean internalJoinGroup(IPlayer player, String groupName) {
        PlayerGroupData playerData = this.getPlayerData(player);
        Group group = this.groups.get(groupName);
        if (group == null) {
            this.platform.sendSystemMessage(player, this.translate("group.group_not_found"));
            return false;
        }
        if (playerData.getCurrentGroup() != null && !playerData.getCurrentGroup().equals(groupName)) {
            this.leaveGroup(player);
        }
        UUID playerUUID = UUID.fromString(player.getUUID());
        group.addMember(playerUUID);
        playerData.setCurrentGroup(groupName);
        playerData.removeInvitation(groupName);
        IComponent joinedMessage = this.parseMessage(this.translate("group.joined").getRawText().replace("{group_name}", groupName), player);
        this.platform.sendSystemMessage(player, joinedMessage);
        IComponent notification = this.parseMessage(this.translate("group.player_joined_notification").getRawText().replace("{player_name}", this.platform.getPlayerName(player)), null);
        group.getMembers().forEach(memberUUID -> {
            IPlayer member;
            if (!memberUUID.equals(playerUUID) && (member = this.platform.getPlayerByUuid((UUID)memberUUID)) != null) {
                this.platform.sendSystemMessage(member, notification);
            }
        });
        this.debugLog("Player " + this.platform.getPlayerName(player) + " joined group: " + groupName);
        return true;
    }

    public boolean leaveGroup(IPlayer player) {
        UUID newOwnerUUID;
        PlayerGroupData data = this.getPlayerData(player);
        String groupName = data.getCurrentGroup();
        if (groupName == null || !this.groups.containsKey(groupName)) {
            this.platform.sendSystemMessage(player, this.translate("group.no_group_to_leave"));
            return false;
        }
        Group group = this.groups.get(groupName);
        UUID playerUUID = UUID.fromString(player.getUUID());
        group.removeMember(playerUUID);
        data.setCurrentGroup(null);
        this.platform.sendSystemMessage(player, this.parseMessage(this.translate("group.left").getRawText().replace("{group_name}", groupName), player));
        IComponent notification = this.parseMessage(this.translate("group.player_left_notification").getRawText().replace("{player_name}", this.platform.getPlayerName(player)), null);
        group.getMembers().forEach(memberUUID -> {
            IPlayer member = this.platform.getPlayerByUuid((UUID)memberUUID);
            if (member != null) {
                this.platform.sendSystemMessage(member, notification);
            }
        });
        if (group.getMembers().isEmpty()) {
            this.groups.remove(groupName);
            this.debugLog("Group " + groupName + " disbanded as last member left.");
        } else if (group.getOwner().equals(playerUUID) && (newOwnerUUID = (UUID)group.getMembers().stream().findFirst().orElse(null)) != null) {
            group.setOwner(newOwnerUUID);
            IPlayer newOwnerPlayer = this.platform.getPlayerByUuid(newOwnerUUID);
            if (newOwnerPlayer != null) {
                this.platform.sendSystemMessage(newOwnerPlayer, this.translate("group.new_owner_notification"));
                this.debugLog("Ownership of group " + groupName + " transferred to " + this.platform.getPlayerName(newOwnerPlayer));
            }
        }
        this.debugLog("Player " + this.platform.getPlayerName(player) + " left group: " + groupName);
        return true;
    }

    public void toggleGroupChat(IPlayer player) {
        PlayerGroupData data = this.getPlayerData(player);
        if (!data.isGroupChatToggled() && data.getCurrentGroup() == null) {
            this.platform.sendSystemMessage(player, this.translate("group.must_be_in_group_to_toggle"));
            return;
        }
        data.setGroupChatToggled(!data.isGroupChatToggled());
        IComponent message = data.isGroupChatToggled() ? this.translate("group.chat_enabled") : this.translate("group.chat_disabled");
        this.platform.sendSystemMessage(player, message);
    }

    public boolean isGroupChatToggled(IPlayer player) {
        return this.getPlayerData(player).isGroupChatToggled();
    }

    public void setGroupChatToggled(IPlayer player, boolean toggled) {
        this.getPlayerData(player).setGroupChatToggled(toggled);
    }

    public void sendMessageToGroup(IPlayer sender, String groupName, String messageContent) {
        Group group = this.groups.get(groupName);
        UUID senderUUID = UUID.fromString(sender.getUUID());
        if (group == null || !group.getMembers().contains(senderUUID)) {
            this.platform.sendSystemMessage(sender, this.translate("group.not_in_group_or_not_exists"));
            return;
        }
        String format = "&9[{group_name}] &r{player_name} &7>&f {message}";
        String preFormatted = format.replace("{group_name}", groupName).replace("{player_name}", this.platform.getPlayerName(sender)).replace("{message}", messageContent);
        IComponent finalMessage = this.parseMessage(preFormatted, sender);
        group.getMembers().forEach(memberUUID -> {
            IPlayer member = this.platform.getPlayerByUuid((UUID)memberUUID);
            if (member != null) {
                this.platform.sendSystemMessage(member, finalMessage);
            }
        });
    }

    public void sendMessageFromCommand(IPlayer sender, String messageContent) {
        String groupName = this.getPlayerData(sender).getCurrentGroup();
        if (groupName == null) {
            this.platform.sendSystemMessage(sender, this.translate("group.no_group_to_send_message"));
            return;
        }
        this.sendMessageToGroup(sender, groupName, messageContent);
    }

    public PlayerGroupData getPlayerData(IPlayer player) {
        return this.playerData.computeIfAbsent(UUID.fromString(player.getUUID()), k -> new PlayerGroupData());
    }

    public void clearAllGroupsAndPlayerData() {
        this.groups.clear();
        this.playerData.clear();
        this.debugLog("All group chat data cleared.");
    }

    private String findPlayerGroup(UUID playerUUID) {
        for (Map.Entry<String, Group> entry : this.groups.entrySet()) {
            if (!entry.getValue().getMembers().contains(playerUUID)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean kickMember(IPlayer owner, String targetName) {
        String groupName = this.getPlayerData(owner).getCurrentGroup();
        if (groupName == null) {
            this.platform.sendSystemMessage(owner, this.translate("group.no_group_to_manage_requests"));
            return false;
        }
        Group group = this.groups.get(groupName);
        UUID ownerUUID = UUID.fromString(owner.getUUID());
        if (!group.getOwner().equals(ownerUUID)) {
            this.platform.sendSystemMessage(owner, this.translate("group.not_owner"));
            return false;
        }
        IPlayer target = this.platform.getPlayerByName(targetName);
        if (target == null) {
            this.platform.sendSystemMessage(owner, this.translate("group.kick_not_found"));
            return false;
        }
        UUID targetUUID = UUID.fromString(target.getUUID());
        if (!group.getMembers().contains(targetUUID)) {
            this.platform.sendSystemMessage(owner, this.translate("group.kick_not_member"));
            return false;
        }
        if (targetUUID.equals(ownerUUID)) {
            this.platform.sendSystemMessage(owner, this.translate("group.kick_cannot_self"));
            return false;
        }
        group.removeMember(targetUUID);
        this.getPlayerData(target).setCurrentGroup(null);
        this.platform.sendSystemMessage(target, this.platform.createLiteralComponent(this.translate("group.kick_success_target").getRawText().replace("{group_name}", groupName)));
        this.platform.sendSystemMessage(owner, this.platform.createLiteralComponent(this.translate("group.kick_success_owner").getRawText().replace("{player_name}", this.platform.getPlayerName(target))));
        IComponent notification = this.platform.createLiteralComponent(this.translate("group.kick_success_notify").getRawText().replace("{player_name}", this.platform.getPlayerName(target)));
        group.getMembers().forEach(memberUUID -> {
            IPlayer member = this.platform.getPlayerByUuid((UUID)memberUUID);
            if (member != null) {
                this.platform.sendSystemMessage(member, notification);
            }
        });
        if (group.getMembers().isEmpty()) {
            this.groups.remove(groupName);
            this.debugLog("Group " + groupName + " disbanded as last member was kicked.");
        }
        this.debugLog("Player " + this.platform.getPlayerName(target) + " was kicked from group: " + groupName + " by owner " + this.platform.getPlayerName(owner));
        return true;
    }
}

