/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.webeditor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;

public class WebEditorResponse {
    private final String id;
    private final JsonObject payload;

    public WebEditorResponse(String id, JsonObject payload) {
        this.id = Objects.requireNonNull(id, "id");
        this.payload = Objects.requireNonNull(payload, "payload");
    }

    public String getId() {
        return this.id;
    }

    public JsonObject getPayload() {
        return this.payload;
    }

    public boolean hasAnyChanges() {
        JsonElement el;
        if (this.payload.has("changes") && (el = this.payload.get("changes")).isJsonArray() && el.getAsJsonArray().size() > 0) {
            return true;
        }
        return this.payload.has("deletions") && (el = this.payload.get("deletions")).isJsonArray() && el.getAsJsonArray().size() > 0;
    }

    public int countChanges() {
        int total = 0;
        if (this.payload.has("changes") && this.payload.get("changes").isJsonArray()) {
            total += this.payload.getAsJsonArray("changes").size();
        }
        if (this.payload.has("deletions") && this.payload.get("deletions").isJsonArray()) {
            total += this.payload.getAsJsonArray("deletions").size();
        }
        return total;
    }

    public JsonArray getChanges() {
        return this.payload.has("changes") && this.payload.get("changes").isJsonArray() ? this.payload.getAsJsonArray("changes") : new JsonArray();
    }

    public JsonArray getDeletions() {
        return this.payload.has("deletions") && this.payload.get("deletions").isJsonArray() ? this.payload.getAsJsonArray("deletions") : new JsonArray();
    }
}

