/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.webeditor.socket;

import eu.avalanche7.paradigm.configs.MainConfigHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class BytesocksClient {
    private final String httpUrl;
    private final String wsUrl;
    private final String userAgent;
    private boolean debugEnabled = false;

    public BytesocksClient(String host, String userAgent) {
        String h = Objects.requireNonNull(host, "host");
        if (h.endsWith("/")) {
            h = h.substring(0, h.length() - 1);
        }
        this.httpUrl = "https://" + h + "/";
        this.wsUrl = "wss://" + h + "/";
        this.userAgent = userAgent == null ? "paradigm/editor" : userAgent;
        try {
            this.debugEnabled = MainConfigHandler.CONFIG.debugEnable.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Socket createSocket(WebSocket.Listener listener) throws IOException {
        HttpURLConnection conn = null;
        try {
            String createUrl = this.httpUrl + "create";
            if (this.debugEnabled) {
                System.out.println("[BytesocksClient] Creating channel at: " + createUrl);
            }
            conn = (HttpURLConnection)URI.create(createUrl).toURL().openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", this.userAgent);
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            int code = conn.getResponseCode();
            if (this.debugEnabled) {
                System.out.println("[BytesocksClient] HTTP response code: " + code);
            }
            if (code != 201) {
                String errorBody = this.readErrorStream(conn);
                String errorMsg = "Bytesocks create returned status " + code + (String)(errorBody.isEmpty() ? "" : ", body: " + errorBody);
                if (this.debugEnabled) {
                    System.err.println("[BytesocksClient] " + errorMsg);
                }
                throw new IOException(errorMsg);
            }
            String id = conn.getHeaderField("Location");
            if (this.debugEnabled) {
                System.out.println("[BytesocksClient] Location header: " + id);
            }
            if (id == null || id.isEmpty()) {
                throw new IOException("Bytesocks create did not return channel id");
            }
            String wsFullUrl = this.wsUrl + id;
            if (this.debugEnabled) {
                System.out.println("[BytesocksClient] Connecting WebSocket to: " + wsFullUrl);
            }
            WebSocket ws = HttpClient.newHttpClient().newWebSocketBuilder().buildAsync(URI.create(wsFullUrl), listener).join();
            if (this.debugEnabled) {
                System.out.println("[BytesocksClient] WebSocket connected, channel: " + id);
            }
            Socket socket = new Socket(id, ws);
            return socket;
        }
        catch (Exception e) {
            if (this.debugEnabled) {
                System.err.println("[BytesocksClient] Exception: " + e.getClass().getName() + ": " + e.getMessage());
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Failed to create socket: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private String readErrorStream(HttpURLConnection conn) {
        try {
            int read;
            InputStream es = conn.getErrorStream();
            if (es == null) {
                return "";
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((read = es.read(buf)) != -1 && baos.size() < 4096) {
                if (read <= 0) continue;
                baos.write(buf, 0, read);
            }
            return baos.toString(StandardCharsets.UTF_8);
        }
        catch (Exception ignored) {
            return "";
        }
    }

    public static final class Socket {
        private final String channelId;
        private final WebSocket webSocket;

        public Socket(String channelId, WebSocket webSocket) {
            this.channelId = channelId;
            this.webSocket = webSocket;
        }

        public String channelId() {
            return this.channelId;
        }

        public WebSocket webSocket() {
            return this.webSocket;
        }
    }
}

