/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CooldownConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"paradigm");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("paradigm/cooldowns.json");
    private static Map<UUID, Map<String, Long>> cooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                Type type = new TypeToken<Map<UUID, Map<String, Long>>>(){}.getType();
                Map loadedCooldowns = (Map)GSON.fromJson((Reader)reader, type);
                if (loadedCooldowns != null) {
                    cooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>(loadedCooldowns);
                }
            }
            catch (Exception e) {
                LOGGER.warn("[Paradigm] Could not parse cooldowns.json, it may be corrupt. A new one will be generated.", (Throwable)e);
            }
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson(cooldowns, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("[Paradigm] Could not save cooldowns config file.", (Throwable)e);
        }
    }

    public static long getLastUsage(UUID playerUuid, String commandName) {
        return ((Map)cooldowns.getOrDefault(playerUuid, new ConcurrentHashMap())).getOrDefault(commandName, 0L);
    }

    public static void setLastUsage(UUID playerUuid, String commandName, long timestamp) {
        cooldowns.computeIfAbsent(playerUuid, k -> new ConcurrentHashMap()).put(commandName, timestamp);
        CooldownConfigHandler.save();
    }
}

