/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.mixin;

import eu.avalanche7.paradigm.Paradigm;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3468;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3324.class})
public class PlayerManagerMixin {
    @Unique
    private static final ThreadLocal<Boolean> SUPPRESS_JOIN_BROADCAST = new ThreadLocal();

    @Inject(method={"onPlayerConnect"}, at={@At(value="HEAD")})
    private void paradigm$decideJoinSuppression(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        Services services = Paradigm.getServices();
        if (services == null) {
            SUPPRESS_JOIN_BROADCAST.set(Boolean.FALSE);
            return;
        }
        ChatConfigHandler.Config chatConfig = services.getChatConfig();
        boolean enableRegular = (Boolean)chatConfig.enableJoinLeaveMessages.value;
        boolean enableFirst = (Boolean)chatConfig.enableFirstJoinMessage.value;
        boolean isFirstJoin = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15389)) == 0;
        boolean shouldSuppress = enableRegular || enableFirst && isFirstJoin;
        SUPPRESS_JOIN_BROADCAST.set(shouldSuppress);
    }

    @Inject(method={"onPlayerConnect"}, at={@At(value="RETURN")})
    private void paradigm$clearJoinSuppression(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        SUPPRESS_JOIN_BROADCAST.remove();
    }

    @Inject(method={"broadcast(Lnet/minecraft/text/Text;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void paradigm$maybeSuppressBroadcast(class_2561 message, boolean overlay, CallbackInfo ci) {
        if (message == null || !(message.method_10851() instanceof class_2588)) {
            return;
        }
        class_2588 content = (class_2588)message.method_10851();
        String key = content.method_11022();
        if ("multiplayer.player.joined".equals(key)) {
            Boolean suppress = SUPPRESS_JOIN_BROADCAST.get();
            if (Boolean.TRUE.equals(suppress)) {
                ci.cancel();
            }
            return;
        }
        if ("multiplayer.player.left".equals(key)) {
            Services services = Paradigm.getServices();
            if (services == null) {
                return;
            }
            ChatConfigHandler.Config chatConfig = services.getChatConfig();
            if (chatConfig != null && ((Boolean)chatConfig.enableJoinLeaveMessages.value).booleanValue()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"onPlayerConnect"}, at={@At(value="TAIL")})
    private void sendCustomJoinMessage(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        Services services = Paradigm.getServices();
        if (services == null) {
            return;
        }
        ChatConfigHandler.Config chatConfig = services.getChatConfig();
        if (!((Boolean)chatConfig.enableJoinLeaveMessages.value).booleanValue() && !((Boolean)chatConfig.enableFirstJoinMessage.value).booleanValue()) {
            return;
        }
        IPlatformAdapter platform = services.getPlatformAdapter();
        if (platform == null) {
            return;
        }
        boolean isFirstJoin = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15389)) == 0;
        String messageFormat = null;
        if (isFirstJoin && ((Boolean)chatConfig.enableFirstJoinMessage.value).booleanValue()) {
            messageFormat = (String)chatConfig.firstJoinMessageFormat.value;
        } else if (((Boolean)chatConfig.enableJoinLeaveMessages.value).booleanValue()) {
            messageFormat = (String)chatConfig.joinMessageFormat.value;
        }
        if (messageFormat != null && !messageFormat.isEmpty()) {
            IPlayer iPlayer = platform.wrapPlayer(player);
            class_2561 formattedMessage = services.getMessageParser().parseMessage(messageFormat, iPlayer).getOriginalText();
            platform.broadcastSystemMessage(formattedMessage);
        }
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void onPlayerRemoveMixin(class_3222 player, CallbackInfo ci) {
        Services services = Paradigm.getServices();
        if (services == null) {
            return;
        }
        ChatConfigHandler.Config chatConfig = services.getChatConfig();
        if (!((Boolean)chatConfig.enableJoinLeaveMessages.value).booleanValue()) {
            return;
        }
        IPlatformAdapter platform = services.getPlatformAdapter();
        if (platform == null) {
            return;
        }
        String leaveMessageFormat = (String)chatConfig.leaveMessageFormat.value;
        if (leaveMessageFormat != null && !leaveMessageFormat.isEmpty()) {
            IPlayer iPlayer = platform.wrapPlayer(player);
            class_2561 formattedMessage = services.getMessageParser().parseMessage(leaveMessageFormat, iPlayer).getOriginalText();
            platform.broadcastSystemMessage(formattedMessage);
        }
    }
}

