/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7157;

public class Restart
implements ParadigmModule {
    private static final String NAME = "Restart";
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("00");
    private Services services;
    private IPlatformAdapter platform;
    private final AtomicBoolean restartInProgress = new AtomicBoolean(false);
    private ScheduledFuture<?> mainTaskFuture = null;
    private final List<ScheduledFuture<?>> warningFutures = new ArrayList();
    private ScheduledFuture<?> shutdownFuture = null;
    private final List<ScheduledFuture<?>> preCommandFutures = new ArrayList();
    private final Set<Integer> sentWarningMoments = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getMainConfig().restartEnable.value;
    }

    @Override
    public void onLoad(Object event, Services services, Object modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("Restart module loaded.");
    }

    @Override
    public void onServerStarting(Object event, Services services) {
        if (this.isEnabled(services)) {
            services.getDebugLogger().debugLog("Restart: Server is starting, scheduling restarts.");
            this.scheduleNextRestart(services);
        }
    }

    @Override
    public void onEnable(Services services) {
        if (services.getMinecraftServer() != null) {
            services.getDebugLogger().debugLog("Restart: Module enabled (deferring restart scheduling to onServerStarting).");
        }
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("Restart: Module disabled, cancelling any scheduled restarts.");
        this.cancelAndCleanup();
    }

    @Override
    public void onServerStopping(Object event, Services services) {
        this.cancelAndCleanup();
    }

    private void cancelAndCleanup() {
        this.services.getDebugLogger().debugLog("Restart: Initiating cleanup process.");
        if (this.mainTaskFuture != null && !this.mainTaskFuture.isDone()) {
            this.mainTaskFuture.cancel(false);
            this.services.getDebugLogger().debugLog("Restart: Main restart task future cancelled.");
        }
        this.mainTaskFuture = null;
        for (ScheduledFuture<?> f : this.warningFutures) {
            if (f == null || f.isDone()) continue;
            f.cancel(false);
        }
        this.warningFutures.clear();
        for (ScheduledFuture<?> f : this.preCommandFutures) {
            if (f == null || f.isDone()) continue;
            f.cancel(false);
        }
        this.preCommandFutures.clear();
        if (this.shutdownFuture != null && !this.shutdownFuture.isDone()) {
            this.shutdownFuture.cancel(false);
        }
        this.shutdownFuture = null;
        this.sentWarningMoments.clear();
        this.restartInProgress.set(false);
        if (this.services != null && this.platform != null) {
            this.platform.removeRestartBossBar();
        }
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, Services services) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restart").requires(source -> source.method_9259(2) || source.method_43737() && services.getPermissionsHandler().hasPermission(source.method_44023(), "paradigm.restart.manage"))).then(class_2170.method_9247((String)"now").executes(context -> {
            services.getDebugLogger().debugLog("Restart: /restart now command executed by " + ((class_2168)context.getSource()).method_9223().getString());
            if (this.restartInProgress.get()) {
                services.getDebugLogger().debugLog("Restart: /restart now overriding active restart sequence.");
                this.cancelAndCleanup();
            }
            this.initiateRestartSequence(60.0, services, services.getRestartConfig());
            this.platform.sendSuccess((class_2168)context.getSource(), (class_2561)this.platform.createLiteralComponent("Initiating immediate 60-second restart sequence."), true);
            return 1;
        }))).then(class_2170.method_9247((String)"cancel").executes(context -> {
            services.getDebugLogger().debugLog("Restart: /restart cancel command executed by " + ((class_2168)context.getSource()).method_9223().getString());
            if (this.restartInProgress.get()) {
                this.cancelAndCleanup();
                this.scheduleNextRestart(services);
                this.platform.sendSuccess((class_2168)context.getSource(), (class_2561)this.platform.createLiteralComponent("The active server restart has been cancelled."), true);
            } else {
                this.platform.sendFailure((class_2168)context.getSource(), (class_2561)this.platform.createLiteralComponent("No restart is currently scheduled to be cancelled."));
            }
            return 1;
        })));
    }

    @Override
    public void registerEventListeners(Object eventBus, Services services) {
    }

    private void scheduleNextRestart(Services services) {
        this.cancelAndCleanup();
        RestartConfigHandler.Config config = services.getRestartConfig();
        String restartType = (String)config.restartType.value;
        long delayMillis = -1L;
        services.getDebugLogger().debugLog("Restart: Scheduling restarts with type: " + restartType);
        if ("fixed".equalsIgnoreCase(restartType)) {
            double intervalHours = (Double)config.restartInterval.value;
            if (intervalHours > 0.0) {
                delayMillis = (long)(intervalHours * 3600.0 * 1000.0);
                services.getDebugLogger().debugLog("Restart: Scheduling next fixed restart in " + intervalHours + " hours.");
            }
        } else if ("realtime".equalsIgnoreCase(restartType)) {
            delayMillis = this.getNextRealTimeDelay(config, services);
        }
        if (delayMillis > 0L) {
            double totalSeconds = (double)delayMillis / 1000.0;
            services.getDebugLogger().debugLog("Restart: Starting restart countdown now for " + totalSeconds + " seconds.");
            this.initiateRestartSequence(totalSeconds, services, config);
        } else {
            services.getDebugLogger().debugLog("Restart: No valid restart delay computed. Skipping schedule.");
        }
    }

    private long getNextRealTimeDelay(RestartConfigHandler.Config config, Services services) {
        List realTimeIntervals = (List)config.realTimeInterval.value;
        if (realTimeIntervals == null || realTimeIntervals.isEmpty()) {
            services.getDebugLogger().debugLog("Restart: Real-time restart intervals are not configured.");
            return -1L;
        }
        long minDelayMillis = Long.MAX_VALUE;
        String nextRestartTimeStr = "N/A";
        for (String restartTimeStr : realTimeIntervals) {
            try {
                long delay;
                SimpleDateFormat format = new SimpleDateFormat("HH:mm");
                Calendar restartCal = Calendar.getInstance();
                restartCal.setTime(format.parse(restartTimeStr));
                Calendar currentDay = Calendar.getInstance();
                restartCal.set(1, currentDay.get(1));
                restartCal.set(2, currentDay.get(2));
                restartCal.set(5, currentDay.get(5));
                restartCal.set(13, 0);
                if (restartCal.getTimeInMillis() <= System.currentTimeMillis()) {
                    restartCal.add(5, 1);
                }
                if ((delay = restartCal.getTimeInMillis() - System.currentTimeMillis()) >= minDelayMillis) continue;
                minDelayMillis = delay;
                nextRestartTimeStr = format.format(restartCal.getTime());
            }
            catch (ParseException e) {
                services.getDebugLogger().debugLog("Restart: Error parsing restart time: " + restartTimeStr, e);
            }
        }
        if (minDelayMillis != Long.MAX_VALUE) {
            services.getDebugLogger().debugLog("Restart: Next real-time restart is scheduled for " + nextRestartTimeStr + " (in " + minDelayMillis / 1000L + " seconds).");
            return minDelayMillis;
        }
        services.getDebugLogger().debugLog("Restart: No upcoming real-time restart found for today.");
        return -1L;
    }

    private boolean isAsEachPlayerDirective(String commandText) {
        if (commandText == null) {
            return false;
        }
        String trimmed = commandText.trim();
        return trimmed.startsWith("asplayer:") || trimmed.startsWith("each:") || trimmed.startsWith("[asPlayer]");
    }

    private String stripAsEachPlayerDirective(String commandText) {
        String trimmed = commandText.trim();
        if (trimmed.startsWith("[asPlayer]")) {
            return trimmed.substring("[asPlayer]".length()).trim();
        }
        if (trimmed.startsWith("asplayer:")) {
            return trimmed.substring("asplayer:".length()).trim();
        }
        if (trimmed.startsWith("each:")) {
            return trimmed.substring("each:".length()).trim();
        }
        return commandText;
    }

    private void initiateRestartSequence(double totalIntervalSeconds, Services services, RestartConfigHandler.Config config) {
        if (!this.restartInProgress.compareAndSet(false, true)) {
            services.getDebugLogger().debugLog("Restart: Restart sequence already in progress. Ignoring new trigger.");
            return;
        }
        this.sentWarningMoments.clear();
        services.getDebugLogger().debugLog("Restart: Initiating restart sequence. Total duration: " + totalIntervalSeconds + " seconds.");
        long totalIntervalMillis = (long)(totalIntervalSeconds * 1000.0);
        ArrayList broadcastTimes = new ArrayList((Collection)config.timerBroadcast.value);
        broadcastTimes.sort(Collections.reverseOrder());
        services.getDebugLogger().debugLog("Restart: Scheduling " + broadcastTimes.size() + " warning messages.");
        Iterator iterator = broadcastTimes.iterator();
        while (iterator.hasNext()) {
            ScheduledFuture<?> future;
            int broadcastTimeSec = (Integer)iterator.next();
            long delayUntilWarning = totalIntervalMillis - (long)broadcastTimeSec * 1000L;
            if (delayUntilWarning < 0L || (future = services.getTaskScheduler().schedule(() -> {
                if (!this.restartInProgress.get()) {
                    return;
                }
                if (!this.sentWarningMoments.add(broadcastTimeSec)) {
                    services.getDebugLogger().debugLog("Restart: Duplicate warning suppressed. Time left: " + broadcastTimeSec + "s.");
                    return;
                }
                this.sendRestartWarning(broadcastTimeSec, services, config, totalIntervalSeconds);
            }, delayUntilWarning, TimeUnit.MILLISECONDS)) == null) continue;
            this.warningFutures.add(future);
        }
        List preCommands = (List)config.preRestartCommands.value;
        if (preCommands != null && !preCommands.isEmpty()) {
            for (RestartConfigHandler.PreRestartCommand pre : preCommands) {
                String commandText;
                int secondsBefore = Math.max(0, pre.secondsBefore);
                long delayUntilRun = totalIntervalMillis - (long)secondsBefore * 1000L;
                if (delayUntilRun < 0L) {
                    services.getDebugLogger().debugLog("Restart: Pre-restart command scheduled too early (" + pre.secondsBefore + "s before) and will be skipped: " + pre.command);
                    continue;
                }
                String string = commandText = pre.command == null ? "" : pre.command;
                ScheduledFuture<?> f = services.getTaskScheduler().schedule(() -> {
                    if (!this.restartInProgress.get()) {
                        return;
                    }
                    if (this.isAsEachPlayerDirective(commandText)) {
                        String raw = this.stripAsEachPlayerDirective(commandText);
                        List<class_3222> players = this.platform.getOnlinePlayers();
                        services.getDebugLogger().debugLog("Restart: Executing pre-restart player-commands (" + secondsBefore + "s before) for " + players.size() + " players: " + raw);
                        for (class_3222 sp : players) {
                            String perPlayer = this.platform.replacePlaceholders(raw, sp);
                            try {
                                class_2168 src = sp.method_5671();
                                this.platform.executeCommandAs(src, perPlayer);
                            }
                            catch (Exception ex) {
                                services.getDebugLogger().debugLog("Restart: Failed executing as player " + this.platform.getPlayerName(sp) + ": " + perPlayer, ex);
                            }
                        }
                    } else {
                        String replaced = this.platform.replacePlaceholders(commandText, null);
                        services.getDebugLogger().debugLog("Restart: Executing pre-restart console command (" + secondsBefore + "s before): " + replaced);
                        this.platform.executeCommandAsConsole(replaced);
                    }
                }, delayUntilRun, TimeUnit.MILLISECONDS);
                if (f == null) continue;
                this.preCommandFutures.add(f);
            }
        }
        this.shutdownFuture = services.getTaskScheduler().schedule(() -> {
            if (!this.restartInProgress.get()) {
                return;
            }
            this.performShutdown(services, config);
        }, totalIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private void sendRestartWarning(long timeLeftSeconds, Services services, RestartConfigHandler.Config config, double originalTotalIntervalSeconds) {
        if (services.getMinecraftServer() == null) {
            services.getDebugLogger().debugLog("Restart: Server instance is null, cannot send restart warning.");
            return;
        }
        services.getDebugLogger().debugLog("Restart: Sending restart warning. Time left: " + timeLeftSeconds + "s.");
        List<class_3222> players = this.platform.getOnlinePlayers();
        for (class_3222 playerEntity : players) {
            String titleMessage;
            IPlayer player = this.platform.wrapPlayer(playerEntity);
            int hours = (int)(timeLeftSeconds / 3600L);
            int minutes = (int)(timeLeftSeconds % 3600L / 60L);
            int seconds = (int)(timeLeftSeconds % 60L);
            String formattedTime = String.format("%dh %sm %ss", hours, TIME_FORMATTER.format(minutes), TIME_FORMATTER.format(seconds));
            String chatMessage = config.BroadcastMessage.value != null ? ((String)config.BroadcastMessage.value).replace("{time}", formattedTime).replace("{minutes}", TIME_FORMATTER.format(minutes)).replace("{seconds}", TIME_FORMATTER.format(seconds)) : "";
            String string = titleMessage = config.titleMessage.value != null ? ((String)config.titleMessage.value).replace("{time}", formattedTime).replace("{minutes}", TIME_FORMATTER.format(minutes)).replace("{seconds}", TIME_FORMATTER.format(seconds)) : "";
            if (((Boolean)config.timerUseChat.value).booleanValue()) {
                this.platform.sendSystemMessage(player.getOriginalPlayer(), services.getMessageParser().parseMessage(chatMessage, player).getOriginalText());
            }
            if (((Boolean)config.titleEnabled.value).booleanValue()) {
                this.platform.sendTitle(player.getOriginalPlayer(), services.getMessageParser().parseMessage(titleMessage, player).getOriginalText(), (class_2561)class_2561.method_43473());
            }
            if (!((Boolean)config.playSoundEnabled.value).booleanValue() || !((double)timeLeftSeconds <= (Double)config.playSoundFirstTime.value)) continue;
            this.platform.playSound(player.getOriginalPlayer(), "minecraft:block.note_block.pling", class_3419.field_15250, 1.0f, 1.0f);
        }
        if (((Boolean)config.bossbarEnabled.value).booleanValue()) {
            int hours = (int)(timeLeftSeconds / 3600L);
            int minutes = (int)(timeLeftSeconds % 3600L / 60L);
            int seconds = (int)(timeLeftSeconds % 60L);
            String formattedTime = String.format("%dh %sm %ss", hours, TIME_FORMATTER.format(minutes), TIME_FORMATTER.format(seconds));
            float progress = Math.max(0.0f, (float)timeLeftSeconds / (float)Math.max(1.0, originalTotalIntervalSeconds));
            String bossBarMessage = config.bossBarMessage.value != null ? ((String)config.bossBarMessage.value).replace("{time}", formattedTime).replace("{minutes}", TIME_FORMATTER.format(minutes)).replace("{seconds}", TIME_FORMATTER.format(seconds)) : "";
            this.platform.createOrUpdateRestartBossBar(services.getMessageParser().parseMessage(bossBarMessage, null).getOriginalText(), IPlatformAdapter.BossBarColor.RED, progress);
        }
    }

    private void performShutdown(Services services, RestartConfigHandler.Config config) {
        if (!this.restartInProgress.get()) {
            return;
        }
        services.getDebugLogger().debugLog("Restart: Initiating final shutdown procedure.");
        class_2561 kickMessage = services.getMessageParser().parseMessage((String)config.defaultRestartReason.value, null).getOriginalText();
        this.platform.shutdownServer(kickMessage);
    }

    public void rescheduleNextRestart(Services services) {
        if (services == null) {
            return;
        }
        this.services = services;
        this.cancelAndCleanup();
        this.scheduleNextRestart(services);
    }
}

