/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules.chat;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.data.PlayerGroupData;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import eu.avalanche7.paradigm.utils.GroupChatManager;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_7471;

public class GroupChat
implements ParadigmModule {
    private static final String NAME = "GroupChat";
    private GroupChatManager groupChatManager;
    private Services services;
    private IPlatformAdapter platform;

    public GroupChat(GroupChatManager groupChatManager) {
        this.groupChatManager = groupChatManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        if (services == null || services.getChatConfig() == null) {
            return true;
        }
        return Boolean.TRUE.equals(services.getChatConfig().enableGroupChat.value);
    }

    @Override
    public void onLoad(Object event, Services services, Object modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("GroupChat module loaded.");
    }

    @Override
    public void onServerStarting(Object event, Services services) {
        services.getDebugLogger().debugLog("GroupChat module: Server starting.");
    }

    @Override
    public void onEnable(Services services) {
        services.getDebugLogger().debugLog("GroupChat module enabled.");
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("GroupChat module disabled.");
        if (this.groupChatManager != null) {
            this.groupChatManager.clearAllGroupsAndPlayerData();
        }
    }

    @Override
    public void onServerStopping(Object event, Services services) {
        services.getDebugLogger().debugLog("GroupChat module: Server stopping.");
        this.onDisable(services);
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, Services services) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"groupchat").requires(source -> source.method_43737() && services.getPermissionsHandler().hasPermission(source.method_44023(), "paradigm.groupchat"))).executes(ctx -> {
            this.displayHelp(((class_2168)ctx.getSource()).method_44023(), services);
            return 1;
        })).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String groupName = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return this.groupChatManager.createGroup(((class_2168)ctx.getSource()).method_44023(), groupName) ? 1 : 0;
        })))).then(class_2170.method_9247((String)"delete").executes(ctx -> this.groupChatManager.deleteGroup(((class_2168)ctx.getSource()).method_44023()) ? 1 : 0))).then(class_2170.method_9247((String)"invite").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_3222 target = class_2186.method_9315((CommandContext)ctx, (String)"player");
            return this.groupChatManager.invitePlayer(((class_2168)ctx.getSource()).method_44023(), target) ? 1 : 0;
        })))).then(class_2170.method_9247((String)"join").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String groupName = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return this.groupChatManager.joinGroup(((class_2168)ctx.getSource()).method_44023(), groupName) ? 1 : 0;
        })))).then(class_2170.method_9247((String)"accept").then(class_2170.method_9244((String)"groupname", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String groupName = StringArgumentType.getString((CommandContext)ctx, (String)"groupname");
            return this.groupChatManager.acceptInvite(((class_2168)ctx.getSource()).method_44023(), groupName) ? 1 : 0;
        })))).then(class_2170.method_9247((String)"deny").then(class_2170.method_9244((String)"groupname", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String groupName = StringArgumentType.getString((CommandContext)ctx, (String)"groupname");
            return this.groupChatManager.denyInvite(((class_2168)ctx.getSource()).method_44023(), groupName) ? 1 : 0;
        })))).then(class_2170.method_9247((String)"request").then(class_2170.method_9244((String)"groupname", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String groupName = StringArgumentType.getString((CommandContext)ctx, (String)"groupname");
            this.groupChatManager.requestJoinGroup(((class_2168)ctx.getSource()).method_44023(), groupName);
            return 1;
        })))).then(class_2170.method_9247((String)"acceptreq").then(class_2170.method_9244((String)"playername", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"playername");
            return this.groupChatManager.acceptJoinRequest(((class_2168)ctx.getSource()).method_44023(), playerName) ? 1 : 0;
        })))).then(class_2170.method_9247((String)"denyreq").then(class_2170.method_9244((String)"playername", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"playername");
            return this.groupChatManager.denyJoinRequest(((class_2168)ctx.getSource()).method_44023(), playerName) ? 1 : 0;
        })))).then(class_2170.method_9247((String)"requests").executes(ctx -> {
            this.groupChatManager.listJoinRequests(((class_2168)ctx.getSource()).method_44023());
            return 1;
        }))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            this.groupChatManager.listGroups(((class_2168)ctx.getSource()).method_44023());
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String groupName = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            this.groupChatManager.groupInfo(((class_2168)ctx.getSource()).method_44023(), groupName);
            return 1;
        }))).executes(ctx -> {
            PlayerGroupData data = this.groupChatManager.getPlayerData(((class_2168)ctx.getSource()).method_44023());
            String currentGroup = data.getCurrentGroup();
            if (currentGroup != null) {
                this.groupChatManager.groupInfo(((class_2168)ctx.getSource()).method_44023(), currentGroup);
            } else {
                this.platform.sendSystemMessage(((class_2168)ctx.getSource()).method_44023(), services.getLang().translate("group.no_group_to_info"));
            }
            return 1;
        }))).then(class_2170.method_9247((String)"say").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String message = StringArgumentType.getString((CommandContext)ctx, (String)"message");
            this.groupChatManager.sendMessageFromCommand(((class_2168)ctx.getSource()).method_44023(), message);
            return 1;
        })))).then(class_2170.method_9247((String)"toggle").executes(ctx -> {
            this.groupChatManager.toggleGroupChat(((class_2168)ctx.getSource()).method_44023());
            return 1;
        }))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            this.displayHelp(((class_2168)ctx.getSource()).method_44023(), services);
            return 1;
        })));
    }

    @Override
    public void registerEventListeners(Object eventBus, Services services) {
        if (!this.isEnabled(services)) {
            services.getDebugLogger().debugLog("GroupChat module is disabled by config; skipping event registration.");
            return;
        }
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register(this::handleGroupChatMessage);
    }

    private boolean handleGroupChatMessage(class_7471 message, class_3222 player, class_2556.class_7602 params) {
        if (player == null || message == null) {
            return true;
        }
        if (this.services == null || !this.isEnabled(this.services) || this.groupChatManager == null) {
            return true;
        }
        if (this.groupChatManager.isGroupChatToggled(player)) {
            PlayerGroupData data = this.groupChatManager.getPlayerData(player);
            String groupName = data.getCurrentGroup();
            if (groupName != null) {
                boolean sentToGroup = this.groupChatManager.sendMessageToGroup(player, groupName, message.method_46291().getString());
                if (sentToGroup) {
                    this.services.getLogger().info("[GroupChat] [{}] {}: {}", new Object[]{groupName, player.method_5477().getString(), message.method_46291().getString()});
                }
            } else {
                this.platform.sendSystemMessage(player, this.services.getLang().translate("group.no_group_to_send_message"));
                this.groupChatManager.setGroupChatToggled(player, false);
                this.platform.sendSystemMessage(player, this.services.getLang().translate("group.chat_disabled"));
            }
            return false;
        }
        return true;
    }

    private void displayHelp(class_3222 player, Services services) {
        String label = "groupchat";
        this.platform.sendSystemMessage(player, services.getLang().translate("group.help_title"));
        this.sendHelpMessage(player, label, "create <name>", services.getLang().translate("group.help_create").getString(), services);
        this.sendHelpMessage(player, label, "delete", services.getLang().translate("group.help_delete").getString(), services);
        this.sendHelpMessage(player, label, "invite <player>", services.getLang().translate("group.help_invite").getString(), services);
        this.sendHelpMessage(player, label, "join <group_name>", services.getLang().translate("group.help_join").getString(), services);
        this.sendHelpMessage(player, label, "leave", services.getLang().translate("group.help_leave").getString(), services);
        this.sendHelpMessage(player, label, "list", services.getLang().translate("group.help_list").getString(), services);
        this.sendHelpMessage(player, label, "info [group_name]", services.getLang().translate("group.help_info").getString(), services);
        this.sendHelpMessage(player, label, "say <message>", services.getLang().translate("group.help_say").getString(), services);
        this.sendHelpMessage(player, label, "toggle", services.getLang().translate("group.help_toggle").getString(), services);
        this.sendHelpMessage(player, label, "accept <group_name>", services.getLang().translate("group.help_accept").getString(), services);
        this.sendHelpMessage(player, label, "deny <group_name>", services.getLang().translate("group.help_deny").getString(), services);
        this.sendHelpMessage(player, label, "request <group_name>", services.getLang().translate("group.help_request").getString(), services);
        this.sendHelpMessage(player, label, "acceptreq <player_name>", services.getLang().translate("group.help_acceptreq").getString(), services);
        this.sendHelpMessage(player, label, "denyreq <player_name>", services.getLang().translate("group.help_denyreq").getString(), services);
        this.sendHelpMessage(player, label, "requests", services.getLang().translate("group.help_requests").getString(), services);
    }

    private void sendHelpMessage(class_3222 player, String label, String command, String description, Services services) {
        IPlayer iPlayer = services.getPlatformAdapter().wrapPlayer(player);
        class_2561 parsedDescription = services.getMessageParser().parseMessage(description, iPlayer).getOriginalText();
        class_5250 hoverText = parsedDescription.method_27661();
        hoverText.method_10862(hoverText.method_10866().method_10977(class_124.field_1075));
        class_5250 base = this.platform.createLiteralComponent(" \u00a79> \u00a7e/" + label + " " + command).method_27692(class_124.field_1054);
        IComponent message = this.platform.wrap((class_2561)base).onClickSuggestCommand("/" + label + " " + command).onHoverComponent(this.platform.wrap((class_2561)hoverText));
        this.platform.sendSystemMessage(player, message.getOriginalText());
    }
}

