/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.JsonValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"paradigm");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("paradigm/chat.json");
    public static volatile Config CONFIG = null;
    private static JsonValidator jsonValidator;
    private static volatile boolean isLoaded;

    public static void setJsonValidator(DebugLogger debugLogger) {
        jsonValidator = new JsonValidator(debugLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getConfig() {
        if (isLoaded && CONFIG != null) return CONFIG;
        Class<ChatConfigHandler> clazz = ChatConfigHandler.class;
        synchronized (ChatConfigHandler.class) {
            if (isLoaded && CONFIG != null) return CONFIG;
            ChatConfigHandler.load();
            // ** MonitorExit[var0] (shouldn't be in output)
            return CONFIG;
        }
    }

    public static void load() {
        boolean shouldSaveMerged;
        Config defaultConfig;
        block28: {
            defaultConfig = new Config();
            shouldSaveMerged = false;
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH, StandardCharsets.UTF_8);){
                    int c;
                    StringBuilder content = new StringBuilder();
                    while ((c = ((Reader)reader).read()) != -1) {
                        content.append((char)c);
                    }
                    if (jsonValidator != null) {
                        JsonValidator.ValidationResult result = jsonValidator.validateAndFix(content.toString());
                        if (result.isValid()) {
                            Config loadedConfig;
                            if (result.hasIssues()) {
                                LOGGER.info("[Paradigm] Fixed JSON syntax issues in chat.json: " + result.getIssuesSummary());
                                LOGGER.info("[Paradigm] Saving corrected version to preserve user values");
                                try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                                    writer.write(result.getFixedJson());
                                    LOGGER.info("[Paradigm] Saved corrected chat.json with preserved user values");
                                }
                                catch (IOException saveError) {
                                    LOGGER.warn("[Paradigm] Failed to save corrected file: " + saveError.getMessage());
                                }
                            }
                            if ((loadedConfig = (Config)GSON.fromJson(result.getFixedJson(), Config.class)) != null) {
                                ChatConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                                LOGGER.info("[Paradigm] Successfully loaded chat.json configuration");
                                shouldSaveMerged = true;
                            }
                            break block28;
                        }
                        LOGGER.warn("[Paradigm] Critical JSON syntax errors in chat.json: " + result.getMessage());
                        LOGGER.warn("[Paradigm] Please fix the JSON syntax manually. Using default values for this session.");
                        LOGGER.warn("[Paradigm] Your file has NOT been modified - fix the syntax and restart the server.");
                        break block28;
                    }
                    Config loadedConfig = (Config)GSON.fromJson(content.toString(), Config.class);
                    if (loadedConfig != null) {
                        ChatConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                        shouldSaveMerged = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("[Paradigm] Could not parse chat.json, using defaults for this session.", (Throwable)e);
                    LOGGER.warn("[Paradigm] Your file has NOT been modified. Please check the file manually.");
                }
            } else {
                LOGGER.info("[Paradigm] chat.json not found, generating with default values.");
                CONFIG = defaultConfig;
                ChatConfigHandler.save();
                LOGGER.info("[Paradigm] Generated new chat.json with default values.");
            }
        }
        CONFIG = defaultConfig;
        if (shouldSaveMerged) {
            try {
                ChatConfigHandler.save();
                LOGGER.info("[Paradigm] Synchronized chat.json with new defaults while preserving user values.");
            }
            catch (Exception e) {
                LOGGER.warn("[Paradigm] Failed to write merged chat.json: " + e.getMessage());
            }
        }
        isLoaded = true;
    }

    private static void mergeConfigs(Config defaults, Config loaded) {
        try {
            Field[] fields;
            for (Field field : fields = Config.class.getDeclaredFields()) {
                if (field.getType() != ConfigEntry.class) continue;
                field.setAccessible(true);
                ConfigEntry loadedEntry = (ConfigEntry)field.get(loaded);
                ConfigEntry defaultEntry = (ConfigEntry)field.get(defaults);
                if (loadedEntry != null && loadedEntry.value != null) {
                    defaultEntry.value = loadedEntry.value;
                    LOGGER.debug("[Paradigm] Preserved user setting for: " + field.getName());
                    continue;
                }
                LOGGER.debug("[Paradigm] Using default value for new/missing config: " + field.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("[Paradigm] Error merging chat configs", (Throwable)e);
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Chat config", e);
        }
    }

    static {
        isLoaded = false;
    }

    public static class Config {
        public ConfigEntry<Boolean> enableStaffChat = new ConfigEntry<Boolean>(true, "Enables or disables the entire Staff Chat module.");
        public ConfigEntry<String> staffChatFormat = new ConfigEntry<String>("&f[&cStaff Chat&f] &d%s &7> &f%s", "The format for messages in staff chat. %s is for the player's name, the second %s is for the message.");
        public ConfigEntry<Boolean> enableStaffBossBar = new ConfigEntry<Boolean>(true, "Shows a boss bar at the top of the screen when a staff member has staff chat toggled on.");
        public ConfigEntry<Boolean> enableGroupChat = new ConfigEntry<Boolean>(true, "Enables or disables the Group Chat feature and its commands.");
        public ConfigEntry<Boolean> enableJoinLeaveMessages = new ConfigEntry<Boolean>(true, "Enables or disables custom join and leave messages.");
        public ConfigEntry<String> joinMessageFormat = new ConfigEntry<String>("&a{player_name} &ehas joined the server!", "The format for join messages. Placeholders: {player_name}, {player_uuid}, {player_level}, {player_health}, {max_player_health}.");
        public ConfigEntry<String> leaveMessageFormat = new ConfigEntry<String>("&c{player_name} &ehas left the server!", "The format for leave messages. Placeholders: {player_name}, {player_uuid}, {player_level}, {player_health}, {max_player_health}.");
        public ConfigEntry<Boolean> enableFirstJoinMessage = new ConfigEntry<Boolean>(true, "Enables a special message for a player's very first join.");
        public ConfigEntry<String> firstJoinMessageFormat = new ConfigEntry<String>("&dWelcome, {player_name}, to the server for the first time!", "The format for the first join message. Same placeholders as regular join.");
    }
}

