/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.avalanche7.paradigm.configs.CooldownConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class CommandManager
implements ParadigmModule {
    private static final String NAME = "CustomCommands";
    private Services services;
    private IPlatformAdapter platform;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        return (Boolean)services.getMainConfig().commandManagerEnable.value;
    }

    @Override
    public void onLoad(Object event, Services services, Object modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("CustomCommands module loaded.");
        services.getCmConfig().loadCommands();
        services.getPermissionsHandler().refreshCustomCommandPermissions();
    }

    @Override
    public void onServerStarting(Object event, Services services) {
    }

    @Override
    public void onEnable(Services services) {
    }

    @Override
    public void onDisable(Services services) {
    }

    @Override
    public void onServerStopping(Object event, Services services) {
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, Services services) {
        services.getCmConfig().getLoadedCommands().forEach(command -> {
            if (dispatcher.getRoot().getChild(command.getName()) != null) {
                services.getDebugLogger().debugLog("CustomCommands: Skipping registration of custom command '" + command.getName() + "' because it conflicts with an existing command.");
                return;
            }
            LiteralArgumentBuilder commandBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)command.getName()).requires(source -> this.platform.hasPermissionForCustomCommand((class_2168)source, (CustomCommand)command));
            commandBuilder = command.getArguments().isEmpty() ? (LiteralArgumentBuilder)((LiteralArgumentBuilder)commandBuilder.executes(ctx -> {
                this.executeCustomCommand((class_2168)ctx.getSource(), (CustomCommand)command, new String[0]);
                return 1;
            })).then(class_2170.method_9244((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
                String rawArgs = StringArgumentType.getString((CommandContext)ctx, (String)"args");
                String[] argsTokens = this.tokenizeArgs(rawArgs);
                this.executeCustomCommand((class_2168)ctx.getSource(), (CustomCommand)command, argsTokens);
                return 1;
            })) : this.buildTypedCommand((LiteralArgumentBuilder<class_2168>)commandBuilder, (CustomCommand)command, 0);
            dispatcher.register(commandBuilder);
        });
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"customcommandsreload").requires(source -> source.method_9259(2))).executes(ctx -> {
            services.getCmConfig().reloadCommands();
            services.getPermissionsHandler().refreshCustomCommandPermissions();
            class_2561 message = services.getMessageParser().parseMessage("&aReloaded custom commands from config.", null).getOriginalText();
            this.platform.sendSuccess((class_2168)ctx.getSource(), message, false);
            return 1;
        }));
    }

    @Override
    public void registerEventListeners(Object eventBus, Services services) {
    }

    private LiteralArgumentBuilder<class_2168> buildTypedCommand(LiteralArgumentBuilder<class_2168> builder, CustomCommand command, int argIndex) {
        List<CustomCommand.ArgumentDefinition> args = command.getArguments();
        if (argIndex >= args.size()) {
            return (LiteralArgumentBuilder)builder.executes(ctx -> this.executeTypedCommand((CommandContext<class_2168>)ctx, command, args));
        }
        CustomCommand.ArgumentDefinition argDef = args.get(argIndex);
        RequiredArgumentBuilder argBuilder = this.createArgumentBuilder(argDef);
        argBuilder = argBuilder.suggests(this.createSuggestionProvider(argDef));
        if (!argDef.isRequired()) {
            builder = (LiteralArgumentBuilder)builder.executes(ctx -> this.executeTypedCommand((CommandContext<class_2168>)ctx, command, args));
        }
        argBuilder = argIndex == args.size() - 1 ? (RequiredArgumentBuilder)argBuilder.executes(ctx -> this.executeTypedCommand((CommandContext<class_2168>)ctx, command, args)) : (RequiredArgumentBuilder)argBuilder.then(this.buildNextArgument(command, argIndex + 1));
        return (LiteralArgumentBuilder)builder.then((ArgumentBuilder)argBuilder);
    }

    private RequiredArgumentBuilder<class_2168, ?> buildNextArgument(CustomCommand command, int argIndex) {
        List<CustomCommand.ArgumentDefinition> args = command.getArguments();
        if (argIndex >= args.size()) {
            return class_2170.method_9244((String)"dummy", (ArgumentType)StringArgumentType.string());
        }
        CustomCommand.ArgumentDefinition argDef = args.get(argIndex);
        RequiredArgumentBuilder argBuilder = this.createArgumentBuilder(argDef);
        argBuilder = argBuilder.suggests(this.createSuggestionProvider(argDef));
        if (!argDef.isRequired()) {
            argBuilder = (RequiredArgumentBuilder)argBuilder.executes(ctx -> this.executeTypedCommand((CommandContext<class_2168>)ctx, command, args));
        }
        argBuilder = argIndex == args.size() - 1 ? (RequiredArgumentBuilder)argBuilder.executes(ctx -> this.executeTypedCommand((CommandContext<class_2168>)ctx, command, args)) : (RequiredArgumentBuilder)argBuilder.then(this.buildNextArgument(command, argIndex + 1));
        return argBuilder;
    }

    private RequiredArgumentBuilder<class_2168, ?> createArgumentBuilder(CustomCommand.ArgumentDefinition argDef) {
        switch (argDef.getType()) {
            case "integer": {
                if (argDef.getMinValue() != null && argDef.getMaxValue() != null) {
                    return class_2170.method_9244((String)argDef.getName(), (ArgumentType)IntegerArgumentType.integer((int)argDef.getMinValue(), (int)argDef.getMaxValue()));
                }
                if (argDef.getMinValue() != null) {
                    return class_2170.method_9244((String)argDef.getName(), (ArgumentType)IntegerArgumentType.integer((int)argDef.getMinValue()));
                }
                return class_2170.method_9244((String)argDef.getName(), (ArgumentType)IntegerArgumentType.integer());
            }
            case "boolean": {
                return class_2170.method_9244((String)argDef.getName(), (ArgumentType)BoolArgumentType.bool());
            }
        }
        return class_2170.method_9244((String)argDef.getName(), (ArgumentType)StringArgumentType.string());
    }

    private SuggestionProvider<class_2168> createSuggestionProvider(CustomCommand.ArgumentDefinition argDef) {
        return (ctx, builder) -> {
            switch (argDef.getType()) {
                case "player": {
                    return class_2172.method_9265(this.platform.getOnlinePlayerNames(), (SuggestionsBuilder)builder);
                }
                case "world": {
                    return class_2172.method_9265(this.platform.getWorldNames(), (SuggestionsBuilder)builder);
                }
                case "gamemode": {
                    return class_2172.method_9265(List.of("survival", "creative", "adventure", "spectator"), (SuggestionsBuilder)builder);
                }
                case "custom": {
                    return class_2172.method_9265(argDef.getCustomCompletions(), (SuggestionsBuilder)builder);
                }
                case "boolean": {
                    return class_2172.method_9265(List.of("true", "false"), (SuggestionsBuilder)builder);
                }
            }
            return Suggestions.empty();
        };
    }

    private int executeTypedCommand(CommandContext<class_2168> ctx, CustomCommand command, List<CustomCommand.ArgumentDefinition> argDefs) {
        class_2168 source = (class_2168)ctx.getSource();
        String[] validatedArgs = new String[argDefs.size()];
        for (int i = 0; i < argDefs.size(); ++i) {
            CustomCommand.ArgumentDefinition argDef = argDefs.get(i);
            try {
                Object value = this.getArgumentValue(ctx, argDef);
                if (value == null && argDef.isRequired()) {
                    class_3222 sp;
                    class_1297 class_12972 = source.method_9228();
                    class_3222 player = class_12972 instanceof class_3222 ? (sp = (class_3222)class_12972) : null;
                    IPlayer iPlayer = player != null ? this.platform.wrapPlayer(player) : null;
                    this.platform.sendFailure(source, this.services.getMessageParser().parseMessage(argDef.getErrorMessage(), iPlayer).getOriginalText());
                    return 0;
                }
                validatedArgs[i] = value != null ? value.toString() : "";
                continue;
            }
            catch (Exception e) {
                class_3222 sp;
                class_1297 class_12973 = source.method_9228();
                class_3222 player = class_12973 instanceof class_3222 ? (sp = (class_3222)class_12973) : null;
                IPlayer iPlayer = player != null ? this.platform.wrapPlayer(player) : null;
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage(argDef.getErrorMessage(), iPlayer).getOriginalText());
                return 0;
            }
        }
        this.executeCustomCommand(source, command, validatedArgs);
        return 1;
    }

    private Object getArgumentValue(CommandContext<class_2168> ctx, CustomCommand.ArgumentDefinition argDef) {
        try {
            switch (argDef.getType()) {
                case "integer": {
                    return IntegerArgumentType.getInteger(ctx, (String)argDef.getName());
                }
                case "boolean": {
                    return BoolArgumentType.getBool(ctx, (String)argDef.getName());
                }
            }
            return StringArgumentType.getString(ctx, (String)argDef.getName());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void executeCustomCommand(class_2168 source, CustomCommand command, String[] argsTokens) {
        class_3222 sp;
        class_3222 player;
        class_1297 class_12972 = source.method_9228();
        class_3222 class_32222 = player = class_12972 instanceof class_3222 ? (sp = (class_3222)class_12972) : null;
        if (command.isRequirePermission() && player != null && !this.services.getPermissionsHandler().hasPermission(player, command.getPermission())) {
            IPlayer iPlayer = this.platform.wrapPlayer(player);
            this.platform.sendFailure(source, this.services.getMessageParser().parseMessage(command.getPermissionErrorMessage(), iPlayer).getOriginalText());
            return;
        }
        CustomCommand.AreaRestriction area = command.getAreaRestriction();
        if (area != null) {
            if (player == null) {
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cThis command can only be run by a player in a specific area.", null).getOriginalText());
                return;
            }
            if (!this.platform.isPlayerInArea(player, area.getWorld(), area.getCorner1(), area.getCorner2())) {
                IPlayer iPlayer = this.platform.wrapPlayer(player);
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage(area.getRestrictionMessage(), iPlayer).getOriginalText());
                return;
            }
        }
        if (command.getCooldownSeconds() != null && command.getCooldownSeconds() > 0 && player != null) {
            this.services.getCooldownConfigHandler();
            long lastUsage = CooldownConfigHandler.getLastUsage(player.method_5667(), command.getName());
            long cooldownMillis = (long)command.getCooldownSeconds().intValue() * 1000L;
            long currentTime = System.currentTimeMillis();
            if (currentTime < lastUsage + cooldownMillis) {
                long remainingMillis = lastUsage + cooldownMillis - currentTime;
                long remainingSeconds = remainingMillis / 1000L + (long)(remainingMillis % 1000L > 0L ? 1 : 0);
                String cooldownMessage = command.getCooldownMessage();
                if (cooldownMessage == null || cooldownMessage.isEmpty()) {
                    cooldownMessage = "&cThis command is on cooldown! Please wait &e{remaining_time} &cseconds.";
                }
                String formattedMessage = cooldownMessage.replace("{remaining_time}", String.valueOf(remainingSeconds));
                IPlayer iPlayer = player != null ? this.platform.wrapPlayer(player) : null;
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage(formattedMessage, iPlayer).getOriginalText());
                return;
            }
            this.services.getCooldownConfigHandler();
            CooldownConfigHandler.setLastUsage(player.method_5667(), command.getName(), currentTime);
        }
        String rawArgs = String.join((CharSequence)" ", argsTokens);
        this.executeActions(source, command.getActions(), player, argsTokens, rawArgs);
    }

    private String[] tokenizeArgs(String rawArgs) {
        if (rawArgs == null || rawArgs.isBlank()) {
            return new String[0];
        }
        return rawArgs.trim().split("\\s+");
    }

    private void executeActions(class_2168 source, List<CustomCommand.Action> actions, class_3222 player, String[] argsTokens, String rawArgs) {
        if (actions == null) {
            return;
        }
        block15: for (CustomCommand.Action action : actions) {
            switch (action.getType()) {
                case "message": {
                    if (action.getText() == null) continue block15;
                    for (String line : action.getText()) {
                        String expandedLine = this.expandCommand(line, player, argsTokens, rawArgs);
                        IPlayer iPlayer = player != null ? this.platform.wrapPlayer(player) : null;
                        class_2561 formattedMessage = this.services.getMessageParser().parseMessage(expandedLine, iPlayer).getOriginalText();
                        this.platform.sendSuccess(source, formattedMessage, false);
                    }
                    continue block15;
                }
                case "teleport": {
                    if (player != null && action.getX() != null && action.getY() != null && action.getZ() != null) {
                        this.platform.teleportPlayer(player, action.getX().intValue(), action.getY().intValue(), action.getZ().intValue());
                        break;
                    }
                    if (player == null) {
                        this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cTeleport action can only be performed by a player.", null).getOriginalText());
                        break;
                    }
                    Iterator<String> iPlayer = player != null ? this.platform.wrapPlayer(player) : null;
                    this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cInvalid teleport coordinates.", (IPlayer)((Object)iPlayer)).getOriginalText());
                    break;
                }
                case "run_command": 
                case "runcmd": {
                    String processed;
                    if (action.getCommands() == null) continue block15;
                    for (String cmd : action.getCommands()) {
                        processed = this.expandCommand(cmd, player, argsTokens, rawArgs);
                        this.platform.executeCommandAs(source, processed);
                    }
                    continue block15;
                }
                case "run_console": {
                    String processed;
                    if (action.getCommands() == null) continue block15;
                    for (String cmd : action.getCommands()) {
                        processed = this.expandCommand(cmd, player, argsTokens, rawArgs);
                        this.platform.executeCommandAsConsole(processed);
                    }
                    continue block15;
                }
                case "conditional": {
                    if (this.checkAllConditions(source, action.getConditions(), player)) {
                        this.executeActions(source, action.getOnSuccess(), player, argsTokens, rawArgs);
                        break;
                    }
                    this.executeActions(source, action.getOnFailure(), player, argsTokens, rawArgs);
                    break;
                }
                default: {
                    Iterator<String> iPlayer = player != null ? this.platform.wrapPlayer(player) : null;
                    this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cUnknown action type: " + action.getType(), (IPlayer)((Object)iPlayer)).getOriginalText());
                }
            }
        }
    }

    private String expandCommand(String cmd, class_3222 player, String[] argsTokens, String rawArgs) {
        String out = this.platform.replacePlaceholders(cmd, player);
        if (out.contains("$*")) {
            out = out.replace("$*", rawArgs == null ? "" : rawArgs);
        }
        for (int i = 0; i < argsTokens.length; ++i) {
            String token = "$" + (i + 1);
            if (!out.contains(token)) continue;
            String argValue = argsTokens[i];
            if (argValue == null || argValue.isEmpty()) {
                argValue = "";
            }
            out = out.replace(token, argValue);
        }
        out = out.replaceAll("\\$(?:[1-9][0-9]*)", "");
        return out.trim();
    }

    private boolean checkAllConditions(class_2168 source, List<CustomCommand.Condition> conditions, class_3222 player) {
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (CustomCommand.Condition condition : conditions) {
            if (this.checkCondition(source, condition, player)) continue;
            return false;
        }
        return true;
    }

    private boolean checkCondition(class_2168 source, CustomCommand.Condition condition, class_3222 player) {
        boolean result = false;
        if (player == null) {
            switch (condition.getType()) {
                case "has_permission": 
                case "has_item": 
                case "is_op": {
                    this.services.getDebugLogger().debugLog("Conditional check '" + condition.getType() + "' requires a player, but was run from console. Failing condition.");
                    return false;
                }
            }
        }
        switch (condition.getType()) {
            case "has_permission": {
                if (player == null || condition.getValue() == null) break;
                result = this.platform.hasPermission(player, condition.getValue());
                break;
            }
            case "has_item": {
                if (player == null || condition.getValue() == null) break;
                result = this.platform.playerHasItem(player, condition.getValue(), condition.getItemAmount());
                break;
            }
            case "is_op": {
                if (player == null) break;
                int level = 2;
                try {
                    if (condition.getValue() != null) {
                        level = Integer.parseInt(condition.getValue());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                result = this.platform.hasPermission(player, "minecraft.command.op", level);
                break;
            }
            default: {
                IPlayer iPlayer = player != null ? this.platform.wrapPlayer(player) : null;
                this.platform.sendFailure(source, this.services.getMessageParser().parseMessage("&cUnknown condition type: " + condition.getType(), iPlayer).getOriginalText());
                return false;
            }
        }
        return condition.isNegate() != result;
    }
}

