/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TelemetryReporter {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final String ENDPOINT = "https://arcturus-official.eu/paradigm/telemetry";
    private final Services services;
    private volatile boolean active = false;

    public TelemetryReporter(Services services) {
        this.services = services;
    }

    public void start() {
        if (!((Boolean)MainConfigHandler.CONFIG.telemetryEnable.value).booleanValue()) {
            return;
        }
        if (MainConfigHandler.CONFIG.telemetryServerId.value == null || ((String)MainConfigHandler.CONFIG.telemetryServerId.value).isBlank()) {
            MainConfigHandler.CONFIG.telemetryServerId.value = UUID.randomUUID().toString();
            MainConfigHandler.save();
        }
        int interval = Math.max(60, MainConfigHandler.CONFIG.telemetryIntervalSeconds.value == null ? 900 : (Integer)MainConfigHandler.CONFIG.telemetryIntervalSeconds.value);
        this.active = true;
        this.services.getTaskScheduler().scheduleAtFixedRate(this::reportOnceSafe, 10L, interval, TimeUnit.SECONDS);
    }

    public void stop() {
        this.active = false;
    }

    private void reportOnceSafe() {
        if (!this.active) {
            return;
        }
        try {
            this.reportOnce();
        }
        catch (Throwable t) {
            this.services.getDebugLogger().debugLog("TelemetryReporter: send failed: " + String.valueOf(t));
        }
    }

    private void reportOnce() throws Exception {
        IPlatformAdapter platform = this.services.getPlatformAdapter();
        List<class_3222> players = platform.getOnlinePlayers();
        int online = players != null ? players.size() : 0;
        int maxPlayers = 0;
        MinecraftServer srvObj = platform.getMinecraftServer();
        if (srvObj instanceof MinecraftServer) {
            MinecraftServer ms = srvObj;
            maxPlayers = ms.method_3760().method_14592();
        }
        String mcVersion = platform.getMinecraftVersion();
        String modVersion = FabricLoader.getInstance().getModContainer("paradigm").map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
        JsonObject payload = new JsonObject();
        payload.addProperty("timestamp", Instant.now().toString());
        payload.addProperty("serverId", (String)MainConfigHandler.CONFIG.telemetryServerId.value);
        payload.addProperty("mcVersion", mcVersion);
        payload.addProperty("modVersion", modVersion);
        payload.addProperty("onlinePlayers", (Number)online);
        payload.addProperty("maxPlayers", (Number)maxPlayers);
        String json = GSON.toJson((JsonElement)payload);
        HttpURLConnection conn = (HttpURLConnection)URI.create(ENDPOINT).toURL().openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("User-Agent", "Paradigm-Telemetry/1.0");
        conn.setDoOutput(true);
        conn.setConnectTimeout(4000);
        conn.setReadTimeout(6000);
        try (OutputStream os = conn.getOutputStream();){
            os.write(json.getBytes(StandardCharsets.UTF_8));
        }
        int code = conn.getResponseCode();
        if (code < 200 || code >= 300) {
            this.services.getDebugLogger().debugLog("TelemetryReporter: non-2xx response: " + code);
        } else {
            this.services.getDebugLogger().debugLog("TelemetryReporter: sent ok: " + code);
        }
        conn.disconnect();
    }
}

