/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.webeditor;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.configs.MOTDConfigHandler;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.ICommandSource;
import eu.avalanche7.paradigm.webeditor.WebEditorRequest;
import eu.avalanche7.paradigm.webeditor.socket.BytesocksClient;
import eu.avalanche7.paradigm.webeditor.socket.WebEditorSocket;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.fabricmc.loader.api.FabricLoader;

public class WebEditorSession {
    private static final String WEB_EDITOR_URL_PATTERN = "https://paradigm.avalanche7.eu/editor/";
    private static final String BYTEBIN_POST_URL = "https://bytebin.avalanche7.eu/post";
    public static final String BYTEBIN_BASE_URL = "https://bytebin.avalanche7.eu/";
    private static final String BYTESOCKS_HOST = "bytesocks.avalanche7.eu";
    private static final String USER_AGENT = "paradigm/editor";
    private final Services services;
    private final ICommandSource owner;
    private WebEditorRequest initialRequest;

    public WebEditorSession(Services services, WebEditorRequest initialRequest) {
        this(services, initialRequest, null);
    }

    public WebEditorSession(Services services, WebEditorRequest initialRequest, ICommandSource owner) {
        this.services = Objects.requireNonNull(services, "services");
        this.initialRequest = Objects.requireNonNull(initialRequest, "initialRequest");
        this.owner = owner;
    }

    public static WebEditorSession of(Services services, JsonObject payload) {
        return new WebEditorSession(services, new WebEditorRequest(payload));
    }

    public static WebEditorSession of(Services services, JsonObject payload, ICommandSource owner) {
        return new WebEditorSession(services, new WebEditorRequest(payload), owner);
    }

    public String open() {
        return this.createInitialSession();
    }

    private boolean debugEnabled() {
        try {
            return MainConfigHandler.CONFIG.debugEnable.get();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private String createInitialSession() {
        if (this.initialRequest == null) {
            return null;
        }
        WebEditorRequest request = this.initialRequest;
        this.initialRequest = null;
        try {
            WebEditorSocket socket = new WebEditorSocket(this.services, this.owner);
            BytesocksClient client = new BytesocksClient(BYTESOCKS_HOST, USER_AGENT);
            socket.initialize(client);
            socket.appendDetailToRequest(request);
            this.services.getWebEditorStore().sockets().putSocket(socket.getChannelId(), socket);
        }
        catch (Exception e) {
            try {
                this.services.getLogger().warn("Paradigm WebEditor: Unable to establish live editor socket: {}", (Object)e.toString());
            }
            catch (Throwable client) {
                // empty catch block
            }
        }
        String id = this.uploadRequestData(request);
        if (id == null) {
            return null;
        }
        this.services.getWebEditorStore().sessions().addNewSession(id, request);
        String baseUrl = this.getEditorBaseUrl();
        String url = baseUrl + id;
        try {
            this.services.getLogger().info("Paradigm WebEditor session created: {}", (Object)url);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return id;
    }

    private String getEditorBaseUrl() {
        try {
            boolean useTestUrl = MainConfigHandler.CONFIG.webEditorTestUrl.get();
            if (useTestUrl) {
                return "http://localhost:8083/editor/";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return WEB_EDITOR_URL_PATTERN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadRequestData(WebEditorRequest request) {
        byte[] json = request.encodeJson();
        byte[] gz = WebEditorSession.gzip(json);
        if (this.debugEnabled()) {
            try {
                this.services.getLogger().info("Paradigm WebEditor: Uploading initial payload: jsonBytes={}, gzBytes={}, sha1={}", new Object[]{json.length, gz.length, WebEditorSession.sha1Hex(json)});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        HttpURLConnection conn = null;
        try {
            String key;
            conn = (HttpURLConnection)URI.create(BYTEBIN_POST_URL).toURL().openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setConnectTimeout(8000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", USER_AGENT);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Content-Encoding", "gzip");
            conn.setRequestProperty("X-Bytebin-Bucket", "editor");
            conn.setFixedLengthStreamingMode(gz.length);
            try (OutputStream os = conn.getOutputStream();){
                os.write(gz);
            }
            int code = conn.getResponseCode();
            if (code < 200 || code >= 300) {
                try {
                    this.services.getLogger().warn("Paradigm WebEditor: Bytebin POST failed with status {}", (Object)code);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                WebEditorSession.logErrorStreamSafely(this.services, conn);
                String string = null;
                return string;
            }
            String location = conn.getHeaderField("Location");
            if (location != null && !location.isEmpty()) {
                key = WebEditorSession.normalizeKey(location);
            } else {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    String body = sb.toString().trim();
                    key = WebEditorSession.parseKeyFromResponse(body);
                    if (key == null || key.isEmpty()) {
                        try {
                            this.services.getLogger().warn("Paradigm WebEditor: Unable to parse Bytebin response: {}", (Object)body);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        String string = null;
                        return string;
                    }
                    key = WebEditorSession.normalizeKey(key);
                }
            }
            if (this.debugEnabled()) {
                try {
                    this.services.getLogger().info("Paradigm WebEditor: Uploaded initial payload to Bytebin: key={}, url={}{}", new Object[]{key, BYTEBIN_BASE_URL, key});
                }
                catch (Throwable br) {
                    // empty catch block
                }
                boolean accessible = WebEditorSession.verifyBytebinObjectAccessible(key);
                try {
                    this.services.getLogger().info("Paradigm WebEditor: Verified uploaded key accessibility: {} (key={})", (Object)accessible, (Object)key);
                }
                catch (Throwable sb) {
                    // empty catch block
                }
                boolean contentMatch = WebEditorSession.verifyBytebinContentMatches(key, json);
                try {
                    this.services.getLogger().info("Paradigm WebEditor: Verified uploaded content integrity: {} (key={}, sha1={})", new Object[]{contentMatch, key, WebEditorSession.sha1Hex(json)});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String string = key;
            return string;
        }
        catch (Exception e) {
            try {
                this.services.getLogger().warn("Paradigm WebEditor: Failed to upload editor data: {}", (Object)e.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string = null;
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadPayload(Services services, JsonObject payload) {
        byte[] json = new Gson().toJson((JsonElement)payload).getBytes(StandardCharsets.UTF_8);
        byte[] gz = WebEditorSession.gzip(json);
        HttpURLConnection conn = null;
        try {
            String key;
            conn = (HttpURLConnection)URI.create(BYTEBIN_POST_URL).toURL().openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setConnectTimeout(8000);
            conn.setRequestProperty("User-Agent", USER_AGENT);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Content-Encoding", "gzip");
            conn.setRequestProperty("X-Bytebin-Bucket", "editor");
            conn.setFixedLengthStreamingMode(gz.length);
            try (OutputStream os = conn.getOutputStream();){
                os.write(gz);
            }
            int code = conn.getResponseCode();
            if (code < 200 || code >= 300) {
                try {
                    services.getLogger().warn("Paradigm WebEditor: Bytebin POST failed with status {}", (Object)code);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                WebEditorSession.logErrorStreamSafely(services, conn);
                String string = null;
                return string;
            }
            String location = conn.getHeaderField("Location");
            if (location != null && !location.isEmpty()) {
                key = WebEditorSession.normalizeKey(location);
            } else {
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    String body = sb.toString().trim();
                    String id = WebEditorSession.parseKeyFromResponse(body);
                    if (id == null || id.isEmpty()) {
                        String string = null;
                        return string;
                    }
                    key = WebEditorSession.normalizeKey(id);
                }
            }
            try {
                services.getLogger().info("Paradigm WebEditor: Uploaded follow-up payload to Bytebin: key={}, url={}{}", new Object[]{key, BYTEBIN_BASE_URL, key});
            }
            catch (Throwable br) {
                // empty catch block
            }
            if (MainConfigHandler.CONFIG != null) {
                boolean dbg = false;
                try {
                    dbg = MainConfigHandler.CONFIG.debugEnable.get();
                }
                catch (Throwable sb) {
                    // empty catch block
                }
                if (dbg) {
                    boolean accessible = WebEditorSession.verifyBytebinObjectAccessible(key);
                    try {
                        services.getLogger().info("Paradigm WebEditor: Verified follow-up key accessibility: {} (key={})", (Object)accessible, (Object)key);
                    }
                    catch (Throwable line) {
                        // empty catch block
                    }
                    boolean contentMatch = WebEditorSession.verifyBytebinContentMatches(key, json);
                    try {
                        services.getLogger().info("Paradigm WebEditor: Verified follow-up content integrity: {} (key={}, sha1={})", new Object[]{contentMatch, key, WebEditorSession.sha1Hex(json)});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            String string = key;
            return string;
        }
        catch (Exception e) {
            try {
                services.getLogger().warn("Paradigm WebEditor: Failed to upload payload: {}", (Object)e.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string = null;
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static JsonObject buildPayload(Services services) {
        JsonObject files;
        JsonObject root;
        block21: {
            root = new JsonObject();
            JsonObject meta = new JsonObject();
            meta.addProperty("plugin", "Paradigm");
            String version = "unknown";
            try {
                try {
                    version = FabricLoader.getInstance().getModContainer("paradigm").map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
                }
                catch (Throwable ignored) {
                    version = "unknown";
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            meta.addProperty("version", version);
            root.add("metadata", (JsonElement)meta);
            files = new JsonObject();
            files.add("main", new Gson().toJsonTree((Object)MainConfigHandler.CONFIG));
            files.add("announcements", new Gson().toJsonTree((Object)AnnouncementsConfigHandler.CONFIG));
            files.add("chat", new Gson().toJsonTree((Object)ChatConfigHandler.CONFIG));
            files.add("motd", new Gson().toJsonTree((Object)MOTDConfigHandler.getConfig()));
            files.add("mentions", new Gson().toJsonTree((Object)MentionConfigHandler.CONFIG));
            files.add("restart", new Gson().toJsonTree((Object)RestartConfigHandler.CONFIG));
            try {
                Path cfgDir = FabricLoader.getInstance().getConfigDir().resolve("paradigm");
                if (!Files.isDirectory(cfgDir, new LinkOption[0])) break block21;
                try (Stream<Path> stream = Files.list(cfgDir);){
                    stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                        String n = p.getFileName().toString().toLowerCase(Locale.ROOT);
                        return n.endsWith(".json");
                    }).forEach(p -> {
                        String name = p.getFileName().toString();
                        String base = name.substring(0, name.length() - 5);
                        String key = base.toLowerCase(Locale.ROOT);
                        if (files.has(key)) {
                            return;
                        }
                        try {
                            String content = Files.readString(p, StandardCharsets.UTF_8);
                            JsonElement parsed = JsonParser.parseString((String)content);
                            if (parsed != null) {
                                files.add(key, parsed);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
            }
            catch (Throwable cfgDir) {
                // empty catch block
            }
        }
        try {
            Path commandsDir = FabricLoader.getInstance().getConfigDir().resolve("paradigm").resolve("commands");
            JsonObject ccRoot = new JsonObject();
            JsonObject ccFiles = new JsonObject();
            JsonArray ccAll = new JsonArray();
            if (Files.isDirectory(commandsDir, new LinkOption[0])) {
                try (Stream<Path> stream = Files.list(commandsDir);){
                    stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".json")).sorted().forEach(p -> {
                        String name = p.getFileName().toString();
                        String base = name.substring(0, name.length() - 5);
                        try {
                            String content = Files.readString(p, StandardCharsets.UTF_8);
                            JsonElement parsed = JsonParser.parseString((String)content);
                            if (parsed != null && parsed.isJsonArray()) {
                                ccFiles.add(base, parsed);
                                for (JsonElement el : parsed.getAsJsonArray()) {
                                    ccAll.add(el);
                                }
                            } else if (parsed != null && parsed.isJsonObject()) {
                                JsonArray arr = new JsonArray();
                                arr.add(parsed);
                                ccFiles.add(base, (JsonElement)arr);
                                ccAll.add(parsed);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                }
            }
            ccRoot.add("files", (JsonElement)ccFiles);
            ccRoot.add("all", (JsonElement)ccAll);
            files.add("customCommands", (JsonElement)ccRoot);
        }
        catch (Throwable commandsDir) {
            // empty catch block
        }
        root.add("files", (JsonElement)files);
        JsonArray sections = WebEditorSession.buildSectionsFromFiles(files);
        root.add("sections", (JsonElement)sections);
        root.addProperty("schemaVersion", (Number)1);
        return root;
    }

    private static JsonArray asArray(String ... values) {
        JsonArray arr = new JsonArray();
        for (String v : values) {
            arr.add(v);
        }
        return arr;
    }

    private static JsonObject arrayOf(JsonObject itemSchema) {
        JsonObject arr = new JsonObject();
        arr.addProperty("type", "array");
        arr.add("item", (JsonElement)itemSchema);
        return arr;
    }

    private static String sha1Hex(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(data);
            StringBuilder sb = new StringBuilder(digest.length * 2);
            for (byte b : digest) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static void logErrorStreamSafely(Services services, HttpURLConnection conn) {
        try {
            String body;
            int read;
            InputStream es = conn.getErrorStream();
            if (es == null) {
                return;
            }
            byte[] buf = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            while ((read = es.read(buf)) != -1) {
                if (read > 0) {
                    baos.write(buf, 0, read);
                }
                if (baos.size() < 2048) continue;
            }
            if (!(body = baos.toString(StandardCharsets.UTF_8)).isEmpty()) {
                try {
                    services.getLogger().warn("Paradigm WebEditor: Bytebin error body: {}", (Object)body);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyBytebinObjectAccessible(String key) {
        HttpURLConnection conn = null;
        try {
            URL url = URI.create(BYTEBIN_BASE_URL + WebEditorSession.normalizeKey(key)).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setRequestProperty("User-Agent", USER_AGENT);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            int code = conn.getResponseCode();
            if (code >= 200 && code < 400) {
                boolean bl = true;
                return bl;
            }
            if (code == 405 || code == 501) {
                conn.disconnect();
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("User-Agent", USER_AGENT);
                conn.setRequestProperty("Range", "bytes=0-0");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                int code2 = conn.getResponseCode();
                boolean bl = code2 >= 200 && code2 < 400;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyBytebinContentMatches(String key, byte[] expectedJson) {
        HttpURLConnection conn = null;
        try {
            String gotSha1;
            int r;
            URL url = URI.create(BYTEBIN_BASE_URL + WebEditorSession.normalizeKey(key)).toURL();
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", USER_AGENT);
            conn.setConnectTimeout(8000);
            conn.setReadTimeout(10000);
            int code = conn.getResponseCode();
            if (code < 200 || code >= 300) {
                boolean bl = false;
                return bl;
            }
            String ce = conn.getHeaderField("Content-Encoding");
            InputStream is = conn.getInputStream();
            if (ce != null && ce.toLowerCase(Locale.ROOT).contains("gzip")) {
                is = new GZIPInputStream(is);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(Math.max(8192, expectedJson.length));
            byte[] buf = new byte[8192];
            while ((r = is.read(buf)) != -1) {
                if (r > 0) {
                    baos.write(buf, 0, r);
                }
                if ((long)baos.size() <= (long)expectedJson.length * 4L + 0x100000L) continue;
            }
            byte[] got = baos.toByteArray();
            String expectedSha1 = WebEditorSession.sha1Hex(expectedJson);
            if (expectedSha1.equals(gotSha1 = WebEditorSession.sha1Hex(got))) {
                boolean bl = true;
                return bl;
            }
            String expectedStr = new String(expectedJson, StandardCharsets.UTF_8).replaceAll("\\s+", "");
            String gotStr = new String(got, StandardCharsets.UTF_8).replaceAll("\\s+", "");
            boolean bl = expectedStr.equals(gotStr);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static String normalizeKey(String locationOrKey) {
        int slash;
        String s = locationOrKey.trim();
        int q = s.indexOf(63);
        if (q != -1) {
            s = s.substring(0, q);
        }
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((slash = s.lastIndexOf(47)) != -1) {
            return s.substring(slash + 1);
        }
        return s;
    }

    private static byte[] gzip(byte[] in) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gz = new GZIPOutputStream(baos);){
                gz.write(in);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            return in;
        }
    }

    private static String parseKeyFromResponse(String body) {
        if (body == null || body.isEmpty()) {
            return null;
        }
        if (body.startsWith("{")) {
            try {
                JsonObject obj = JsonParser.parseString((String)body).getAsJsonObject();
                if (obj.has("key")) {
                    return obj.get("key").getAsString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return body;
    }

    private static JsonArray buildSectionsFromFiles(JsonObject files) {
        JsonArray sections = new JsonArray();
        for (Map.Entry e : files.entrySet()) {
            String key = (String)e.getKey();
            JsonElement value = (JsonElement)e.getValue();
            String title = key.substring(0, 1).toUpperCase(Locale.ROOT) + (key.length() > 1 ? key.substring(1) : "");
            JsonObject section = WebEditorSession.buildSectionFromJson(key, title, value);
            if (section == null) continue;
            sections.add((JsonElement)section);
        }
        return sections;
    }

    private static JsonObject buildSectionFromJson(String key, String title, JsonElement jsonData) {
        JsonObject section = new JsonObject();
        section.addProperty("key", key);
        section.addProperty("title", title);
        section.addProperty("filename", key + ".json");
        JsonObject fields = new JsonObject();
        boolean isEntryMap = false;
        if (jsonData != null && jsonData.isJsonObject()) {
            JsonObject obj = jsonData.getAsJsonObject();
            for (Map.Entry fe : obj.entrySet()) {
                JsonObject fo;
                String fieldKey = (String)fe.getKey();
                JsonElement fieldData = (JsonElement)fe.getValue();
                if (fieldData != null && fieldData.isJsonObject() && (fo = fieldData.getAsJsonObject()).has("value") && fo.has("description")) {
                    JsonArray opts;
                    isEntryMap = true;
                    JsonObject f = new JsonObject();
                    String t = WebEditorSession.inferFieldType(fo.get("value"));
                    f.addProperty("type", t);
                    f.add("default", WebEditorSession.cloneJson(fo.get("value")));
                    f.addProperty("description", WebEditorSession.safeGetAsString(fo.get("description")));
                    f.addProperty("displayName", WebEditorSession.prettifyName(fieldKey));
                    if (WebEditorSession.shouldPreview(fo.get("value"))) {
                        f.addProperty("preview", Boolean.valueOf(true));
                    }
                    if ((opts = WebEditorSession.enumOptionsFor(key, fieldKey, fo.get("value"), f.get("description").getAsString())) != null) {
                        f.add("options", (JsonElement)opts);
                    }
                    fields.add(fieldKey, (JsonElement)f);
                    continue;
                }
                JsonObject f = new JsonObject();
                String t = WebEditorSession.inferFieldType(fieldData);
                f.addProperty("type", t);
                f.add("default", WebEditorSession.cloneJson(fieldData));
                f.addProperty("description", "");
                f.addProperty("displayName", WebEditorSession.prettifyName(fieldKey));
                if (WebEditorSession.shouldPreview(fieldData)) {
                    f.addProperty("preview", Boolean.valueOf(true));
                }
                fields.add(fieldKey, (JsonElement)f);
            }
        } else if (jsonData != null && jsonData.isJsonArray()) {
            f = new JsonObject();
            f.addProperty("type", WebEditorSession.inferFieldType(jsonData));
            f.add("default", WebEditorSession.cloneJson(jsonData));
            f.addProperty("description", "");
            f.addProperty("displayName", WebEditorSession.prettifyName(key));
            fields.add(key, (JsonElement)f);
        } else if (jsonData != null && jsonData.isJsonPrimitive()) {
            f = new JsonObject();
            f.addProperty("type", WebEditorSession.inferFieldType(jsonData));
            f.add("default", WebEditorSession.cloneJson(jsonData));
            f.addProperty("description", "");
            f.addProperty("displayName", WebEditorSession.prettifyName(key));
            fields.add(key, (JsonElement)f);
        }
        String type = "entryMap";
        if (!isEntryMap) {
            if ("motd".equals(key)) {
                type = "plainObject";
            } else {
                boolean allSimple = true;
                for (Map.Entry fe : fields.entrySet()) {
                    JsonObject f = ((JsonElement)fe.getValue()).getAsJsonObject();
                    String ft = f.get("type").getAsString();
                    if ("string".equals(ft) || "number".equals(ft) || "boolean".equals(ft) || "string[]".equals(ft) || "number[]".equals(ft)) continue;
                    allSimple = false;
                    break;
                }
                type = allSimple ? "plainObject" : "entryMap";
            }
        }
        section.addProperty("type", type);
        section.add("fields", (JsonElement)fields);
        return section;
    }

    private static String inferFieldType(JsonElement value) {
        if (value == null || value.isJsonNull()) {
            return "string";
        }
        if (value.isJsonPrimitive()) {
            if (value.getAsJsonPrimitive().isBoolean()) {
                return "boolean";
            }
            if (value.getAsJsonPrimitive().isNumber()) {
                return "number";
            }
            return "string";
        }
        if (value.isJsonArray()) {
            JsonArray arr = value.getAsJsonArray();
            if (arr.isEmpty()) {
                return "string[]";
            }
            JsonElement first = arr.get(0);
            if (first.isJsonPrimitive() && first.getAsJsonPrimitive().isNumber()) {
                return "number[]";
            }
            return "string[]";
        }
        return "string";
    }

    private static boolean shouldPreview(JsonElement value) {
        try {
            if (value == null) {
                return false;
            }
            if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                String s = value.getAsString();
                return s.contains("&") || s.contains("[");
            }
            if (value.isJsonArray()) {
                for (JsonElement el : value.getAsJsonArray()) {
                    String s;
                    if (!el.isJsonPrimitive() || !el.getAsJsonPrimitive().isString() || !(s = el.getAsString()).contains("&") && !s.contains("[")) continue;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static String prettifyName(String in) {
        if (in == null || in.isEmpty()) {
            return "";
        }
        String s = in.replace('_', ' ');
        StringBuilder out = new StringBuilder();
        char prev = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0) {
                out.append(Character.toUpperCase(c));
            } else if (Character.isUpperCase(c) && Character.isLowerCase(prev)) {
                out.append(' ').append(c);
            } else {
                out.append(c);
            }
            prev = c;
        }
        return out.toString().trim();
    }

    private static String safeGetAsString(JsonElement e) {
        try {
            if (e != null && e.isJsonPrimitive()) {
                return e.getAsString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    private static JsonElement cloneJson(JsonElement e) {
        if (e == null) {
            return JsonNull.INSTANCE;
        }
        return JsonParser.parseString((String)e.toString());
    }

    private static JsonArray enumOptionsFor(String sectionKey, String fieldKey, JsonElement value, String description) {
        HashMap<String, String[]> known = new HashMap<String, String[]>();
        known.put("announcements.orderMode", new String[]{"SEQUENTIAL", "RANDOM"});
        known.put("announcements.bossbarColor", new String[]{"BLUE", "GREEN", "PINK", "PURPLE", "RED", "WHITE", "YELLOW"});
        known.put("restart.restartType", new String[]{"Realtime", "Fixed", "None"});
        String path = sectionKey + "." + fieldKey;
        String[] opts = (String[])known.get(path);
        if (opts == null) {
            int idx;
            String parsed = null;
            if (description != null && (idx = description.indexOf("Options:")) >= 0) {
                parsed = description.substring(idx + 8).trim();
            }
            if (parsed != null && !parsed.isEmpty()) {
                String[] parts = parsed.split(",");
                for (int i = 0; i < parts.length; ++i) {
                    parts[i] = parts[i].trim();
                }
                opts = parts;
            }
        }
        if (opts == null) {
            return null;
        }
        JsonArray arr = new JsonArray();
        for (String o : opts) {
            arr.add(o);
        }
        return arr;
    }
}

