/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import eu.avalanche7.paradigm.data.CustomCommand;
import eu.avalanche7.paradigm.utils.DebugLogger;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class CMConfig {
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Path configFolderPath = Path.of("config", "paradigm", "commands");
    private List<CustomCommand> loadedCommands = new ArrayList<CustomCommand>();
    private final DebugLogger debugLogger;

    public CMConfig(DebugLogger debugLogger) {
        this.debugLogger = debugLogger;
    }

    public void loadCommands() {
        block18: {
            this.loadedCommands.clear();
            try {
                Stream<Path> stream;
                Files.createDirectories(this.configFolderPath, new FileAttribute[0]);
                boolean isEmpty = true;
                if (Files.exists(this.configFolderPath, new LinkOption[0]) && Files.isDirectory(this.configFolderPath, new LinkOption[0])) {
                    stream = Files.list(this.configFolderPath);
                    try {
                        isEmpty = stream.noneMatch(p -> p.toString().endsWith(".json"));
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                if (isEmpty) {
                    this.debugLogger.debugLog("CMConfig: No command files found in " + String.valueOf(this.configFolderPath) + ". Generating example commands.");
                    this.generateDefaultConfig();
                    break block18;
                }
                stream = Files.list(this.configFolderPath);
                try {
                    stream.filter(path -> path.toString().endsWith(".json")).forEach(file -> {
                        try (FileReader reader = new FileReader(file.toFile());){
                            CustomCommand[] commands = (CustomCommand[])this.gson.fromJson((Reader)reader, CustomCommand[].class);
                            if (commands != null) {
                                for (CustomCommand command : commands) {
                                    if (command != null && command.getName() != null && !command.getName().trim().isEmpty()) {
                                        this.loadedCommands.add(command);
                                        continue;
                                    }
                                    this.debugLogger.debugLog("CMConfig: Skipped a null or invalid command entry in file: " + String.valueOf(file.getFileName()));
                                }
                            }
                            this.debugLogger.debugLog("CMConfig: Loaded commands from file: " + String.valueOf(file.getFileName()));
                        }
                        catch (JsonSyntaxException | IOException e) {
                            this.debugLogger.debugLog("CMConfig: Failed to load or parse commands from file: " + String.valueOf(file.getFileName()), (Exception)e);
                        }
                    });
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
                if (this.loadedCommands.isEmpty() && !isEmpty) {
                    this.debugLogger.debugLog("CMConfig: No valid commands loaded from existing files. Consider checking their format or generating defaults.");
                }
            }
            catch (IOException e) {
                this.debugLogger.debugLog("CMConfig: Failed to read commands configuration folder.", e);
            }
        }
    }

    public void saveCommands() {
        try {
            Files.createDirectories(this.configFolderPath, new FileAttribute[0]);
            Path exampleFile = this.configFolderPath.resolve("examples.json");
            try (FileWriter writer = new FileWriter(exampleFile.toFile());){
                this.gson.toJson(this.loadedCommands, (Appendable)writer);
                this.debugLogger.debugLog("CMConfig: Commands configuration saved successfully to examples.json.");
            }
        }
        catch (IOException e) {
            this.debugLogger.debugLog("CMConfig: Failed to save commands configuration.", e);
        }
    }

    private void generateDefaultConfig() {
        ArrayList<CustomCommand> defaultCommands = new ArrayList<CustomCommand>();
        ArrayList<CustomCommand.Action> actions1 = new ArrayList<CustomCommand.Action>();
        actions1.add(new CustomCommand.Action("message", List.of("&aHello &6{player}! &bWelcome to the server!", "&aEnjoy your stay and check out our rules."), null, null, null, null, null, null, null));
        defaultCommands.add(new CustomCommand("example", "Sends a greeting to the player.", "example.custom.permissions", false, null, actions1, null, null, null));
        ArrayList<CustomCommand.Action> actions2 = new ArrayList<CustomCommand.Action>();
        actions2.add(new CustomCommand.Action("teleport", null, 100, 64, 100, null, null, null, null));
        actions2.add(new CustomCommand.Action("message", List.of("&aYou have been teleported to spawn!"), null, null, null, null, null, null, null));
        defaultCommands.add(new CustomCommand("example2", "Teleports the player to spawn.", "example2.custom.permissions", false, null, actions2, null, null, null));
        ArrayList<CustomCommand.Action> actions3 = new ArrayList<CustomCommand.Action>();
        actions3.add(new CustomCommand.Action("runcmd", null, null, null, null, List.of("say Hello world!", "give @p minecraft:diamond 1"), null, null, null));
        defaultCommands.add(new CustomCommand("example3", "Runs multiple commands for admins.", "example3.custom.permissions", true, null, actions3, null, null, null));
        ArrayList<CustomCommand.Action> successActions = new ArrayList<CustomCommand.Action>();
        successActions.add(new CustomCommand.Action("message", List.of("&aSuccess! You had the required item."), null, null, null, null, null, null, null));
        successActions.add(new CustomCommand.Action("run_console", null, null, null, null, List.of("say {player} has at least 5 diamonds!"), null, null, null));
        ArrayList<CustomCommand.Action> failureActions = new ArrayList<CustomCommand.Action>();
        failureActions.add(new CustomCommand.Action("message", List.of("&cFailure! You need at least 5 diamonds to use this command."), null, null, null, null, null, null, null));
        ArrayList<CustomCommand.Condition> conditions = new ArrayList<CustomCommand.Condition>();
        conditions.add(new CustomCommand.Condition("has_item", "minecraft:diamond", 5, false));
        ArrayList<CustomCommand.Action> conditionalActionList = new ArrayList<CustomCommand.Action>();
        conditionalActionList.add(new CustomCommand.Action("conditional", null, null, null, null, null, conditions, successActions, failureActions));
        defaultCommands.add(new CustomCommand("checkdiamond", "Checks if you have 5 diamonds.", "paradigm.checkdiamond", false, null, conditionalActionList, null, null, null));
        ArrayList<CustomCommand.Action> cooldownActions = new ArrayList<CustomCommand.Action>();
        cooldownActions.add(new CustomCommand.Action("message", List.of("&aYou successfully used the cooldown command!"), null, null, null, null, null, null, null));
        defaultCommands.add(new CustomCommand("cooldown_test", "A command with a 30-second cooldown.", "paradigm.cooldown.test", false, null, cooldownActions, 30, "&cThis command is on cooldown! Please wait &e{remaining_time} &cseconds.", null));
        ArrayList<CustomCommand.Action> areaActions = new ArrayList<CustomCommand.Action>();
        areaActions.add(new CustomCommand.Action("message", List.of("&aYou have found the secret altar!"), null, null, null, null, null, null, null));
        CustomCommand.AreaRestriction restriction = new CustomCommand.AreaRestriction("minecraft:overworld", Arrays.asList(0, 60, 0), Arrays.asList(10, 70, 10), "&cYou must be at the secret altar to use this command.");
        defaultCommands.add(new CustomCommand("altar_ritual", "A command that only works in a specific area.", "paradigm.altar.use", false, null, areaActions, 60, "&cThe altar's magic needs time to recharge.", restriction));
        this.loadedCommands = defaultCommands;
        this.saveCommands();
    }

    public List<CustomCommand> getLoadedCommands() {
        return this.loadedCommands;
    }

    public void reloadCommands() {
        this.debugLogger.debugLog("CMConfig: Reloading custom commands...");
        this.loadCommands();
        this.debugLogger.debugLog("CMConfig: Custom commands reloaded. Found " + this.loadedCommands.size() + " commands.");
    }
}

