/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.avalanche7.paradigm.configs.ConfigEntry;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.JsonValidator;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MentionConfigHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"paradigm");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("paradigm/mentions.json");
    public static volatile Config CONFIG = null;
    private static JsonValidator jsonValidator;
    private static volatile boolean isLoaded;

    public static void setJsonValidator(DebugLogger debugLogger) {
        jsonValidator = new JsonValidator(debugLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getConfig() {
        if (isLoaded && CONFIG != null) return CONFIG;
        Class<MentionConfigHandler> clazz = MentionConfigHandler.class;
        synchronized (MentionConfigHandler.class) {
            if (isLoaded && CONFIG != null) return CONFIG;
            MentionConfigHandler.load();
            // ** MonitorExit[var0] (shouldn't be in output)
            return CONFIG;
        }
    }

    public static void load() {
        boolean shouldSaveMerged;
        Config defaultConfig;
        block26: {
            defaultConfig = new Config();
            shouldSaveMerged = false;
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                    int c;
                    StringBuilder content = new StringBuilder();
                    while ((c = reader.read()) != -1) {
                        content.append((char)c);
                    }
                    if (jsonValidator != null) {
                        JsonValidator.ValidationResult result = jsonValidator.validateAndFix(content.toString());
                        if (result.isValid()) {
                            Config loadedConfig;
                            if (result.hasIssues()) {
                                LOGGER.info("[Paradigm] Fixed JSON syntax issues in mentions.json: " + result.getIssuesSummary());
                                LOGGER.info("[Paradigm] Saving corrected version to preserve user values");
                                try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                                    writer.write(result.getFixedJson());
                                    LOGGER.info("[Paradigm] Saved corrected mentions.json with preserved user values");
                                }
                                catch (IOException saveError) {
                                    LOGGER.warn("[Paradigm] Failed to save corrected file: " + saveError.getMessage());
                                }
                            }
                            if ((loadedConfig = (Config)GSON.fromJson(result.getFixedJson(), Config.class)) != null) {
                                MentionConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                                LOGGER.info("[Paradigm] Successfully loaded mentions.json configuration");
                                shouldSaveMerged = true;
                            }
                            break block26;
                        }
                        LOGGER.warn("[Paradigm] Critical JSON syntax errors in mentions.json: " + result.getMessage());
                        LOGGER.warn("[Paradigm] Please fix the JSON syntax manually. Using default values for this session.");
                        LOGGER.warn("[Paradigm] Your file has NOT been modified - fix the syntax and restart the server.");
                        break block26;
                    }
                    Config loadedConfig = (Config)GSON.fromJson(content.toString(), Config.class);
                    if (loadedConfig != null) {
                        MentionConfigHandler.mergeConfigs(defaultConfig, loadedConfig);
                        shouldSaveMerged = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("[Paradigm] Could not parse mentions.json, using defaults for this session.", (Throwable)e);
                    LOGGER.warn("[Paradigm] Your file has NOT been modified. Please check the file manually.");
                }
            } else {
                LOGGER.info("[Paradigm] mentions.json not found, generating with default values.");
                CONFIG = defaultConfig;
                MentionConfigHandler.save();
                LOGGER.info("[Paradigm] Generated new mentions.json with default values.");
            }
        }
        CONFIG = defaultConfig;
        if (shouldSaveMerged) {
            try {
                MentionConfigHandler.save();
                LOGGER.info("[Paradigm] Synchronized mentions.json with new defaults while preserving user values.");
            }
            catch (Exception e) {
                LOGGER.warn("[Paradigm] Failed to write merged mentions.json: " + e.getMessage());
            }
        }
        isLoaded = true;
    }

    private static void mergeConfigs(Config defaults, Config loaded) {
        try {
            Field[] fields;
            for (Field field : fields = Config.class.getDeclaredFields()) {
                if (field.getType() != ConfigEntry.class) continue;
                field.setAccessible(true);
                ConfigEntry loadedEntry = (ConfigEntry)field.get(loaded);
                ConfigEntry defaultEntry = (ConfigEntry)field.get(defaults);
                if (loadedEntry != null && loadedEntry.value != null) {
                    defaultEntry.value = loadedEntry.value;
                    LOGGER.debug("[Paradigm] Preserved user setting for: " + field.getName());
                    continue;
                }
                LOGGER.debug("[Paradigm] Using default value for new/missing config: " + field.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("[Paradigm] Error merging mention configs", (Throwable)e);
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Mentions config", e);
        }
    }

    static {
        isLoaded = false;
    }

    public static class Config {
        public ConfigEntry<String> MENTION_SYMBOL = new ConfigEntry<String>("@", "The symbol used for mentions (e.g., '@').");
        public ConfigEntry<String> INDIVIDUAL_MENTION_MESSAGE = new ConfigEntry<String>("\u00a74%s \u00a7cmentioned you in chat!", "The message sent to a player when they are individually mentioned. %s is the mentioner's name.");
        public ConfigEntry<String> EVERYONE_MENTION_MESSAGE = new ConfigEntry<String>("\u00a74%s \u00a7cmentioned everyone in chat!", "The message sent to everyone when @everyone is used. %s is the mentioner's name.");
        public ConfigEntry<String> INDIVIDUAL_TITLE_MESSAGE = new ConfigEntry<String>("\u00a74%s \u00a7cmentioned you!", "The title message shown to a player when they are individually mentioned. %s is the mentioner's name.");
        public ConfigEntry<String> EVERYONE_TITLE_MESSAGE = new ConfigEntry<String>("\u00a74%s \u00a7cmentioned everyone!", "The title message shown to everyone when @everyone is used. %s is the mentioner's name.");
        public ConfigEntry<Integer> INDIVIDUAL_MENTION_RATE_LIMIT = new ConfigEntry<Integer>(30, "The cooldown in seconds for individual player mentions.");
        public ConfigEntry<Integer> EVERYONE_MENTION_RATE_LIMIT = new ConfigEntry<Integer>(60, "The cooldown in seconds for @everyone mentions.");
        public ConfigEntry<Boolean> enableChatNotification = new ConfigEntry<Boolean>(true, "Enable or disable chat notifications for mentions.");
        public ConfigEntry<Boolean> enableTitleNotification = new ConfigEntry<Boolean>(true, "Enable or disable title notifications for mentions.");
        public ConfigEntry<Boolean> enableSubtitleNotification = new ConfigEntry<Boolean>(true, "Enable or disable subtitle notifications for mentions.");
        public ConfigEntry<String> SENDER_FEEDBACK_PLAYER_MESSAGE = new ConfigEntry<String>("You mentioned %s in chat.", "Feedback message shown to the sender after mentioning players. %s is the list of mentioned player names.");
        public ConfigEntry<String> SENDER_FEEDBACK_EVERYONE_MESSAGE = new ConfigEntry<String>("You mentioned everyone in chat.", "Feedback message shown to the sender after using @everyone.");
        public ConfigEntry<String> CHAT_APPEND_PREFIX = new ConfigEntry<String>("- ", "Prefix used when appending the leftover message content in chat notifications (after a newline).");
    }
}

