/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.core;

import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.configs.CMConfig;
import eu.avalanche7.paradigm.configs.ChatConfigHandler;
import eu.avalanche7.paradigm.configs.CooldownConfigHandler;
import eu.avalanche7.paradigm.configs.MOTDConfigHandler;
import eu.avalanche7.paradigm.configs.MainConfigHandler;
import eu.avalanche7.paradigm.configs.MentionConfigHandler;
import eu.avalanche7.paradigm.configs.RestartConfigHandler;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.utils.DebugLogger;
import eu.avalanche7.paradigm.utils.GroupChatManager;
import eu.avalanche7.paradigm.utils.Lang;
import eu.avalanche7.paradigm.utils.MessageParser;
import eu.avalanche7.paradigm.utils.PermissionsHandler;
import eu.avalanche7.paradigm.utils.Placeholders;
import eu.avalanche7.paradigm.utils.TaskScheduler;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Services {
    private MinecraftServer server;
    private final Logger logger;
    private final MainConfigHandler.Config mainConfig;
    private final AnnouncementsConfigHandler.Config announcementsConfig;
    private final MOTDConfigHandler.Config motdConfig;
    private final MentionConfigHandler.Config mentionConfig;
    private final RestartConfigHandler.Config restartConfig;
    private final ChatConfigHandler.Config chatConfig;
    private final CMConfig cmConfigInstance;
    private final CooldownConfigHandler cooldownConfigHandler;
    private final DebugLogger debugLoggerInstance;
    private final Lang langInstance;
    private final MessageParser messageParserInstance;
    private final PermissionsHandler permissionsHandlerInstance;
    private final Placeholders placeholdersInstance;
    private final TaskScheduler taskSchedulerInstance;
    private final GroupChatManager groupChatManagerInstance;
    private final IPlatformAdapter platformAdapter;

    public Services(Logger logger, MainConfigHandler.Config mainConfig, AnnouncementsConfigHandler.Config announcementsConfig, MOTDConfigHandler.Config motdConfig, MentionConfigHandler.Config mentionConfig, RestartConfigHandler.Config restartConfig, ChatConfigHandler.Config chatConfig, CMConfig cmConfig, GroupChatManager groupChatManager, DebugLogger debugLogger, Lang lang, MessageParser messageParser, PermissionsHandler permissionsHandler, Placeholders placeholders, TaskScheduler taskScheduler, IPlatformAdapter platformAdapter, CooldownConfigHandler cooldownConfigHandler) {
        this.logger = logger;
        this.mainConfig = mainConfig;
        this.announcementsConfig = announcementsConfig;
        this.motdConfig = motdConfig;
        this.mentionConfig = mentionConfig;
        this.restartConfig = restartConfig;
        this.chatConfig = chatConfig;
        this.cmConfigInstance = cmConfig;
        this.groupChatManagerInstance = groupChatManager;
        this.debugLoggerInstance = debugLogger;
        this.langInstance = lang;
        this.messageParserInstance = messageParser;
        this.permissionsHandlerInstance = permissionsHandler;
        this.placeholdersInstance = placeholders;
        this.taskSchedulerInstance = taskScheduler;
        this.platformAdapter = platformAdapter;
        this.cooldownConfigHandler = cooldownConfigHandler;
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
        if (this.server != null && this.taskSchedulerInstance != null) {
            this.taskSchedulerInstance.initialize(this.server);
        }
        if (this.permissionsHandlerInstance != null) {
            this.permissionsHandlerInstance.initialize();
        }
        if (this.platformAdapter != null) {
            this.platformAdapter.setMinecraftServer(server);
            this.platformAdapter.provideMessageParser(this.messageParserInstance);
        }
    }

    public MinecraftServer getMinecraftServer() {
        if (this.server == null && this.logger != null) {
            this.logger.warn("Paradigm Services: MinecraftServer instance requested before it was set!");
        }
        return this.server;
    }

    public CooldownConfigHandler getCooldownConfigHandler() {
        return this.cooldownConfigHandler;
    }

    public IPlatformAdapter getPlatformAdapter() {
        return this.platformAdapter;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public DebugLogger getDebugLogger() {
        return this.debugLoggerInstance;
    }

    public Lang getLang() {
        return this.langInstance;
    }

    public MessageParser getMessageParser() {
        return this.messageParserInstance;
    }

    public PermissionsHandler getPermissionsHandler() {
        return this.permissionsHandlerInstance;
    }

    public Placeholders getPlaceholders() {
        return this.placeholdersInstance;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskSchedulerInstance;
    }

    public MainConfigHandler.Config getMainConfig() {
        return this.mainConfig;
    }

    public AnnouncementsConfigHandler.Config getAnnouncementsConfig() {
        return this.announcementsConfig;
    }

    public MOTDConfigHandler.Config getMotdConfig() {
        return this.motdConfig;
    }

    public MentionConfigHandler.Config getMentionConfig() {
        return this.mentionConfig;
    }

    public RestartConfigHandler.Config getRestartConfig() {
        return this.restartConfig;
    }

    public ChatConfigHandler.Config getChatConfig() {
        return this.chatConfig;
    }

    public CMConfig getCmConfig() {
        return this.cmConfigInstance;
    }

    public GroupChatManager getGroupChatManager() {
        return this.groupChatManagerInstance;
    }
}

