/*
 * Decompiled with CFR 0.152.
 */
package eu.avalanche7.paradigm.modules;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.avalanche7.paradigm.configs.AnnouncementsConfigHandler;
import eu.avalanche7.paradigm.core.ParadigmModule;
import eu.avalanche7.paradigm.core.Services;
import eu.avalanche7.paradigm.platform.Interfaces.IComponent;
import eu.avalanche7.paradigm.platform.Interfaces.IPlatformAdapter;
import eu.avalanche7.paradigm.platform.Interfaces.IPlayer;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class Announcements
implements ParadigmModule {
    private static final String NAME = "Announcements";
    private final Random random = new Random(System.currentTimeMillis());
    private int globalMessageIndex = 0;
    private int actionbarMessageIndex = 0;
    private int titleMessageIndex = 0;
    private int bossbarMessageIndex = 0;
    private int lastGlobalRandomIndex = -1;
    private int lastActionbarRandomIndex = -1;
    private int lastTitleRandomIndex = -1;
    private int lastBossbarRandomIndex = -1;
    private boolean announcementsScheduled = false;
    private ScheduledFuture<?> globalTask = null;
    private ScheduledFuture<?> actionbarTask = null;
    private ScheduledFuture<?> titleTask = null;
    private ScheduledFuture<?> bossbarTask = null;
    private IPlatformAdapter platform;
    private Services services;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Services services) {
        AnnouncementsConfigHandler.Config cfg = services.getAnnouncementsConfig();
        return cfg != null && (cfg.globalEnable != null && Boolean.TRUE.equals(cfg.globalEnable.value) || cfg.actionbarEnable != null && Boolean.TRUE.equals(cfg.actionbarEnable.value) || cfg.titleEnable != null && Boolean.TRUE.equals(cfg.titleEnable.value) || cfg.bossbarEnable != null && Boolean.TRUE.equals(cfg.bossbarEnable.value));
    }

    @Override
    public void onLoad(Object event, Services services, Object modEventBus) {
        this.services = services;
        this.platform = services.getPlatformAdapter();
        services.getDebugLogger().debugLog("Announcements module loaded.");
    }

    @Override
    public void onServerStarting(Object event, Services services) {
        if (this.isEnabled(services) && !this.announcementsScheduled) {
            services.getDebugLogger().debugLog("Announcements: Server starting, scheduling announcements if enabled.");
            this.scheduleConfiguredAnnouncements();
        }
    }

    @Override
    public void onEnable(Services services) {
        if (this.platform != null && this.isEnabled(services) && !this.announcementsScheduled) {
            services.getDebugLogger().debugLog("Announcements: Module enabled, scheduling announcements.");
            this.scheduleConfiguredAnnouncements();
        }
    }

    @Override
    public void onDisable(Services services) {
        services.getDebugLogger().debugLog("Announcements: Module disabled. Cancelling scheduled tasks.");
        this.cancelAllTasks();
        this.announcementsScheduled = false;
    }

    @Override
    public void onServerStopping(Object event, Services services) {
        services.getDebugLogger().debugLog("Announcements: Server stopping.");
        this.cancelAllTasks();
        this.announcementsScheduled = false;
    }

    @Override
    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, Services services) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"paradigm").requires(source -> source.method_9259(2) || source.method_43737() && services.getPermissionsHandler().hasPermission(source.method_44023(), "paradigm.broadcast"))).then(class_2170.method_9247((String)"broadcast").then(class_2170.method_9244((String)"header_footer", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.broadcastMessageCmd((CommandContext<class_2168>)context, "broadcast")))))).then(class_2170.method_9247((String)"actionbar").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.broadcastMessageCmd((CommandContext<class_2168>)context, "actionbar"))))).then(class_2170.method_9247((String)"title").then(class_2170.method_9244((String)"titleAndSubtitle", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.broadcastTitleCmd((CommandContext<class_2168>)context))))).then(class_2170.method_9247((String)"bossbar").then(class_2170.method_9244((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (IPlatformAdapter.BossBarColor color : IPlatformAdapter.BossBarColor.values()) {
                builder.suggest(color.name().toLowerCase());
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.broadcastMessageCmd((CommandContext<class_2168>)context, "bossbar")))))));
    }

    @Override
    public void registerEventListeners(Object eventBus, Services services) {
    }

    private void scheduleConfiguredAnnouncements() {
        long interval;
        this.services.getDebugLogger().debugLog("Announcements: scheduleConfiguredAnnouncements() called.");
        if (this.announcementsScheduled) {
            this.services.getDebugLogger().debugLog("Announcements: Announcements already scheduled, skipping.");
            return;
        }
        this.cancelAllTasks();
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        if (this.platform == null) {
            this.services.getDebugLogger().debugLog("Announcements: Cannot schedule announcements, platform adapter is null.");
            return;
        }
        if (((Boolean)config.globalEnable.value).booleanValue()) {
            interval = ((Integer)config.globalInterval.value).intValue();
            this.globalTask = this.services.getTaskScheduler().scheduleAtFixedRate(this::broadcastGlobalMessages, interval, interval, TimeUnit.SECONDS);
            this.services.getDebugLogger().debugLog("Announcements: Scheduled global messages with interval: " + interval + " seconds");
        }
        if (((Boolean)config.actionbarEnable.value).booleanValue()) {
            interval = ((Integer)config.actionbarInterval.value).intValue();
            this.actionbarTask = this.services.getTaskScheduler().scheduleAtFixedRate(this::broadcastActionbarMessages, interval, interval, TimeUnit.SECONDS);
            this.services.getDebugLogger().debugLog("Announcements: Scheduled actionbar messages with interval: " + interval + " seconds");
        }
        if (((Boolean)config.titleEnable.value).booleanValue()) {
            interval = ((Integer)config.titleInterval.value).intValue();
            this.titleTask = this.services.getTaskScheduler().scheduleAtFixedRate(this::broadcastTitleMessages, interval, interval, TimeUnit.SECONDS);
            this.services.getDebugLogger().debugLog("Announcements: Scheduled title messages with interval: " + interval + " seconds");
        }
        if (((Boolean)config.bossbarEnable.value).booleanValue()) {
            interval = ((Integer)config.bossbarInterval.value).intValue();
            this.bossbarTask = this.services.getTaskScheduler().scheduleAtFixedRate(this::broadcastBossbarMessages, interval, interval, TimeUnit.SECONDS);
            this.services.getDebugLogger().debugLog("Announcements: Scheduled bossbar messages with interval: " + interval + " seconds");
        }
        this.announcementsScheduled = true;
    }

    private void cancelAllTasks() {
        if (this.globalTask != null && !this.globalTask.isCancelled()) {
            this.globalTask.cancel(false);
            this.globalTask = null;
            this.services.getDebugLogger().debugLog("Announcements: Cancelled global messages task.");
        }
        if (this.actionbarTask != null && !this.actionbarTask.isCancelled()) {
            this.actionbarTask.cancel(false);
            this.actionbarTask = null;
            this.services.getDebugLogger().debugLog("Announcements: Cancelled actionbar messages task.");
        }
        if (this.titleTask != null && !this.titleTask.isCancelled()) {
            this.titleTask.cancel(false);
            this.titleTask = null;
            this.services.getDebugLogger().debugLog("Announcements: Cancelled title messages task.");
        }
        if (this.bossbarTask != null && !this.bossbarTask.isCancelled()) {
            this.bossbarTask.cancel(false);
            this.bossbarTask = null;
            this.services.getDebugLogger().debugLog("Announcements: Cancelled bossbar messages task.");
        }
    }

    private String getNextMessage(List<String> messages, String orderMode, String type) {
        String messageText;
        String prefix;
        String string = prefix = this.services.getAnnouncementsConfig().prefix.value != null ? (String)this.services.getAnnouncementsConfig().prefix.value + "\u00a7r" : "";
        if ("SEQUENTIAL".equalsIgnoreCase(orderMode)) {
            int index;
            switch (type) {
                case "global": {
                    index = this.globalMessageIndex++;
                    if (this.globalMessageIndex < messages.size()) break;
                    this.globalMessageIndex = 0;
                    break;
                }
                case "actionbar": {
                    index = this.actionbarMessageIndex++;
                    if (this.actionbarMessageIndex < messages.size()) break;
                    this.actionbarMessageIndex = 0;
                    break;
                }
                case "title": {
                    index = this.titleMessageIndex++;
                    if (this.titleMessageIndex < messages.size()) break;
                    this.titleMessageIndex = 0;
                    break;
                }
                case "bossbar": {
                    index = this.bossbarMessageIndex++;
                    if (this.bossbarMessageIndex < messages.size()) break;
                    this.bossbarMessageIndex = 0;
                    break;
                }
                default: {
                    index = this.random.nextInt(messages.size());
                }
            }
            messageText = messages.get(index);
        } else {
            int index;
            int lastIndex = switch (type) {
                case "global" -> this.lastGlobalRandomIndex;
                case "actionbar" -> this.lastActionbarRandomIndex;
                case "title" -> this.lastTitleRandomIndex;
                case "bossbar" -> this.lastBossbarRandomIndex;
                default -> -1;
            };
            if (messages.size() > 1) {
                while ((index = this.random.nextInt(messages.size())) == lastIndex) {
                }
            } else {
                index = 0;
            }
            switch (type) {
                case "global": {
                    this.lastGlobalRandomIndex = index;
                    break;
                }
                case "actionbar": {
                    this.lastActionbarRandomIndex = index;
                    break;
                }
                case "title": {
                    this.lastTitleRandomIndex = index;
                    break;
                }
                case "bossbar": {
                    this.lastBossbarRandomIndex = index;
                }
            }
            messageText = messages.get(index);
        }
        return messageText.replace("{Prefix}", prefix);
    }

    private void broadcastGlobalMessages() {
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        List messages = (List)config.globalMessages.value;
        if (this.platform == null || messages.isEmpty()) {
            return;
        }
        String orderMode = (String)config.orderMode.value;
        String messageText = this.getNextMessage(messages, orderMode, "global");
        boolean headerFooter = (Boolean)config.headerAndFooter.value;
        String header = config.header.value != null ? (String)config.header.value : "";
        String footer = config.footer.value != null ? (String)config.footer.value : "";
        this.platform.getOnlinePlayers().forEach(player -> {
            IPlayer iPlayer = this.platform.wrapPlayer((class_3222)player);
            if (headerFooter) {
                IComponent headerComp = this.services.getMessageParser().parseMessage(header, iPlayer);
                IComponent messageComp = this.services.getMessageParser().parseMessage(messageText, iPlayer);
                IComponent footerComp = this.services.getMessageParser().parseMessage(footer, iPlayer);
                this.platform.sendSystemMessage((class_3222)player, headerComp.getOriginalText());
                this.platform.sendSystemMessage((class_3222)player, messageComp.getOriginalText());
                this.platform.sendSystemMessage((class_3222)player, footerComp.getOriginalText());
            } else {
                IComponent messageComp = this.services.getMessageParser().parseMessage(messageText, iPlayer);
                this.platform.sendSystemMessage((class_3222)player, messageComp.getOriginalText());
            }
        });
        this.services.getDebugLogger().debugLog("Announcements: Broadcasted global message: " + messageText);
    }

    private void broadcastActionbarMessages() {
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        List messages = (List)config.actionbarMessages.value;
        if (this.platform == null || messages.isEmpty()) {
            return;
        }
        String orderMode = (String)config.orderMode.value;
        String messageText = this.getNextMessage(messages, orderMode, "actionbar");
        this.platform.getOnlinePlayers().forEach(player -> {
            IPlayer iPlayer = this.platform.wrapPlayer((class_3222)player);
            IComponent messageComp = this.services.getMessageParser().parseMessage(messageText, iPlayer);
            this.platform.sendActionBar((class_3222)player, messageComp.getOriginalText());
        });
        this.services.getDebugLogger().debugLog("Announcements: Broadcasted actionbar message: " + messageText);
    }

    private void broadcastTitleMessages() {
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        List messages = (List)config.titleMessages.value;
        if (this.platform == null || messages.isEmpty()) {
            return;
        }
        String orderMode = (String)config.orderMode.value;
        String messageText = this.getNextMessage(messages, orderMode, "title");
        this.platform.getOnlinePlayers().forEach(player -> {
            IPlayer iPlayer = this.platform.wrapPlayer((class_3222)player);
            String[] parts = messageText.split(" \\|\\| ", 2);
            IComponent titleComp = this.services.getMessageParser().parseMessage(parts[0], iPlayer);
            IComponent subtitleComp = parts.length > 1 ? this.services.getMessageParser().parseMessage(parts[1], iPlayer) : this.services.getMessageParser().parseMessage("", iPlayer);
            this.platform.clearTitles((class_3222)player);
            this.platform.sendTitle((class_3222)player, titleComp.getOriginalText(), subtitleComp.getOriginalText());
        });
        this.services.getDebugLogger().debugLog("Announcements: Broadcasted title message: " + messageText);
    }

    private void broadcastBossbarMessages() {
        IPlatformAdapter.BossBarColor tempBossbarColor;
        AnnouncementsConfigHandler.Config config = this.services.getAnnouncementsConfig();
        List messages = (List)config.bossbarMessages.value;
        if (this.platform == null || messages.isEmpty()) {
            return;
        }
        String orderMode = (String)config.orderMode.value;
        String messageText = this.getNextMessage(messages, orderMode, "bossbar");
        int bossbarTime = config.bossbarTime.value != null ? (Integer)config.bossbarTime.value : 10;
        String colorStr = config.bossbarColor.value != null ? ((String)config.bossbarColor.value).toUpperCase() : "PURPLE";
        try {
            tempBossbarColor = IPlatformAdapter.BossBarColor.valueOf(colorStr);
        }
        catch (IllegalArgumentException e) {
            this.services.getDebugLogger().debugLog("Announcements: Invalid bossbar color: " + colorStr + ". Defaulting to PURPLE.");
            tempBossbarColor = IPlatformAdapter.BossBarColor.PURPLE;
        }
        IPlatformAdapter.BossBarColor bossbarColor = tempBossbarColor;
        this.platform.getOnlinePlayers().forEach(player -> {
            IPlayer iPlayer = this.platform.wrapPlayer((class_3222)player);
            IComponent messageComp = this.services.getMessageParser().parseMessage(messageText, iPlayer);
            this.platform.sendBossBar(Collections.singletonList(player), messageComp.getOriginalText(), bossbarTime, bossbarColor, 1.0f);
        });
        this.services.getDebugLogger().debugLog("Announcements: Broadcasted bossbar message: " + messageText);
    }

    public int broadcastTitleCmd(CommandContext<class_2168> context) {
        String titleAndSubtitle = StringArgumentType.getString(context, (String)"titleAndSubtitle");
        this.services.getDebugLogger().debugLog("Announcements: /paradigm title command executed with message: " + titleAndSubtitle);
        String[] parts = titleAndSubtitle.split(" \\|\\| ", 2);
        this.platform.getOnlinePlayers().forEach(target -> {
            IPlayer iPlayer = this.platform.wrapPlayer((class_3222)target);
            IComponent titleComp = this.services.getMessageParser().parseMessage(parts[0], iPlayer);
            IComponent subtitleComp = parts.length > 1 ? this.services.getMessageParser().parseMessage(parts[1], iPlayer) : this.services.getMessageParser().parseMessage("", iPlayer);
            this.platform.clearTitles((class_3222)target);
            this.platform.sendTitle((class_3222)target, titleComp.getOriginalText(), subtitleComp.getOriginalText());
        });
        this.platform.sendSuccess((class_2168)context.getSource(), (class_2561)this.platform.createLiteralComponent("Title broadcasted."), true);
        return 1;
    }

    public int broadcastMessageCmd(CommandContext<class_2168> context, String type) {
        String messageStr = StringArgumentType.getString(context, (String)"message");
        this.services.getDebugLogger().debugLog("Announcements: /paradigm " + type + " command executed with message: " + messageStr);
        switch (type) {
            case "broadcast": {
                boolean headerFooter = BoolArgumentType.getBool(context, (String)"header_footer");
                String header = (String)this.services.getAnnouncementsConfig().header.value;
                String footer = (String)this.services.getAnnouncementsConfig().footer.value;
                this.platform.getOnlinePlayers().forEach(player -> {
                    IPlayer iPlayer = this.platform.wrapPlayer((class_3222)player);
                    IComponent messageComp = this.services.getMessageParser().parseMessage(messageStr, iPlayer);
                    if (headerFooter) {
                        IComponent headerComp = this.services.getMessageParser().parseMessage(header, iPlayer);
                        IComponent footerComp = this.services.getMessageParser().parseMessage(footer, iPlayer);
                        this.platform.sendSystemMessage((class_3222)player, headerComp.getOriginalText());
                        this.platform.sendSystemMessage((class_3222)player, messageComp.getOriginalText());
                        this.platform.sendSystemMessage((class_3222)player, footerComp.getOriginalText());
                    } else {
                        this.platform.sendSystemMessage((class_3222)player, messageComp.getOriginalText());
                    }
                });
                break;
            }
            case "actionbar": {
                this.platform.getOnlinePlayers().forEach(player -> {
                    IPlayer iPlayer = this.platform.wrapPlayer((class_3222)player);
                    IComponent messageComp = this.services.getMessageParser().parseMessage(messageStr, iPlayer);
                    this.platform.sendActionBar((class_3222)player, messageComp.getOriginalText());
                });
                break;
            }
            case "bossbar": {
                IPlatformAdapter.BossBarColor bossBarColor;
                String colorStr = StringArgumentType.getString(context, (String)"color");
                int interval = IntegerArgumentType.getInteger(context, (String)"interval");
                try {
                    bossBarColor = IPlatformAdapter.BossBarColor.valueOf(colorStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.platform.sendFailure((class_2168)context.getSource(), (class_2561)this.platform.createLiteralComponent("Invalid bossbar color: " + colorStr));
                    return 0;
                }
                this.platform.getOnlinePlayers().forEach(player -> {
                    IPlayer iPlayer = this.platform.wrapPlayer((class_3222)player);
                    IComponent messageComp = this.services.getMessageParser().parseMessage(messageStr, iPlayer);
                    this.platform.sendBossBar(Collections.singletonList(player), messageComp.getOriginalText(), interval, bossBarColor, 1.0f);
                });
                break;
            }
            default: {
                this.platform.sendFailure((class_2168)context.getSource(), (class_2561)this.platform.createLiteralComponent("Invalid message type for command: " + type));
                return 0;
            }
        }
        this.platform.sendSuccess((class_2168)context.getSource(), (class_2561)this.platform.createLiteralComponent(type + " broadcasted."), true);
        return 1;
    }

    public void rescheduleAnnouncements() {
        if (this.services == null) {
            return;
        }
        this.services.getDebugLogger().debugLog("Announcements: Rescheduling announcements on config reload.");
        this.cancelAllTasks();
        this.announcementsScheduled = false;
        this.scheduleConfiguredAnnouncements();
    }
}

